//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations

import "time"

type AppliedReservationList struct {
	// Url to get the next page of reservations
	NextLink *string   `json:"nextLink,omitempty"`
	Value    []*string `json:"value,omitempty"`
}

type AppliedReservations struct {
	Properties *AppliedReservationsProperties `json:"properties,omitempty"`

	// READ-ONLY; Identifier of the applied reservations
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/AppliedReservations"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type AppliedReservationsProperties struct {
	ReservationOrderIDs *AppliedReservationList `json:"reservationOrderIds,omitempty"`
}

type AvailableScopeProperties struct {
	Properties *SubscriptionScopeProperties `json:"properties,omitempty"`
}

// AvailableScopeRequest - Available scope
type AvailableScopeRequest struct {
	// Available scope request properties
	Properties *AvailableScopeRequestProperties `json:"properties,omitempty"`
}

// AvailableScopeRequestProperties - Available scope request properties
type AvailableScopeRequestProperties struct {
	Scopes []*string `json:"scopes,omitempty"`
}

// AzureReservationAPIClientGetAppliedReservationListOptions contains the optional parameters for the AzureReservationAPIClient.GetAppliedReservationList
// method.
type AzureReservationAPIClientGetAppliedReservationListOptions struct {
	// placeholder for future optional parameters
}

// AzureReservationAPIClientGetCatalogOptions contains the optional parameters for the AzureReservationAPIClient.GetCatalog
// method.
type AzureReservationAPIClientGetCatalogOptions struct {
	// Filters the skus based on the location specified in this parameter. This can be an azure region or global
	Location *string
	// Offer id used to get the third party products
	OfferID *string
	// Plan id used to get the third party products
	PlanID *string
	// Publisher id used to get the third party products
	PublisherID *string
	// The type of the resource for which the skus should be provided.
	ReservedResourceType *string
}

// BillingInformation - billing information
type BillingInformation struct {
	BillingCurrencyProratedAmount            *Price `json:"billingCurrencyProratedAmount,omitempty"`
	BillingCurrencyRemainingCommitmentAmount *Price `json:"billingCurrencyRemainingCommitmentAmount,omitempty"`
	BillingCurrencyTotalPaidAmount           *Price `json:"billingCurrencyTotalPaidAmount,omitempty"`
}

// CalculateExchangeClientBeginPostOptions contains the optional parameters for the CalculateExchangeClient.BeginPost method.
type CalculateExchangeClientBeginPostOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CalculateExchangeOperationResultResponse - CalculateExchange operation result
type CalculateExchangeOperationResultResponse struct {
	// Required if status == failed or status == canceled.
	Error *OperationResultError `json:"error,omitempty"`

	// It should match what is used to GET the operation result.
	ID *string `json:"id,omitempty"`

	// It must match the last segment of the id field, and will typically be a GUID / system generated value.
	Name *string `json:"name,omitempty"`

	// CalculateExchange response properties
	Properties *CalculateExchangeResponseProperties `json:"properties,omitempty"`

	// Status of the operation.
	Status *CalculateExchangeOperationResultStatus `json:"status,omitempty"`
}

// CalculateExchangeRequest - Calculate exchange request
type CalculateExchangeRequest struct {
	// Calculate exchange request properties
	Properties *CalculateExchangeRequestProperties `json:"properties,omitempty"`
}

// CalculateExchangeRequestProperties - Calculate exchange request properties
type CalculateExchangeRequestProperties struct {
	// List of reservations that are being returned in this exchange.
	ReservationsToExchange []*ReservationToReturn `json:"reservationsToExchange,omitempty"`

	// List of reservations that are being purchased in this exchange.
	ReservationsToPurchase []*PurchaseRequest `json:"reservationsToPurchase,omitempty"`
}

// CalculateExchangeResponseProperties - CalculateExchange response properties
type CalculateExchangeResponseProperties struct {
	NetPayable *Price `json:"netPayable,omitempty"`

	// Exchange policy errors
	PolicyResult   *ExchangePolicyErrors `json:"policyResult,omitempty"`
	PurchasesTotal *Price                `json:"purchasesTotal,omitempty"`
	RefundsTotal   *Price                `json:"refundsTotal,omitempty"`

	// Details of the reservations being returned
	ReservationsToExchange []*ReservationToExchange `json:"reservationsToExchange,omitempty"`

	// Details of the reservations being purchased
	ReservationsToPurchase []*ReservationToPurchaseCalculateExchange `json:"reservationsToPurchase,omitempty"`

	// Exchange session identifier
	SessionID *string `json:"sessionId,omitempty"`
}

type CalculatePriceResponse struct {
	Properties *CalculatePriceResponseProperties `json:"properties,omitempty"`
}

type CalculatePriceResponseProperties struct {
	// Currency and amount that customer will be charged in customer's local currency. Tax is not included.
	BillingCurrencyTotal *CalculatePriceResponsePropertiesBillingCurrencyTotal `json:"billingCurrencyTotal,omitempty"`

	// Total amount in pricing currency.
	GrandTotal *float64 `json:"grandTotal,omitempty"`

	// True if billing is managed by Microsoft Partner. Used only for CSP accounts.
	IsBillingPartnerManaged *bool `json:"isBillingPartnerManaged,omitempty"`

	// Whether or not tax is included in grand total
	IsTaxIncluded *bool `json:"isTaxIncluded,omitempty"`

	// Net total amount in pricing currency.
	NetTotal        *float64         `json:"netTotal,omitempty"`
	PaymentSchedule []*PaymentDetail `json:"paymentSchedule,omitempty"`

	// Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included.
	PricingCurrencyTotal *CalculatePriceResponsePropertiesPricingCurrencyTotal `json:"pricingCurrencyTotal,omitempty"`

	// GUID that represents reservation order that can be placed after calculating price.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`

	// Description of SKU that is being purchased.
	SKUDescription *string `json:"skuDescription,omitempty"`

	// Title of SKU that is being purchased.
	SKUTitle *string `json:"skuTitle,omitempty"`

	// Tax amount in pricing currency.
	TaxTotal *float64 `json:"taxTotal,omitempty"`
}

// CalculatePriceResponsePropertiesBillingCurrencyTotal - Currency and amount that customer will be charged in customer's
// local currency. Tax is not included.
type CalculatePriceResponsePropertiesBillingCurrencyTotal struct {
	// Amount in pricing currency. Tax is not included.
	Amount *float64 `json:"amount,omitempty"`

	// The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string `json:"currencyCode,omitempty"`
}

// CalculatePriceResponsePropertiesPricingCurrencyTotal - Amount that Microsoft uses for record. Used during refund for calculating
// refund limit. Tax is not included.
type CalculatePriceResponsePropertiesPricingCurrencyTotal struct {
	Amount *float32 `json:"amount,omitempty"`

	// The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string `json:"currencyCode,omitempty"`
}

// CalculateRefundClientPostOptions contains the optional parameters for the CalculateRefundClient.Post method.
type CalculateRefundClientPostOptions struct {
	// placeholder for future optional parameters
}

type CalculateRefundRequest struct {
	// Fully qualified identifier of the reservation order being returned
	ID         *string                           `json:"id,omitempty"`
	Properties *CalculateRefundRequestProperties `json:"properties,omitempty"`
}

type CalculateRefundRequestProperties struct {
	// Reservation to return
	ReservationToReturn *ReservationToReturn `json:"reservationToReturn,omitempty"`

	// The scope of the refund, e.g. Reservation
	Scope *string `json:"scope,omitempty"`
}

type CalculateRefundResponse struct {
	// Fully qualified identifier of the reservation being returned
	ID         *string                   `json:"id,omitempty"`
	Properties *RefundResponseProperties `json:"properties,omitempty"`
}

type Catalog struct {
	// The billing plan options available for this SKU.
	BillingPlans map[string][]*ReservationBillingPlan `json:"billingPlans,omitempty"`

	// READ-ONLY
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Pricing information about the SKU
	Msrp *CatalogMsrp `json:"msrp,omitempty" azure:"ro"`

	// READ-ONLY; The name of SKU
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY
	Restrictions []*SKURestriction `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY
	SKUProperties []*SKUProperty `json:"skuProperties,omitempty" azure:"ro"`

	// READ-ONLY; The size of this SKU
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; Available reservation terms for this resource
	Terms []*ReservationTerm `json:"terms,omitempty" azure:"ro"`

	// READ-ONLY; The tier of this SKU
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// CatalogMsrp - Pricing information about the SKU
type CatalogMsrp struct {
	// Amount in pricing currency. Tax not included.
	P1Y *Price `json:"p1Y,omitempty"`
}

type ChangeDirectoryRequest struct {
	// Tenant id GUID that reservation order is to be transferred to
	DestinationTenantID *string `json:"destinationTenantId,omitempty"`
}

// ChangeDirectoryResponse - Change directory response
type ChangeDirectoryResponse struct {
	// Change directory result for reservation order or reservation
	ReservationOrder *ChangeDirectoryResult   `json:"reservationOrder,omitempty"`
	Reservations     []*ChangeDirectoryResult `json:"reservations,omitempty"`
}

// ChangeDirectoryResult - Change directory result for reservation order or reservation
type ChangeDirectoryResult struct {
	// Error reason if operation failed. Null otherwise
	Error *string `json:"error,omitempty"`

	// Identifier of the reservation order or reservation
	ID *string `json:"id,omitempty"`

	// True if change directory operation succeeded on this reservation order or reservation
	IsSucceeded *bool `json:"isSucceeded,omitempty"`

	// Name of the reservation order or reservation
	Name *string `json:"name,omitempty"`
}

// CreateGenericQuotaRequestParameters - Quota change requests information.
type CreateGenericQuotaRequestParameters struct {
	// Quota change requests.
	Value []*CurrentQuotaLimitBase `json:"value,omitempty"`
}

// CurrentQuotaLimit - Current quota limits.
type CurrentQuotaLimit struct {
	// Additional properties for the quota status for the resource.
	Properties *QuotaRequestStatusDetails `json:"properties,omitempty"`

	// Quota details.
	QuotaInformation *CurrentQuotaLimitBase `json:"quotaInformation,omitempty"`
}

// CurrentQuotaLimitBase - Quota properties.
type CurrentQuotaLimitBase struct {
	// Quota properties for the resource.
	Properties *QuotaProperties `json:"properties,omitempty"`

	// READ-ONLY; The quota request ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/ServiceLimits"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type Error struct {
	Error *ExtendedErrorInfo `json:"error,omitempty"`
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// ExceptionResponse - The API error.
type ExceptionResponse struct {
	// The API error details.
	Error *ServiceError `json:"error,omitempty"`
}

// ExchangeClientBeginPostOptions contains the optional parameters for the ExchangeClient.BeginPost method.
type ExchangeClientBeginPostOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExchangeOperationResultResponse - Exchange operation result
type ExchangeOperationResultResponse struct {
	// Required if status == failed or status == canceled.
	Error *OperationResultError `json:"error,omitempty"`

	// It should match what is used to GET the operation result.
	ID *string `json:"id,omitempty"`

	// It must match the last segment of the id field, and will typically be a GUID / system generated value.
	Name *string `json:"name,omitempty"`

	// Exchange response properties
	Properties *ExchangeResponseProperties `json:"properties,omitempty"`

	// Status of the operation.
	Status *ExchangeOperationResultStatus `json:"status,omitempty"`
}

// ExchangePolicyError - error details
type ExchangePolicyError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExchangePolicyErrors - Exchange policy errors
type ExchangePolicyErrors struct {
	// Exchange Policy errors
	PolicyErrors []*ExchangePolicyError `json:"policyErrors,omitempty"`
}

// ExchangeRequest - Exchange request
type ExchangeRequest struct {
	// Exchange request properties
	Properties *ExchangeRequestProperties `json:"properties,omitempty"`
}

// ExchangeRequestProperties - Exchange request properties
type ExchangeRequestProperties struct {
	// SessionId that was returned by CalculateExchange API.
	SessionID *string `json:"sessionId,omitempty"`
}

// ExchangeResponseProperties - Exchange response properties
type ExchangeResponseProperties struct {
	NetPayable *Price `json:"netPayable,omitempty"`

	// Exchange policy errors
	PolicyResult   *ExchangePolicyErrors `json:"policyResult,omitempty"`
	PurchasesTotal *Price                `json:"purchasesTotal,omitempty"`
	RefundsTotal   *Price                `json:"refundsTotal,omitempty"`

	// Details of the reservations being returned
	ReservationsToExchange []*ReservationToReturnForExchange `json:"reservationsToExchange,omitempty"`

	// Details of the reservations being purchased
	ReservationsToPurchase []*ReservationToPurchaseExchange `json:"reservationsToPurchase,omitempty"`

	// Exchange session identifier
	SessionID *string `json:"sessionId,omitempty"`
}

type ExtendedErrorInfo struct {
	Code    *ErrorResponseCode `json:"code,omitempty"`
	Message *string            `json:"message,omitempty"`
}

type ExtendedStatusInfo struct {
	// The message giving detailed information about the status code.
	Message    *string                `json:"message,omitempty"`
	StatusCode *ReservationStatusCode `json:"statusCode,omitempty"`
}

// ListResult - The list of reservations and summary of roll out count of reservations in each state.
type ListResult struct {
	// The roll out count summary of the reservations
	Summary *ReservationSummary `json:"summary,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservations.
	Value []*ReservationResponse `json:"value,omitempty" azure:"ro"`
}

type MergeProperties struct {
	// Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	Sources []*string `json:"sources,omitempty"`
}

type MergeRequest struct {
	Properties *MergeProperties `json:"properties,omitempty"`
}

// OperationClientListOptions contains the optional parameters for the OperationClient.List method.
type OperationClientListOptions struct {
	// placeholder for future optional parameters
}

type OperationDisplay struct {
	Description *string `json:"description,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
}

type OperationList struct {
	// Url to get the next page of items.
	NextLink *string              `json:"nextLink,omitempty"`
	Value    []*OperationResponse `json:"value,omitempty"`
}

type OperationResponse struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
}

// OperationResultError - Required if status == failed or status == canceled.
type OperationResultError struct {
	// Required if status == failed or status == cancelled. If status == failed, provide an invariant error code used for error
	// troubleshooting, aggregation, and analysis.
	Code *string `json:"code,omitempty"`

	// Required if status == failed. Localized. If status == failed, provide an actionable error message indicating what error
	// occurred, and what the user can do to address the issue.
	Message *string `json:"message,omitempty"`
}

type Patch struct {
	Properties *PatchProperties `json:"properties,omitempty"`
}

type PatchProperties struct {
	// Type of the Applied Scope.
	AppliedScopeType *AppliedScopeType `json:"appliedScopeType,omitempty"`

	// List of the subscriptions that the benefit will be applied. Do not specify if AppliedScopeType is Shared.
	AppliedScopes []*string `json:"appliedScopes,omitempty"`

	// Turning this on will apply the reservation discount to other VMs in the same VM size group. Only specify for VirtualMachines
	// reserved resource type.
	InstanceFlexibility *InstanceFlexibility `json:"instanceFlexibility,omitempty"`

	// Name of the Reservation
	Name *string `json:"name,omitempty"`

	// Setting this to true will automatically purchase a new reservation on the expiration date time.
	Renew           *bool                           `json:"renew,omitempty"`
	RenewProperties *PatchPropertiesRenewProperties `json:"renewProperties,omitempty"`
}

type PatchPropertiesRenewProperties struct {
	PurchaseProperties *PurchaseRequest `json:"purchaseProperties,omitempty"`
}

// PaymentDetail - Information about payment related to a reservation order.
type PaymentDetail struct {
	// Shows the Account that is charged for this payment.
	BillingAccount *string `json:"billingAccount,omitempty"`

	// Amount charged in Billing currency. Tax not included. Is null for future payments
	BillingCurrencyTotal *Price `json:"billingCurrencyTotal,omitempty"`

	// Date when the payment needs to be done.
	DueDate            *time.Time          `json:"dueDate,omitempty"`
	ExtendedStatusInfo *ExtendedStatusInfo `json:"extendedStatusInfo,omitempty"`

	// Date when the transaction is completed. Is null when it is scheduled.
	PaymentDate *time.Time `json:"paymentDate,omitempty"`

	// Amount in pricing currency. Tax not included.
	PricingCurrencyTotal *Price `json:"pricingCurrencyTotal,omitempty"`

	// Describes whether the payment is completed, failed, cancelled or scheduled in the future.
	Status *PaymentStatus `json:"status,omitempty"`
}

type Price struct {
	Amount *float64 `json:"amount,omitempty"`

	// The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string `json:"currencyCode,omitempty"`
}

// Properties - The properties of the reservations
type Properties struct {
	// The applied scope type
	AppliedScopeType *AppliedScopeType `json:"appliedScopeType,omitempty"`

	// The list of applied scopes
	AppliedScopes []*string `json:"appliedScopes,omitempty"`

	// Indicates if the reservation is archived
	Archived *bool `json:"archived,omitempty"`

	// This is the DateTime when the reservation benefit started.
	BenefitStartTime *time.Time `json:"benefitStartTime,omitempty"`

	// The billing plan options available for this SKU.
	BillingPlan *ReservationBillingPlan `json:"billingPlan,omitempty"`

	// Subscription that will be charged for purchasing Reservation
	BillingScopeID *string `json:"billingScopeId,omitempty"`

	// Capabilities of the reservation
	Capabilities *string `json:"capabilities,omitempty"`

	// Friendly name for user to easily identify the reservation
	DisplayName *string `json:"displayName,omitempty"`

	// DateTime of the Reservation starting when this version is effective from.
	EffectiveDateTime *time.Time `json:"effectiveDateTime,omitempty"`

	// This is the date when the Reservation will expire.
	ExpiryDate *time.Time `json:"expiryDate,omitempty"`

	// The message giving detailed information about the status code.
	ExtendedStatusInfo *ExtendedStatusInfo `json:"extendedStatusInfo,omitempty"`

	// Allows reservation discount to be applied across skus within the same Autofit group. Not all skus support instance size
	// flexibility.
	InstanceFlexibility *InstanceFlexibility        `json:"instanceFlexibility,omitempty"`
	MergeProperties     *ReservationMergeProperties `json:"mergeProperties,omitempty"`

	// Current state of the reservation.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// This is the date when the Reservation was purchased.
	PurchaseDate *time.Time `json:"purchaseDate,omitempty"`

	// Quantity of the SKUs that are part of the Reservation.
	Quantity *int32 `json:"quantity,omitempty"`

	// Setting this to true will automatically purchase a new reservation on the expiration date time.
	Renew *bool `json:"renew,omitempty"`

	// Reservation Id of the reservation which is purchased because of renew. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
	RenewDestination *string                  `json:"renewDestination,omitempty"`
	RenewProperties  *RenewPropertiesResponse `json:"renewProperties,omitempty"`

	// Reservation Id of the reservation from which this reservation is renewed. Format of the resource Id is
	// /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
	RenewSource *string `json:"renewSource,omitempty"`

	// The type of the resource that is being reserved.
	ReservedResourceType *ReservedResourceType `json:"reservedResourceType,omitempty"`

	// Description of the SKU in english.
	SKUDescription  *string                     `json:"skuDescription,omitempty"`
	SplitProperties *ReservationSplitProperties `json:"splitProperties,omitempty"`

	// Represent the term of Reservation.
	Term *ReservationTerm `json:"term,omitempty"`

	// READ-ONLY; The provisioning state of the reservation for display, e.g. Succeeded
	DisplayProvisioningState *string `json:"displayProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; DateTime of the last time the Reservation was updated.
	LastUpdatedDateTime *time.Time `json:"lastUpdatedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the reservation, e.g. Succeeded
	ProvisioningSubState *string `json:"provisioningSubState,omitempty" azure:"ro"`

	// READ-ONLY; The applied scope type of the reservation for display, e.g. Shared
	UserFriendlyAppliedScopeType *string `json:"userFriendlyAppliedScopeType,omitempty" azure:"ro"`

	// READ-ONLY; The renew state of the reservation for display, e.g. On
	UserFriendlyRenewState *string `json:"userFriendlyRenewState,omitempty" azure:"ro"`

	// READ-ONLY; Reservation utilization
	Utilization *PropertiesUtilization `json:"utilization,omitempty" azure:"ro"`
}

// PropertiesUtilization - Reservation utilization
type PropertiesUtilization struct {
	// The array of aggregates of a reservation's utilization
	Aggregates []*ReservationUtilizationAggregates `json:"aggregates,omitempty"`

	// READ-ONLY; The number of days trend for a reservation
	Trend *string `json:"trend,omitempty" azure:"ro"`
}

type PurchaseRequest struct {
	// The Azure Region where the reserved resource lives.
	Location   *string                    `json:"location,omitempty"`
	Properties *PurchaseRequestProperties `json:"properties,omitempty"`
	SKU        *SKUName                   `json:"sku,omitempty"`
}

type PurchaseRequestProperties struct {
	// Type of the Applied Scope.
	AppliedScopeType *AppliedScopeType `json:"appliedScopeType,omitempty"`

	// List of the subscriptions that the benefit will be applied. Do not specify if AppliedScopeType is Shared.
	AppliedScopes []*string `json:"appliedScopes,omitempty"`

	// Represent the billing plans.
	BillingPlan *ReservationBillingPlan `json:"billingPlan,omitempty"`

	// Subscription that will be charged for purchasing Reservation
	BillingScopeID *string `json:"billingScopeId,omitempty"`

	// Friendly name of the Reservation
	DisplayName *string `json:"displayName,omitempty"`

	// Quantity of the SKUs that are part of the Reservation.
	Quantity *int32 `json:"quantity,omitempty"`

	// Setting this to true will automatically purchase a new reservation on the expiration date time.
	Renew *bool `json:"renew,omitempty"`

	// Properties specific to each reserved resource type. Not required if not applicable.
	ReservedResourceProperties *PurchaseRequestPropertiesReservedResourceProperties `json:"reservedResourceProperties,omitempty"`

	// The type of the resource that is being reserved.
	ReservedResourceType *ReservedResourceType `json:"reservedResourceType,omitempty"`

	// Represent the term of Reservation.
	Term *ReservationTerm `json:"term,omitempty"`
}

// PurchaseRequestPropertiesReservedResourceProperties - Properties specific to each reserved resource type. Not required
// if not applicable.
type PurchaseRequestPropertiesReservedResourceProperties struct {
	// Turning this on will apply the reservation discount to other VMs in the same VM size group. Only specify for VirtualMachines
	// reserved resource type.
	InstanceFlexibility *InstanceFlexibility `json:"instanceFlexibility,omitempty"`
}

// QuotaClientBeginCreateOrUpdateOptions contains the optional parameters for the QuotaClient.BeginCreateOrUpdate method.
type QuotaClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// QuotaClientBeginUpdateOptions contains the optional parameters for the QuotaClient.BeginUpdate method.
type QuotaClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// QuotaClientGetOptions contains the optional parameters for the QuotaClient.Get method.
type QuotaClientGetOptions struct {
	// placeholder for future optional parameters
}

// QuotaClientListOptions contains the optional parameters for the QuotaClient.List method.
type QuotaClientListOptions struct {
	// placeholder for future optional parameters
}

// QuotaLimits - Quota limits.
type QuotaLimits struct {
	// The URI for fetching the next page of quotas (service limits). When no more pages exist, the value is null.
	NextLink *string `json:"nextLink,omitempty"`

	// List of quotas (service limits).
	Value []*CurrentQuotaLimitBase `json:"value,omitempty"`
}

// QuotaLimitsResponse - Quotas (service limits) in the request response.
type QuotaLimitsResponse struct {
	// The URI for fetching the next page of quota limits. When no more pages exist, the value is null.
	NextLink *string `json:"nextLink,omitempty"`

	// List of quotas with the quota request status.
	Value []*CurrentQuotaLimit `json:"value,omitempty"`
}

// QuotaProperties - Quota properties for the resource.
type QuotaProperties struct {
	// Quota properties.
	Limit *int32 `json:"limit,omitempty"`

	// Name of the resource provide by the resource provider. Use this property for quotaRequests resource operations.
	Name *ResourceName `json:"name,omitempty"`

	// Additional properties for the specified resource provider.
	Properties interface{} `json:"properties,omitempty"`

	// The name of the resource type.
	ResourceType *ResourceType `json:"resourceType,omitempty"`

	// The limit units, such as count and bytes. Use the unit field provided in the response of the GET quota operation.
	Unit *string `json:"unit,omitempty"`

	// READ-ONLY; Current usage value for the resource.
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; The time period over which the quota usage values are summarized. For example, P1D (per one day), PT1M (per
	// one minute), and PT1S (per one second). This parameter is optional because, for some
	// resources such as compute, the time period is irrelevant.
	QuotaPeriod *string `json:"quotaPeriod,omitempty" azure:"ro"`
}

// QuotaRequestDetails - Quota request details.
type QuotaRequestDetails struct {
	// Quota request details.
	Properties *QuotaRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Quota request ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Quota request name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QuotaRequestDetailsList - Quota request details.
type QuotaRequestDetailsList struct {
	// The URI to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string `json:"nextLink,omitempty"`

	// The quota requests.
	Value []*QuotaRequestDetails `json:"value,omitempty"`
}

// QuotaRequestOneResourceProperties - The details of quota request.
type QuotaRequestOneResourceProperties struct {
	// The quota request addition properties.
	Properties *CurrentQuotaLimitBase `json:"properties,omitempty"`

	// READ-ONLY; User friendly status message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The quota request status.
	ProvisioningState *QuotaRequestState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time when the quota request was submitted using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	RequestSubmitTime *time.Time `json:"requestSubmitTime,omitempty" azure:"ro"`
}

// QuotaRequestOneResourceSubmitResponse - Response for the quota submission request.
type QuotaRequestOneResourceSubmitResponse struct {
	// The details for quota request.
	Properties *QuotaRequestOneResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; The quota request ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/ServiceLimits"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QuotaRequestProperties - The details of quota request.
type QuotaRequestProperties struct {
	// The quota request status.
	ProvisioningState *QuotaRequestState `json:"provisioningState,omitempty"`

	// The quotaRequests.
	Value []*SubRequest `json:"value,omitempty"`

	// READ-ONLY; User friendly status message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The time when the quota request was submitted using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	RequestSubmitTime *time.Time `json:"requestSubmitTime,omitempty" azure:"ro"`
}

// QuotaRequestStatusClientGetOptions contains the optional parameters for the QuotaRequestStatusClient.Get method.
type QuotaRequestStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// QuotaRequestStatusClientListOptions contains the optional parameters for the QuotaRequestStatusClient.List method.
type QuotaRequestStatusClientListOptions struct {
	// FIELD SUPPORTED OPERATORS
	// requestSubmitTime ge, le, eq, gt, lt
	Filter *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element includes a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// Number of records to return.
	Top *int32
}

// QuotaRequestStatusDetails - Quota request status details.
type QuotaRequestStatusDetails struct {
	// READ-ONLY; A user friendly message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The details of the quota request status.
	ProvisioningState *QuotaRequestState `json:"provisioningState,omitempty" azure:"ro"`
}

// QuotaRequestSubmitResponse - Response for the quota submission request.
type QuotaRequestSubmitResponse struct {
	// The quota request details.
	Properties *QuotaRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; The quota request ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/serviceLimits"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QuotaRequestSubmitResponse201 - Response with request ID that the quota request was accepted.
type QuotaRequestSubmitResponse201 struct {
	// Quota request status.
	Properties *QuotaRequestStatusDetails `json:"properties,omitempty"`

	// READ-ONLY; The quota request ID. Use the requestId parameter to check the request status.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation ID
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RefundBillingInformation - billing information
type RefundBillingInformation struct {
	BillingCurrencyProratedAmount            *Price `json:"billingCurrencyProratedAmount,omitempty"`
	BillingCurrencyRemainingCommitmentAmount *Price `json:"billingCurrencyRemainingCommitmentAmount,omitempty"`
	BillingCurrencyTotalPaidAmount           *Price `json:"billingCurrencyTotalPaidAmount,omitempty"`

	// Represent the billing plans.
	BillingPlan *ReservationBillingPlan `json:"billingPlan,omitempty"`

	// The number of completed transactions in this reservation's payment
	CompletedTransactions *int32 `json:"completedTransactions,omitempty"`

	// The number of total transactions in this reservation's payment
	TotalTransactions *int32 `json:"totalTransactions,omitempty"`
}

// RefundPolicyError - error details
type RefundPolicyError struct {
	Code    *ErrorResponseCode `json:"code,omitempty"`
	Message *string            `json:"message,omitempty"`
}

// RefundPolicyResult - Refund policy result
type RefundPolicyResult struct {
	// Refund policy result property
	Properties *RefundPolicyResultProperty `json:"properties,omitempty"`
}

// RefundPolicyResultProperty - Refund policy result property
type RefundPolicyResultProperty struct {
	ConsumedRefundsTotal *Price `json:"consumedRefundsTotal,omitempty"`
	MaxRefundLimit       *Price `json:"maxRefundLimit,omitempty"`

	// Refund Policy errors
	PolicyErrors []*RefundPolicyError `json:"policyErrors,omitempty"`
}

type RefundRequest struct {
	Properties *RefundRequestProperties `json:"properties,omitempty"`
}

type RefundRequestProperties struct {
	// Reservation to return
	ReservationToReturn *ReservationToReturn `json:"reservationToReturn,omitempty"`

	// The reason of returning the reservation
	ReturnReason *string `json:"returnReason,omitempty"`

	// The scope of the refund, e.g. Reservation
	Scope *string `json:"scope,omitempty"`

	// SessionId that was returned by CalculateRefund API.
	SessionID *string `json:"sessionId,omitempty"`
}

type RefundResponse struct {
	// Fully qualified identifier of the reservation being returned
	ID         *string                   `json:"id,omitempty"`
	Properties *RefundResponseProperties `json:"properties,omitempty"`
}

type RefundResponseProperties struct {
	// billing information
	BillingInformation  *RefundBillingInformation `json:"billingInformation,omitempty"`
	BillingRefundAmount *Price                    `json:"billingRefundAmount,omitempty"`

	// Refund policy result
	PolicyResult        *RefundPolicyResult `json:"policyResult,omitempty"`
	PricingRefundAmount *Price              `json:"pricingRefundAmount,omitempty"`

	// Quantity to be returned
	Quantity *int32 `json:"quantity,omitempty"`

	// Refund session identifier
	SessionID *string `json:"sessionId,omitempty"`
}

type RenewPropertiesResponse struct {
	// Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included.
	BillingCurrencyTotal *RenewPropertiesResponseBillingCurrencyTotal `json:"billingCurrencyTotal,omitempty"`

	// Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked
	// price 30 days before expiry.
	PricingCurrencyTotal *RenewPropertiesResponsePricingCurrencyTotal `json:"pricingCurrencyTotal,omitempty"`
	PurchaseProperties   *PurchaseRequest                             `json:"purchaseProperties,omitempty"`
}

// RenewPropertiesResponseBillingCurrencyTotal - Currency and amount that customer will be charged in customer's local currency
// for renewal purchase. Tax is not included.
type RenewPropertiesResponseBillingCurrencyTotal struct {
	Amount *float32 `json:"amount,omitempty"`

	// The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string `json:"currencyCode,omitempty"`
}

// RenewPropertiesResponsePricingCurrencyTotal - Amount that Microsoft uses for record. Used during refund for calculating
// refund limit. Tax is not included. This is locked price 30 days before expiry.
type RenewPropertiesResponsePricingCurrencyTotal struct {
	Amount *float32 `json:"amount,omitempty"`

	// The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string `json:"currencyCode,omitempty"`
}

// ReservationClientArchiveOptions contains the optional parameters for the ReservationClient.Archive method.
type ReservationClientArchiveOptions struct {
	// placeholder for future optional parameters
}

// ReservationClientBeginAvailableScopesOptions contains the optional parameters for the ReservationClient.BeginAvailableScopes
// method.
type ReservationClientBeginAvailableScopesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReservationClientBeginMergeOptions contains the optional parameters for the ReservationClient.BeginMerge method.
type ReservationClientBeginMergeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReservationClientBeginSplitOptions contains the optional parameters for the ReservationClient.BeginSplit method.
type ReservationClientBeginSplitOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReservationClientBeginUpdateOptions contains the optional parameters for the ReservationClient.BeginUpdate method.
type ReservationClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReservationClientGetOptions contains the optional parameters for the ReservationClient.Get method.
type ReservationClientGetOptions struct {
	// Supported value of this query is renewProperties
	Expand *string
}

// ReservationClientListAllOptions contains the optional parameters for the ReservationClient.ListAll method.
type ReservationClientListAllOptions struct {
	// May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support
	// 'ne', 'gt', 'le', 'ge', or 'not'. Reservation properties include sku/name,
	// properties/{appliedScopeType, archived, displayName, displayProvisioningState, effectiveDateTime, expiryDate, provisioningState,
	// quantity, renew, reservedResourceType, term,
	// userFriendlyAppliedScopeType, userFriendlyRenewState}
	Filter *string
	// May be used to sort order by reservation properties.
	Orderby *string
	// To indicate whether to refresh the roll up counts of the reservations group by provisioning states
	RefreshSummary *string
	// The selected provisioning state
	SelectedState *string
	// The number of reservations to skip from the list before returning results
	Skiptoken *float32
	// To number of reservations to return
	Take *float32
}

// ReservationClientListOptions contains the optional parameters for the ReservationClient.List method.
type ReservationClientListOptions struct {
	// placeholder for future optional parameters
}

// ReservationClientListRevisionsOptions contains the optional parameters for the ReservationClient.ListRevisions method.
type ReservationClientListRevisionsOptions struct {
	// placeholder for future optional parameters
}

// ReservationClientUnarchiveOptions contains the optional parameters for the ReservationClient.Unarchive method.
type ReservationClientUnarchiveOptions struct {
	// placeholder for future optional parameters
}

type ReservationList struct {
	// Url to get the next page of reservations.
	NextLink *string                `json:"nextLink,omitempty"`
	Value    []*ReservationResponse `json:"value,omitempty"`
}

type ReservationMergeProperties struct {
	// Reservation Resource Id Created due to the merge. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeDestination *string `json:"mergeDestination,omitempty"`

	// Resource Ids of the Source Reservation's merged to form this Reservation. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeSources []*string `json:"mergeSources,omitempty"`
}

// ReservationOrderBillingPlanInformation - Information describing the type of billing plan for this reservation.
type ReservationOrderBillingPlanInformation struct {
	// For recurring billing plans, indicates the date when next payment will be processed. Null when total is paid off.
	NextPaymentDueDate *time.Time `json:"nextPaymentDueDate,omitempty"`

	// Amount of money to be paid for the Order. Tax is not included.
	PricingCurrencyTotal *Price `json:"pricingCurrencyTotal,omitempty"`

	// Date when the billing plan has started.
	StartDate    *time.Time       `json:"startDate,omitempty"`
	Transactions []*PaymentDetail `json:"transactions,omitempty"`
}

// ReservationOrderClientBeginPurchaseOptions contains the optional parameters for the ReservationOrderClient.BeginPurchase
// method.
type ReservationOrderClientBeginPurchaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReservationOrderClientCalculateOptions contains the optional parameters for the ReservationOrderClient.Calculate method.
type ReservationOrderClientCalculateOptions struct {
	// placeholder for future optional parameters
}

// ReservationOrderClientChangeDirectoryOptions contains the optional parameters for the ReservationOrderClient.ChangeDirectory
// method.
type ReservationOrderClientChangeDirectoryOptions struct {
	// placeholder for future optional parameters
}

// ReservationOrderClientGetOptions contains the optional parameters for the ReservationOrderClient.Get method.
type ReservationOrderClientGetOptions struct {
	// May be used to expand the planInformation.
	Expand *string
}

// ReservationOrderClientListOptions contains the optional parameters for the ReservationOrderClient.List method.
type ReservationOrderClientListOptions struct {
	// placeholder for future optional parameters
}

type ReservationOrderList struct {
	// Url to get the next page of reservationOrders.
	NextLink *string                     `json:"nextLink,omitempty"`
	Value    []*ReservationOrderResponse `json:"value,omitempty"`
}

type ReservationOrderProperties struct {
	// This is the DateTime when the reservation benefit started.
	BenefitStartTime *time.Time `json:"benefitStartTime,omitempty"`

	// Represent the billing plans.
	BillingPlan *ReservationBillingPlan `json:"billingPlan,omitempty"`

	// This is the DateTime when the reservation was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`

	// Friendly name for user to easily identified the reservation.
	DisplayName *string `json:"displayName,omitempty"`

	// This is the date when the Reservation will expire.
	ExpiryDate *time.Time `json:"expiryDate,omitempty"`

	// Total Quantity of the SKUs purchased in the Reservation.
	OriginalQuantity *int32 `json:"originalQuantity,omitempty"`

	// Information describing the type of billing plan for this reservation.
	PlanInformation *ReservationOrderBillingPlanInformation `json:"planInformation,omitempty"`

	// Current state of the reservation.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// This is the DateTime when the reservation was initially requested for purchase.
	RequestDateTime *time.Time             `json:"requestDateTime,omitempty"`
	Reservations    []*ReservationResponse `json:"reservations,omitempty"`

	// Represent the term of Reservation.
	Term *ReservationTerm `json:"term,omitempty"`
}

type ReservationOrderResponse struct {
	Etag       *int32                      `json:"etag,omitempty"`
	Properties *ReservationOrderProperties `json:"properties,omitempty"`

	// READ-ONLY; Identifier of the reservation
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the reservation
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/reservations"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationResponse - The definition of the reservation.
type ReservationResponse struct {
	Etag *int32 `json:"etag,omitempty"`

	// Resource Provider type to be reserved.
	Kind *string `json:"kind,omitempty"`

	// The Azure Region where the reserved resource lives.
	Location *string `json:"location,omitempty"`

	// The properties associated to this reservation
	Properties *Properties `json:"properties,omitempty"`

	// The sku information associated to this reservation
	SKU *SKUName `json:"sku,omitempty"`

	// READ-ONLY; Identifier of the reservation
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the reservation
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of resource. "Microsoft.Capacity/reservationOrders/reservations"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ReservationSplitProperties struct {
	// List of destination Resource Id that are created due to split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitDestinations []*string `json:"splitDestinations,omitempty"`

	// Resource Id of the Reservation from which this is split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitSource *string `json:"splitSource,omitempty"`
}

// ReservationSummary - The roll up count summary of reservations in each state
type ReservationSummary struct {
	// READ-ONLY; The number of reservation in Cancelled state
	CancelledCount *float32 `json:"cancelledCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Expired state
	ExpiredCount *float32 `json:"expiredCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Expiring state
	ExpiringCount *float32 `json:"expiringCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Failed state
	FailedCount *float32 `json:"failedCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Pending state
	PendingCount *float32 `json:"pendingCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Processing state
	ProcessingCount *float32 `json:"processingCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Succeeded state
	SucceededCount *float32 `json:"succeededCount,omitempty" azure:"ro"`
}

// ReservationToExchange - Reservation refund details
type ReservationToExchange struct {
	// billing information
	BillingInformation  *BillingInformation `json:"billingInformation,omitempty"`
	BillingRefundAmount *Price              `json:"billingRefundAmount,omitempty"`

	// Quantity to be returned
	Quantity *int32 `json:"quantity,omitempty"`

	// Fully qualified id of the Reservation being returned.
	ReservationID *string `json:"reservationId,omitempty"`
}

// ReservationToPurchaseCalculateExchange - Reservation purchase details
type ReservationToPurchaseCalculateExchange struct {
	BillingCurrencyTotal *Price           `json:"billingCurrencyTotal,omitempty"`
	Properties           *PurchaseRequest `json:"properties,omitempty"`
}

// ReservationToPurchaseExchange - Reservation purchase details
type ReservationToPurchaseExchange struct {
	BillingCurrencyTotal *Price           `json:"billingCurrencyTotal,omitempty"`
	Properties           *PurchaseRequest `json:"properties,omitempty"`

	// Fully qualified id of the Reservation being purchased. This value is only guaranteed to be non-null if the purchase is
	// successful.
	ReservationID *string `json:"reservationId,omitempty"`

	// Fully qualified id of the ReservationOrder being purchased
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`

	// Status of the individual operation.
	Status *OperationStatus `json:"status,omitempty"`
}

// ReservationToReturn - Reservation to return
type ReservationToReturn struct {
	// Quantity to be returned. Must be greater than zero.
	Quantity *int32 `json:"quantity,omitempty"`

	// Fully qualified identifier of the Reservation being returned
	ReservationID *string `json:"reservationId,omitempty"`
}

// ReservationToReturnForExchange - Reservation refund details
type ReservationToReturnForExchange struct {
	// billing information
	BillingInformation  *BillingInformation `json:"billingInformation,omitempty"`
	BillingRefundAmount *Price              `json:"billingRefundAmount,omitempty"`

	// Quantity to be returned
	Quantity *int32 `json:"quantity,omitempty"`

	// Fully qualified id of the Reservation being returned.
	ReservationID *string `json:"reservationId,omitempty"`

	// Status of the individual operation.
	Status *OperationStatus `json:"status,omitempty"`
}

// ReservationUtilizationAggregates - The aggregate values of reservation utilization
type ReservationUtilizationAggregates struct {
	// READ-ONLY; The grain of the aggregate
	Grain *float32 `json:"grain,omitempty" azure:"ro"`

	// READ-ONLY; The grain unit of the aggregate
	GrainUnit *string `json:"grainUnit,omitempty" azure:"ro"`

	// READ-ONLY; The aggregate value
	Value *float32 `json:"value,omitempty" azure:"ro"`

	// READ-ONLY; The aggregate value unit
	ValueUnit *string `json:"valueUnit,omitempty" azure:"ro"`
}

// ResourceName - Resource name provided by the resource provider. Use this property for quotaRequest parameter.
type ResourceName struct {
	// Resource name.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; Resource display localized name.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`
}

// ReturnClientPostOptions contains the optional parameters for the ReturnClient.Post method.
type ReturnClientPostOptions struct {
	// placeholder for future optional parameters
}

type SKUCapability struct {
	// An invariant to describe the feature.
	Name *string `json:"name,omitempty"`

	// An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

type SKUName struct {
	Name *string `json:"name,omitempty"`
}

type SKUProperty struct {
	// An invariant to describe the feature.
	Name *string `json:"name,omitempty"`

	// An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

type SKURestriction struct {
	// The reason for restriction.
	ReasonCode *string `json:"reasonCode,omitempty"`

	// The type of restrictions.
	Type *string `json:"type,omitempty"`

	// The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU
	// is restricted.
	Values []*string `json:"values,omitempty"`
}

type ScopeProperties struct {
	Scope *string `json:"scope,omitempty"`
	Valid *bool   `json:"valid,omitempty"`
}

// ServiceError - The API error details.
type ServiceError struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error message text.
	Message *string `json:"message,omitempty"`

	// READ-ONLY; The list of error details.
	Details []*ServiceErrorDetail `json:"details,omitempty" azure:"ro"`
}

// ServiceErrorDetail - The error details.
type ServiceErrorDetail struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

type SplitProperties struct {
	// List of the quantities in the new reservations to create.
	Quantities []*int32 `json:"quantities,omitempty"`

	// Resource id of the reservation to be split. Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	ReservationID *string `json:"reservationId,omitempty"`
}

type SplitRequest struct {
	Properties *SplitProperties `json:"properties,omitempty"`
}

// SubRequest - The sub-request submitted with the quota request.
type SubRequest struct {
	// The resource name.
	Name *ResourceName `json:"name,omitempty"`

	// The quota request status.
	ProvisioningState *QuotaRequestState `json:"provisioningState,omitempty"`

	// The limit units, such as count and bytes. Use the unit field provided in the response of the GET quota operation.
	Unit *string `json:"unit,omitempty"`

	// READ-ONLY; Quota (resource limit).
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; User-friendly status message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Resource type for which the quota check was made.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Sub request ID for individual request.
	SubRequestID *string `json:"subRequestId,omitempty" azure:"ro"`
}

type SubscriptionScopeProperties struct {
	Scopes []*ScopeProperties `json:"scopes,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
