//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// EnvironmentsClient contains the methods for the AppServiceEnvironments group.
// Don't use this type directly, use NewEnvironmentsClient() instead.
type EnvironmentsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewEnvironmentsClient creates a new instance of EnvironmentsClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewEnvironmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EnvironmentsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &EnvironmentsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the
// EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection method.
func (client *EnvironmentsClient) BeginApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*runtime.Poller[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.approveOrRejectPrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// ApproveOrRejectPrivateEndpointConnection - Description for Approves or rejects a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) approveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.approveOrRejectPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// approveOrRejectPrivateEndpointConnectionCreateRequest creates the ApproveOrRejectPrivateEndpointConnection request.
func (client *EnvironmentsClient) approveOrRejectPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource, options *EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, privateEndpointWrapper)
}

// BeginChangeVnet - Description for Move an App Service Environment to a different VNET.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// vnetInfo - Details for the new virtual network.
// options - EnvironmentsClientBeginChangeVnetOptions contains the optional parameters for the EnvironmentsClient.BeginChangeVnet
// method.
func (client *EnvironmentsClient) BeginChangeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientChangeVnetResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientChangeVnetResponse]{
		More: func(page EnvironmentsClientChangeVnetResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientChangeVnetResponse) (EnvironmentsClientChangeVnetResponse, error) {
			req, err := runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			if err != nil {
				return EnvironmentsClientChangeVnetResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientChangeVnetResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientChangeVnetResponse{}, runtime.NewResponseError(resp)
			}
			return client.changeVnetHandleResponse(resp)
		},
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.changeVnet(ctx, resourceGroupName, name, vnetInfo, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientChangeVnetResponse]]{
			Response: &pager,
		})
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.pl, &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientChangeVnetResponse]]{
			Response: &pager,
		})
	}
}

// ChangeVnet - Description for Move an App Service Environment to a different VNET.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) changeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*http.Response, error) {
	req, err := client.changeVnetCreateRequest(ctx, resourceGroupName, name, vnetInfo, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// changeVnetCreateRequest creates the ChangeVnet request.
func (client *EnvironmentsClient) changeVnetCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile, options *EnvironmentsClientBeginChangeVnetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, vnetInfo)
}

// changeVnetHandleResponse handles the ChangeVnet response.
func (client *EnvironmentsClient) changeVnetHandleResponse(resp *http.Response) (EnvironmentsClientChangeVnetResponse, error) {
	result := EnvironmentsClientChangeVnetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientChangeVnetResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// hostingEnvironmentEnvelope - Configuration details of the App Service Environment.
// options - EnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdate
// method.
func (client *EnvironmentsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) createOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *EnvironmentsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentResource, options *EnvironmentsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, hostingEnvironmentEnvelope)
}

// BeginCreateOrUpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// multiRolePoolEnvelope - Properties of the multi-role pool.
// options - EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateMultiRolePool
// method.
func (client *EnvironmentsClient) BeginCreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateMultiRolePool(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientCreateOrUpdateMultiRolePoolResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) createOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*http.Response, error) {
	req, err := client.createOrUpdateMultiRolePoolCreateRequest(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateMultiRolePoolCreateRequest creates the CreateOrUpdateMultiRolePool request.
func (client *EnvironmentsClient) createOrUpdateMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, multiRolePoolEnvelope)
}

// BeginCreateOrUpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// workerPoolEnvelope - Properties of the worker pool.
// options - EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateWorkerPool
// method.
func (client *EnvironmentsClient) BeginCreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*runtime.Poller[EnvironmentsClientCreateOrUpdateWorkerPoolResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateWorkerPool(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientCreateOrUpdateWorkerPoolResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientCreateOrUpdateWorkerPoolResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) createOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*http.Response, error) {
	req, err := client.createOrUpdateWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateWorkerPoolCreateRequest creates the CreateOrUpdateWorkerPool request.
func (client *EnvironmentsClient) createOrUpdateWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, workerPoolEnvelope)
}

// BeginDelete - Description for Delete an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginDeleteOptions contains the optional parameters for the EnvironmentsClient.BeginDelete
// method.
func (client *EnvironmentsClient) BeginDelete(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*runtime.Poller[EnvironmentsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Description for Delete an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) deleteOperation(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *EnvironmentsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ForceDelete != nil {
		reqQP.Set("forceDelete", strconv.FormatBool(*options.ForceDelete))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAseCustomDNSSuffixConfiguration - Delete Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration
// method.
func (client *EnvironmentsClient) DeleteAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse, error) {
	req, err := client.deleteAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteAseCustomDNSSuffixConfigurationHandleResponse(resp)
}

// deleteAseCustomDNSSuffixConfigurationCreateRequest creates the DeleteAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) deleteAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAseCustomDNSSuffixConfigurationHandleResponse handles the DeleteAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) deleteAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Interface); err != nil {
		return EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// BeginDeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.BeginDeletePrivateEndpointConnection
// method.
func (client *EnvironmentsClient) BeginDeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*runtime.Poller[EnvironmentsClientDeletePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnection(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientDeletePrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientDeletePrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeletePrivateEndpointConnection - Description for Deletes a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) deletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.deletePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deletePrivateEndpointConnectionCreateRequest creates the DeletePrivateEndpointConnection request.
func (client *EnvironmentsClient) deletePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get the properties of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetOptions contains the optional parameters for the EnvironmentsClient.Get method.
func (client *EnvironmentsClient) Get(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOptions) (EnvironmentsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *EnvironmentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *EnvironmentsClient) getHandleResponse(resp *http.Response) (EnvironmentsClientGetResponse, error) {
	result := EnvironmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentResource); err != nil {
		return EnvironmentsClientGetResponse{}, err
	}
	return result, nil
}

// GetAseCustomDNSSuffixConfiguration - Get Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseCustomDNSSuffixConfiguration
// method.
func (client *EnvironmentsClient) GetAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse, error) {
	req, err := client.getAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAseCustomDNSSuffixConfigurationHandleResponse(resp)
}

// getAseCustomDNSSuffixConfigurationCreateRequest creates the GetAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) getAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAseCustomDNSSuffixConfigurationHandleResponse handles the GetAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) getAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomDNSSuffixConfiguration); err != nil {
		return EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// GetAseV3NetworkingConfiguration - Description for Get networking configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetAseV3NetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseV3NetworkingConfiguration
// method.
func (client *EnvironmentsClient) GetAseV3NetworkingConfiguration(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseV3NetworkingConfigurationOptions) (EnvironmentsClientGetAseV3NetworkingConfigurationResponse, error) {
	req, err := client.getAseV3NetworkingConfigurationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAseV3NetworkingConfigurationHandleResponse(resp)
}

// getAseV3NetworkingConfigurationCreateRequest creates the GetAseV3NetworkingConfiguration request.
func (client *EnvironmentsClient) getAseV3NetworkingConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetAseV3NetworkingConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/networking"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAseV3NetworkingConfigurationHandleResponse handles the GetAseV3NetworkingConfiguration response.
func (client *EnvironmentsClient) getAseV3NetworkingConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientGetAseV3NetworkingConfigurationResponse, error) {
	result := EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AseV3NetworkingConfiguration); err != nil {
		return EnvironmentsClientGetAseV3NetworkingConfigurationResponse{}, err
	}
	return result, nil
}

// GetDiagnosticsItem - Description for Get a diagnostics item for an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// diagnosticsName - Name of the diagnostics item.
// options - EnvironmentsClientGetDiagnosticsItemOptions contains the optional parameters for the EnvironmentsClient.GetDiagnosticsItem
// method.
func (client *EnvironmentsClient) GetDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string, options *EnvironmentsClientGetDiagnosticsItemOptions) (EnvironmentsClientGetDiagnosticsItemResponse, error) {
	req, err := client.getDiagnosticsItemCreateRequest(ctx, resourceGroupName, name, diagnosticsName, options)
	if err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDiagnosticsItemHandleResponse(resp)
}

// getDiagnosticsItemCreateRequest creates the GetDiagnosticsItem request.
func (client *EnvironmentsClient) getDiagnosticsItemCreateRequest(ctx context.Context, resourceGroupName string, name string, diagnosticsName string, options *EnvironmentsClientGetDiagnosticsItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if diagnosticsName == "" {
		return nil, errors.New("parameter diagnosticsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticsName}", url.PathEscape(diagnosticsName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDiagnosticsItemHandleResponse handles the GetDiagnosticsItem response.
func (client *EnvironmentsClient) getDiagnosticsItemHandleResponse(resp *http.Response) (EnvironmentsClientGetDiagnosticsItemResponse, error) {
	result := EnvironmentsClientGetDiagnosticsItemResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostingEnvironmentDiagnostics); err != nil {
		return EnvironmentsClientGetDiagnosticsItemResponse{}, err
	}
	return result, nil
}

// NewGetInboundNetworkDependenciesEndpointsPager - Description for Get the network endpoints of all inbound dependencies
// of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.GetInboundNetworkDependenciesEndpoints
// method.
func (client *EnvironmentsClient) NewGetInboundNetworkDependenciesEndpointsPager(resourceGroupName string, name string, options *EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions) *runtime.Pager[EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse]{
		More: func(page EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse) (EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getInboundNetworkDependenciesEndpointsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getInboundNetworkDependenciesEndpointsHandleResponse(resp)
		},
	})
}

// getInboundNetworkDependenciesEndpointsCreateRequest creates the GetInboundNetworkDependenciesEndpoints request.
func (client *EnvironmentsClient) getInboundNetworkDependenciesEndpointsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/inboundNetworkDependenciesEndpoints"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getInboundNetworkDependenciesEndpointsHandleResponse handles the GetInboundNetworkDependenciesEndpoints response.
func (client *EnvironmentsClient) getInboundNetworkDependenciesEndpointsHandleResponse(resp *http.Response) (EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse, error) {
	result := EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InboundEnvironmentEndpointCollection); err != nil {
		return EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse{}, err
	}
	return result, nil
}

// GetMultiRolePool - Description for Get properties of a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.GetMultiRolePool
// method.
func (client *EnvironmentsClient) GetMultiRolePool(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetMultiRolePoolOptions) (EnvironmentsClientGetMultiRolePoolResponse, error) {
	req, err := client.getMultiRolePoolCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetMultiRolePoolResponse{}, runtime.NewResponseError(resp)
	}
	return client.getMultiRolePoolHandleResponse(resp)
}

// getMultiRolePoolCreateRequest creates the GetMultiRolePool request.
func (client *EnvironmentsClient) getMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getMultiRolePoolHandleResponse handles the GetMultiRolePool response.
func (client *EnvironmentsClient) getMultiRolePoolHandleResponse(resp *http.Response) (EnvironmentsClientGetMultiRolePoolResponse, error) {
	result := EnvironmentsClientGetMultiRolePoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientGetMultiRolePoolResponse{}, err
	}
	return result, nil
}

// NewGetOutboundNetworkDependenciesEndpointsPager - Description for Get the network endpoints of all outbound dependencies
// of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.GetOutboundNetworkDependenciesEndpoints
// method.
func (client *EnvironmentsClient) NewGetOutboundNetworkDependenciesEndpointsPager(resourceGroupName string, name string, options *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions) *runtime.Pager[EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse]{
		More: func(page EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse) (EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getOutboundNetworkDependenciesEndpointsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getOutboundNetworkDependenciesEndpointsHandleResponse(resp)
		},
	})
}

// getOutboundNetworkDependenciesEndpointsCreateRequest creates the GetOutboundNetworkDependenciesEndpoints request.
func (client *EnvironmentsClient) getOutboundNetworkDependenciesEndpointsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/outboundNetworkDependenciesEndpoints"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOutboundNetworkDependenciesEndpointsHandleResponse handles the GetOutboundNetworkDependenciesEndpoints response.
func (client *EnvironmentsClient) getOutboundNetworkDependenciesEndpointsHandleResponse(resp *http.Response) (EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse, error) {
	result := EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OutboundEnvironmentEndpointCollection); err != nil {
		return EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnection - Description for Gets a private endpoint connection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// privateEndpointConnectionName - Name of the private endpoint connection.
// options - EnvironmentsClientGetPrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.GetPrivateEndpointConnection
// method.
func (client *EnvironmentsClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientGetPrivateEndpointConnectionOptions) (EnvironmentsClientGetPrivateEndpointConnectionResponse, error) {
	req, err := client.getPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, name, privateEndpointConnectionName, options)
	if err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateEndpointConnectionHandleResponse(resp)
}

// getPrivateEndpointConnectionCreateRequest creates the GetPrivateEndpointConnection request.
func (client *EnvironmentsClient) getPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, options *EnvironmentsClientGetPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionHandleResponse handles the GetPrivateEndpointConnection response.
func (client *EnvironmentsClient) getPrivateEndpointConnectionHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateEndpointConnectionResponse, error) {
	result := EnvironmentsClientGetPrivateEndpointConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemotePrivateEndpointConnectionARMResource); err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionResponse{}, err
	}
	return result, nil
}

// NewGetPrivateEndpointConnectionListPager - Description for Gets the list of private endpoints associated with a hosting
// environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the EnvironmentsClient.GetPrivateEndpointConnectionList
// method.
func (client *EnvironmentsClient) NewGetPrivateEndpointConnectionListPager(resourceGroupName string, name string, options *EnvironmentsClientGetPrivateEndpointConnectionListOptions) *runtime.Pager[EnvironmentsClientGetPrivateEndpointConnectionListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientGetPrivateEndpointConnectionListResponse]{
		More: func(page EnvironmentsClientGetPrivateEndpointConnectionListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientGetPrivateEndpointConnectionListResponse) (EnvironmentsClientGetPrivateEndpointConnectionListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getPrivateEndpointConnectionListCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, runtime.NewResponseError(resp)
			}
			return client.getPrivateEndpointConnectionListHandleResponse(resp)
		},
	})
}

// getPrivateEndpointConnectionListCreateRequest creates the GetPrivateEndpointConnectionList request.
func (client *EnvironmentsClient) getPrivateEndpointConnectionListCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateEndpointConnectionListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionListHandleResponse handles the GetPrivateEndpointConnectionList response.
func (client *EnvironmentsClient) getPrivateEndpointConnectionListHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateEndpointConnectionListResponse, error) {
	result := EnvironmentsClientGetPrivateEndpointConnectionListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionCollection); err != nil {
		return EnvironmentsClientGetPrivateEndpointConnectionListResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResources - Description for Gets the private link resources
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetPrivateLinkResourcesOptions contains the optional parameters for the EnvironmentsClient.GetPrivateLinkResources
// method.
func (client *EnvironmentsClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateLinkResourcesOptions) (EnvironmentsClientGetPrivateLinkResourcesResponse, error) {
	req, err := client.getPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateLinkResourcesHandleResponse(resp)
}

// getPrivateLinkResourcesCreateRequest creates the GetPrivateLinkResources request.
func (client *EnvironmentsClient) getPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateLinkResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesHandleResponse handles the GetPrivateLinkResources response.
func (client *EnvironmentsClient) getPrivateLinkResourcesHandleResponse(resp *http.Response) (EnvironmentsClientGetPrivateLinkResourcesResponse, error) {
	result := EnvironmentsClientGetPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourcesWrapper); err != nil {
		return EnvironmentsClientGetPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// GetVipInfo - Description for Get IP addresses assigned to an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientGetVipInfoOptions contains the optional parameters for the EnvironmentsClient.GetVipInfo method.
func (client *EnvironmentsClient) GetVipInfo(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetVipInfoOptions) (EnvironmentsClientGetVipInfoResponse, error) {
	req, err := client.getVipInfoCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetVipInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVipInfoHandleResponse(resp)
}

// getVipInfoCreateRequest creates the GetVipInfo request.
func (client *EnvironmentsClient) getVipInfoCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientGetVipInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVipInfoHandleResponse handles the GetVipInfo response.
func (client *EnvironmentsClient) getVipInfoHandleResponse(resp *http.Response) (EnvironmentsClientGetVipInfoResponse, error) {
	result := EnvironmentsClientGetVipInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResponse); err != nil {
		return EnvironmentsClientGetVipInfoResponse{}, err
	}
	return result, nil
}

// GetWorkerPool - Description for Get properties of a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// options - EnvironmentsClientGetWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.GetWorkerPool
// method.
func (client *EnvironmentsClient) GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientGetWorkerPoolOptions) (EnvironmentsClientGetWorkerPoolResponse, error) {
	req, err := client.getWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
	if err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientGetWorkerPoolResponse{}, runtime.NewResponseError(resp)
	}
	return client.getWorkerPoolHandleResponse(resp)
}

// getWorkerPoolCreateRequest creates the GetWorkerPool request.
func (client *EnvironmentsClient) getWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientGetWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWorkerPoolHandleResponse handles the GetWorkerPool response.
func (client *EnvironmentsClient) getWorkerPoolHandleResponse(resp *http.Response) (EnvironmentsClientGetWorkerPoolResponse, error) {
	result := EnvironmentsClientGetWorkerPoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientGetWorkerPoolResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all App Service Environments for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - EnvironmentsClientListOptions contains the optional parameters for the EnvironmentsClient.List method.
func (client *EnvironmentsClient) NewListPager(options *EnvironmentsClientListOptions) *runtime.Pager[EnvironmentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListResponse]{
		More: func(page EnvironmentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListResponse) (EnvironmentsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *EnvironmentsClient) listCreateRequest(ctx context.Context, options *EnvironmentsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EnvironmentsClient) listHandleResponse(resp *http.Response) (EnvironmentsClientListResponse, error) {
	result := EnvironmentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentCollection); err != nil {
		return EnvironmentsClientListResponse{}, err
	}
	return result, nil
}

// NewListAppServicePlansPager - Description for Get all App Service plans in an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListAppServicePlansOptions contains the optional parameters for the EnvironmentsClient.ListAppServicePlans
// method.
func (client *EnvironmentsClient) NewListAppServicePlansPager(resourceGroupName string, name string, options *EnvironmentsClientListAppServicePlansOptions) *runtime.Pager[EnvironmentsClientListAppServicePlansResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListAppServicePlansResponse]{
		More: func(page EnvironmentsClientListAppServicePlansResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListAppServicePlansResponse) (EnvironmentsClientListAppServicePlansResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAppServicePlansCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListAppServicePlansResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListAppServicePlansResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListAppServicePlansResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAppServicePlansHandleResponse(resp)
		},
	})
}

// listAppServicePlansCreateRequest creates the ListAppServicePlans request.
func (client *EnvironmentsClient) listAppServicePlansCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListAppServicePlansOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAppServicePlansHandleResponse handles the ListAppServicePlans response.
func (client *EnvironmentsClient) listAppServicePlansHandleResponse(resp *http.Response) (EnvironmentsClientListAppServicePlansResponse, error) {
	result := EnvironmentsClientListAppServicePlansResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PlanCollection); err != nil {
		return EnvironmentsClientListAppServicePlansResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get all App Service Environments in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// options - EnvironmentsClientListByResourceGroupOptions contains the optional parameters for the EnvironmentsClient.ListByResourceGroup
// method.
func (client *EnvironmentsClient) NewListByResourceGroupPager(resourceGroupName string, options *EnvironmentsClientListByResourceGroupOptions) *runtime.Pager[EnvironmentsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListByResourceGroupResponse]{
		More: func(page EnvironmentsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListByResourceGroupResponse) (EnvironmentsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *EnvironmentsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *EnvironmentsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *EnvironmentsClient) listByResourceGroupHandleResponse(resp *http.Response) (EnvironmentsClientListByResourceGroupResponse, error) {
	result := EnvironmentsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentCollection); err != nil {
		return EnvironmentsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListCapacitiesPager - Description for Get the used, available, and total worker capacity an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListCapacitiesOptions contains the optional parameters for the EnvironmentsClient.ListCapacities
// method.
func (client *EnvironmentsClient) NewListCapacitiesPager(resourceGroupName string, name string, options *EnvironmentsClientListCapacitiesOptions) *runtime.Pager[EnvironmentsClientListCapacitiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListCapacitiesResponse]{
		More: func(page EnvironmentsClientListCapacitiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListCapacitiesResponse) (EnvironmentsClientListCapacitiesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCapacitiesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListCapacitiesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListCapacitiesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListCapacitiesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCapacitiesHandleResponse(resp)
		},
	})
}

// listCapacitiesCreateRequest creates the ListCapacities request.
func (client *EnvironmentsClient) listCapacitiesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListCapacitiesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCapacitiesHandleResponse handles the ListCapacities response.
func (client *EnvironmentsClient) listCapacitiesHandleResponse(resp *http.Response) (EnvironmentsClientListCapacitiesResponse, error) {
	result := EnvironmentsClientListCapacitiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StampCapacityCollection); err != nil {
		return EnvironmentsClientListCapacitiesResponse{}, err
	}
	return result, nil
}

// ListDiagnostics - Description for Get diagnostic information for an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListDiagnosticsOptions contains the optional parameters for the EnvironmentsClient.ListDiagnostics
// method.
func (client *EnvironmentsClient) ListDiagnostics(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListDiagnosticsOptions) (EnvironmentsClientListDiagnosticsResponse, error) {
	req, err := client.listDiagnosticsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientListDiagnosticsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listDiagnosticsHandleResponse(resp)
}

// listDiagnosticsCreateRequest creates the ListDiagnostics request.
func (client *EnvironmentsClient) listDiagnosticsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListDiagnosticsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDiagnosticsHandleResponse handles the ListDiagnostics response.
func (client *EnvironmentsClient) listDiagnosticsHandleResponse(resp *http.Response) (EnvironmentsClientListDiagnosticsResponse, error) {
	result := EnvironmentsClientListDiagnosticsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HostingEnvironmentDiagnosticsArray); err != nil {
		return EnvironmentsClientListDiagnosticsResponse{}, err
	}
	return result, nil
}

// NewListMultiRoleMetricDefinitionsPager - Description for Get metric definitions for a multi-role pool of an App Service
// Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListMultiRoleMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRoleMetricDefinitions
// method.
func (client *EnvironmentsClient) NewListMultiRoleMetricDefinitionsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListMultiRoleMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRoleMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListMultiRoleMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRoleMetricDefinitionsResponse) (EnvironmentsClientListMultiRoleMetricDefinitionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMultiRoleMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMultiRoleMetricDefinitionsHandleResponse(resp)
		},
	})
}

// listMultiRoleMetricDefinitionsCreateRequest creates the ListMultiRoleMetricDefinitions request.
func (client *EnvironmentsClient) listMultiRoleMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRoleMetricDefinitionsHandleResponse handles the ListMultiRoleMetricDefinitions response.
func (client *EnvironmentsClient) listMultiRoleMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRoleMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListMultiRoleMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolInstanceMetricDefinitionsPager - Description for Get metric definitions for a specific instance of
// a multi-role pool of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// instance - Name of the instance in the multi-role pool.
// options - EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions contains the optional parameters for the
// EnvironmentsClient.ListMultiRolePoolInstanceMetricDefinitions method.
func (client *EnvironmentsClient) NewListMultiRolePoolInstanceMetricDefinitionsPager(resourceGroupName string, name string, instance string, options *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse) (EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMultiRolePoolInstanceMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, instance, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMultiRolePoolInstanceMetricDefinitionsHandleResponse(resp)
		},
	})
}

// listMultiRolePoolInstanceMetricDefinitionsCreateRequest creates the ListMultiRolePoolInstanceMetricDefinitions request.
func (client *EnvironmentsClient) listMultiRolePoolInstanceMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, instance string, options *EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if instance == "" {
		return nil, errors.New("parameter instance cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instance}", url.PathEscape(instance))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolInstanceMetricDefinitionsHandleResponse handles the ListMultiRolePoolInstanceMetricDefinitions response.
func (client *EnvironmentsClient) listMultiRolePoolInstanceMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolSKUsPager - Description for Get available SKUs for scaling a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListMultiRolePoolSKUsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRolePoolSKUs
// method.
func (client *EnvironmentsClient) NewListMultiRolePoolSKUsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolSKUsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolSKUsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolSKUsResponse) (EnvironmentsClientListMultiRolePoolSKUsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMultiRolePoolSKUsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListMultiRolePoolSKUsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolSKUsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListMultiRolePoolSKUsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMultiRolePoolSKUsHandleResponse(resp)
		},
	})
}

// listMultiRolePoolSKUsCreateRequest creates the ListMultiRolePoolSKUs request.
func (client *EnvironmentsClient) listMultiRolePoolSKUsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolSKUsHandleResponse handles the ListMultiRolePoolSKUs response.
func (client *EnvironmentsClient) listMultiRolePoolSKUsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolSKUsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUInfoCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolSKUsResponse{}, err
	}
	return result, nil
}

// NewListMultiRolePoolsPager - Description for Get all multi-role pools.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListMultiRolePoolsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRolePools
// method.
func (client *EnvironmentsClient) NewListMultiRolePoolsPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolsOptions) *runtime.Pager[EnvironmentsClientListMultiRolePoolsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRolePoolsResponse]{
		More: func(page EnvironmentsClientListMultiRolePoolsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRolePoolsResponse) (EnvironmentsClientListMultiRolePoolsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMultiRolePoolsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListMultiRolePoolsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListMultiRolePoolsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListMultiRolePoolsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMultiRolePoolsHandleResponse(resp)
		},
	})
}

// listMultiRolePoolsCreateRequest creates the ListMultiRolePools request.
func (client *EnvironmentsClient) listMultiRolePoolsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRolePoolsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRolePoolsHandleResponse handles the ListMultiRolePools response.
func (client *EnvironmentsClient) listMultiRolePoolsHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRolePoolsResponse, error) {
	result := EnvironmentsClientListMultiRolePoolsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolCollection); err != nil {
		return EnvironmentsClientListMultiRolePoolsResponse{}, err
	}
	return result, nil
}

// NewListMultiRoleUsagesPager - Description for Get usage metrics for a multi-role pool of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListMultiRoleUsagesOptions contains the optional parameters for the EnvironmentsClient.ListMultiRoleUsages
// method.
func (client *EnvironmentsClient) NewListMultiRoleUsagesPager(resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleUsagesOptions) *runtime.Pager[EnvironmentsClientListMultiRoleUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListMultiRoleUsagesResponse]{
		More: func(page EnvironmentsClientListMultiRoleUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListMultiRoleUsagesResponse) (EnvironmentsClientListMultiRoleUsagesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listMultiRoleUsagesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListMultiRoleUsagesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListMultiRoleUsagesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListMultiRoleUsagesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMultiRoleUsagesHandleResponse(resp)
		},
	})
}

// listMultiRoleUsagesCreateRequest creates the ListMultiRoleUsages request.
func (client *EnvironmentsClient) listMultiRoleUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListMultiRoleUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMultiRoleUsagesHandleResponse handles the ListMultiRoleUsages response.
func (client *EnvironmentsClient) listMultiRoleUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListMultiRoleUsagesResponse, error) {
	result := EnvironmentsClientListMultiRoleUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageCollection); err != nil {
		return EnvironmentsClientListMultiRoleUsagesResponse{}, err
	}
	return result, nil
}

// ListOperations - Description for List all currently running operations on the App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListOperationsOptions contains the optional parameters for the EnvironmentsClient.ListOperations
// method.
func (client *EnvironmentsClient) ListOperations(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListOperationsOptions) (EnvironmentsClientListOperationsResponse, error) {
	req, err := client.listOperationsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientListOperationsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listOperationsHandleResponse(resp)
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *EnvironmentsClient) listOperationsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *EnvironmentsClient) listOperationsHandleResponse(resp *http.Response) (EnvironmentsClientListOperationsResponse, error) {
	result := EnvironmentsClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationArray); err != nil {
		return EnvironmentsClientListOperationsResponse{}, err
	}
	return result, nil
}

// NewListUsagesPager - Description for Get global usage metrics of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListUsagesOptions contains the optional parameters for the EnvironmentsClient.ListUsages method.
func (client *EnvironmentsClient) NewListUsagesPager(resourceGroupName string, name string, options *EnvironmentsClientListUsagesOptions) *runtime.Pager[EnvironmentsClientListUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListUsagesResponse]{
		More: func(page EnvironmentsClientListUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListUsagesResponse) (EnvironmentsClientListUsagesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listUsagesCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListUsagesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListUsagesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListUsagesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listUsagesHandleResponse(resp)
		},
	})
}

// listUsagesCreateRequest creates the ListUsages request.
func (client *EnvironmentsClient) listUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listUsagesHandleResponse handles the ListUsages response.
func (client *EnvironmentsClient) listUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListUsagesResponse, error) {
	result := EnvironmentsClientListUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmUsageQuotaCollection); err != nil {
		return EnvironmentsClientListUsagesResponse{}, err
	}
	return result, nil
}

// NewListWebAppsPager - Description for Get all apps in an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListWebAppsOptions contains the optional parameters for the EnvironmentsClient.ListWebApps
// method.
func (client *EnvironmentsClient) NewListWebAppsPager(resourceGroupName string, name string, options *EnvironmentsClientListWebAppsOptions) *runtime.Pager[EnvironmentsClientListWebAppsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebAppsResponse]{
		More: func(page EnvironmentsClientListWebAppsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebAppsResponse) (EnvironmentsClientListWebAppsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWebAppsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWebAppsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWebAppsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWebAppsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWebAppsHandleResponse(resp)
		},
	})
}

// listWebAppsCreateRequest creates the ListWebApps request.
func (client *EnvironmentsClient) listWebAppsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListWebAppsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.PropertiesToInclude != nil {
		reqQP.Set("propertiesToInclude", *options.PropertiesToInclude)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebAppsHandleResponse handles the ListWebApps response.
func (client *EnvironmentsClient) listWebAppsHandleResponse(resp *http.Response) (EnvironmentsClientListWebAppsResponse, error) {
	result := EnvironmentsClientListWebAppsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientListWebAppsResponse{}, err
	}
	return result, nil
}

// NewListWebWorkerMetricDefinitionsPager - Description for Get metric definitions for a worker pool of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// options - EnvironmentsClientListWebWorkerMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListWebWorkerMetricDefinitions
// method.
func (client *EnvironmentsClient) NewListWebWorkerMetricDefinitionsPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListWebWorkerMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebWorkerMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListWebWorkerMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebWorkerMetricDefinitionsResponse) (EnvironmentsClientListWebWorkerMetricDefinitionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWebWorkerMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWebWorkerMetricDefinitionsHandleResponse(resp)
		},
	})
}

// listWebWorkerMetricDefinitionsCreateRequest creates the ListWebWorkerMetricDefinitions request.
func (client *EnvironmentsClient) listWebWorkerMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebWorkerMetricDefinitionsHandleResponse handles the ListWebWorkerMetricDefinitions response.
func (client *EnvironmentsClient) listWebWorkerMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListWebWorkerMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListWebWorkerMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListWebWorkerUsagesPager - Description for Get usage metrics for a worker pool of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// options - EnvironmentsClientListWebWorkerUsagesOptions contains the optional parameters for the EnvironmentsClient.ListWebWorkerUsages
// method.
func (client *EnvironmentsClient) NewListWebWorkerUsagesPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerUsagesOptions) *runtime.Pager[EnvironmentsClientListWebWorkerUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWebWorkerUsagesResponse]{
		More: func(page EnvironmentsClientListWebWorkerUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWebWorkerUsagesResponse) (EnvironmentsClientListWebWorkerUsagesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWebWorkerUsagesCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWebWorkerUsagesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWebWorkerUsagesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWebWorkerUsagesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWebWorkerUsagesHandleResponse(resp)
		},
	})
}

// listWebWorkerUsagesCreateRequest creates the ListWebWorkerUsages request.
func (client *EnvironmentsClient) listWebWorkerUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWebWorkerUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebWorkerUsagesHandleResponse handles the ListWebWorkerUsages response.
func (client *EnvironmentsClient) listWebWorkerUsagesHandleResponse(resp *http.Response) (EnvironmentsClientListWebWorkerUsagesResponse, error) {
	result := EnvironmentsClientListWebWorkerUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageCollection); err != nil {
		return EnvironmentsClientListWebWorkerUsagesResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolInstanceMetricDefinitionsPager - Description for Get metric definitions for a specific instance of a worker
// pool of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// instance - Name of the instance in the worker pool.
// options - EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPoolInstanceMetricDefinitions
// method.
func (client *EnvironmentsClient) NewListWorkerPoolInstanceMetricDefinitionsPager(resourceGroupName string, name string, workerPoolName string, instance string, options *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse) (EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWorkerPoolInstanceMetricDefinitionsCreateRequest(ctx, resourceGroupName, name, workerPoolName, instance, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWorkerPoolInstanceMetricDefinitionsHandleResponse(resp)
		},
	})
}

// listWorkerPoolInstanceMetricDefinitionsCreateRequest creates the ListWorkerPoolInstanceMetricDefinitions request.
func (client *EnvironmentsClient) listWorkerPoolInstanceMetricDefinitionsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, options *EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if instance == "" {
		return nil, errors.New("parameter instance cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{instance}", url.PathEscape(instance))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolInstanceMetricDefinitionsHandleResponse handles the ListWorkerPoolInstanceMetricDefinitions response.
func (client *EnvironmentsClient) listWorkerPoolInstanceMetricDefinitionsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse, error) {
	result := EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceMetricDefinitionCollection); err != nil {
		return EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolSKUsPager - Description for Get available SKUs for scaling a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// options - EnvironmentsClientListWorkerPoolSKUsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPoolSKUs
// method.
func (client *EnvironmentsClient) NewListWorkerPoolSKUsPager(resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWorkerPoolSKUsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolSKUsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolSKUsResponse) (EnvironmentsClientListWorkerPoolSKUsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWorkerPoolSKUsCreateRequest(ctx, resourceGroupName, name, workerPoolName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWorkerPoolSKUsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWorkerPoolSKUsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWorkerPoolSKUsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWorkerPoolSKUsHandleResponse(resp)
		},
	})
}

// listWorkerPoolSKUsCreateRequest creates the ListWorkerPoolSKUs request.
func (client *EnvironmentsClient) listWorkerPoolSKUsCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, options *EnvironmentsClientListWorkerPoolSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolSKUsHandleResponse handles the ListWorkerPoolSKUs response.
func (client *EnvironmentsClient) listWorkerPoolSKUsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolSKUsResponse, error) {
	result := EnvironmentsClientListWorkerPoolSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUInfoCollection); err != nil {
		return EnvironmentsClientListWorkerPoolSKUsResponse{}, err
	}
	return result, nil
}

// NewListWorkerPoolsPager - Description for Get all worker pools of an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientListWorkerPoolsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPools
// method.
func (client *EnvironmentsClient) NewListWorkerPoolsPager(resourceGroupName string, name string, options *EnvironmentsClientListWorkerPoolsOptions) *runtime.Pager[EnvironmentsClientListWorkerPoolsResponse] {
	return runtime.NewPager(runtime.PagingHandler[EnvironmentsClientListWorkerPoolsResponse]{
		More: func(page EnvironmentsClientListWorkerPoolsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientListWorkerPoolsResponse) (EnvironmentsClientListWorkerPoolsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listWorkerPoolsCreateRequest(ctx, resourceGroupName, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EnvironmentsClientListWorkerPoolsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientListWorkerPoolsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientListWorkerPoolsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listWorkerPoolsHandleResponse(resp)
		},
	})
}

// listWorkerPoolsCreateRequest creates the ListWorkerPools request.
func (client *EnvironmentsClient) listWorkerPoolsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientListWorkerPoolsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWorkerPoolsHandleResponse handles the ListWorkerPools response.
func (client *EnvironmentsClient) listWorkerPoolsHandleResponse(resp *http.Response) (EnvironmentsClientListWorkerPoolsResponse, error) {
	result := EnvironmentsClientListWorkerPoolsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolCollection); err != nil {
		return EnvironmentsClientListWorkerPoolsResponse{}, err
	}
	return result, nil
}

// Reboot - Description for Reboot all machines in an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientRebootOptions contains the optional parameters for the EnvironmentsClient.Reboot method.
func (client *EnvironmentsClient) Reboot(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientRebootOptions) (EnvironmentsClientRebootResponse, error) {
	req, err := client.rebootCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientRebootResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientRebootResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return EnvironmentsClientRebootResponse{}, runtime.NewResponseError(resp)
	}
	return EnvironmentsClientRebootResponse{}, nil
}

// rebootCreateRequest creates the Reboot request.
func (client *EnvironmentsClient) rebootCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientRebootOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginResume - Description for Resume an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginResumeOptions contains the optional parameters for the EnvironmentsClient.BeginResume
// method.
func (client *EnvironmentsClient) BeginResume(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientResumeResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientResumeResponse]{
		More: func(page EnvironmentsClientResumeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientResumeResponse) (EnvironmentsClientResumeResponse, error) {
			req, err := runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			if err != nil {
				return EnvironmentsClientResumeResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientResumeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientResumeResponse{}, runtime.NewResponseError(resp)
			}
			return client.resumeHandleResponse(resp)
		},
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.resume(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientResumeResponse]]{
			Response: &pager,
		})
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.pl, &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientResumeResponse]]{
			Response: &pager,
		})
	}
}

// Resume - Description for Resume an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) resume(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*http.Response, error) {
	req, err := client.resumeCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// resumeCreateRequest creates the Resume request.
func (client *EnvironmentsClient) resumeCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginResumeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// resumeHandleResponse handles the Resume response.
func (client *EnvironmentsClient) resumeHandleResponse(resp *http.Response) (EnvironmentsClientResumeResponse, error) {
	result := EnvironmentsClientResumeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientResumeResponse{}, err
	}
	return result, nil
}

// BeginSuspend - Description for Suspend an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginSuspendOptions contains the optional parameters for the EnvironmentsClient.BeginSuspend
// method.
func (client *EnvironmentsClient) BeginSuspend(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*runtime.Poller[*runtime.Pager[EnvironmentsClientSuspendResponse]], error) {
	pager := runtime.NewPager(runtime.PagingHandler[EnvironmentsClientSuspendResponse]{
		More: func(page EnvironmentsClientSuspendResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EnvironmentsClientSuspendResponse) (EnvironmentsClientSuspendResponse, error) {
			req, err := runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			if err != nil {
				return EnvironmentsClientSuspendResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EnvironmentsClientSuspendResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EnvironmentsClientSuspendResponse{}, runtime.NewResponseError(resp)
			}
			return client.suspendHandleResponse(resp)
		},
	})
	if options == nil || options.ResumeToken == "" {
		resp, err := client.suspend(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[*runtime.Pager[EnvironmentsClientSuspendResponse]]{
			Response: &pager,
		})
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.pl, &runtime.NewPollerFromResumeTokenOptions[*runtime.Pager[EnvironmentsClientSuspendResponse]]{
			Response: &pager,
		})
	}
}

// Suspend - Description for Suspend an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) suspend(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*http.Response, error) {
	req, err := client.suspendCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// suspendCreateRequest creates the Suspend request.
func (client *EnvironmentsClient) suspendCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginSuspendOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// suspendHandleResponse handles the Suspend response.
func (client *EnvironmentsClient) suspendHandleResponse(resp *http.Response) (EnvironmentsClientSuspendResponse, error) {
	result := EnvironmentsClientSuspendResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return EnvironmentsClientSuspendResponse{}, err
	}
	return result, nil
}

// TestUpgradeAvailableNotification - Send a test notification that an upgrade is available for this App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientTestUpgradeAvailableNotificationOptions contains the optional parameters for the EnvironmentsClient.TestUpgradeAvailableNotification
// method.
func (client *EnvironmentsClient) TestUpgradeAvailableNotification(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientTestUpgradeAvailableNotificationOptions) (EnvironmentsClientTestUpgradeAvailableNotificationResponse, error) {
	req, err := client.testUpgradeAvailableNotificationCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, runtime.NewResponseError(resp)
	}
	return EnvironmentsClientTestUpgradeAvailableNotificationResponse{}, nil
}

// testUpgradeAvailableNotificationCreateRequest creates the TestUpgradeAvailableNotification request.
func (client *EnvironmentsClient) testUpgradeAvailableNotificationCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientTestUpgradeAvailableNotificationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/testUpgradeAvailableNotification"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Description for Create or update an App Service Environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// hostingEnvironmentEnvelope - Configuration details of the App Service Environment.
// options - EnvironmentsClientUpdateOptions contains the optional parameters for the EnvironmentsClient.Update method.
func (client *EnvironmentsClient) Update(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentPatchResource, options *EnvironmentsClientUpdateOptions) (EnvironmentsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, name, hostingEnvironmentEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return EnvironmentsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *EnvironmentsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope EnvironmentPatchResource, options *EnvironmentsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, hostingEnvironmentEnvelope)
}

// updateHandleResponse handles the Update response.
func (client *EnvironmentsClient) updateHandleResponse(resp *http.Response) (EnvironmentsClientUpdateResponse, error) {
	result := EnvironmentsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EnvironmentResource); err != nil {
		return EnvironmentsClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateAseCustomDNSSuffixConfiguration - Update Custom Dns Suffix configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration
// method.
func (client *EnvironmentsClient) UpdateAseCustomDNSSuffixConfiguration(ctx context.Context, resourceGroupName string, name string, customDNSSuffixConfiguration CustomDNSSuffixConfiguration, options *EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions) (EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse, error) {
	req, err := client.updateAseCustomDNSSuffixConfigurationCreateRequest(ctx, resourceGroupName, name, customDNSSuffixConfiguration, options)
	if err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateAseCustomDNSSuffixConfigurationHandleResponse(resp)
}

// updateAseCustomDNSSuffixConfigurationCreateRequest creates the UpdateAseCustomDNSSuffixConfiguration request.
func (client *EnvironmentsClient) updateAseCustomDNSSuffixConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, customDNSSuffixConfiguration CustomDNSSuffixConfiguration, options *EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/customdnssuffix"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, customDNSSuffixConfiguration)
}

// updateAseCustomDNSSuffixConfigurationHandleResponse handles the UpdateAseCustomDNSSuffixConfiguration response.
func (client *EnvironmentsClient) updateAseCustomDNSSuffixConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse, error) {
	result := EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomDNSSuffixConfiguration); err != nil {
		return EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse{}, err
	}
	return result, nil
}

// UpdateAseNetworkingConfiguration - Description for Update networking configuration of an App Service Environment
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientUpdateAseNetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseNetworkingConfiguration
// method.
func (client *EnvironmentsClient) UpdateAseNetworkingConfiguration(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration AseV3NetworkingConfiguration, options *EnvironmentsClientUpdateAseNetworkingConfigurationOptions) (EnvironmentsClientUpdateAseNetworkingConfigurationResponse, error) {
	req, err := client.updateAseNetworkingConfigurationCreateRequest(ctx, resourceGroupName, name, aseNetworkingConfiguration, options)
	if err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateAseNetworkingConfigurationHandleResponse(resp)
}

// updateAseNetworkingConfigurationCreateRequest creates the UpdateAseNetworkingConfiguration request.
func (client *EnvironmentsClient) updateAseNetworkingConfigurationCreateRequest(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration AseV3NetworkingConfiguration, options *EnvironmentsClientUpdateAseNetworkingConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/configurations/networking"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, aseNetworkingConfiguration)
}

// updateAseNetworkingConfigurationHandleResponse handles the UpdateAseNetworkingConfiguration response.
func (client *EnvironmentsClient) updateAseNetworkingConfigurationHandleResponse(resp *http.Response) (EnvironmentsClientUpdateAseNetworkingConfigurationResponse, error) {
	result := EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AseV3NetworkingConfiguration); err != nil {
		return EnvironmentsClientUpdateAseNetworkingConfigurationResponse{}, err
	}
	return result, nil
}

// UpdateMultiRolePool - Description for Create or update a multi-role pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// multiRolePoolEnvelope - Properties of the multi-role pool.
// options - EnvironmentsClientUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.UpdateMultiRolePool
// method.
func (client *EnvironmentsClient) UpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateMultiRolePoolOptions) (EnvironmentsClientUpdateMultiRolePoolResponse, error) {
	req, err := client.updateMultiRolePoolCreateRequest(ctx, resourceGroupName, name, multiRolePoolEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateMultiRolePoolHandleResponse(resp)
}

// updateMultiRolePoolCreateRequest creates the UpdateMultiRolePool request.
func (client *EnvironmentsClient) updateMultiRolePoolCreateRequest(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateMultiRolePoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, multiRolePoolEnvelope)
}

// updateMultiRolePoolHandleResponse handles the UpdateMultiRolePool response.
func (client *EnvironmentsClient) updateMultiRolePoolHandleResponse(resp *http.Response) (EnvironmentsClientUpdateMultiRolePoolResponse, error) {
	result := EnvironmentsClientUpdateMultiRolePoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientUpdateMultiRolePoolResponse{}, err
	}
	return result, nil
}

// UpdateWorkerPool - Description for Create or update a worker pool.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// workerPoolName - Name of the worker pool.
// workerPoolEnvelope - Properties of the worker pool.
// options - EnvironmentsClientUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.UpdateWorkerPool
// method.
func (client *EnvironmentsClient) UpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateWorkerPoolOptions) (EnvironmentsClientUpdateWorkerPoolResponse, error) {
	req, err := client.updateWorkerPoolCreateRequest(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope, options)
	if err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateWorkerPoolHandleResponse(resp)
}

// updateWorkerPoolCreateRequest creates the UpdateWorkerPool request.
func (client *EnvironmentsClient) updateWorkerPoolCreateRequest(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, options *EnvironmentsClientUpdateWorkerPoolOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerPoolName == "" {
		return nil, errors.New("parameter workerPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerPoolName}", url.PathEscape(workerPoolName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, workerPoolEnvelope)
}

// updateWorkerPoolHandleResponse handles the UpdateWorkerPool response.
func (client *EnvironmentsClient) updateWorkerPoolHandleResponse(resp *http.Response) (EnvironmentsClientUpdateWorkerPoolResponse, error) {
	result := EnvironmentsClientUpdateWorkerPoolResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WorkerPoolResource); err != nil {
		return EnvironmentsClientUpdateWorkerPoolResponse{}, err
	}
	return result, nil
}

// BeginUpgrade - Description for Initiate an upgrade of an App Service Environment if one is available.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// name - Name of the App Service Environment.
// options - EnvironmentsClientBeginUpgradeOptions contains the optional parameters for the EnvironmentsClient.BeginUpgrade
// method.
func (client *EnvironmentsClient) BeginUpgrade(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*runtime.Poller[EnvironmentsClientUpgradeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.upgrade(ctx, resourceGroupName, name, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EnvironmentsClientUpgradeResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EnvironmentsClientUpgradeResponse](options.ResumeToken, client.pl, nil)
	}
}

// Upgrade - Description for Initiate an upgrade of an App Service Environment if one is available.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
func (client *EnvironmentsClient) upgrade(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*http.Response, error) {
	req, err := client.upgradeCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// upgradeCreateRequest creates the Upgrade request.
func (client *EnvironmentsClient) upgradeCreateRequest(ctx context.Context, resourceGroupName string, name string, options *EnvironmentsClientBeginUpgradeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/upgrade"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
