// Code generated by smithy-go-codegen DO NOT EDIT.

package workmail

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/workmail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns the data available for the resource.
func (c *Client) DescribeResource(ctx context.Context, params *DescribeResourceInput, optFns ...func(*Options)) (*DescribeResourceOutput, error) {
	if params == nil {
		params = &DescribeResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeResource", params, optFns, c.addOperationDescribeResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeResourceInput struct {

	// The identifier associated with the organization for which the resource is
	// described.
	//
	// This member is required.
	OrganizationId *string

	// The identifier of the resource to be described.
	//
	// This member is required.
	ResourceId *string

	noSmithyDocumentSerde
}

type DescribeResourceOutput struct {

	// The booking options for the described resource.
	BookingOptions *types.BookingOptions

	// The date and time when a resource was disabled from WorkMail, in UNIX epoch time
	// format.
	DisabledDate *time.Time

	// The email of the described resource.
	Email *string

	// The date and time when a resource was enabled for WorkMail, in UNIX epoch time
	// format.
	EnabledDate *time.Time

	// The name of the described resource.
	Name *string

	// The identifier of the described resource.
	ResourceId *string

	// The state of the resource: enabled (registered to Amazon WorkMail), disabled
	// (deregistered or never registered to WorkMail), or deleted.
	State types.EntityState

	// The type of the described resource.
	Type types.ResourceType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "workmail",
		OperationName: "DescribeResource",
	}
}
