// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes the Studio Lifecycle Configuration.
func (c *Client) DescribeStudioLifecycleConfig(ctx context.Context, params *DescribeStudioLifecycleConfigInput, optFns ...func(*Options)) (*DescribeStudioLifecycleConfigOutput, error) {
	if params == nil {
		params = &DescribeStudioLifecycleConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeStudioLifecycleConfig", params, optFns, c.addOperationDescribeStudioLifecycleConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeStudioLifecycleConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeStudioLifecycleConfigInput struct {

	// The name of the Studio Lifecycle Configuration to describe.
	//
	// This member is required.
	StudioLifecycleConfigName *string

	noSmithyDocumentSerde
}

type DescribeStudioLifecycleConfigOutput struct {

	// The creation time of the Studio Lifecycle Configuration.
	CreationTime *time.Time

	// This value is equivalent to CreationTime because Studio Lifecycle Configurations
	// are immutable.
	LastModifiedTime *time.Time

	// The App type that the Lifecycle Configuration is attached to.
	StudioLifecycleConfigAppType types.StudioLifecycleConfigAppType

	// The ARN of the Lifecycle Configuration to describe.
	StudioLifecycleConfigArn *string

	// The content of your Studio Lifecycle Configuration script.
	StudioLifecycleConfigContent *string

	// The name of the Studio Lifecycle Configuration that is described.
	StudioLifecycleConfigName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeStudioLifecycleConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeStudioLifecycleConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeStudioLifecycleConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeStudioLifecycleConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeStudioLifecycleConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeStudioLifecycleConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "DescribeStudioLifecycleConfig",
	}
}
