//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer

import "time"

// AccessPoliciesClientCreateOrUpdateOptions contains the optional parameters for the AccessPoliciesClient.CreateOrUpdate
// method.
type AccessPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientDeleteOptions contains the optional parameters for the AccessPoliciesClient.Delete method.
type AccessPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientGetOptions contains the optional parameters for the AccessPoliciesClient.Get method.
type AccessPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientListOptions contains the optional parameters for the AccessPoliciesClient.List method.
type AccessPoliciesClientListOptions struct {
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// AccessPoliciesClientUpdateOptions contains the optional parameters for the AccessPoliciesClient.Update method.
type AccessPoliciesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccessPolicyEntity - Access policies help define the authentication rules, and control access to specific video resources.
type AccessPolicyEntity struct {
	// The resource properties.
	Properties *AccessPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccessPolicyEntityCollection - A collection of AccessPolicyEntity items.
type AccessPolicyEntityCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of AccessPolicyEntity items.
	Value []*AccessPolicyEntity `json:"value,omitempty"`
}

// AccessPolicyProperties - Application level properties for the access policy resource.
type AccessPolicyProperties struct {
	// Authentication method to be used when validating client API access.
	Authentication AuthenticationBaseClassification `json:"authentication,omitempty"`

	// Defines the access level granted by this policy.
	Role *AccessPolicyRole `json:"role,omitempty"`
}

// AccountEncryption - Defines how the Video Analyzer account is (optionally) encrypted.
type AccountEncryption struct {
	// REQUIRED; The type of key used to encrypt the Account Key.
	Type *AccountEncryptionKeyType `json:"type,omitempty"`

	// The Key Vault identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// READ-ONLY; The current status of the Key Vault mapping.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// AudioEncoderAac - A custom preset for encoding audio with the AAC codec.
type AudioEncoderAac struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of
	// 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted,
	// the bitrate of the input audio is used.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
}

// GetAudioEncoderBase implements the AudioEncoderBaseClassification interface for type AudioEncoderAac.
func (a *AudioEncoderAac) GetAudioEncoderBase() *AudioEncoderBase {
	return &AudioEncoderBase{
		Type:        a.Type,
		BitrateKbps: a.BitrateKbps,
	}
}

// AudioEncoderBaseClassification provides polymorphic access to related types.
// Call the interface's GetAudioEncoderBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioEncoderAac, *AudioEncoderBase
type AudioEncoderBaseClassification interface {
	// GetAudioEncoderBase returns the AudioEncoderBase content of the underlying type.
	GetAudioEncoderBase() *AudioEncoderBase
}

// AudioEncoderBase - Base type for all audio encoder presets, which define the recipe or instructions on how audio should
// be processed.
type AudioEncoderBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of
	// 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted,
	// the bitrate of the input audio is used.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`
}

// GetAudioEncoderBase implements the AudioEncoderBaseClassification interface for type AudioEncoderBase.
func (a *AudioEncoderBase) GetAudioEncoderBase() *AudioEncoderBase { return a }

// AuthenticationBaseClassification provides polymorphic access to related types.
// Call the interface's GetAuthenticationBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AuthenticationBase, *JwtAuthentication
type AuthenticationBaseClassification interface {
	// GetAuthenticationBase returns the AuthenticationBase content of the underlying type.
	GetAuthenticationBase() *AuthenticationBase
}

// AuthenticationBase - Base class for access policies authentication methods.
type AuthenticationBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetAuthenticationBase implements the AuthenticationBaseClassification interface for type AuthenticationBase.
func (a *AuthenticationBase) GetAuthenticationBase() *AuthenticationBase { return a }

// CertificateSourceClassification provides polymorphic access to related types.
// Call the interface's GetCertificateSource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CertificateSource, *PemCertificateList
type CertificateSourceClassification interface {
	// GetCertificateSource returns the CertificateSource content of the underlying type.
	GetCertificateSource() *CertificateSource
}

// CertificateSource - Base class for certificate sources.
type CertificateSource struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetCertificateSource implements the CertificateSourceClassification interface for type CertificateSource.
func (c *CertificateSource) GetCertificateSource() *CertificateSource { return c }

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`

	// Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// Collection - A collection of VideoAnalyzer items.
type Collection struct {
	// A collection of VideoAnalyzer items.
	Value []*VideoAnalyzer `json:"value,omitempty"`
}

// CredentialsBaseClassification provides polymorphic access to related types.
// Call the interface's GetCredentialsBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CredentialsBase, *UsernamePasswordCredentials
type CredentialsBaseClassification interface {
	// GetCredentialsBase returns the CredentialsBase content of the underlying type.
	GetCredentialsBase() *CredentialsBase
}

// CredentialsBase - Base class for credential objects.
type CredentialsBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetCredentialsBase implements the CredentialsBaseClassification interface for type CredentialsBase.
func (c *CredentialsBase) GetCredentialsBase() *CredentialsBase { return c }

// EccTokenKey - Required validation properties for tokens generated with Elliptical Curve algorithm.
type EccTokenKey struct {
	// REQUIRED; Elliptical curve algorithm to be used: ES256, ES384 or ES512.
	Alg *AccessPolicyEccAlgo `json:"alg,omitempty"`

	// REQUIRED; JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; X coordinate.
	X *string `json:"x,omitempty"`

	// REQUIRED; Y coordinate.
	Y *string `json:"y,omitempty"`
}

// GetTokenKey implements the TokenKeyClassification interface for type EccTokenKey.
func (e *EccTokenKey) GetTokenKey() *TokenKey {
	return &TokenKey{
		Type: e.Type,
		Kid:  e.Kid,
	}
}

// EdgeModuleEntity - The representation of an edge module.
type EdgeModuleEntity struct {
	// The resource properties.
	Properties *EdgeModuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EdgeModuleEntityCollection - A collection of EdgeModuleEntity items.
type EdgeModuleEntityCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of EdgeModuleEntity items.
	Value []*EdgeModuleEntity `json:"value,omitempty"`
}

// EdgeModuleProperties - Application level properties for the edge module resource.
type EdgeModuleProperties struct {
	// READ-ONLY; Internal ID generated for the instance of the Video Analyzer edge module.
	EdgeModuleID *string `json:"edgeModuleId,omitempty" azure:"ro"`
}

// EdgeModuleProvisioningToken - Provisioning token properties. A provisioning token allows for a single instance of Azure
// Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token
// itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial
// handshake, the IoT edge module will agree on a set of authentication keys
// which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token
// can be generated for the same IoT edge module in case the module state lost or
// reset.
type EdgeModuleProvisioningToken struct {
	// READ-ONLY; The expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized
	// and connected to the Internet prior to the token expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The token blob to be provided to the Azure Video Analyzer IoT edge module through the Azure IoT Edge module
	// twin properties.
	Token *string `json:"token,omitempty" azure:"ro"`
}

// EdgeModulesClientCreateOrUpdateOptions contains the optional parameters for the EdgeModulesClient.CreateOrUpdate method.
type EdgeModulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EdgeModulesClientDeleteOptions contains the optional parameters for the EdgeModulesClient.Delete method.
type EdgeModulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EdgeModulesClientGetOptions contains the optional parameters for the EdgeModulesClient.Get method.
type EdgeModulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EdgeModulesClientListOptions contains the optional parameters for the EdgeModulesClient.List method.
type EdgeModulesClientListOptions struct {
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// EdgeModulesClientListProvisioningTokenOptions contains the optional parameters for the EdgeModulesClient.ListProvisioningToken
// method.
type EdgeModulesClientListProvisioningTokenOptions struct {
	// placeholder for future optional parameters
}

// EncoderCustomPreset - Describes a custom preset for encoding the input content using the encoder processor.
type EncoderCustomPreset struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// Describes a custom preset for encoding audio.
	AudioEncoder AudioEncoderBaseClassification `json:"audioEncoder,omitempty"`

	// Describes a custom preset for encoding video.
	VideoEncoder VideoEncoderBaseClassification `json:"videoEncoder,omitempty"`
}

// GetEncoderPresetBase implements the EncoderPresetBaseClassification interface for type EncoderCustomPreset.
func (e *EncoderCustomPreset) GetEncoderPresetBase() *EncoderPresetBase {
	return &EncoderPresetBase{
		Type: e.Type,
	}
}

// EncoderPresetBaseClassification provides polymorphic access to related types.
// Call the interface's GetEncoderPresetBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EncoderCustomPreset, *EncoderPresetBase, *EncoderSystemPreset
type EncoderPresetBaseClassification interface {
	// GetEncoderPresetBase returns the EncoderPresetBase content of the underlying type.
	GetEncoderPresetBase() *EncoderPresetBase
}

// EncoderPresetBase - Base type for all encoder presets, which define the recipe or instructions on how the input content
// should be processed.
type EncoderPresetBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetEncoderPresetBase implements the EncoderPresetBaseClassification interface for type EncoderPresetBase.
func (e *EncoderPresetBase) GetEncoderPresetBase() *EncoderPresetBase { return e }

// EncoderProcessor - Encoder processor allows for encoding of the input content. For example, it can used to change the resolution
// from 4K to 1280x720.
type EncoderProcessor struct {
	// REQUIRED; An array of upstream node references within the topology to be used as inputs for this node.
	Inputs []*NodeInput `json:"inputs,omitempty"`

	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The encoder preset, which defines the recipe or instructions on how the input content should be processed.
	Preset EncoderPresetBaseClassification `json:"preset,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type EncoderProcessor.
func (e *EncoderProcessor) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: e.Type,
		Name: e.Name,
	}
}

// GetProcessorNodeBase implements the ProcessorNodeBaseClassification interface for type EncoderProcessor.
func (e *EncoderProcessor) GetProcessorNodeBase() *ProcessorNodeBase {
	return &ProcessorNodeBase{
		Inputs: e.Inputs,
		Type:   e.Type,
		Name:   e.Name,
	}
}

// EncoderSystemPreset - Describes a built-in preset for encoding the input content using the encoder processor.
type EncoderSystemPreset struct {
	// REQUIRED; Name of the built-in encoding preset.
	Name *EncoderSystemPresetType `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetEncoderPresetBase implements the EncoderPresetBaseClassification interface for type EncoderSystemPreset.
func (e *EncoderSystemPreset) GetEncoderPresetBase() *EncoderPresetBase {
	return &EncoderPresetBase{
		Type: e.Type,
	}
}

// Endpoint - The endpoint details.
type Endpoint struct {
	// REQUIRED; The type of the endpoint.
	Type *VideoAnalyzerEndpointType `json:"type,omitempty"`

	// The URL of the endpoint.
	EndpointURL *string `json:"endpointUrl,omitempty"`
}

// EndpointBaseClassification provides polymorphic access to related types.
// Call the interface's GetEndpointBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EndpointBase, *TLSEndpoint, *UnsecuredEndpoint
type EndpointBaseClassification interface {
	// GetEndpointBase returns the EndpointBase content of the underlying type.
	GetEndpointBase() *EndpointBase
}

// EndpointBase - Base class for endpoints.
type EndpointBase struct {
	// REQUIRED; Credentials to be presented to the endpoint.
	Credentials CredentialsBaseClassification `json:"credentials,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`

	// Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically
	// used when the endpoint is behind a firewall.
	Tunnel TunnelBaseClassification `json:"tunnel,omitempty"`
}

// GetEndpointBase implements the EndpointBaseClassification interface for type EndpointBase.
func (e *EndpointBase) GetEndpointBase() *EndpointBase { return e }

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GroupLevelAccessControl - Group level network access control.
type GroupLevelAccessControl struct {
	// Whether or not public network access is allowed for specified resources under the Video Analyzer account.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// Identity - The managed identity for the Video Analyzer resource.
type Identity struct {
	// REQUIRED; The identity type.
	Type *string `json:"type,omitempty"`

	// The User Assigned Managed Identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity `json:"userAssignedIdentities,omitempty"`
}

// IotHub - The IoT Hub details.
type IotHub struct {
	// REQUIRED; The IoT Hub resource identifier.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The IoT Hub identity.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// READ-ONLY; The current status of the Iot Hub mapping.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// JwtAuthentication - Properties for access validation based on JSON Web Tokens (JWT).
type JwtAuthentication struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// List of expected token audiences. Token audience is valid if it matches at least one of the given values.
	Audiences []*string `json:"audiences,omitempty"`

	// List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
	Claims []*TokenClaim `json:"claims,omitempty"`

	// List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
	Issuers []*string `json:"issuers,omitempty"`

	// List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token
	// signing key. Token signature must match exactly one key.
	Keys []TokenKeyClassification `json:"keys,omitempty"`
}

// GetAuthenticationBase implements the AuthenticationBaseClassification interface for type JwtAuthentication.
func (j *JwtAuthentication) GetAuthenticationBase() *AuthenticationBase {
	return &AuthenticationBase{
		Type: j.Type,
	}
}

// KeyVaultProperties - The details for accessing the encryption keys in Key Vault.
type KeyVaultProperties struct {
	// REQUIRED; The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1)
	// or reference a key without a version (for example
	// https://vault/keys/mykey).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// READ-ONLY; The current key used to encrypt Video Analyzer account, including the key version.
	CurrentKeyIdentifier *string `json:"currentKeyIdentifier,omitempty" azure:"ro"`
}

// ListProvisioningTokenInput - The input parameters to generate registration token for the Azure Video Analyzer IoT edge
// module.
type ListProvisioningTokenInput struct {
	// REQUIRED; The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized
	// and connected to the Internet prior to the token expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`
}

// LivePipeline - Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and
// publishing of content for a unique RTSP camera.
type LivePipeline struct {
	// The resource properties.
	Properties *LivePipelineProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LivePipelineCollection - A collection of LivePipeline items.
type LivePipelineCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of LivePipeline items.
	Value []*LivePipeline `json:"value,omitempty"`
}

// LivePipelineOperationStatus - Used for tracking the status of an operation on the live pipeline.
type LivePipelineOperationStatus struct {
	// READ-ONLY; The error details for the live pipeline operation.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The name of the live pipeline operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the live pipeline operation.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// LivePipelineOperationStatusesClientGetOptions contains the optional parameters for the LivePipelineOperationStatusesClient.Get
// method.
type LivePipelineOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LivePipelineProperties - Live pipeline properties.
type LivePipelineProperties struct {
	// REQUIRED; Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in
	// increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will
	// disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to
	// see if the camera bitrate is now below the reserved capacity. Doing so will
	// ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
	BitrateKbps *int32 `json:"bitrateKbps,omitempty"`

	// REQUIRED; The reference to an existing pipeline topology defined for real-time content processing. When activated, this
	// live pipeline will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`

	// An optional description for the pipeline.
	Description *string `json:"description,omitempty"`

	// List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override
	// parameters values for parameters which have been declared in the referenced
	// topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be
	// optionally be overridden.
	Parameters []*ParameterDefinition `json:"parameters,omitempty"`

	// READ-ONLY; Current state of the pipeline (read-only).
	State *LivePipelineState `json:"state,omitempty" azure:"ro"`
}

// LivePipelinePropertiesUpdate - Live pipeline properties.
type LivePipelinePropertiesUpdate struct {
	// Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments
	// of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will
	// disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to
	// see if the camera bitrate is now below the reserved capacity. Doing so will
	// ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
	BitrateKbps *int32 `json:"bitrateKbps,omitempty"`

	// An optional description for the pipeline.
	Description *string `json:"description,omitempty"`

	// List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override
	// parameters values for parameters which have been declared in the referenced
	// topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be
	// optionally be overridden.
	Parameters []*ParameterDefinition `json:"parameters,omitempty"`

	// The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline
	// will process content according to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`

	// READ-ONLY; Current state of the pipeline (read-only).
	State *LivePipelineState `json:"state,omitempty" azure:"ro"`
}

// LivePipelineUpdate - Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving
// and publishing of content for a unique RTSP camera.
type LivePipelineUpdate struct {
	// The resource properties.
	Properties *LivePipelinePropertiesUpdate `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LivePipelinesClientBeginActivateOptions contains the optional parameters for the LivePipelinesClient.BeginActivate method.
type LivePipelinesClientBeginActivateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LivePipelinesClientBeginDeactivateOptions contains the optional parameters for the LivePipelinesClient.BeginDeactivate
// method.
type LivePipelinesClientBeginDeactivateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LivePipelinesClientCreateOrUpdateOptions contains the optional parameters for the LivePipelinesClient.CreateOrUpdate method.
type LivePipelinesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LivePipelinesClientDeleteOptions contains the optional parameters for the LivePipelinesClient.Delete method.
type LivePipelinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LivePipelinesClientGetOptions contains the optional parameters for the LivePipelinesClient.Get method.
type LivePipelinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LivePipelinesClientListOptions contains the optional parameters for the LivePipelinesClient.List method.
type LivePipelinesClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// LivePipelinesClientUpdateOptions contains the optional parameters for the LivePipelinesClient.Update method.
type LivePipelinesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientCheckNameAvailabilityOptions contains the optional parameters for the LocationsClient.CheckNameAvailability
// method.
type LocationsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// LogSpecification - A diagnostic log emitted by service.
type LogSpecification struct {
	// READ-ONLY; The time range for requests in each blob.
	BlobDuration *string `json:"blobDuration,omitempty" azure:"ro"`

	// READ-ONLY; The diagnostic log category display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The diagnostic log category name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MetricDimension - A metric dimension.
type MetricDimension struct {
	// READ-ONLY; The display name for the dimension.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The metric dimension name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty" azure:"ro"`
}

// MetricProperties - Metric properties.
type MetricProperties struct {
	// READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty" azure:"ro"`
}

// MetricSpecification - A metric emitted by service.
type MetricSpecification struct {
	// Supported aggregation types.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// READ-ONLY; The metric aggregation type
	AggregationType *MetricAggregationType `json:"aggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The metric dimensions.
	Dimensions []*MetricDimension `json:"dimensions,omitempty" azure:"ro"`

	// READ-ONLY; The metric display description.
	DisplayDescription *string `json:"displayDescription,omitempty" azure:"ro"`

	// READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether regional MDM account is enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty" azure:"ro"`

	// READ-ONLY; The metric lock aggregation type
	LockAggregationType *MetricAggregationType `json:"lockAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The metric name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty" azure:"ro"`

	// READ-ONLY; The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty" azure:"ro"`

	// READ-ONLY; The supported time grain types.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty" azure:"ro"`

	// READ-ONLY; The metric unit
	Unit *MetricUnit `json:"unit,omitempty" azure:"ro"`
}

// NetworkAccessControl - Network access control for video analyzer account.
type NetworkAccessControl struct {
	// Public network access for consumption group.
	Consumption *GroupLevelAccessControl `json:"consumption,omitempty"`

	// Public network access for ingestion group.
	Ingestion *GroupLevelAccessControl `json:"ingestion,omitempty"`

	// Public network access for integration group.
	Integration *GroupLevelAccessControl `json:"integration,omitempty"`
}

// NodeBaseClassification provides polymorphic access to related types.
// Call the interface's GetNodeBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EncoderProcessor, *NodeBase, *ProcessorNodeBase, *RtspSource, *SinkNodeBase, *SourceNodeBase, *VideoSink, *VideoSource
type NodeBaseClassification interface {
	// GetNodeBase returns the NodeBase content of the underlying type.
	GetNodeBase() *NodeBase
}

// NodeBase - Base class for nodes.
type NodeBase struct {
	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type NodeBase.
func (n *NodeBase) GetNodeBase() *NodeBase { return n }

// NodeInput - Describes an input signal to be used on a pipeline node.
type NodeInput struct {
	// REQUIRED; The name of the upstream node in the pipeline which output is used as input of the current node.
	NodeName *string `json:"nodeName,omitempty"`
}

// Operation - An operation.
type Operation struct {
	// REQUIRED; The operation name.
	Name *string `json:"name,omitempty"`

	// Indicates the action type.
	ActionType *ActionType `json:"actionType,omitempty"`

	// The operation display name.
	Display *OperationDisplay `json:"display,omitempty"`

	// Whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties format.
	Properties *MetricProperties `json:"properties,omitempty"`
}

// OperationCollection - A collection of Operation items.
type OperationCollection struct {
	// A collection of Operation items.
	Value []*Operation `json:"value,omitempty"`
}

// OperationDisplay - Operation details.
type OperationDisplay struct {
	// The operation description.
	Description *string `json:"description,omitempty"`

	// The operation type.
	Operation *string `json:"operation,omitempty"`

	// The service provider.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationResultsClientGetOptions contains the optional parameters for the OperationResultsClient.Get method.
type OperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationStatus - Status of video analyzer operation.
type OperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string `json:"name,omitempty"`

	// Operation end time.
	EndTime *string `json:"endTime,omitempty"`

	// The error detail.
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation resource ID.
	ID *string `json:"id,omitempty"`

	// Operation start time.
	StartTime *string `json:"startTime,omitempty"`

	// Operation status.
	Status *string `json:"status,omitempty"`
}

// OperationStatusesClientGetOptions contains the optional parameters for the OperationStatusesClient.Get method.
type OperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ParameterDeclaration - Single topology parameter declaration. Declared parameters can and must be referenced throughout
// the topology and can optionally have default values to be used when they are not defined in the
// pipelines.
type ParameterDeclaration struct {
	// REQUIRED; Name of the parameter.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of the parameter.
	Type *ParameterType `json:"type,omitempty"`

	// The default value for the parameter to be used if the pipeline does not specify a value.
	Default *string `json:"default,omitempty"`

	// Description of the parameter.
	Description *string `json:"description,omitempty"`
}

// ParameterDefinition - Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters
// for more information.
type ParameterDefinition struct {
	// REQUIRED; Name of the parameter declared in the pipeline topology.
	Name *string `json:"name,omitempty"`

	// Parameter value to be applied on this specific pipeline.
	Value *string `json:"value,omitempty"`
}

// PemCertificateList - A list of PEM formatted certificates.
type PemCertificateList struct {
	// REQUIRED; PEM formatted public certificates. One certificate per entry.
	Certificates []*string `json:"certificates,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetCertificateSource implements the CertificateSourceClassification interface for type PemCertificateList.
func (p *PemCertificateList) GetCertificateSource() *CertificateSource {
	return &CertificateSource{
		Type: p.Type,
	}
}

// PipelineJob - Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions
// of archived content.
type PipelineJob struct {
	// The resource properties.
	Properties *PipelineJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineJobCollection - A collection of PipelineJob items.
type PipelineJobCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of PipelineJob items.
	Value []*PipelineJob `json:"value,omitempty"`
}

// PipelineJobError - Details about the error for a failed pipeline job.
type PipelineJobError struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`
}

// PipelineJobOperationStatus - Used for tracking the status of an operation on the pipeline job.
type PipelineJobOperationStatus struct {
	// READ-ONLY; The error details for the pipeline job operation.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The name of the pipeline job operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the pipeline job operation.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// PipelineJobOperationStatusesClientGetOptions contains the optional parameters for the PipelineJobOperationStatusesClient.Get
// method.
type PipelineJobOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelineJobProperties - Pipeline job properties.
type PipelineJobProperties struct {
	// REQUIRED; Reference to an existing pipeline topology. When activated, this pipeline job will process content according
	// to the pipeline topology definition.
	TopologyName *string `json:"topologyName,omitempty"`

	// An optional description for the pipeline.
	Description *string `json:"description,omitempty"`

	// List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override
	// parameters values for parameters which have been declared in the referenced
	// topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be
	// optionally be overridden.
	Parameters []*ParameterDefinition `json:"parameters,omitempty"`

	// READ-ONLY; Details about the error, in case the pipeline job fails.
	Error *PipelineJobError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The date-time by when this pipeline job will be automatically deleted from your account.
	Expiration *time.Time `json:"expiration,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the pipeline (read-only).
	State *PipelineJobState `json:"state,omitempty" azure:"ro"`
}

// PipelineJobPropertiesUpdate - Pipeline job properties.
type PipelineJobPropertiesUpdate struct {
	// An optional description for the pipeline.
	Description *string `json:"description,omitempty"`

	// List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override
	// parameters values for parameters which have been declared in the referenced
	// topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be
	// optionally be overridden.
	Parameters []*ParameterDefinition `json:"parameters,omitempty"`

	// Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline
	// topology definition.
	TopologyName *string `json:"topologyName,omitempty"`

	// READ-ONLY; Details about the error, in case the pipeline job fails.
	Error *PipelineJobError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The date-time by when this pipeline job will be automatically deleted from your account.
	Expiration *time.Time `json:"expiration,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the pipeline (read-only).
	State *PipelineJobState `json:"state,omitempty" azure:"ro"`
}

// PipelineJobUpdate - Pipeline job represents a unique instance of a batch topology, used for offline processing of selected
// portions of archived content.
type PipelineJobUpdate struct {
	// The resource properties.
	Properties *PipelineJobPropertiesUpdate `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineJobsClientBeginCancelOptions contains the optional parameters for the PipelineJobsClient.BeginCancel method.
type PipelineJobsClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PipelineJobsClientCreateOrUpdateOptions contains the optional parameters for the PipelineJobsClient.CreateOrUpdate method.
type PipelineJobsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PipelineJobsClientDeleteOptions contains the optional parameters for the PipelineJobsClient.Delete method.
type PipelineJobsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PipelineJobsClientGetOptions contains the optional parameters for the PipelineJobsClient.Get method.
type PipelineJobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelineJobsClientListOptions contains the optional parameters for the PipelineJobsClient.List method.
type PipelineJobsClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// PipelineJobsClientUpdateOptions contains the optional parameters for the PipelineJobsClient.Update method.
type PipelineJobsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PipelineTopologiesClientCreateOrUpdateOptions contains the optional parameters for the PipelineTopologiesClient.CreateOrUpdate
// method.
type PipelineTopologiesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PipelineTopologiesClientDeleteOptions contains the optional parameters for the PipelineTopologiesClient.Delete method.
type PipelineTopologiesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PipelineTopologiesClientGetOptions contains the optional parameters for the PipelineTopologiesClient.Get method.
type PipelineTopologiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelineTopologiesClientListOptions contains the optional parameters for the PipelineTopologiesClient.List method.
type PipelineTopologiesClientListOptions struct {
	// Restricts the set of items returned.
	Filter *string
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// PipelineTopologiesClientUpdateOptions contains the optional parameters for the PipelineTopologiesClient.Update method.
type PipelineTopologiesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PipelineTopology - Pipeline topology describes the processing steps to be applied when processing content for a particular
// outcome. The topology should be defined according to the scenario to be achieved and can be
// reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology
// which captures content from a RTSP camera and archives the content can be
// reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual
// instance properties can be defined through the use of user-defined parameters,
// which allow for a topology to be parameterized. This allows individual pipelines refer to different values, such as individual
// cameras' RTSP endpoints and credentials. Overall a topology is composed
// of the following:
// * Parameters: list of user defined parameters that can be references across the topology nodes.
// * Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
// * Processors: list of nodes which perform data analysis or transformations.
// * Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.
type PipelineTopology struct {
	// REQUIRED; Topology kind.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; Describes the properties of a SKU.
	SKU *SKU `json:"sku,omitempty"`

	// The resource properties.
	Properties *PipelineTopologyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineTopologyCollection - A collection of PipelineTopology items.
type PipelineTopologyCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of PipelineTopology items.
	Value []*PipelineTopology `json:"value,omitempty"`
}

// PipelineTopologyProperties - Describes the properties of a pipeline topology.
type PipelineTopologyProperties struct {
	// REQUIRED; List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
	Sinks []SinkNodeBaseClassification `json:"sinks,omitempty"`

	// REQUIRED; List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
	Sources []SourceNodeBaseClassification `json:"sources,omitempty"`

	// An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described
	// here.
	Description *string `json:"description,omitempty"`

	// List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through
	// the use of "${PARAMETER_NAME}" string pattern. Parameters can have
	// optional default values and can later be defined in individual instances of the pipeline.
	Parameters []*ParameterDeclaration `json:"parameters,omitempty"`

	// List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
	Processors []ProcessorNodeBaseClassification `json:"processors,omitempty"`
}

// PipelineTopologyPropertiesUpdate - Describes the properties of a pipeline topology.
type PipelineTopologyPropertiesUpdate struct {
	// An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described
	// here.
	Description *string `json:"description,omitempty"`

	// List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through
	// the use of "${PARAMETER_NAME}" string pattern. Parameters can have
	// optional default values and can later be defined in individual instances of the pipeline.
	Parameters []*ParameterDeclaration `json:"parameters,omitempty"`

	// List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
	Processors []ProcessorNodeBaseClassification `json:"processors,omitempty"`

	// List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
	Sinks []SinkNodeBaseClassification `json:"sinks,omitempty"`

	// List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
	Sources []SourceNodeBaseClassification `json:"sources,omitempty"`
}

// PipelineTopologyUpdate - Pipeline topology describes the processing steps to be applied when processing content for a particular
// outcome. The topology should be defined according to the scenario to be achieved and can be
// reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology
// which captures content from a RTSP camera and archives the content can be
// reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual
// instance properties can be defined through the use of user-defined parameters,
// which allow for a topology to be parameterized. This allows individual pipelines refer to different values, such as individual
// cameras' RTSP endpoints and credentials. Overall a topology is composed
// of the following:
// * Parameters: list of user defined parameters that can be references across the topology nodes.
// * Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
// * Processors: list of nodes which perform data analysis or transformations.
// * Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.
type PipelineTopologyUpdate struct {
	// Topology kind.
	Kind *Kind `json:"kind,omitempty"`

	// The resource properties.
	Properties *PipelineTopologyPropertiesUpdate `json:"properties,omitempty"`

	// Describes the properties of a SKU.
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionOperationStatus - Status of private endpoint connection operation.
type PrivateEndpointConnectionOperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string `json:"name,omitempty"`

	// Operation end time.
	EndTime *string `json:"endTime,omitempty"`

	// The error detail.
	Error *ErrorDetail `json:"error,omitempty"`

	// Operation resource ID.
	ID *string `json:"id,omitempty"`

	// Operation start time.
	StartTime *string `json:"startTime,omitempty"`

	// Operation status.
	Status *string `json:"status,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsOperationResultsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsOperationResultsClient.Get
// method.
type PrivateEndpointConnectionsOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsOperationStatusesClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsOperationStatusesClient.Get
// method.
type PrivateEndpointConnectionsOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProcessorNodeBaseClassification provides polymorphic access to related types.
// Call the interface's GetProcessorNodeBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EncoderProcessor, *ProcessorNodeBase
type ProcessorNodeBaseClassification interface {
	NodeBaseClassification
	// GetProcessorNodeBase returns the ProcessorNodeBase content of the underlying type.
	GetProcessorNodeBase() *ProcessorNodeBase
}

// ProcessorNodeBase - Base class for topology processor nodes.
type ProcessorNodeBase struct {
	// REQUIRED; An array of upstream node references within the topology to be used as inputs for this node.
	Inputs []*NodeInput `json:"inputs,omitempty"`

	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type ProcessorNodeBase.
func (p *ProcessorNodeBase) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: p.Type,
		Name: p.Name,
	}
}

// GetProcessorNodeBase implements the ProcessorNodeBaseClassification interface for type ProcessorNodeBase.
func (p *ProcessorNodeBase) GetProcessorNodeBase() *ProcessorNodeBase { return p }

// Properties - The properties of the Video Analyzer account.
type Properties struct {
	// REQUIRED; The storage accounts for this resource.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`

	// The IoT Hubs for this resource.
	IotHubs []*IotHub `json:"iotHubs,omitempty"`

	// Network access control for Video Analyzer.
	NetworkAccessControl *NetworkAccessControl `json:"networkAccessControl,omitempty"`

	// Whether or not public network access is allowed for resources under the Video Analyzer account.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The endpoints associated with this resource.
	Endpoints []*Endpoint `json:"endpoints,omitempty" azure:"ro"`

	// READ-ONLY; Private Endpoint Connections created under Video Analyzer account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Video Analyzer account.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PropertiesUpdate - The properties of the Video Analyzer account.
type PropertiesUpdate struct {
	// The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`

	// The IoT Hubs for this resource.
	IotHubs []*IotHub `json:"iotHubs,omitempty"`

	// Network access control for Video Analyzer.
	NetworkAccessControl *NetworkAccessControl `json:"networkAccessControl,omitempty"`

	// Whether or not public network access is allowed for resources under the Video Analyzer account.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The storage accounts for this resource.
	StorageAccounts []*StorageAccount `json:"storageAccounts,omitempty"`

	// READ-ONLY; The endpoints associated with this resource.
	Endpoints []*Endpoint `json:"endpoints,omitempty" azure:"ro"`

	// READ-ONLY; Private Endpoint Connections created under Video Analyzer account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Video Analyzer account.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceIdentity - The user assigned managed identity to use when accessing a resource.
type ResourceIdentity struct {
	// REQUIRED; The user assigned managed identity's resource identifier to use when accessing a resource.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// RsaTokenKey - Required validation properties for tokens generated with RSA algorithm.
type RsaTokenKey struct {
	// REQUIRED; RSA algorithm to be used: RS256, RS384 or RS512.
	Alg *AccessPolicyRsaAlgo `json:"alg,omitempty"`

	// REQUIRED; RSA public key exponent.
	E *string `json:"e,omitempty"`

	// REQUIRED; JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`

	// REQUIRED; RSA public key modulus.
	N *string `json:"n,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTokenKey implements the TokenKeyClassification interface for type RsaTokenKey.
func (r *RsaTokenKey) GetTokenKey() *TokenKey {
	return &TokenKey{
		Type: r.Type,
		Kid:  r.Kid,
	}
}

// RtspSource - RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.
type RtspSource struct {
	// REQUIRED; RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video
	// Analyzer to connect to RTSP cameras and/or generic RTSP servers.
	Endpoint EndpointBaseClassification `json:"endpoint,omitempty"`

	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on
	// the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged
	// through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
	Transport *RtspTransport `json:"transport,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type RtspSource.
func (r *RtspSource) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: r.Type,
		Name: r.Name,
	}
}

// GetSourceNodeBase implements the SourceNodeBaseClassification interface for type RtspSource.
func (r *RtspSource) GetSourceNodeBase() *SourceNodeBase {
	return &SourceNodeBase{
		Type: r.Type,
		Name: r.Name,
	}
}

// SKU - The SKU details.
type SKU struct {
	// REQUIRED; The SKU name.
	Name *SKUName `json:"name,omitempty"`

	// READ-ONLY; The SKU tier.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// SecureIotDeviceRemoteTunnel - A remote tunnel securely established using IoT Hub device information.
type SecureIotDeviceRemoteTunnel struct {
	// REQUIRED; The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
	DeviceID *string `json:"deviceId,omitempty"`

	// REQUIRED; Name of the IoT Hub.
	IotHubName *string `json:"iotHubName,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTunnelBase implements the TunnelBaseClassification interface for type SecureIotDeviceRemoteTunnel.
func (s *SecureIotDeviceRemoteTunnel) GetTunnelBase() *TunnelBase {
	return &TunnelBase{
		Type: s.Type,
	}
}

// ServiceSpecification - The service metric specifications.
type ServiceSpecification struct {
	// READ-ONLY; List of log specifications.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty" azure:"ro"`

	// READ-ONLY; List of metric specifications.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty" azure:"ro"`
}

// SinkNodeBaseClassification provides polymorphic access to related types.
// Call the interface's GetSinkNodeBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SinkNodeBase, *VideoSink
type SinkNodeBaseClassification interface {
	NodeBaseClassification
	// GetSinkNodeBase returns the SinkNodeBase content of the underlying type.
	GetSinkNodeBase() *SinkNodeBase
}

// SinkNodeBase - Base class for topology sink nodes.
type SinkNodeBase struct {
	// REQUIRED; An array of upstream node references within the topology to be used as inputs for this node.
	Inputs []*NodeInput `json:"inputs,omitempty"`

	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type SinkNodeBase.
func (s *SinkNodeBase) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: s.Type,
		Name: s.Name,
	}
}

// GetSinkNodeBase implements the SinkNodeBaseClassification interface for type SinkNodeBase.
func (s *SinkNodeBase) GetSinkNodeBase() *SinkNodeBase { return s }

// SourceNodeBaseClassification provides polymorphic access to related types.
// Call the interface's GetSourceNodeBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *RtspSource, *SourceNodeBase, *VideoSource
type SourceNodeBaseClassification interface {
	NodeBaseClassification
	// GetSourceNodeBase returns the SourceNodeBase content of the underlying type.
	GetSourceNodeBase() *SourceNodeBase
}

// SourceNodeBase - Base class for topology source nodes.
type SourceNodeBase struct {
	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type SourceNodeBase.
func (s *SourceNodeBase) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: s.Type,
		Name: s.Name,
	}
}

// GetSourceNodeBase implements the SourceNodeBaseClassification interface for type SourceNodeBase.
func (s *SourceNodeBase) GetSourceNodeBase() *SourceNodeBase { return s }

// StorageAccount - The details about the associated storage account.
type StorageAccount struct {
	// REQUIRED; The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage
	// account must be a Standard Storage account (either Microsoft.ClassicStorage or
	// Microsoft.Storage).
	ID *string `json:"id,omitempty"`

	// A managed identity that Video Analyzer will use to access the storage account.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// READ-ONLY; The current status of the storage account mapping.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TLSEndpoint - TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted
// in transit).
type TLSEndpoint struct {
	// REQUIRED; Credentials to be presented to the endpoint.
	Credentials CredentialsBaseClassification `json:"credentials,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`

	// List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's
	// list of trusted authorities should be used.
	TrustedCertificates CertificateSourceClassification `json:"trustedCertificates,omitempty"`

	// Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically
	// used when the endpoint is behind a firewall.
	Tunnel TunnelBaseClassification `json:"tunnel,omitempty"`

	// Validation options to use when authenticating a TLS connection. By default, strict validation is used.
	ValidationOptions *TLSValidationOptions `json:"validationOptions,omitempty"`
}

// GetEndpointBase implements the EndpointBaseClassification interface for type TLSEndpoint.
func (t *TLSEndpoint) GetEndpointBase() *EndpointBase {
	return &EndpointBase{
		Type:        t.Type,
		Credentials: t.Credentials,
		URL:         t.URL,
		Tunnel:      t.Tunnel,
	}
}

// TLSValidationOptions - Options for controlling the validation of TLS endpoints.
type TLSValidationOptions struct {
	// When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
	IgnoreHostname *string `json:"ignoreHostname,omitempty"`

	// When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
	IgnoreSignature *string `json:"ignoreSignature,omitempty"`
}

// TimeSequenceBaseClassification provides polymorphic access to related types.
// Call the interface's GetTimeSequenceBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *TimeSequenceBase, *VideoSequenceAbsoluteTimeMarkers
type TimeSequenceBaseClassification interface {
	// GetTimeSequenceBase returns the TimeSequenceBase content of the underlying type.
	GetTimeSequenceBase() *TimeSequenceBase
}

// TimeSequenceBase - A sequence of datetime ranges as a string.
type TimeSequenceBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTimeSequenceBase implements the TimeSequenceBaseClassification interface for type TimeSequenceBase.
func (t *TimeSequenceBase) GetTimeSequenceBase() *TimeSequenceBase { return t }

// TokenClaim - Properties for expected token claims.
type TokenClaim struct {
	// REQUIRED; Name of the claim which must be present on the token.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Expected value of the claim to be present on the token.
	Value *string `json:"value,omitempty"`
}

// TokenKeyClassification provides polymorphic access to related types.
// Call the interface's GetTokenKey() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EccTokenKey, *RsaTokenKey, *TokenKey
type TokenKeyClassification interface {
	// GetTokenKey returns the TokenKey content of the underlying type.
	GetTokenKey() *TokenKey
}

// TokenKey - Key properties for JWT token validation.
type TokenKey struct {
	// REQUIRED; JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
	Kid *string `json:"kid,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTokenKey implements the TokenKeyClassification interface for type TokenKey.
func (t *TokenKey) GetTokenKey() *TokenKey { return t }

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TunnelBaseClassification provides polymorphic access to related types.
// Call the interface's GetTunnelBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SecureIotDeviceRemoteTunnel, *TunnelBase
type TunnelBaseClassification interface {
	// GetTunnelBase returns the TunnelBase content of the underlying type.
	GetTunnelBase() *TunnelBase
}

// TunnelBase - Base class for tunnel objects.
type TunnelBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTunnelBase implements the TunnelBaseClassification interface for type TunnelBase.
func (t *TunnelBase) GetTunnelBase() *TunnelBase { return t }

// UnsecuredEndpoint - Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no
// encryption in transit).
type UnsecuredEndpoint struct {
	// REQUIRED; Credentials to be presented to the endpoint.
	Credentials CredentialsBaseClassification `json:"credentials,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; The endpoint URL for Video Analyzer to connect to.
	URL *string `json:"url,omitempty"`

	// Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically
	// used when the endpoint is behind a firewall.
	Tunnel TunnelBaseClassification `json:"tunnel,omitempty"`
}

// GetEndpointBase implements the EndpointBaseClassification interface for type UnsecuredEndpoint.
func (u *UnsecuredEndpoint) GetEndpointBase() *EndpointBase {
	return &EndpointBase{
		Type:        u.Type,
		Credentials: u.Credentials,
		URL:         u.URL,
		Tunnel:      u.Tunnel,
	}
}

// Update - The update operation for a Video Analyzer account.
type Update struct {
	// The identities associated to the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`

	// The resource properties.
	Properties *PropertiesUpdate `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// UserAssignedManagedIdentity - The details of the user assigned managed identity used by the Video Analyzer resource.
type UserAssignedManagedIdentity struct {
	// READ-ONLY; The client ID.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UsernamePasswordCredentials - Username and password credentials.
type UsernamePasswordCredentials struct {
	// REQUIRED; Password to be presented as part of the credentials. It is recommended that this value is parameterized as a
	// secret string in order to prevent this value to be returned as part of the resource on API
	// requests.
	Password *string `json:"password,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; Username to be presented as part of the credentials.
	Username *string `json:"username,omitempty"`
}

// GetCredentialsBase implements the CredentialsBaseClassification interface for type UsernamePasswordCredentials.
func (u *UsernamePasswordCredentials) GetCredentialsBase() *CredentialsBase {
	return &CredentialsBase{
		Type: u.Type,
	}
}

// VideoAnalyzer - The Video Analyzer account.
type VideoAnalyzer struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The identities associated to the Video Analyzer resource.
	Identity *Identity `json:"identity,omitempty"`

	// The resource properties.
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VideoAnalyzersClientBeginCreateOrUpdateOptions contains the optional parameters for the VideoAnalyzersClient.BeginCreateOrUpdate
// method.
type VideoAnalyzersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VideoAnalyzersClientBeginUpdateOptions contains the optional parameters for the VideoAnalyzersClient.BeginUpdate method.
type VideoAnalyzersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VideoAnalyzersClientDeleteOptions contains the optional parameters for the VideoAnalyzersClient.Delete method.
type VideoAnalyzersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VideoAnalyzersClientGetOptions contains the optional parameters for the VideoAnalyzersClient.Get method.
type VideoAnalyzersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VideoAnalyzersClientListBySubscriptionOptions contains the optional parameters for the VideoAnalyzersClient.ListBySubscription
// method.
type VideoAnalyzersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VideoAnalyzersClientListOptions contains the optional parameters for the VideoAnalyzersClient.List method.
type VideoAnalyzersClientListOptions struct {
	// placeholder for future optional parameters
}

// VideoArchival - Video archival properties.
type VideoArchival struct {
	// Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage.
	// It must be provided in the ISO8601 duration format in the granularity of days,
	// up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically
	// deleted. This value can be updated at any time and the new desired retention
	// period will be effective within 24 hours.
	RetentionPeriod *string `json:"retentionPeriod,omitempty"`
}

// VideoContentToken - "Video content token grants access to the video content URLs."
type VideoContentToken struct {
	// READ-ONLY; The content token expiration date in ISO8601 format (eg. 2021-01-01T00:00:00Z).
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The content token value to be added to the video content URL as the value for the "token" query string parameter.
	// The token is specific to a single video.
	Token *string `json:"token,omitempty" azure:"ro"`
}

// VideoContentUrls - Set of URLs to the video content.
type VideoContentUrls struct {
	// Video archive streaming base URL. The archived content can be automatically played by the Azure Video Analyzer player widget.
	// Alternatively, this URL can be used in conjunction with the video content
	// authorization token on any compatible DASH or HLS players by appending the following to the base URL:
	// - HLSv4: /manifest(format=m3u8-aapl).m3u8
	// - HLS CMAF: /manifest(format=m3u8-cmaf)
	// - DASH CMAF: /manifest(format=mpd-time-cmaf)
	// Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the
	// chosen video segment length. It is available when the video type is 'archive' and video archiving is enabled.
	ArchiveBaseURL *string `json:"archiveBaseUrl,omitempty"`

	// Video file download URL. This URL can be used in conjunction with the video content authorization token to download the
	// video MP4 file. The resulting MP4 file can be played on any standard media
	// player. It is available when the video type is 'file' and video file is available for consumption.
	DownloadURL *string `json:"downloadUrl,omitempty"`

	// Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download
	// the most recent still image from the video archive in different resolutions. They
	// are available when the video type is 'archive' and preview images are enabled.
	PreviewImageUrls *VideoPreviewImageUrls `json:"previewImageUrls,omitempty"`

	// Video low-latency streaming URL. The live content can be automatically played by the Azure Video Analyzer player widget.
	// Alternatively, this URL can be used in conjunction with the video content
	// authorization token to expose a WebSocket tunneled RTSP stream. It is available when the video type is 'archive' and a
	// live, low-latency feed is available from the source.
	RtspTunnelURL *string `json:"rtspTunnelUrl,omitempty"`
}

// VideoCreationProperties - Optional properties to be used in case a new video resource needs to be created on the service.
// These will not take effect if the video already exists.
type VideoCreationProperties struct {
	// Optional description provided by the user. Value can be up to 2048 characters long.
	Description *string `json:"description,omitempty"`

	// Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format
	// (i.e. "P1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day
	// increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies
	// where "kind" is set to "live".
	RetentionPeriod *string `json:"retentionPeriod,omitempty"`

	// Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments
	// provide lower archive playback latency but generate larger volume of storage
	// transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency.
	// Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30
	// seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial
	// call to create the video resource can lead to errors when uploading content to
	// the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
	SegmentLength *string `json:"segmentLength,omitempty"`

	// Optional title provided by the user. Value can be up to 256 characters long.
	Title *string `json:"title,omitempty"`
}

// VideoEncoderBaseClassification provides polymorphic access to related types.
// Call the interface's GetVideoEncoderBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *VideoEncoderBase, *VideoEncoderH264
type VideoEncoderBaseClassification interface {
	// GetVideoEncoderBase returns the VideoEncoderBase content of the underlying type.
	GetVideoEncoderBase() *VideoEncoderBase
}

// VideoEncoderBase - Base type for all video encoding presets, which define the recipe or instructions on how the input video
// should be processed.
type VideoEncoderBase struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically
	// to try and match the quality of the input video.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`

	// The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal
	// to 300. If omitted, the encoder uses the average frame rate of the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
	Scale *VideoScale `json:"scale,omitempty"`
}

// GetVideoEncoderBase implements the VideoEncoderBaseClassification interface for type VideoEncoderBase.
func (v *VideoEncoderBase) GetVideoEncoderBase() *VideoEncoderBase { return v }

// VideoEncoderH264 - A custom preset for encoding video with the H.264 (AVC) codec.
type VideoEncoderH264 struct {
	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically
	// to try and match the quality of the input video.
	BitrateKbps *string `json:"bitrateKbps,omitempty"`

	// The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal
	// to 300. If omitted, the encoder uses the average frame rate of the input video.
	FrameRate *string `json:"frameRate,omitempty"`

	// Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
	Scale *VideoScale `json:"scale,omitempty"`
}

// GetVideoEncoderBase implements the VideoEncoderBaseClassification interface for type VideoEncoderH264.
func (v *VideoEncoderH264) GetVideoEncoderBase() *VideoEncoderBase {
	return &VideoEncoderBase{
		Type:        v.Type,
		BitrateKbps: v.BitrateKbps,
		FrameRate:   v.FrameRate,
		Scale:       v.Scale,
	}
}

// VideoEntity - Represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP cameras through
// live pipelines or can be created by exporting sequences from existing captured video through a
// pipeline job. Videos ingested through live pipelines can be streamed through Azure Video Analyzer Player Widget or compatible
// players. Exported videos can be downloaded as MP4 files.
type VideoEntity struct {
	// The resource properties.
	Properties *VideoProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VideoEntityCollection - A collection of VideoEntity items.
type VideoEntityCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	NextLink *string `json:"@nextLink,omitempty"`

	// A collection of VideoEntity items.
	Value []*VideoEntity `json:"value,omitempty"`
}

// VideoFlags - Video flags contain information about the available video actions and its dynamic properties based on the
// current video state.
type VideoFlags struct {
	// REQUIRED; Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
	CanStream *bool `json:"canStream,omitempty"`

	// REQUIRED; Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos
	// have this value set to false.
	HasData *bool `json:"hasData,omitempty"`

	// REQUIRED; Value indicating whether or not the video is currently being referenced be an active pipeline. The fact that
	// is being referenced, doesn't necessarily indicate that data is being received. For example,
	// video recording may be gated on events or camera may not be accessible at the time.
	IsInUse *bool `json:"isInUse,omitempty"`
}

// VideoMediaInfo - Contains information about the video and audio content.
type VideoMediaInfo struct {
	// Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller
	// segments provide lower archive playback latency but generate larger volume of
	// storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency.
	// Value must be specified in ISO8601 duration format (i.e. "PT30S" equals
	// 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
	SegmentLength *string `json:"segmentLength,omitempty"`
}

// VideoPreviewImageUrls - Video preview image URLs. These URLs can be used in conjunction with the video content authorization
// token to download the most recent still image from the video archive in different resolutions. They
// are available when the video type is 'archive' and preview images are enabled.
type VideoPreviewImageUrls struct {
	// High resolution preview image URL.
	Large *string `json:"large,omitempty"`

	// Medium resolution preview image URL.
	Medium *string `json:"medium,omitempty"`

	// Low resolution preview image URL.
	Small *string `json:"small,omitempty"`
}

// VideoProperties - Application level properties for the video resource.
type VideoProperties struct {
	// Video archival properties.
	Archival *VideoArchival `json:"archival,omitempty"`

	// Optional video description provided by the user. Value can be up to 2048 characters long.
	Description *string `json:"description,omitempty"`

	// Contains information about the video and audio content.
	MediaInfo *VideoMediaInfo `json:"mediaInfo,omitempty"`

	// Optional video title provided by the user. Value can be up to 256 characters long.
	Title *string `json:"title,omitempty"`

	// READ-ONLY; Set of URLs to the video content.
	ContentUrls *VideoContentUrls `json:"contentUrls,omitempty" azure:"ro"`

	// READ-ONLY; Video flags contain information about the available video actions and its dynamic properties based on the current
	// video state.
	Flags *VideoFlags `json:"flags,omitempty" azure:"ro"`

	// READ-ONLY; Video content type. Different content types are suitable for different applications and scenarios.
	Type *VideoType `json:"type,omitempty" azure:"ro"`
}

// VideoPublishingOptions - Optional flags used to change how video is published. These are only allowed for topologies where
// "kind" is set to "live".
type VideoPublishingOptions struct {
	// When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only
	// for low latency video streaming. Default is 'false'. If set to 'true', then
	// "disableRtspPublishing" must be set to 'false'.
	DisableArchive *string `json:"disableArchive,omitempty"`

	// When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example,
	// when the topology is used only for archiving content. Default is 'false'. If
	// set to 'true', then "disableArchive" must be set to 'false'.
	DisableRtspPublishing *string `json:"disableRtspPublishing,omitempty"`
}

// VideoScale - The video scaling information.
type VideoScale struct {
	// The desired output video height.
	Height *string `json:"height,omitempty"`

	// Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width
	// and height must be specified. Else if the mode is 'PreserveAspectRatio' then
	// only one of width or height need be provided.
	Mode *VideoScaleMode `json:"mode,omitempty"`

	// The desired output video width.
	Width *string `json:"width,omitempty"`
}

// VideoSequenceAbsoluteTimeMarkers - A sequence of absolute datetime ranges as a string. The datetime values should follow
// IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range
// specified in the sequence.
type VideoSequenceAbsoluteTimeMarkers struct {
	// REQUIRED; The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
	Ranges *string `json:"ranges,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`
}

// GetTimeSequenceBase implements the TimeSequenceBaseClassification interface for type VideoSequenceAbsoluteTimeMarkers.
func (v *VideoSequenceAbsoluteTimeMarkers) GetTimeSequenceBase() *TimeSequenceBase {
	return &TimeSequenceBase{
		Type: v.Type,
	}
}

// VideoSink - Video sink in a live topology allows for video and audio to be captured, optionally archived, and published
// via a video resource. If archiving is enabled, this results in a video of type 'archive'. If
// used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of
// type 'file'
type VideoSink struct {
	// REQUIRED; An array of upstream node references within the topology to be used as inputs for this node.
	Inputs []*NodeInput `json:"inputs,omitempty"`

	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source,
	// and if disableArchive is set to true, then no content is archived.
	VideoName *string `json:"videoName,omitempty"`

	// Optional video properties to be used in case a new video resource needs to be created on the service.
	VideoCreationProperties *VideoCreationProperties `json:"videoCreationProperties,omitempty"`

	// Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies
	// where "kind" is set to "live".
	VideoPublishingOptions *VideoPublishingOptions `json:"videoPublishingOptions,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type VideoSink.
func (v *VideoSink) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: v.Type,
		Name: v.Name,
	}
}

// GetSinkNodeBase implements the SinkNodeBaseClassification interface for type VideoSink.
func (v *VideoSink) GetSinkNodeBase() *SinkNodeBase {
	return &SinkNodeBase{
		Inputs: v.Inputs,
		Type:   v.Type,
		Name:   v.Name,
	}
}

// VideoSource - Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently
// supported only with batch pipelines.
type VideoSource struct {
	// REQUIRED; Node name. Must be unique within the topology.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
	TimeSequences TimeSequenceBaseClassification `json:"timeSequences,omitempty"`

	// REQUIRED; The discriminator for derived types.
	Type *string `json:"@type,omitempty"`

	// REQUIRED; Name of the Video Analyzer video resource to be used as the source.
	VideoName *string `json:"videoName,omitempty"`
}

// GetNodeBase implements the NodeBaseClassification interface for type VideoSource.
func (v *VideoSource) GetNodeBase() *NodeBase {
	return &NodeBase{
		Type: v.Type,
		Name: v.Name,
	}
}

// GetSourceNodeBase implements the SourceNodeBaseClassification interface for type VideoSource.
func (v *VideoSource) GetSourceNodeBase() *SourceNodeBase {
	return &SourceNodeBase{
		Type: v.Type,
		Name: v.Name,
	}
}

// VideosClientCreateOrUpdateOptions contains the optional parameters for the VideosClient.CreateOrUpdate method.
type VideosClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// VideosClientDeleteOptions contains the optional parameters for the VideosClient.Delete method.
type VideosClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VideosClientGetOptions contains the optional parameters for the VideosClient.Get method.
type VideosClientGetOptions struct {
	// placeholder for future optional parameters
}

// VideosClientListContentTokenOptions contains the optional parameters for the VideosClient.ListContentToken method.
type VideosClientListContentTokenOptions struct {
	// placeholder for future optional parameters
}

// VideosClientListOptions contains the optional parameters for the VideosClient.List method.
type VideosClientListOptions struct {
	// Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the
	// number of available items up to but not greater than the specified value n.
	Top *int32
}

// VideosClientUpdateOptions contains the optional parameters for the VideosClient.Update method.
type VideosClientUpdateOptions struct {
	// placeholder for future optional parameters
}
