//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplaceordering

import "time"

// AgreementProperties - Agreement Terms definition
type AgreementProperties struct {
	// If any version of the terms have been accepted, otherwise false.
	Accepted *bool `json:"accepted,omitempty"`

	// Link to HTML with Microsoft and Publisher terms.
	LicenseTextLink *string `json:"licenseTextLink,omitempty"`

	// Link to HTML with Azure Marketplace terms.
	MarketplaceTermsLink *string `json:"marketplaceTermsLink,omitempty"`

	// Plan identifier string of image being deployed.
	Plan *string `json:"plan,omitempty"`

	// Link to the privacy policy of the publisher.
	PrivacyPolicyLink *string `json:"privacyPolicyLink,omitempty"`

	// Offer identifier string of image being deployed.
	Product *string `json:"product,omitempty"`

	// Publisher identifier string of image being deployed.
	Publisher *string `json:"publisher,omitempty"`

	// Date and time in UTC of when the terms were accepted. This is empty if Accepted is false.
	RetrieveDatetime *time.Time `json:"retrieveDatetime,omitempty"`

	// Terms signature.
	Signature *string `json:"signature,omitempty"`
}

// AgreementTerms - Terms properties for provided Publisher/Offer/Plan tuple
type AgreementTerms struct {
	// Represents the properties of the resource.
	Properties *AgreementProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates Microsoft.MarketplaceOrdering service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - The details of the error.
type ErrorResponseError struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// MarketplaceAgreementsClientCancelOptions contains the optional parameters for the MarketplaceAgreementsClient.Cancel method.
type MarketplaceAgreementsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceAgreementsClientCreateOptions contains the optional parameters for the MarketplaceAgreementsClient.Create method.
type MarketplaceAgreementsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceAgreementsClientGetAgreementOptions contains the optional parameters for the MarketplaceAgreementsClient.GetAgreement
// method.
type MarketplaceAgreementsClientGetAgreementOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceAgreementsClientGetOptions contains the optional parameters for the MarketplaceAgreementsClient.Get method.
type MarketplaceAgreementsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceAgreementsClientListOptions contains the optional parameters for the MarketplaceAgreementsClient.List method.
type MarketplaceAgreementsClientListOptions struct {
	// placeholder for future optional parameters
}

// MarketplaceAgreementsClientSignOptions contains the optional parameters for the MarketplaceAgreementsClient.Sign method.
type MarketplaceAgreementsClientSignOptions struct {
	// placeholder for future optional parameters
}

// Operation - Microsoft.MarketplaceOrdering REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation description.
	Description *string `json:"description,omitempty"`

	// Operation type: Get Agreement, Sign Agreement, Cancel Agreement etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.MarketplaceOrdering
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Agreement, virtualmachine, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list MarketplaceOrdering operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// List of Microsoft.MarketplaceOrdering operations supported by the Microsoft.MarketplaceOrdering resource provider.
	Value []*Operation `json:"value,omitempty"`

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - ARM resource.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
