// Code generated by protoc-gen-go. DO NOT EDIT.
// source: diff.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type CommitDiffRequest struct {
	Repository             *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId           string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId          string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
	IgnoreWhitespaceChange bool        `protobuf:"varint,4,opt,name=ignore_whitespace_change,json=ignoreWhitespaceChange" json:"ignore_whitespace_change,omitempty"`
	Paths                  [][]byte    `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	CollapseDiffs          bool        `protobuf:"varint,6,opt,name=collapse_diffs,json=collapseDiffs" json:"collapse_diffs,omitempty"`
	EnforceLimits          bool        `protobuf:"varint,7,opt,name=enforce_limits,json=enforceLimits" json:"enforce_limits,omitempty"`
	MaxFiles               int32       `protobuf:"varint,8,opt,name=max_files,json=maxFiles" json:"max_files,omitempty"`
	MaxLines               int32       `protobuf:"varint,9,opt,name=max_lines,json=maxLines" json:"max_lines,omitempty"`
	MaxBytes               int32       `protobuf:"varint,10,opt,name=max_bytes,json=maxBytes" json:"max_bytes,omitempty"`
	SafeMaxFiles           int32       `protobuf:"varint,11,opt,name=safe_max_files,json=safeMaxFiles" json:"safe_max_files,omitempty"`
	SafeMaxLines           int32       `protobuf:"varint,12,opt,name=safe_max_lines,json=safeMaxLines" json:"safe_max_lines,omitempty"`
	SafeMaxBytes           int32       `protobuf:"varint,13,opt,name=safe_max_bytes,json=safeMaxBytes" json:"safe_max_bytes,omitempty"`
}

func (m *CommitDiffRequest) Reset()                    { *m = CommitDiffRequest{} }
func (m *CommitDiffRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitDiffRequest) ProtoMessage()               {}
func (*CommitDiffRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

func (m *CommitDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetIgnoreWhitespaceChange() bool {
	if m != nil {
		return m.IgnoreWhitespaceChange
	}
	return false
}

func (m *CommitDiffRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *CommitDiffRequest) GetCollapseDiffs() bool {
	if m != nil {
		return m.CollapseDiffs
	}
	return false
}

func (m *CommitDiffRequest) GetEnforceLimits() bool {
	if m != nil {
		return m.EnforceLimits
	}
	return false
}

func (m *CommitDiffRequest) GetMaxFiles() int32 {
	if m != nil {
		return m.MaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxLines() int32 {
	if m != nil {
		return m.MaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxBytes() int32 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxFiles() int32 {
	if m != nil {
		return m.SafeMaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxLines() int32 {
	if m != nil {
		return m.SafeMaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxBytes() int32 {
	if m != nil {
		return m.SafeMaxBytes
	}
	return 0
}

// A CommitDiffResponse corresponds to a single changed file in a commit.
type CommitDiffResponse struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId       string `protobuf:"bytes,3,opt,name=from_id,json=fromId" json:"from_id,omitempty"`
	ToId         string `protobuf:"bytes,4,opt,name=to_id,json=toId" json:"to_id,omitempty"`
	OldMode      int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode" json:"old_mode,omitempty"`
	NewMode      int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode" json:"new_mode,omitempty"`
	Binary       bool   `protobuf:"varint,7,opt,name=binary" json:"binary,omitempty"`
	RawPatchData []byte `protobuf:"bytes,9,opt,name=raw_patch_data,json=rawPatchData,proto3" json:"raw_patch_data,omitempty"`
	EndOfPatch   bool   `protobuf:"varint,10,opt,name=end_of_patch,json=endOfPatch" json:"end_of_patch,omitempty"`
	// Indicates the diff file at which we overflow according to the limitations sent,
	// in which case only this attribute will be set.
	OverflowMarker bool `protobuf:"varint,11,opt,name=overflow_marker,json=overflowMarker" json:"overflow_marker,omitempty"`
	// Indicates the patch surpassed a "safe" limit and was therefore pruned, but
	// the client may still request the full patch on a separate request.
	Collapsed bool `protobuf:"varint,12,opt,name=collapsed" json:"collapsed,omitempty"`
	// Indicates the patch was pruned since it surpassed a hard limit, and can
	// therefore not be expanded.
	TooLarge bool `protobuf:"varint,13,opt,name=too_large,json=tooLarge" json:"too_large,omitempty"`
}

func (m *CommitDiffResponse) Reset()                    { *m = CommitDiffResponse{} }
func (m *CommitDiffResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitDiffResponse) ProtoMessage()               {}
func (*CommitDiffResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{1} }

func (m *CommitDiffResponse) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDiffResponse) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDiffResponse) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDiffResponse) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDiffResponse) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDiffResponse) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

func (m *CommitDiffResponse) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

func (m *CommitDiffResponse) GetRawPatchData() []byte {
	if m != nil {
		return m.RawPatchData
	}
	return nil
}

func (m *CommitDiffResponse) GetEndOfPatch() bool {
	if m != nil {
		return m.EndOfPatch
	}
	return false
}

func (m *CommitDiffResponse) GetOverflowMarker() bool {
	if m != nil {
		return m.OverflowMarker
	}
	return false
}

func (m *CommitDiffResponse) GetCollapsed() bool {
	if m != nil {
		return m.Collapsed
	}
	return false
}

func (m *CommitDiffResponse) GetTooLarge() bool {
	if m != nil {
		return m.TooLarge
	}
	return false
}

type CommitDeltaRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId  string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
	Paths         [][]byte    `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (m *CommitDeltaRequest) Reset()                    { *m = CommitDeltaRequest{} }
func (m *CommitDeltaRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitDeltaRequest) ProtoMessage()               {}
func (*CommitDeltaRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{2} }

func (m *CommitDeltaRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDeltaRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type CommitDelta struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId  string `protobuf:"bytes,3,opt,name=from_id,json=fromId" json:"from_id,omitempty"`
	ToId    string `protobuf:"bytes,4,opt,name=to_id,json=toId" json:"to_id,omitempty"`
	OldMode int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode" json:"old_mode,omitempty"`
	NewMode int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode" json:"new_mode,omitempty"`
}

func (m *CommitDelta) Reset()                    { *m = CommitDelta{} }
func (m *CommitDelta) String() string            { return proto.CompactTextString(m) }
func (*CommitDelta) ProtoMessage()               {}
func (*CommitDelta) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{3} }

func (m *CommitDelta) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDelta) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDelta) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDelta) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDelta) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDelta) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

type CommitDeltaResponse struct {
	Deltas []*CommitDelta `protobuf:"bytes,1,rep,name=deltas" json:"deltas,omitempty"`
}

func (m *CommitDeltaResponse) Reset()                    { *m = CommitDeltaResponse{} }
func (m *CommitDeltaResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitDeltaResponse) ProtoMessage()               {}
func (*CommitDeltaResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{4} }

func (m *CommitDeltaResponse) GetDeltas() []*CommitDelta {
	if m != nil {
		return m.Deltas
	}
	return nil
}

type CommitPatchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitPatchRequest) Reset()                    { *m = CommitPatchRequest{} }
func (m *CommitPatchRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitPatchRequest) ProtoMessage()               {}
func (*CommitPatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{5} }

func (m *CommitPatchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitPatchRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitPatchResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *CommitPatchResponse) Reset()                    { *m = CommitPatchResponse{} }
func (m *CommitPatchResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitPatchResponse) ProtoMessage()               {}
func (*CommitPatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{6} }

func (m *CommitPatchResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawDiffRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId  string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
}

func (m *RawDiffRequest) Reset()                    { *m = RawDiffRequest{} }
func (m *RawDiffRequest) String() string            { return proto.CompactTextString(m) }
func (*RawDiffRequest) ProtoMessage()               {}
func (*RawDiffRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{7} }

func (m *RawDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawDiffResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *RawDiffResponse) Reset()                    { *m = RawDiffResponse{} }
func (m *RawDiffResponse) String() string            { return proto.CompactTextString(m) }
func (*RawDiffResponse) ProtoMessage()               {}
func (*RawDiffResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{8} }

func (m *RawDiffResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawPatchRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId  string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
}

func (m *RawPatchRequest) Reset()                    { *m = RawPatchRequest{} }
func (m *RawPatchRequest) String() string            { return proto.CompactTextString(m) }
func (*RawPatchRequest) ProtoMessage()               {}
func (*RawPatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{9} }

func (m *RawPatchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawPatchRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawPatchRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawPatchResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *RawPatchResponse) Reset()                    { *m = RawPatchResponse{} }
func (m *RawPatchResponse) String() string            { return proto.CompactTextString(m) }
func (*RawPatchResponse) ProtoMessage()               {}
func (*RawPatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{10} }

func (m *RawPatchResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type DiffStatsRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId  string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
}

func (m *DiffStatsRequest) Reset()                    { *m = DiffStatsRequest{} }
func (m *DiffStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*DiffStatsRequest) ProtoMessage()               {}
func (*DiffStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{11} }

func (m *DiffStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DiffStatsRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *DiffStatsRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type DiffStats struct {
	Path      []byte `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Additions int32  `protobuf:"varint,2,opt,name=additions" json:"additions,omitempty"`
	Deletions int32  `protobuf:"varint,3,opt,name=deletions" json:"deletions,omitempty"`
}

func (m *DiffStats) Reset()                    { *m = DiffStats{} }
func (m *DiffStats) String() string            { return proto.CompactTextString(m) }
func (*DiffStats) ProtoMessage()               {}
func (*DiffStats) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{12} }

func (m *DiffStats) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *DiffStats) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *DiffStats) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

type DiffStatsResponse struct {
	Stats []*DiffStats `protobuf:"bytes,1,rep,name=stats" json:"stats,omitempty"`
}

func (m *DiffStatsResponse) Reset()                    { *m = DiffStatsResponse{} }
func (m *DiffStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*DiffStatsResponse) ProtoMessage()               {}
func (*DiffStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{13} }

func (m *DiffStatsResponse) GetStats() []*DiffStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitDiffRequest)(nil), "gitaly.CommitDiffRequest")
	proto.RegisterType((*CommitDiffResponse)(nil), "gitaly.CommitDiffResponse")
	proto.RegisterType((*CommitDeltaRequest)(nil), "gitaly.CommitDeltaRequest")
	proto.RegisterType((*CommitDelta)(nil), "gitaly.CommitDelta")
	proto.RegisterType((*CommitDeltaResponse)(nil), "gitaly.CommitDeltaResponse")
	proto.RegisterType((*CommitPatchRequest)(nil), "gitaly.CommitPatchRequest")
	proto.RegisterType((*CommitPatchResponse)(nil), "gitaly.CommitPatchResponse")
	proto.RegisterType((*RawDiffRequest)(nil), "gitaly.RawDiffRequest")
	proto.RegisterType((*RawDiffResponse)(nil), "gitaly.RawDiffResponse")
	proto.RegisterType((*RawPatchRequest)(nil), "gitaly.RawPatchRequest")
	proto.RegisterType((*RawPatchResponse)(nil), "gitaly.RawPatchResponse")
	proto.RegisterType((*DiffStatsRequest)(nil), "gitaly.DiffStatsRequest")
	proto.RegisterType((*DiffStats)(nil), "gitaly.DiffStats")
	proto.RegisterType((*DiffStatsResponse)(nil), "gitaly.DiffStatsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DiffService service

type DiffServiceClient interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error)
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error)
	CommitPatch(ctx context.Context, in *CommitPatchRequest, opts ...grpc.CallOption) (DiffService_CommitPatchClient, error)
	RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error)
	RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error)
	DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error)
}

type diffServiceClient struct {
	cc *grpc.ClientConn
}

func NewDiffServiceClient(cc *grpc.ClientConn) DiffServiceClient {
	return &diffServiceClient{cc}
}

func (c *diffServiceClient) CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[0], c.cc, "/gitaly.DiffService/CommitDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDiffClient interface {
	Recv() (*CommitDiffResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDiffClient) Recv() (*CommitDiffResponse, error) {
	m := new(CommitDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[1], c.cc, "/gitaly.DiffService/CommitDelta", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDeltaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDeltaClient interface {
	Recv() (*CommitDeltaResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDeltaClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDeltaClient) Recv() (*CommitDeltaResponse, error) {
	m := new(CommitDeltaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitPatch(ctx context.Context, in *CommitPatchRequest, opts ...grpc.CallOption) (DiffService_CommitPatchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[2], c.cc, "/gitaly.DiffService/CommitPatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitPatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitPatchClient interface {
	Recv() (*CommitPatchResponse, error)
	grpc.ClientStream
}

type diffServiceCommitPatchClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitPatchClient) Recv() (*CommitPatchResponse, error) {
	m := new(CommitPatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[3], c.cc, "/gitaly.DiffService/RawDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawDiffClient interface {
	Recv() (*RawDiffResponse, error)
	grpc.ClientStream
}

type diffServiceRawDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawDiffClient) Recv() (*RawDiffResponse, error) {
	m := new(RawDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[4], c.cc, "/gitaly.DiffService/RawPatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawPatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawPatchClient interface {
	Recv() (*RawPatchResponse, error)
	grpc.ClientStream
}

type diffServiceRawPatchClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawPatchClient) Recv() (*RawPatchResponse, error) {
	m := new(RawPatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[5], c.cc, "/gitaly.DiffService/DiffStats", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceDiffStatsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_DiffStatsClient interface {
	Recv() (*DiffStatsResponse, error)
	grpc.ClientStream
}

type diffServiceDiffStatsClient struct {
	grpc.ClientStream
}

func (x *diffServiceDiffStatsClient) Recv() (*DiffStatsResponse, error) {
	m := new(DiffStatsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for DiffService service

type DiffServiceServer interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(*CommitDiffRequest, DiffService_CommitDiffServer) error
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(*CommitDeltaRequest, DiffService_CommitDeltaServer) error
	CommitPatch(*CommitPatchRequest, DiffService_CommitPatchServer) error
	RawDiff(*RawDiffRequest, DiffService_RawDiffServer) error
	RawPatch(*RawPatchRequest, DiffService_RawPatchServer) error
	DiffStats(*DiffStatsRequest, DiffService_DiffStatsServer) error
}

func RegisterDiffServiceServer(s *grpc.Server, srv DiffServiceServer) {
	s.RegisterService(&_DiffService_serviceDesc, srv)
}

func _DiffService_CommitDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDiff(m, &diffServiceCommitDiffServer{stream})
}

type DiffService_CommitDiffServer interface {
	Send(*CommitDiffResponse) error
	grpc.ServerStream
}

type diffServiceCommitDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDiffServer) Send(m *CommitDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitDelta_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDeltaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDelta(m, &diffServiceCommitDeltaServer{stream})
}

type DiffService_CommitDeltaServer interface {
	Send(*CommitDeltaResponse) error
	grpc.ServerStream
}

type diffServiceCommitDeltaServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDeltaServer) Send(m *CommitDeltaResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitPatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitPatch(m, &diffServiceCommitPatchServer{stream})
}

type DiffService_CommitPatchServer interface {
	Send(*CommitPatchResponse) error
	grpc.ServerStream
}

type diffServiceCommitPatchServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitPatchServer) Send(m *CommitPatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawDiff(m, &diffServiceRawDiffServer{stream})
}

type DiffService_RawDiffServer interface {
	Send(*RawDiffResponse) error
	grpc.ServerStream
}

type diffServiceRawDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawDiffServer) Send(m *RawDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawPatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawPatch(m, &diffServiceRawPatchServer{stream})
}

type DiffService_RawPatchServer interface {
	Send(*RawPatchResponse) error
	grpc.ServerStream
}

type diffServiceRawPatchServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawPatchServer) Send(m *RawPatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_DiffStats_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DiffStatsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).DiffStats(m, &diffServiceDiffStatsServer{stream})
}

type DiffService_DiffStatsServer interface {
	Send(*DiffStatsResponse) error
	grpc.ServerStream
}

type diffServiceDiffStatsServer struct {
	grpc.ServerStream
}

func (x *diffServiceDiffStatsServer) Send(m *DiffStatsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DiffService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.DiffService",
	HandlerType: (*DiffServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "CommitDiff",
			Handler:       _DiffService_CommitDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitDelta",
			Handler:       _DiffService_CommitDelta_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitPatch",
			Handler:       _DiffService_CommitPatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawDiff",
			Handler:       _DiffService_RawDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawPatch",
			Handler:       _DiffService_RawPatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DiffStats",
			Handler:       _DiffService_DiffStats_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "diff.proto",
}

func init() { proto.RegisterFile("diff.proto", fileDescriptor4) }

var fileDescriptor4 = []byte{
	// 849 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcb, 0x6e, 0x23, 0x45,
	0x14, 0xa5, 0x63, 0xbb, 0xd3, 0xbe, 0xee, 0xbc, 0x2a, 0x28, 0xd3, 0xf1, 0xb0, 0xb0, 0x5a, 0xcc,
	0x8c, 0x11, 0x52, 0x84, 0xc2, 0x86, 0x05, 0x42, 0x62, 0x26, 0x02, 0x65, 0x94, 0x88, 0x51, 0xb3,
	0x60, 0xc1, 0xa2, 0x55, 0x71, 0xdd, 0xb6, 0x4b, 0x74, 0x77, 0x99, 0xaa, 0x22, 0x1e, 0xff, 0x06,
	0xf0, 0x0f, 0x6c, 0xd8, 0xf3, 0x6b, 0x2c, 0x58, 0xa0, 0xaa, 0xea, 0x97, 0x13, 0x6b, 0x36, 0x33,
	0x0b, 0xef, 0x5c, 0xe7, 0x9c, 0xbe, 0xf7, 0xd4, 0x7d, 0x54, 0x02, 0xc0, 0x78, 0x96, 0x5d, 0x2c,
	0xa5, 0xd0, 0x82, 0xf8, 0x73, 0xae, 0x69, 0xbe, 0x1e, 0x87, 0x6a, 0x41, 0x25, 0x32, 0x87, 0xc6,
	0xff, 0xf5, 0xe0, 0xe4, 0x95, 0x28, 0x0a, 0xae, 0xaf, 0x78, 0x96, 0x25, 0xf8, 0xeb, 0x6f, 0xa8,
	0x34, 0xb9, 0x04, 0x90, 0xb8, 0x14, 0x8a, 0x6b, 0x21, 0xd7, 0x91, 0x37, 0xf1, 0xa6, 0xa3, 0x4b,
	0x72, 0xe1, 0x02, 0x5c, 0x24, 0x0d, 0x93, 0x74, 0x54, 0xe4, 0x53, 0x38, 0xcc, 0x31, 0xd3, 0xe9,
	0xcc, 0x46, 0x4b, 0x39, 0x8b, 0xf6, 0x26, 0xde, 0x74, 0x98, 0x84, 0x06, 0x75, 0x29, 0xae, 0x19,
	0x79, 0x0e, 0x47, 0x92, 0xcf, 0x17, 0x5d, 0x59, 0xcf, 0xca, 0x0e, 0x2c, 0xdc, 0xe8, 0xbe, 0x82,
	0x88, 0xcf, 0x4b, 0x21, 0x31, 0x5d, 0x2d, 0xb8, 0x46, 0xb5, 0xa4, 0x33, 0x4c, 0x67, 0x0b, 0x5a,
	0xce, 0x31, 0xea, 0x4f, 0xbc, 0x69, 0x90, 0x9c, 0x39, 0xfe, 0xa7, 0x86, 0x7e, 0x65, 0x59, 0xf2,
	0x31, 0x0c, 0x96, 0x54, 0x2f, 0x54, 0x34, 0x98, 0xf4, 0xa6, 0x61, 0xe2, 0x0e, 0xe4, 0x19, 0x1c,
	0xce, 0x44, 0x9e, 0xd3, 0xa5, 0xc2, 0xd4, 0x14, 0x45, 0x45, 0xbe, 0x8d, 0x72, 0x50, 0xa3, 0xe6,
	0xfa, 0x56, 0x86, 0x65, 0x26, 0xe4, 0x0c, 0xd3, 0x9c, 0x17, 0x5c, 0xab, 0x68, 0xdf, 0xc9, 0x2a,
	0xf4, 0xc6, 0x82, 0xe4, 0x29, 0x0c, 0x0b, 0xfa, 0x36, 0xcd, 0x78, 0x8e, 0x2a, 0x0a, 0x26, 0xde,
	0x74, 0x90, 0x04, 0x05, 0x7d, 0xfb, 0x9d, 0x39, 0xd7, 0x64, 0xce, 0x4b, 0x54, 0xd1, 0xb0, 0x21,
	0x6f, 0xcc, 0xb9, 0x26, 0xef, 0xd6, 0x1a, 0x55, 0x04, 0x0d, 0xf9, 0xd2, 0x9c, 0x4d, 0x09, 0x15,
	0xcd, 0x30, 0x6d, 0x63, 0x8f, 0xac, 0x22, 0x34, 0xe8, 0x6d, 0x1d, 0xbf, 0xab, 0x72, 0x49, 0xc2,
	0x0d, 0x95, 0x4b, 0xd4, 0x55, 0xb9, 0x6c, 0x07, 0x1b, 0x2a, 0x9b, 0x31, 0xfe, 0x77, 0x0f, 0x48,
	0xb7, 0xfd, 0x6a, 0x29, 0x4a, 0x85, 0xc6, 0x65, 0x26, 0x45, 0x91, 0x9a, 0xda, 0xd9, 0xf6, 0x87,
	0x49, 0x60, 0x80, 0x37, 0x54, 0x2f, 0xc8, 0x13, 0xd8, 0xd7, 0xc2, 0x51, 0x7b, 0x96, 0xf2, 0xb5,
	0xa8, 0x09, 0xfb, 0x55, 0xd3, 0x53, 0xdf, 0x1c, 0xaf, 0x19, 0x39, 0x85, 0x81, 0x16, 0x06, 0xee,
	0x5b, 0xb8, 0xaf, 0xc5, 0x35, 0x23, 0xe7, 0x10, 0x88, 0x9c, 0xa5, 0x85, 0x60, 0x18, 0x0d, 0xac,
	0xb5, 0x7d, 0x91, 0xb3, 0x5b, 0xc1, 0xd0, 0x50, 0x25, 0xae, 0x1c, 0xe5, 0x3b, 0xaa, 0xc4, 0x95,
	0xa5, 0xce, 0xc0, 0xbf, 0xe3, 0x25, 0x95, 0xeb, 0xaa, 0x31, 0xd5, 0xc9, 0x5c, 0x57, 0xd2, 0x95,
	0x71, 0x35, 0x5b, 0xa4, 0x8c, 0x6a, 0x6a, 0x2b, 0x1f, 0x26, 0xa1, 0xa4, 0xab, 0x37, 0x06, 0xbc,
	0xa2, 0x9a, 0x92, 0x09, 0x84, 0x58, 0xb2, 0x54, 0x64, 0x4e, 0x68, 0x1b, 0x10, 0x24, 0x80, 0x25,
	0xfb, 0x21, 0xb3, 0x2a, 0xf2, 0x02, 0x8e, 0xc4, 0x3d, 0xca, 0x2c, 0x17, 0xab, 0xb4, 0xa0, 0xf2,
	0x17, 0x94, 0xb6, 0x07, 0x41, 0x72, 0x58, 0xc3, 0xb7, 0x16, 0x25, 0x9f, 0xc0, 0xb0, 0x1e, 0x1d,
	0x66, 0x1b, 0x10, 0x24, 0x2d, 0x60, 0x0a, 0xa8, 0x85, 0x48, 0x73, 0x2a, 0xe7, 0x68, 0x0b, 0x1f,
	0x24, 0x81, 0x16, 0xe2, 0xc6, 0x9c, 0x5f, 0xf7, 0x83, 0xe0, 0x78, 0x18, 0xff, 0xed, 0x35, 0xa5,
	0xc7, 0x5c, 0xd3, 0xdd, 0x59, 0xbd, 0x66, 0x81, 0xfa, 0x9d, 0x05, 0x8a, 0xff, 0xf2, 0x60, 0xd4,
	0xb1, 0xbb, 0xbb, 0x23, 0x12, 0xbf, 0x84, 0xd3, 0x8d, 0xba, 0x56, 0x33, 0xfd, 0x39, 0xf8, 0xcc,
	0x00, 0x2a, 0xf2, 0x26, 0xbd, 0xe9, 0xe8, 0xf2, 0xb4, 0x2e, 0x6a, 0x57, 0x5c, 0x49, 0x62, 0x56,
	0xf7, 0xc6, 0x4e, 0xc5, 0xfb, 0xf4, 0x66, 0x0c, 0x81, 0xc4, 0x7b, 0xae, 0xb8, 0x28, 0xab, 0x5a,
	0x34, 0xe7, 0xf8, 0xb3, 0xda, 0x69, 0x95, 0xa5, 0x72, 0x4a, 0xa0, 0x6f, 0x27, 0xd8, 0x55, 0xd5,
	0xfe, 0x8e, 0x7f, 0xf7, 0xe0, 0x30, 0xa1, 0xab, 0x9d, 0x7a, 0xa4, 0xe3, 0x67, 0x70, 0xd4, 0x78,
	0x7a, 0x87, 0xf7, 0x3f, 0x3c, 0xab, 0x7b, 0xef, 0x52, 0x7e, 0x58, 0xf3, 0xcf, 0xe1, 0xb8, 0x35,
	0xf5, 0x0e, 0xf7, 0x7f, 0x7a, 0x70, 0x6c, 0xae, 0xf8, 0xa3, 0xa6, 0x5a, 0xed, 0x8e, 0xfd, 0x9f,
	0x61, 0xd8, 0xb8, 0x32, 0xbe, 0x3b, 0x7b, 0x68, 0x7f, 0x9b, 0x07, 0x8a, 0x32, 0xc6, 0x35, 0x17,
	0xa5, 0xb2, 0x99, 0x06, 0x49, 0x0b, 0x18, 0x96, 0x61, 0x8e, 0x8e, 0xed, 0x39, 0xb6, 0x01, 0xe2,
	0xaf, 0xe1, 0xa4, 0x73, 0xe5, 0xaa, 0x38, 0x2f, 0x60, 0xa0, 0x0c, 0x50, 0xed, 0xcf, 0x49, 0x7d,
	0xdd, 0x56, 0xe9, 0xf8, 0xcb, 0x7f, 0x7a, 0x30, 0xb2, 0x20, 0xca, 0x7b, 0x3e, 0x43, 0xf2, 0x3d,
	0x40, 0xfb, 0x37, 0x86, 0x9c, 0x3f, 0xd8, 0xbb, 0x76, 0xa2, 0xc7, 0xe3, 0x6d, 0x94, 0xcb, 0x1e,
	0x7f, 0xf4, 0x85, 0x47, 0x5e, 0x6f, 0x3e, 0x41, 0xe3, 0x6d, 0x1b, 0x5c, 0x85, 0x7a, 0xba, 0x95,
	0xdb, 0x16, 0xcb, 0xbd, 0xfb, 0x0f, 0x62, 0x75, 0x67, 0xf5, 0x61, 0xac, 0x8d, 0x91, 0xb1, 0xb1,
	0xbe, 0x81, 0xfd, 0x6a, 0x0f, 0xc8, 0x59, 0x33, 0x04, 0x1b, 0xcb, 0x3a, 0x7e, 0xf2, 0x08, 0xef,
	0x7c, 0xff, 0x2d, 0x04, 0xf5, 0x28, 0x92, 0xae, 0x70, 0xc3, 0x45, 0xf4, 0x98, 0xe8, 0x84, 0xb8,
	0xea, 0x8e, 0x43, 0xf4, 0xb8, 0x35, 0x55, 0x90, 0xf3, 0x2d, 0x4c, 0x1b, 0xe5, 0xce, 0xb7, 0xff,
	0x14, 0x7e, 0xf9, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x14, 0xf1, 0x18, 0xaf, 0x38, 0x0a, 0x00,
	0x00,
}
