// Code generated by protoc-gen-go. DO NOT EDIT.
// source: ref.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type FindLocalBranchesRequest_SortBy int32

const (
	FindLocalBranchesRequest_NAME         FindLocalBranchesRequest_SortBy = 0
	FindLocalBranchesRequest_UPDATED_ASC  FindLocalBranchesRequest_SortBy = 1
	FindLocalBranchesRequest_UPDATED_DESC FindLocalBranchesRequest_SortBy = 2
)

var FindLocalBranchesRequest_SortBy_name = map[int32]string{
	0: "NAME",
	1: "UPDATED_ASC",
	2: "UPDATED_DESC",
}
var FindLocalBranchesRequest_SortBy_value = map[string]int32{
	"NAME":         0,
	"UPDATED_ASC":  1,
	"UPDATED_DESC": 2,
}

func (x FindLocalBranchesRequest_SortBy) String() string {
	return proto.EnumName(FindLocalBranchesRequest_SortBy_name, int32(x))
}
func (FindLocalBranchesRequest_SortBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor8, []int{8, 0}
}

type CreateBranchResponse_Status int32

const (
	CreateBranchResponse_OK                      CreateBranchResponse_Status = 0
	CreateBranchResponse_ERR_EXISTS              CreateBranchResponse_Status = 1
	CreateBranchResponse_ERR_INVALID             CreateBranchResponse_Status = 2
	CreateBranchResponse_ERR_INVALID_START_POINT CreateBranchResponse_Status = 3
)

var CreateBranchResponse_Status_name = map[int32]string{
	0: "OK",
	1: "ERR_EXISTS",
	2: "ERR_INVALID",
	3: "ERR_INVALID_START_POINT",
}
var CreateBranchResponse_Status_value = map[string]int32{
	"OK":                      0,
	"ERR_EXISTS":              1,
	"ERR_INVALID":             2,
	"ERR_INVALID_START_POINT": 3,
}

func (x CreateBranchResponse_Status) String() string {
	return proto.EnumName(CreateBranchResponse_Status_name, int32(x))
}
func (CreateBranchResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor8, []int{19, 0}
}

type FindDefaultBranchNameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindDefaultBranchNameRequest) Reset()                    { *m = FindDefaultBranchNameRequest{} }
func (m *FindDefaultBranchNameRequest) String() string            { return proto.CompactTextString(m) }
func (*FindDefaultBranchNameRequest) ProtoMessage()               {}
func (*FindDefaultBranchNameRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func (m *FindDefaultBranchNameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindDefaultBranchNameResponse struct {
	Name []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindDefaultBranchNameResponse) Reset()                    { *m = FindDefaultBranchNameResponse{} }
func (m *FindDefaultBranchNameResponse) String() string            { return proto.CompactTextString(m) }
func (*FindDefaultBranchNameResponse) ProtoMessage()               {}
func (*FindDefaultBranchNameResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{1} }

func (m *FindDefaultBranchNameResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindAllBranchNamesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllBranchNamesRequest) Reset()                    { *m = FindAllBranchNamesRequest{} }
func (m *FindAllBranchNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchNamesRequest) ProtoMessage()               {}
func (*FindAllBranchNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{2} }

func (m *FindAllBranchNamesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllBranchNamesResponse struct {
	Names [][]byte `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *FindAllBranchNamesResponse) Reset()                    { *m = FindAllBranchNamesResponse{} }
func (m *FindAllBranchNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchNamesResponse) ProtoMessage()               {}
func (*FindAllBranchNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{3} }

func (m *FindAllBranchNamesResponse) GetNames() [][]byte {
	if m != nil {
		return m.Names
	}
	return nil
}

type FindAllTagNamesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllTagNamesRequest) Reset()                    { *m = FindAllTagNamesRequest{} }
func (m *FindAllTagNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagNamesRequest) ProtoMessage()               {}
func (*FindAllTagNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{4} }

func (m *FindAllTagNamesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllTagNamesResponse struct {
	Names [][]byte `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *FindAllTagNamesResponse) Reset()                    { *m = FindAllTagNamesResponse{} }
func (m *FindAllTagNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagNamesResponse) ProtoMessage()               {}
func (*FindAllTagNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{5} }

func (m *FindAllTagNamesResponse) GetNames() [][]byte {
	if m != nil {
		return m.Names
	}
	return nil
}

type FindRefNameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Require that the resulting ref contains this commit as an ancestor
	CommitId string `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Example prefix: "refs/heads/". Type bytes because that is the type of ref names.
	Prefix []byte `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
}

func (m *FindRefNameRequest) Reset()                    { *m = FindRefNameRequest{} }
func (m *FindRefNameRequest) String() string            { return proto.CompactTextString(m) }
func (*FindRefNameRequest) ProtoMessage()               {}
func (*FindRefNameRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{6} }

func (m *FindRefNameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindRefNameRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *FindRefNameRequest) GetPrefix() []byte {
	if m != nil {
		return m.Prefix
	}
	return nil
}

type FindRefNameResponse struct {
	// Example name: "refs/heads/master". Cannot assume UTF8, so the type is bytes.
	Name []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindRefNameResponse) Reset()                    { *m = FindRefNameResponse{} }
func (m *FindRefNameResponse) String() string            { return proto.CompactTextString(m) }
func (*FindRefNameResponse) ProtoMessage()               {}
func (*FindRefNameResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{7} }

func (m *FindRefNameResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindLocalBranchesRequest struct {
	Repository *Repository                     `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	SortBy     FindLocalBranchesRequest_SortBy `protobuf:"varint,2,opt,name=sort_by,json=sortBy,enum=gitaly.FindLocalBranchesRequest_SortBy" json:"sort_by,omitempty"`
}

func (m *FindLocalBranchesRequest) Reset()                    { *m = FindLocalBranchesRequest{} }
func (m *FindLocalBranchesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchesRequest) ProtoMessage()               {}
func (*FindLocalBranchesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{8} }

func (m *FindLocalBranchesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindLocalBranchesRequest) GetSortBy() FindLocalBranchesRequest_SortBy {
	if m != nil {
		return m.SortBy
	}
	return FindLocalBranchesRequest_NAME
}

type FindLocalBranchesResponse struct {
	Branches []*FindLocalBranchResponse `protobuf:"bytes,1,rep,name=branches" json:"branches,omitempty"`
}

func (m *FindLocalBranchesResponse) Reset()                    { *m = FindLocalBranchesResponse{} }
func (m *FindLocalBranchesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchesResponse) ProtoMessage()               {}
func (*FindLocalBranchesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{9} }

func (m *FindLocalBranchesResponse) GetBranches() []*FindLocalBranchResponse {
	if m != nil {
		return m.Branches
	}
	return nil
}

type FindLocalBranchResponse struct {
	Name            []byte                       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	CommitId        string                       `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	CommitSubject   []byte                       `protobuf:"bytes,3,opt,name=commit_subject,json=commitSubject,proto3" json:"commit_subject,omitempty"`
	CommitAuthor    *FindLocalBranchCommitAuthor `protobuf:"bytes,4,opt,name=commit_author,json=commitAuthor" json:"commit_author,omitempty"`
	CommitCommitter *FindLocalBranchCommitAuthor `protobuf:"bytes,5,opt,name=commit_committer,json=commitCommitter" json:"commit_committer,omitempty"`
}

func (m *FindLocalBranchResponse) Reset()                    { *m = FindLocalBranchResponse{} }
func (m *FindLocalBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchResponse) ProtoMessage()               {}
func (*FindLocalBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{10} }

func (m *FindLocalBranchResponse) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *FindLocalBranchResponse) GetCommitSubject() []byte {
	if m != nil {
		return m.CommitSubject
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitAuthor() *FindLocalBranchCommitAuthor {
	if m != nil {
		return m.CommitAuthor
	}
	return nil
}

func (m *FindLocalBranchResponse) GetCommitCommitter() *FindLocalBranchCommitAuthor {
	if m != nil {
		return m.CommitCommitter
	}
	return nil
}

type FindLocalBranchCommitAuthor struct {
	Name  []byte                     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Email []byte                     `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	Date  *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=date" json:"date,omitempty"`
}

func (m *FindLocalBranchCommitAuthor) Reset()                    { *m = FindLocalBranchCommitAuthor{} }
func (m *FindLocalBranchCommitAuthor) String() string            { return proto.CompactTextString(m) }
func (*FindLocalBranchCommitAuthor) ProtoMessage()               {}
func (*FindLocalBranchCommitAuthor) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{11} }

func (m *FindLocalBranchCommitAuthor) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindLocalBranchCommitAuthor) GetEmail() []byte {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *FindLocalBranchCommitAuthor) GetDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.Date
	}
	return nil
}

type FindAllBranchesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Only return branches that are merged into root ref
	MergedOnly bool `protobuf:"varint,2,opt,name=merged_only,json=mergedOnly" json:"merged_only,omitempty"`
	// If merged_only is true, this is a list of branches from which we
	// return those merged into the root ref
	MergedBranches [][]byte `protobuf:"bytes,3,rep,name=merged_branches,json=mergedBranches,proto3" json:"merged_branches,omitempty"`
}

func (m *FindAllBranchesRequest) Reset()                    { *m = FindAllBranchesRequest{} }
func (m *FindAllBranchesRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchesRequest) ProtoMessage()               {}
func (*FindAllBranchesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{12} }

func (m *FindAllBranchesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllBranchesRequest) GetMergedOnly() bool {
	if m != nil {
		return m.MergedOnly
	}
	return false
}

func (m *FindAllBranchesRequest) GetMergedBranches() [][]byte {
	if m != nil {
		return m.MergedBranches
	}
	return nil
}

type FindAllBranchesResponse struct {
	Branches []*FindAllBranchesResponse_Branch `protobuf:"bytes,1,rep,name=branches" json:"branches,omitempty"`
}

func (m *FindAllBranchesResponse) Reset()                    { *m = FindAllBranchesResponse{} }
func (m *FindAllBranchesResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllBranchesResponse) ProtoMessage()               {}
func (*FindAllBranchesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{13} }

func (m *FindAllBranchesResponse) GetBranches() []*FindAllBranchesResponse_Branch {
	if m != nil {
		return m.Branches
	}
	return nil
}

type FindAllBranchesResponse_Branch struct {
	Name   []byte     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Target *GitCommit `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
}

func (m *FindAllBranchesResponse_Branch) Reset()         { *m = FindAllBranchesResponse_Branch{} }
func (m *FindAllBranchesResponse_Branch) String() string { return proto.CompactTextString(m) }
func (*FindAllBranchesResponse_Branch) ProtoMessage()    {}
func (*FindAllBranchesResponse_Branch) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{13, 0}
}

func (m *FindAllBranchesResponse_Branch) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FindAllBranchesResponse_Branch) GetTarget() *GitCommit {
	if m != nil {
		return m.Target
	}
	return nil
}

type FindAllTagsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
}

func (m *FindAllTagsRequest) Reset()                    { *m = FindAllTagsRequest{} }
func (m *FindAllTagsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagsRequest) ProtoMessage()               {}
func (*FindAllTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{14} }

func (m *FindAllTagsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

type FindAllTagsResponse struct {
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags" json:"tags,omitempty"`
}

func (m *FindAllTagsResponse) Reset()                    { *m = FindAllTagsResponse{} }
func (m *FindAllTagsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllTagsResponse) ProtoMessage()               {}
func (*FindAllTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{15} }

func (m *FindAllTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

type RefExistsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Any ref, e.g. 'refs/heads/master' or 'refs/tags/v1.0.1'. Must start with 'refs/'.
	Ref []byte `protobuf:"bytes,2,opt,name=ref,proto3" json:"ref,omitempty"`
}

func (m *RefExistsRequest) Reset()                    { *m = RefExistsRequest{} }
func (m *RefExistsRequest) String() string            { return proto.CompactTextString(m) }
func (*RefExistsRequest) ProtoMessage()               {}
func (*RefExistsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{16} }

func (m *RefExistsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RefExistsRequest) GetRef() []byte {
	if m != nil {
		return m.Ref
	}
	return nil
}

type RefExistsResponse struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *RefExistsResponse) Reset()                    { *m = RefExistsResponse{} }
func (m *RefExistsResponse) String() string            { return proto.CompactTextString(m) }
func (*RefExistsResponse) ProtoMessage()               {}
func (*RefExistsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{17} }

func (m *RefExistsResponse) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type CreateBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Name       []byte      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	StartPoint []byte      `protobuf:"bytes,3,opt,name=start_point,json=startPoint,proto3" json:"start_point,omitempty"`
}

func (m *CreateBranchRequest) Reset()                    { *m = CreateBranchRequest{} }
func (m *CreateBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateBranchRequest) ProtoMessage()               {}
func (*CreateBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{18} }

func (m *CreateBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CreateBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CreateBranchRequest) GetStartPoint() []byte {
	if m != nil {
		return m.StartPoint
	}
	return nil
}

type CreateBranchResponse struct {
	Status CreateBranchResponse_Status `protobuf:"varint,1,opt,name=status,enum=gitaly.CreateBranchResponse_Status" json:"status,omitempty"`
	Branch *Branch                     `protobuf:"bytes,2,opt,name=branch" json:"branch,omitempty"`
}

func (m *CreateBranchResponse) Reset()                    { *m = CreateBranchResponse{} }
func (m *CreateBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateBranchResponse) ProtoMessage()               {}
func (*CreateBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{19} }

func (m *CreateBranchResponse) GetStatus() CreateBranchResponse_Status {
	if m != nil {
		return m.Status
	}
	return CreateBranchResponse_OK
}

func (m *CreateBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

type DeleteBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Name       []byte      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *DeleteBranchRequest) Reset()                    { *m = DeleteBranchRequest{} }
func (m *DeleteBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBranchRequest) ProtoMessage()               {}
func (*DeleteBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{20} }

func (m *DeleteBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DeleteBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

// Not clear if we need to do status signaling; we can add fields later.
type DeleteBranchResponse struct {
}

func (m *DeleteBranchResponse) Reset()                    { *m = DeleteBranchResponse{} }
func (m *DeleteBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteBranchResponse) ProtoMessage()               {}
func (*DeleteBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{21} }

type FindBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// Name can be 'master' but also 'refs/heads/master'
	Name []byte `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *FindBranchRequest) Reset()                    { *m = FindBranchRequest{} }
func (m *FindBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*FindBranchRequest) ProtoMessage()               {}
func (*FindBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{22} }

func (m *FindBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindBranchRequest) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

type FindBranchResponse struct {
	Branch *Branch `protobuf:"bytes,1,opt,name=branch" json:"branch,omitempty"`
}

func (m *FindBranchResponse) Reset()                    { *m = FindBranchResponse{} }
func (m *FindBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*FindBranchResponse) ProtoMessage()               {}
func (*FindBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{23} }

func (m *FindBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

type DeleteRefsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// The following two fields are mutually exclusive
	ExceptWithPrefix [][]byte `protobuf:"bytes,2,rep,name=except_with_prefix,json=exceptWithPrefix,proto3" json:"except_with_prefix,omitempty"`
	Refs             [][]byte `protobuf:"bytes,3,rep,name=refs,proto3" json:"refs,omitempty"`
}

func (m *DeleteRefsRequest) Reset()                    { *m = DeleteRefsRequest{} }
func (m *DeleteRefsRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRefsRequest) ProtoMessage()               {}
func (*DeleteRefsRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{24} }

func (m *DeleteRefsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DeleteRefsRequest) GetExceptWithPrefix() [][]byte {
	if m != nil {
		return m.ExceptWithPrefix
	}
	return nil
}

func (m *DeleteRefsRequest) GetRefs() [][]byte {
	if m != nil {
		return m.Refs
	}
	return nil
}

type DeleteRefsResponse struct {
	GitError string `protobuf:"bytes,1,opt,name=git_error,json=gitError" json:"git_error,omitempty"`
}

func (m *DeleteRefsResponse) Reset()                    { *m = DeleteRefsResponse{} }
func (m *DeleteRefsResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRefsResponse) ProtoMessage()               {}
func (*DeleteRefsResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{25} }

func (m *DeleteRefsResponse) GetGitError() string {
	if m != nil {
		return m.GitError
	}
	return ""
}

type ListBranchNamesContainingCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Limit the number of tag names to be returned
	// If the limit is set to zero, all items will be returned
	Limit uint32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
}

func (m *ListBranchNamesContainingCommitRequest) Reset() {
	*m = ListBranchNamesContainingCommitRequest{}
}
func (m *ListBranchNamesContainingCommitRequest) String() string { return proto.CompactTextString(m) }
func (*ListBranchNamesContainingCommitRequest) ProtoMessage()    {}
func (*ListBranchNamesContainingCommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{26}
}

func (m *ListBranchNamesContainingCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListBranchNamesContainingCommitRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *ListBranchNamesContainingCommitRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type ListBranchNamesContainingCommitResponse struct {
	BranchNames [][]byte `protobuf:"bytes,2,rep,name=branch_names,json=branchNames,proto3" json:"branch_names,omitempty"`
}

func (m *ListBranchNamesContainingCommitResponse) Reset() {
	*m = ListBranchNamesContainingCommitResponse{}
}
func (m *ListBranchNamesContainingCommitResponse) String() string { return proto.CompactTextString(m) }
func (*ListBranchNamesContainingCommitResponse) ProtoMessage()    {}
func (*ListBranchNamesContainingCommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{27}
}

func (m *ListBranchNamesContainingCommitResponse) GetBranchNames() [][]byte {
	if m != nil {
		return m.BranchNames
	}
	return nil
}

type ListTagNamesContainingCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Limit the number of tag names to be returned
	// If the limit is set to zero, all items will be returned
	Limit uint32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
}

func (m *ListTagNamesContainingCommitRequest) Reset()         { *m = ListTagNamesContainingCommitRequest{} }
func (m *ListTagNamesContainingCommitRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagNamesContainingCommitRequest) ProtoMessage()    {}
func (*ListTagNamesContainingCommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{28}
}

func (m *ListTagNamesContainingCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListTagNamesContainingCommitRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *ListTagNamesContainingCommitRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type ListTagNamesContainingCommitResponse struct {
	TagNames [][]byte `protobuf:"bytes,2,rep,name=tag_names,json=tagNames,proto3" json:"tag_names,omitempty"`
}

func (m *ListTagNamesContainingCommitResponse) Reset()         { *m = ListTagNamesContainingCommitResponse{} }
func (m *ListTagNamesContainingCommitResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagNamesContainingCommitResponse) ProtoMessage()    {}
func (*ListTagNamesContainingCommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor8, []int{29}
}

func (m *ListTagNamesContainingCommitResponse) GetTagNames() [][]byte {
	if m != nil {
		return m.TagNames
	}
	return nil
}

type GetTagMessagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagIds     []string    `protobuf:"bytes,3,rep,name=tag_ids,json=tagIds" json:"tag_ids,omitempty"`
}

func (m *GetTagMessagesRequest) Reset()                    { *m = GetTagMessagesRequest{} }
func (m *GetTagMessagesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTagMessagesRequest) ProtoMessage()               {}
func (*GetTagMessagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{30} }

func (m *GetTagMessagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetTagMessagesRequest) GetTagIds() []string {
	if m != nil {
		return m.TagIds
	}
	return nil
}

type GetTagMessagesResponse struct {
	Message []byte `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Only present for a new tag message
	TagId string `protobuf:"bytes,3,opt,name=tag_id,json=tagId" json:"tag_id,omitempty"`
}

func (m *GetTagMessagesResponse) Reset()                    { *m = GetTagMessagesResponse{} }
func (m *GetTagMessagesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTagMessagesResponse) ProtoMessage()               {}
func (*GetTagMessagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{31} }

func (m *GetTagMessagesResponse) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *GetTagMessagesResponse) GetTagId() string {
	if m != nil {
		return m.TagId
	}
	return ""
}

func init() {
	proto.RegisterType((*FindDefaultBranchNameRequest)(nil), "gitaly.FindDefaultBranchNameRequest")
	proto.RegisterType((*FindDefaultBranchNameResponse)(nil), "gitaly.FindDefaultBranchNameResponse")
	proto.RegisterType((*FindAllBranchNamesRequest)(nil), "gitaly.FindAllBranchNamesRequest")
	proto.RegisterType((*FindAllBranchNamesResponse)(nil), "gitaly.FindAllBranchNamesResponse")
	proto.RegisterType((*FindAllTagNamesRequest)(nil), "gitaly.FindAllTagNamesRequest")
	proto.RegisterType((*FindAllTagNamesResponse)(nil), "gitaly.FindAllTagNamesResponse")
	proto.RegisterType((*FindRefNameRequest)(nil), "gitaly.FindRefNameRequest")
	proto.RegisterType((*FindRefNameResponse)(nil), "gitaly.FindRefNameResponse")
	proto.RegisterType((*FindLocalBranchesRequest)(nil), "gitaly.FindLocalBranchesRequest")
	proto.RegisterType((*FindLocalBranchesResponse)(nil), "gitaly.FindLocalBranchesResponse")
	proto.RegisterType((*FindLocalBranchResponse)(nil), "gitaly.FindLocalBranchResponse")
	proto.RegisterType((*FindLocalBranchCommitAuthor)(nil), "gitaly.FindLocalBranchCommitAuthor")
	proto.RegisterType((*FindAllBranchesRequest)(nil), "gitaly.FindAllBranchesRequest")
	proto.RegisterType((*FindAllBranchesResponse)(nil), "gitaly.FindAllBranchesResponse")
	proto.RegisterType((*FindAllBranchesResponse_Branch)(nil), "gitaly.FindAllBranchesResponse.Branch")
	proto.RegisterType((*FindAllTagsRequest)(nil), "gitaly.FindAllTagsRequest")
	proto.RegisterType((*FindAllTagsResponse)(nil), "gitaly.FindAllTagsResponse")
	proto.RegisterType((*RefExistsRequest)(nil), "gitaly.RefExistsRequest")
	proto.RegisterType((*RefExistsResponse)(nil), "gitaly.RefExistsResponse")
	proto.RegisterType((*CreateBranchRequest)(nil), "gitaly.CreateBranchRequest")
	proto.RegisterType((*CreateBranchResponse)(nil), "gitaly.CreateBranchResponse")
	proto.RegisterType((*DeleteBranchRequest)(nil), "gitaly.DeleteBranchRequest")
	proto.RegisterType((*DeleteBranchResponse)(nil), "gitaly.DeleteBranchResponse")
	proto.RegisterType((*FindBranchRequest)(nil), "gitaly.FindBranchRequest")
	proto.RegisterType((*FindBranchResponse)(nil), "gitaly.FindBranchResponse")
	proto.RegisterType((*DeleteRefsRequest)(nil), "gitaly.DeleteRefsRequest")
	proto.RegisterType((*DeleteRefsResponse)(nil), "gitaly.DeleteRefsResponse")
	proto.RegisterType((*ListBranchNamesContainingCommitRequest)(nil), "gitaly.ListBranchNamesContainingCommitRequest")
	proto.RegisterType((*ListBranchNamesContainingCommitResponse)(nil), "gitaly.ListBranchNamesContainingCommitResponse")
	proto.RegisterType((*ListTagNamesContainingCommitRequest)(nil), "gitaly.ListTagNamesContainingCommitRequest")
	proto.RegisterType((*ListTagNamesContainingCommitResponse)(nil), "gitaly.ListTagNamesContainingCommitResponse")
	proto.RegisterType((*GetTagMessagesRequest)(nil), "gitaly.GetTagMessagesRequest")
	proto.RegisterType((*GetTagMessagesResponse)(nil), "gitaly.GetTagMessagesResponse")
	proto.RegisterEnum("gitaly.FindLocalBranchesRequest_SortBy", FindLocalBranchesRequest_SortBy_name, FindLocalBranchesRequest_SortBy_value)
	proto.RegisterEnum("gitaly.CreateBranchResponse_Status", CreateBranchResponse_Status_name, CreateBranchResponse_Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for RefService service

type RefServiceClient interface {
	FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error)
	FindAllBranchNames(ctx context.Context, in *FindAllBranchNamesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchNamesClient, error)
	FindAllTagNames(ctx context.Context, in *FindAllTagNamesRequest, opts ...grpc.CallOption) (RefService_FindAllTagNamesClient, error)
	// Find a Ref matching the given constraints. Response may be empty.
	FindRefName(ctx context.Context, in *FindRefNameRequest, opts ...grpc.CallOption) (*FindRefNameResponse, error)
	// Return a stream so we can divide the response in chunks of branches
	FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (RefService_FindLocalBranchesClient, error)
	FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchesClient, error)
	FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (RefService_FindAllTagsClient, error)
	RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error)
	CreateBranch(ctx context.Context, in *CreateBranchRequest, opts ...grpc.CallOption) (*CreateBranchResponse, error)
	DeleteBranch(ctx context.Context, in *DeleteBranchRequest, opts ...grpc.CallOption) (*DeleteBranchResponse, error)
	FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error)
	DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error)
	ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListBranchNamesContainingCommitClient, error)
	ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListTagNamesContainingCommitClient, error)
	GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (RefService_GetTagMessagesClient, error)
}

type refServiceClient struct {
	cc *grpc.ClientConn
}

func NewRefServiceClient(cc *grpc.ClientConn) RefServiceClient {
	return &refServiceClient{cc}
}

func (c *refServiceClient) FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error) {
	out := new(FindDefaultBranchNameResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindDefaultBranchName", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindAllBranchNames(ctx context.Context, in *FindAllBranchNamesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchNamesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[0], c.cc, "/gitaly.RefService/FindAllBranchNames", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllBranchNamesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllBranchNamesClient interface {
	Recv() (*FindAllBranchNamesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllBranchNamesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllBranchNamesClient) Recv() (*FindAllBranchNamesResponse, error) {
	m := new(FindAllBranchNamesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllTagNames(ctx context.Context, in *FindAllTagNamesRequest, opts ...grpc.CallOption) (RefService_FindAllTagNamesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[1], c.cc, "/gitaly.RefService/FindAllTagNames", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllTagNamesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllTagNamesClient interface {
	Recv() (*FindAllTagNamesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllTagNamesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllTagNamesClient) Recv() (*FindAllTagNamesResponse, error) {
	m := new(FindAllTagNamesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindRefName(ctx context.Context, in *FindRefNameRequest, opts ...grpc.CallOption) (*FindRefNameResponse, error) {
	out := new(FindRefNameResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindRefName", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (RefService_FindLocalBranchesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[2], c.cc, "/gitaly.RefService/FindLocalBranches", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindLocalBranchesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindLocalBranchesClient interface {
	Recv() (*FindLocalBranchesResponse, error)
	grpc.ClientStream
}

type refServiceFindLocalBranchesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindLocalBranchesClient) Recv() (*FindLocalBranchesResponse, error) {
	m := new(FindLocalBranchesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (RefService_FindAllBranchesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[3], c.cc, "/gitaly.RefService/FindAllBranches", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllBranchesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllBranchesClient interface {
	Recv() (*FindAllBranchesResponse, error)
	grpc.ClientStream
}

type refServiceFindAllBranchesClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllBranchesClient) Recv() (*FindAllBranchesResponse, error) {
	m := new(FindAllBranchesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (RefService_FindAllTagsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[4], c.cc, "/gitaly.RefService/FindAllTags", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceFindAllTagsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_FindAllTagsClient interface {
	Recv() (*FindAllTagsResponse, error)
	grpc.ClientStream
}

type refServiceFindAllTagsClient struct {
	grpc.ClientStream
}

func (x *refServiceFindAllTagsClient) Recv() (*FindAllTagsResponse, error) {
	m := new(FindAllTagsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error) {
	out := new(RefExistsResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/RefExists", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) CreateBranch(ctx context.Context, in *CreateBranchRequest, opts ...grpc.CallOption) (*CreateBranchResponse, error) {
	out := new(CreateBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/CreateBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) DeleteBranch(ctx context.Context, in *DeleteBranchRequest, opts ...grpc.CallOption) (*DeleteBranchResponse, error) {
	out := new(DeleteBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/DeleteBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error) {
	out := new(FindBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/FindBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error) {
	out := new(DeleteRefsResponse)
	err := grpc.Invoke(ctx, "/gitaly.RefService/DeleteRefs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListBranchNamesContainingCommitClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[5], c.cc, "/gitaly.RefService/ListBranchNamesContainingCommit", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceListBranchNamesContainingCommitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_ListBranchNamesContainingCommitClient interface {
	Recv() (*ListBranchNamesContainingCommitResponse, error)
	grpc.ClientStream
}

type refServiceListBranchNamesContainingCommitClient struct {
	grpc.ClientStream
}

func (x *refServiceListBranchNamesContainingCommitClient) Recv() (*ListBranchNamesContainingCommitResponse, error) {
	m := new(ListBranchNamesContainingCommitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (RefService_ListTagNamesContainingCommitClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[6], c.cc, "/gitaly.RefService/ListTagNamesContainingCommit", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceListTagNamesContainingCommitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_ListTagNamesContainingCommitClient interface {
	Recv() (*ListTagNamesContainingCommitResponse, error)
	grpc.ClientStream
}

type refServiceListTagNamesContainingCommitClient struct {
	grpc.ClientStream
}

func (x *refServiceListTagNamesContainingCommitClient) Recv() (*ListTagNamesContainingCommitResponse, error) {
	m := new(ListTagNamesContainingCommitResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *refServiceClient) GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (RefService_GetTagMessagesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_RefService_serviceDesc.Streams[7], c.cc, "/gitaly.RefService/GetTagMessages", opts...)
	if err != nil {
		return nil, err
	}
	x := &refServiceGetTagMessagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RefService_GetTagMessagesClient interface {
	Recv() (*GetTagMessagesResponse, error)
	grpc.ClientStream
}

type refServiceGetTagMessagesClient struct {
	grpc.ClientStream
}

func (x *refServiceGetTagMessagesClient) Recv() (*GetTagMessagesResponse, error) {
	m := new(GetTagMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for RefService service

type RefServiceServer interface {
	FindDefaultBranchName(context.Context, *FindDefaultBranchNameRequest) (*FindDefaultBranchNameResponse, error)
	FindAllBranchNames(*FindAllBranchNamesRequest, RefService_FindAllBranchNamesServer) error
	FindAllTagNames(*FindAllTagNamesRequest, RefService_FindAllTagNamesServer) error
	// Find a Ref matching the given constraints. Response may be empty.
	FindRefName(context.Context, *FindRefNameRequest) (*FindRefNameResponse, error)
	// Return a stream so we can divide the response in chunks of branches
	FindLocalBranches(*FindLocalBranchesRequest, RefService_FindLocalBranchesServer) error
	FindAllBranches(*FindAllBranchesRequest, RefService_FindAllBranchesServer) error
	FindAllTags(*FindAllTagsRequest, RefService_FindAllTagsServer) error
	RefExists(context.Context, *RefExistsRequest) (*RefExistsResponse, error)
	CreateBranch(context.Context, *CreateBranchRequest) (*CreateBranchResponse, error)
	DeleteBranch(context.Context, *DeleteBranchRequest) (*DeleteBranchResponse, error)
	FindBranch(context.Context, *FindBranchRequest) (*FindBranchResponse, error)
	DeleteRefs(context.Context, *DeleteRefsRequest) (*DeleteRefsResponse, error)
	ListBranchNamesContainingCommit(*ListBranchNamesContainingCommitRequest, RefService_ListBranchNamesContainingCommitServer) error
	ListTagNamesContainingCommit(*ListTagNamesContainingCommitRequest, RefService_ListTagNamesContainingCommitServer) error
	GetTagMessages(*GetTagMessagesRequest, RefService_GetTagMessagesServer) error
}

func RegisterRefServiceServer(s *grpc.Server, srv RefServiceServer) {
	s.RegisterService(&_RefService_serviceDesc, srv)
}

func _RefService_FindDefaultBranchName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindDefaultBranchNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindDefaultBranchName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, req.(*FindDefaultBranchNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindAllBranchNames_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllBranchNamesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllBranchNames(m, &refServiceFindAllBranchNamesServer{stream})
}

type RefService_FindAllBranchNamesServer interface {
	Send(*FindAllBranchNamesResponse) error
	grpc.ServerStream
}

type refServiceFindAllBranchNamesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllBranchNamesServer) Send(m *FindAllBranchNamesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllTagNames_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllTagNamesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllTagNames(m, &refServiceFindAllTagNamesServer{stream})
}

type RefService_FindAllTagNamesServer interface {
	Send(*FindAllTagNamesResponse) error
	grpc.ServerStream
}

type refServiceFindAllTagNamesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllTagNamesServer) Send(m *FindAllTagNamesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindRefName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindRefNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindRefName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindRefName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindRefName(ctx, req.(*FindRefNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindLocalBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindLocalBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindLocalBranches(m, &refServiceFindLocalBranchesServer{stream})
}

type RefService_FindLocalBranchesServer interface {
	Send(*FindLocalBranchesResponse) error
	grpc.ServerStream
}

type refServiceFindLocalBranchesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindLocalBranchesServer) Send(m *FindLocalBranchesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllBranches(m, &refServiceFindAllBranchesServer{stream})
}

type RefService_FindAllBranchesServer interface {
	Send(*FindAllBranchesResponse) error
	grpc.ServerStream
}

type refServiceFindAllBranchesServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllBranchesServer) Send(m *FindAllBranchesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_FindAllTags_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllTagsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllTags(m, &refServiceFindAllTagsServer{stream})
}

type RefService_FindAllTagsServer interface {
	Send(*FindAllTagsResponse) error
	grpc.ServerStream
}

type refServiceFindAllTagsServer struct {
	grpc.ServerStream
}

func (x *refServiceFindAllTagsServer) Send(m *FindAllTagsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_RefExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).RefExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/RefExists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).RefExists(ctx, req.(*RefExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_CreateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).CreateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/CreateBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).CreateBranch(ctx, req.(*CreateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_DeleteBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).DeleteBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/DeleteBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).DeleteBranch(ctx, req.(*DeleteBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/FindBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindBranch(ctx, req.(*FindBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_DeleteRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).DeleteRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.RefService/DeleteRefs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).DeleteRefs(ctx, req.(*DeleteRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_ListBranchNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBranchNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListBranchNamesContainingCommit(m, &refServiceListBranchNamesContainingCommitServer{stream})
}

type RefService_ListBranchNamesContainingCommitServer interface {
	Send(*ListBranchNamesContainingCommitResponse) error
	grpc.ServerStream
}

type refServiceListBranchNamesContainingCommitServer struct {
	grpc.ServerStream
}

func (x *refServiceListBranchNamesContainingCommitServer) Send(m *ListBranchNamesContainingCommitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_ListTagNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListTagNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListTagNamesContainingCommit(m, &refServiceListTagNamesContainingCommitServer{stream})
}

type RefService_ListTagNamesContainingCommitServer interface {
	Send(*ListTagNamesContainingCommitResponse) error
	grpc.ServerStream
}

type refServiceListTagNamesContainingCommitServer struct {
	grpc.ServerStream
}

func (x *refServiceListTagNamesContainingCommitServer) Send(m *ListTagNamesContainingCommitResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RefService_GetTagMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTagMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).GetTagMessages(m, &refServiceGetTagMessagesServer{stream})
}

type RefService_GetTagMessagesServer interface {
	Send(*GetTagMessagesResponse) error
	grpc.ServerStream
}

type refServiceGetTagMessagesServer struct {
	grpc.ServerStream
}

func (x *refServiceGetTagMessagesServer) Send(m *GetTagMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _RefService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RefService",
	HandlerType: (*RefServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindDefaultBranchName",
			Handler:    _RefService_FindDefaultBranchName_Handler,
		},
		{
			MethodName: "FindRefName",
			Handler:    _RefService_FindRefName_Handler,
		},
		{
			MethodName: "RefExists",
			Handler:    _RefService_RefExists_Handler,
		},
		{
			MethodName: "CreateBranch",
			Handler:    _RefService_CreateBranch_Handler,
		},
		{
			MethodName: "DeleteBranch",
			Handler:    _RefService_DeleteBranch_Handler,
		},
		{
			MethodName: "FindBranch",
			Handler:    _RefService_FindBranch_Handler,
		},
		{
			MethodName: "DeleteRefs",
			Handler:    _RefService_DeleteRefs_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "FindAllBranchNames",
			Handler:       _RefService_FindAllBranchNames_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllTagNames",
			Handler:       _RefService_FindAllTagNames_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindLocalBranches",
			Handler:       _RefService_FindLocalBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllBranches",
			Handler:       _RefService_FindAllBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllTags",
			Handler:       _RefService_FindAllTags_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBranchNamesContainingCommit",
			Handler:       _RefService_ListBranchNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListTagNamesContainingCommit",
			Handler:       _RefService_ListTagNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTagMessages",
			Handler:       _RefService_GetTagMessages_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ref.proto",
}

func init() { proto.RegisterFile("ref.proto", fileDescriptor8) }

var fileDescriptor8 = []byte{
	// 1350 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x4f, 0x6f, 0x1a, 0x47,
	0x14, 0xf7, 0x62, 0x9b, 0xc0, 0x83, 0xe0, 0xf5, 0xc4, 0x71, 0xc8, 0x3a, 0x09, 0xce, 0xe4, 0xbf,
	0x1a, 0xe1, 0x96, 0xa8, 0xbd, 0xb4, 0x87, 0x62, 0xa0, 0x09, 0x89, 0x83, 0xad, 0x81, 0xa6, 0xa9,
	0xda, 0x6a, 0xb5, 0xc0, 0xb0, 0xde, 0x0a, 0x58, 0xba, 0x3b, 0x24, 0xf1, 0x21, 0x3d, 0x56, 0xaa,
	0x5a, 0xa9, 0xb7, 0x7e, 0x84, 0x7e, 0x90, 0x5e, 0x7a, 0xe8, 0x97, 0xaa, 0x76, 0x66, 0xf6, 0x1f,
	0x5e, 0xb0, 0x55, 0x6a, 0xf5, 0x04, 0xf3, 0xe6, 0xbd, 0xdf, 0xfb, 0x3b, 0xef, 0xbd, 0x85, 0xac,
	0x43, 0x07, 0xe5, 0x89, 0x63, 0x33, 0x1b, 0xa5, 0x4d, 0x8b, 0x19, 0xc3, 0x13, 0x2d, 0xef, 0x1e,
	0x1b, 0x0e, 0xed, 0x0b, 0xaa, 0x56, 0x32, 0x6d, 0xdb, 0x1c, 0xd2, 0x3d, 0x7e, 0xea, 0x4e, 0x07,
	0x7b, 0xcc, 0x1a, 0x51, 0x97, 0x19, 0xa3, 0x89, 0x60, 0xc0, 0x04, 0x6e, 0x7c, 0x61, 0x8d, 0xfb,
	0x75, 0x3a, 0x30, 0xa6, 0x43, 0xb6, 0xef, 0x18, 0xe3, 0xde, 0x71, 0xcb, 0x18, 0x51, 0x42, 0x7f,
	0x98, 0x52, 0x97, 0xa1, 0x0a, 0x80, 0x43, 0x27, 0xb6, 0x6b, 0x31, 0xdb, 0x39, 0x29, 0x2a, 0xbb,
	0xca, 0xc3, 0x5c, 0x05, 0x95, 0x85, 0xae, 0x32, 0x09, 0x6e, 0x48, 0x84, 0x0b, 0x3f, 0x81, 0x9b,
	0x73, 0x30, 0xdd, 0x89, 0x3d, 0x76, 0x29, 0x42, 0xb0, 0x36, 0x36, 0x46, 0x94, 0xc3, 0xe5, 0x09,
	0xff, 0x8f, 0x0f, 0xe1, 0xba, 0x27, 0x54, 0x1d, 0x0e, 0x43, 0x01, 0x77, 0x19, 0x2b, 0x2a, 0xa0,
	0x25, 0x01, 0x4a, 0x13, 0xb6, 0x60, 0xdd, 0x53, 0xeb, 0x16, 0x95, 0xdd, 0xd5, 0x87, 0x79, 0x22,
	0x0e, 0xf8, 0x00, 0xb6, 0xa5, 0x4c, 0xc7, 0x30, 0x97, 0xb6, 0x60, 0x0f, 0xae, 0x9d, 0x42, 0x5b,
	0xa8, 0xfe, 0x3d, 0x20, 0x4f, 0x80, 0xd0, 0xc1, 0x92, 0x29, 0x40, 0x3b, 0x90, 0xed, 0xd9, 0xa3,
	0x91, 0xc5, 0x74, 0xab, 0x5f, 0x4c, 0xed, 0x2a, 0x0f, 0xb3, 0x24, 0x23, 0x08, 0xcd, 0x3e, 0xda,
	0x86, 0xf4, 0xc4, 0xa1, 0x03, 0xeb, 0x5d, 0x71, 0x95, 0x27, 0x40, 0x9e, 0xf0, 0x23, 0xb8, 0x12,
	0x53, 0xbf, 0x20, 0x5b, 0x7f, 0x29, 0x50, 0xf4, 0x78, 0x0f, 0xec, 0x9e, 0x21, 0xe3, 0xbb, 0x54,
	0xac, 0xd0, 0xe7, 0x70, 0xc9, 0xb5, 0x1d, 0xa6, 0x77, 0x4f, 0xb8, 0xb9, 0x85, 0xca, 0x03, 0x5f,
	0x60, 0x9e, 0x9a, 0x72, 0xdb, 0x76, 0xd8, 0xfe, 0x09, 0x49, 0xbb, 0xfc, 0x17, 0x7f, 0x0c, 0x69,
	0x41, 0x41, 0x19, 0x58, 0x6b, 0x55, 0x5f, 0x36, 0xd4, 0x15, 0xb4, 0x01, 0xb9, 0x2f, 0x8f, 0xea,
	0xd5, 0x4e, 0xa3, 0xae, 0x57, 0xdb, 0x35, 0x55, 0x41, 0x2a, 0xe4, 0x7d, 0x42, 0xbd, 0xd1, 0xae,
	0xa9, 0x29, 0xfc, 0x5a, 0xd4, 0xdd, 0x8c, 0x06, 0xe9, 0xfa, 0xa7, 0x90, 0xe9, 0x4a, 0x1a, 0xcf,
	0x54, 0xae, 0x52, 0x9a, 0x63, 0x96, 0x2f, 0x42, 0x02, 0x01, 0xfc, 0x4b, 0x4a, 0xe4, 0x3f, 0x81,
	0x2b, 0x29, 0xa6, 0x8b, 0x73, 0x76, 0x0f, 0x0a, 0xf2, 0xd2, 0x9d, 0x76, 0xbf, 0xa7, 0x3d, 0x26,
	0x73, 0x77, 0x59, 0x50, 0xdb, 0x82, 0x88, 0x9e, 0x81, 0x24, 0xe8, 0xc6, 0x94, 0x1d, 0xdb, 0x4e,
	0x71, 0x8d, 0x47, 0xff, 0xce, 0x1c, 0xab, 0x6b, 0x9c, 0xb7, 0xca, 0x59, 0x49, 0xbe, 0x17, 0x39,
	0xa1, 0x16, 0xa8, 0x12, 0x49, 0xfc, 0x30, 0xea, 0x14, 0xd7, 0xcf, 0x0f, 0xb6, 0x21, 0xa4, 0x6a,
	0xbe, 0x2c, 0x7e, 0x0b, 0x3b, 0x0b, 0xf8, 0x13, 0x03, 0xb2, 0x05, 0xeb, 0x74, 0x64, 0x58, 0x43,
	0x1e, 0x8c, 0x3c, 0x11, 0x07, 0x54, 0x86, 0xb5, 0xbe, 0xc1, 0x28, 0xf7, 0x3f, 0x57, 0xd1, 0xca,
	0xa2, 0xc3, 0x95, 0xfd, 0x0e, 0x57, 0xee, 0xf8, 0x1d, 0x8e, 0x70, 0x3e, 0xfc, 0xbb, 0x12, 0x3c,
	0xea, 0xff, 0xa2, 0x50, 0x4b, 0x90, 0x1b, 0x51, 0xc7, 0xa4, 0x7d, 0xdd, 0x1e, 0x0f, 0x45, 0xb1,
	0x66, 0x08, 0x08, 0xd2, 0xe1, 0x78, 0x78, 0x82, 0x1e, 0xc0, 0x86, 0x64, 0x08, 0x4a, 0x67, 0x95,
	0x3f, 0xf2, 0x82, 0x20, 0xfb, 0x46, 0xe0, 0x3f, 0x94, 0xa0, 0x3f, 0x9c, 0x2a, 0xbc, 0xfd, 0x53,
	0x85, 0x77, 0x3f, 0x1a, 0xf5, 0x04, 0x91, 0xb2, 0xac, 0xb0, 0x40, 0x4e, 0x7b, 0x0a, 0x69, 0x41,
	0x4b, 0x0c, 0xee, 0x23, 0x48, 0x33, 0xc3, 0x31, 0x29, 0xe3, 0x2e, 0xe4, 0x2a, 0x9b, 0x3e, 0xfe,
	0x53, 0x3f, 0x6b, 0x44, 0x32, 0xe0, 0x67, 0xa2, 0x2d, 0x89, 0x3e, 0xb6, 0x54, 0x47, 0xfc, 0x44,
	0x74, 0x98, 0x00, 0x49, 0x7a, 0x5b, 0x82, 0x35, 0x66, 0x98, 0xbe, 0xa7, 0x39, 0x1f, 0xa4, 0x63,
	0x98, 0x84, 0x5f, 0xe0, 0xd7, 0xa0, 0x12, 0x3a, 0x68, 0xbc, 0xb3, 0x5c, 0xb6, 0x54, 0xf2, 0x54,
	0x58, 0x75, 0xe8, 0x40, 0xd6, 0x93, 0xf7, 0x17, 0x3f, 0x82, 0xcd, 0x08, 0x72, 0xd8, 0x9d, 0xdf,
	0x18, 0xc3, 0xa9, 0x08, 0x58, 0x86, 0x88, 0x03, 0xfe, 0x11, 0xae, 0xd4, 0x1c, 0x6a, 0x30, 0xea,
	0xbf, 0xe5, 0x7f, 0x6f, 0x87, 0x9f, 0x90, 0x54, 0x24, 0x21, 0x25, 0xc8, 0xb9, 0xcc, 0x70, 0x98,
	0x3e, 0xb1, 0xad, 0xb1, 0xff, 0xbc, 0x81, 0x93, 0x8e, 0x3c, 0x0a, 0xfe, 0x5b, 0x81, 0xad, 0xb8,
	0x01, 0x41, 0x97, 0x4a, 0xbb, 0xcc, 0x60, 0x53, 0x97, 0x6b, 0x2f, 0x84, 0x0f, 0x34, 0x89, 0xbb,
	0xdc, 0xe6, 0xac, 0x44, 0x8a, 0xa0, 0xfb, 0x90, 0x16, 0x15, 0x23, 0xeb, 0xa0, 0xe0, 0x0b, 0x4b,
	0x31, 0x79, 0x8b, 0x5b, 0x90, 0x16, 0x92, 0x28, 0x0d, 0xa9, 0xc3, 0x17, 0xea, 0x0a, 0x2a, 0x00,
	0x34, 0x08, 0xd1, 0x1b, 0xaf, 0x9b, 0xed, 0x4e, 0x5b, 0x55, 0xbc, 0x66, 0xeb, 0x9d, 0x9b, 0xad,
	0x57, 0xd5, 0x83, 0x66, 0x5d, 0x4d, 0xa1, 0x1d, 0xb8, 0x16, 0x21, 0xe8, 0xed, 0x4e, 0x95, 0x74,
	0xf4, 0xa3, 0xc3, 0x66, 0xab, 0xa3, 0xae, 0xe2, 0xef, 0xe0, 0x4a, 0x9d, 0x0e, 0xe9, 0x05, 0x45,
	0x13, 0x6f, 0xc3, 0x56, 0x1c, 0x5e, 0x78, 0x8f, 0xbf, 0x81, 0x4d, 0xaf, 0x02, 0x2f, 0x46, 0xe9,
	0x67, 0xe2, 0xa1, 0xcc, 0xa4, 0x27, 0x8c, 0xb0, 0xb2, 0x30, 0xc2, 0x3f, 0x2b, 0xb0, 0x29, 0x6c,
	0x26, 0x74, 0xb0, 0x54, 0x99, 0x3f, 0x06, 0x44, 0xdf, 0xf5, 0xe8, 0x84, 0xe9, 0x6f, 0x2d, 0x76,
	0xac, 0xcb, 0x61, 0x9f, 0xe2, 0x5d, 0x48, 0x15, 0x37, 0x5f, 0x59, 0xec, 0xf8, 0x88, 0xd3, 0x3d,
	0x4f, 0x1c, 0x3a, 0xf0, 0xbb, 0x14, 0xff, 0x8f, 0x3f, 0x02, 0x14, 0x35, 0x45, 0x7a, 0xb2, 0x03,
	0x59, 0xd3, 0x62, 0x3a, 0x75, 0x1c, 0xdb, 0xe1, 0xa6, 0x64, 0x49, 0xc6, 0xb4, 0x58, 0xc3, 0x3b,
	0xe3, 0xdf, 0x14, 0xb8, 0x7f, 0x60, 0xb9, 0x91, 0x7d, 0xcf, 0xad, 0xd9, 0x63, 0x66, 0x58, 0x63,
	0x6b, 0x6c, 0xca, 0x8e, 0x72, 0x51, 0x1b, 0xcd, 0x16, 0xac, 0x0f, 0xad, 0x91, 0x25, 0x5e, 0xcd,
	0x65, 0x22, 0x0e, 0x98, 0xc0, 0x83, 0x33, 0x0d, 0x92, 0x9e, 0xdd, 0x86, 0xbc, 0xc8, 0x82, 0x2e,
	0xd6, 0x32, 0x11, 0xab, 0x5c, 0x37, 0x14, 0x7d, 0xbe, 0x96, 0x51, 0xd4, 0x14, 0xfe, 0x55, 0x81,
	0x3b, 0x1e, 0xa8, 0xbf, 0xd1, 0xfd, 0xcf, 0x2e, 0x36, 0xe1, 0xee, 0x62, 0x6b, 0xc2, 0xcc, 0x31,
	0xc3, 0x8c, 0x39, 0x97, 0x61, 0x52, 0x48, 0x7a, 0x36, 0x85, 0xab, 0x4f, 0xa9, 0x87, 0xf4, 0x92,
	0xba, 0xae, 0x61, 0x2e, 0x37, 0x25, 0xaf, 0xc1, 0x25, 0x4f, 0x9f, 0xd5, 0x17, 0x65, 0x95, 0xf5,
	0x66, 0x89, 0xd9, 0xec, 0x7b, 0xba, 0x52, 0xea, 0x2a, 0x09, 0x8d, 0xc1, 0x5f, 0xc3, 0xf6, 0xac,
	0x5a, 0x69, 0x73, 0x11, 0x2e, 0x8d, 0x04, 0x4d, 0x3e, 0x32, 0xff, 0x88, 0xae, 0x7a, 0xb3, 0xcb,
	0x43, 0xe7, 0xc1, 0xc8, 0x92, 0x75, 0x0e, 0x2e, 0xfc, 0xe0, 0x7e, 0x71, 0xec, 0xca, 0x9f, 0x00,
	0x40, 0xe8, 0xa0, 0x4d, 0x9d, 0x37, 0x56, 0x8f, 0xa2, 0x01, 0x5c, 0x4d, 0xfc, 0x2c, 0x41, 0x77,
	0xa3, 0xa3, 0x75, 0xde, 0x97, 0x90, 0x76, 0xef, 0x0c, 0x2e, 0xd9, 0x60, 0x56, 0x90, 0x1e, 0x8c,
	0xcb, 0x48, 0xe5, 0xa1, 0xdb, 0x89, 0xf3, 0x3b, 0xfa, 0x8d, 0xa1, 0xe1, 0x45, 0x2c, 0x3e, 0xfc,
	0x87, 0x0a, 0x7a, 0x05, 0x1b, 0x33, 0xdf, 0x15, 0xe8, 0xd6, 0x8c, 0xe8, 0xcc, 0xe7, 0x8b, 0x56,
	0x9a, 0x7b, 0x1f, 0xc1, 0x7d, 0x06, 0xb9, 0xc8, 0xfe, 0x8f, 0xb4, 0xa8, 0x4c, 0xfc, 0x9b, 0x44,
	0xdb, 0x49, 0xbc, 0x0b, 0x42, 0xf0, 0xad, 0xe8, 0xb2, 0xb1, 0xa5, 0x1a, 0xed, 0x9e, 0xb5, 0xd1,
	0x6b, 0xb7, 0x17, 0x70, 0x24, 0xfa, 0x1f, 0x60, 0xdf, 0x9a, 0xbb, 0x1d, 0x25, 0xfb, 0x9f, 0x88,
	0xfb, 0x5c, 0xf8, 0x2f, 0xb7, 0x93, 0xb8, 0xff, 0xf1, 0xe5, 0x27, 0xee, 0xff, 0xcc, 0x3a, 0xc3,
	0xb1, 0xf6, 0x21, 0x1b, 0xec, 0x15, 0xa8, 0x18, 0xbe, 0x96, 0xf8, 0x12, 0xa3, 0x5d, 0x4f, 0xb8,
	0x09, 0xa2, 0xf8, 0x02, 0xf2, 0xd1, 0x09, 0x8e, 0x76, 0x92, 0xe7, 0xba, 0x40, 0xba, 0xb1, 0x68,
	0xe8, 0x0b, 0xb0, 0xe8, 0x40, 0x0c, 0xc1, 0x12, 0xa6, 0x70, 0x08, 0x96, 0x38, 0x43, 0x57, 0x50,
	0x03, 0x20, 0x1c, 0x74, 0xe8, 0x7a, 0x34, 0x18, 0x71, 0x20, 0x2d, 0xe9, 0x2a, 0x0a, 0x13, 0x4e,
	0x99, 0x10, 0xe6, 0xd4, 0x10, 0x0c, 0x61, 0x4e, 0x0f, 0x25, 0xbc, 0x82, 0x7e, 0x52, 0xa0, 0x74,
	0x46, 0xa3, 0x47, 0x65, 0x1f, 0xe1, 0x7c, 0x23, 0x4a, 0xdb, 0x3b, 0x37, 0x7f, 0x24, 0xe9, 0xef,
	0xe1, 0xc6, 0xa2, 0x6e, 0x8c, 0x3e, 0x88, 0x82, 0x9e, 0x31, 0x41, 0xb4, 0xc7, 0xe7, 0x63, 0x8e,
	0xa8, 0x6f, 0x43, 0x21, 0xde, 0x4a, 0xd1, 0xcd, 0x60, 0xa9, 0x4f, 0xea, 0xec, 0xda, 0xad, 0x79,
	0xd7, 0x21, 0x68, 0x37, 0xcd, 0x3f, 0xac, 0x9e, 0xfc, 0x13, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x28,
	0x88, 0xdb, 0x6b, 0x12, 0x00, 0x00,
}
