{- git-annex command
 -
 - Copyright 2010 Joey Hess <joey@kitenet.net>
 -
 - Licensed under the GNU GPL version 3 or higher.
 -}

module Command.Untrust where

import Command
import qualified Remote
import UUID
import Trust
import Messages

command :: [Command]
command = [repoCommand "untrust" (paramRepeating paramRemote) seek
	"do not trust a repository"]

seek :: [CommandSeek]
seek = [withString start]

start :: CommandStartString
start name = notBareRepo $ do
	showStart "untrust" name
	u <- Remote.nameToUUID name
	return $ Just $ perform u

perform :: UUID -> CommandPerform
perform uuid = do
	trustSet uuid UnTrusted
	return $ Just $ return True
