{- git-annex command
 -
 - Copyright 2010 Joey Hess <joey@kitenet.net>
 -
 - Licensed under the GNU GPL version 3 or higher.
 -}

module Command.Trust where

import Command
import qualified Remote
import Trust
import UUID
import Messages

command :: [Command]
command = [repoCommand "trust" (paramRepeating paramRemote) seek
	"trust a repository"]

seek :: [CommandSeek]
seek = [withString start]

start :: CommandStartString
start name = notBareRepo $ do
	showStart "trust" name
	u <- Remote.nameToUUID name
	return $ Just $ perform u

perform :: UUID -> CommandPerform
perform uuid = do
	trustSet uuid Trusted
	return $ Just $ return True
