/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"



static void builtin_module_init (void);

static gpointer create_window_rc_stuff (gpointer data,
					gpointer func_data,
					gpointer invoke_data);



void
g_inspector_builtin_register_module_window_rc_stuff (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-rc-stuff";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-window-rc-stuff",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_window_rc_stuff,
				  NULL);
}



static void close_button_clicked (GtkButton *button,
				  gpointer   user_data);

static GtkWidget* create_default_files (void);
static GtkWidget* create_parse_file    (void);
static GtkWidget* create_parse_string  (void);



static gpointer
create_window_rc_stuff (gpointer data,
			gpointer func_data,
			gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *dialog;


  dialog = gtk_dialog_new ();
  top = dialog;
  g_inspector_tag_to_widget (top);

  gtk_window_set_title (GTK_WINDOW (dialog), "GtkRc Stuff");
  gtk_window_set_default_size (GTK_WINDOW (dialog), 400, 300);


  {
    GtkWidget *close_button;

    close_button = gtk_button_new_with_label ("Close");

    gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
				 close_button);

    g_signal_connect (close_button,
		      "clicked",
		      G_CALLBACK (close_button_clicked),
		      (gpointer)dialog);
    
  }


  {
    GtkWidget *w;

    w = create_default_files ();

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			w,
			FALSE, FALSE, 0);
  }

  {
    GtkWidget *w;

    w = create_parse_file ();

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			w,
			FALSE, FALSE, 0);
  }

  {
    GtkWidget *w;

    w = create_parse_string ();

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), w,
			TRUE, TRUE, 0);
  }


  gtk_widget_show_all (top);


  return top;
}

static void
close_button_clicked (GtkButton *button,
                      gpointer   user_data)
{
  gtk_widget_destroy (GTK_WIDGET (user_data));
}



/***/
static void reparse_all_button_clicked (GtkButton *button,
					gpointer   user_data);

static GtkWidget*
create_default_files (void)
{
  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox0;

  frame = gtk_frame_new ("Default Files");
  top = frame;

  vbox0 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox0);

  {
    GtkWidget *vbox1;

    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start_defaults (GTK_BOX (vbox0), vbox1);
    
    {
      GtkWidget *vbox2;
      GtkWidget *label;
      gchar **default_files;
      gchar **f;

      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_box_pack_start_defaults (GTK_BOX (vbox1), vbox2);

      default_files = gtk_rc_get_default_files ();


      f = default_files;
      while (*f != NULL)
	{
	  label = gtk_label_new (*f);
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);

	  gtk_box_pack_start_defaults (GTK_BOX (vbox2), label);

	  ++f;
	}
    }

    gtk_box_pack_start_defaults (GTK_BOX (vbox1), gtk_hseparator_new ());

    {
      GtkWidget *hbox;
      GtkWidget *reparse_all_button;

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start_defaults (GTK_BOX (vbox1), hbox);

      reparse_all_button = gtk_button_new_with_label ("Reparse All");
      gtk_box_pack_start (GTK_BOX (hbox), reparse_all_button, FALSE, FALSE, 0);

      g_signal_connect (reparse_all_button,
			"clicked",
			G_CALLBACK (reparse_all_button_clicked),
			NULL);
    
    }
  }

  return top;
}

static void
reparse_all_button_clicked (GtkButton *button,
			    gpointer   user_data)
{
  gtk_rc_reparse_all ();
}


/*****/
static void parse_file_button_clicked (GtkButton *button,
				       gpointer   user_data);

static GtkWidget*
create_parse_file (void)
{
  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox;

  frame = gtk_frame_new ("Parse File");
  top = frame;

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);


  {
    GtkWidget *entry;

    GtkWidget *hbox;
    GtkWidget *parse_file_button;


    /***/
    entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (vbox),
			entry,
			FALSE, TRUE, 0);


    /***/
    gtk_box_pack_start (GTK_BOX (vbox),
			gtk_hseparator_new (),
			FALSE, FALSE, 0);


    /***/
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start_defaults (GTK_BOX (vbox), hbox);

    parse_file_button = gtk_button_new_with_label ("Parse File");
    gtk_box_pack_start (GTK_BOX (hbox), parse_file_button, FALSE, FALSE, 0);

    g_signal_connect (parse_file_button,
		      "clicked",
		      G_CALLBACK (parse_file_button_clicked),
		      entry);
    
  }

  return top;
}

static void
parse_file_button_clicked (GtkButton *button,
			   gpointer   user_data)
{
  GtkEntry *entry;
  const gchar *filename;

  entry = GTK_ENTRY (user_data);

  filename = gtk_entry_get_text (entry);

  if ((filename != NULL) &&
      (filename[0] != '\0'))
    {
      gtk_rc_parse (filename);
    }
}

/*****/
static void parse_string_button_clicked (GtkButton *button,
					 gpointer   user_data);

static GtkWidget*
create_parse_string (void)
{
  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox;

  frame = gtk_frame_new ("Parse String");
  top = frame;

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);


  {
    GtkWidget *text_view;

    GtkWidget *hbox;
    GtkWidget *parse_string_button;


    /***/
    text_view = gtk_text_view_new ();
    gtk_box_pack_start (GTK_BOX (vbox),
			text_view,
			TRUE, TRUE, 0);


    /***/
    gtk_box_pack_start (GTK_BOX (vbox),
			gtk_hseparator_new (),
			FALSE, FALSE, 0);


    /***/

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox),
			hbox,
			FALSE, FALSE, 0);

    parse_string_button = gtk_button_new_with_label ("Parse String");
    gtk_box_pack_start (GTK_BOX (hbox), parse_string_button, FALSE, FALSE, 0);

    g_signal_connect (parse_string_button,
		      "clicked",
		      G_CALLBACK (parse_string_button_clicked),
		      text_view);
  }

  return top;
}

static void
parse_string_button_clicked (GtkButton *button,
			     gpointer   user_data)
{
  GtkTextView *text_view;
  GtkTextBuffer *text_buffer;
  GtkTextIter start;
  GtkTextIter end;
  gchar *string;


  text_view = GTK_TEXT_VIEW (user_data);


  text_buffer = gtk_text_view_get_buffer (text_view);

  gtk_text_buffer_get_bounds (text_buffer, &start, &end);

  string = gtk_text_buffer_get_text (text_buffer, &start, &end, FALSE);


  gtk_rc_parse_string (string);


  g_free (string);
}
