/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "gtktreecontainer.h"

#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_window  (gpointer data,
				gpointer func_data,
				gpointer invoke_data);



void
g_inspector_builtin_register_module_window_enum_detail (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-enum-detail";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("view-genum-detail",
				  "View GEnum Detail",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_ENUM,
				  create_window,
				  NULL);
  g_inspector_register_procedure ("view-gflags-detail",
				  "View GFlags Detail",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_FLAGS,
				  create_window,
				  NULL);
}



static void close_button_clicked (GtkButton *button,
				  gpointer   user_data);


static gpointer
create_window (gpointer data,
	       gpointer func_data,
	       gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *dialog;
  GtkWidget *close_button;
  gchar     *window_title;


  type = GPOINTER_TO_TYPE (data);

  dialog = gtk_dialog_new ();
  g_inspector_tag_to_widget (dialog);
  top = dialog;

  if (G_TYPE_IS_ENUM (type))
    {
      window_title = g_strdup_printf ("GEnum Detail: %s",
				      g_type_name (type));
    }
  else /* G_TYPE_IS_FLAGS (type) */
    {
      window_title = g_strdup_printf ("GFlags Detail: %s",
				      g_type_name (type));
    }

  gtk_window_set_title (GTK_WINDOW (dialog), window_title);
  gtk_window_set_default_size (GTK_WINDOW (dialog), 400, 300);
  g_free (window_title);

  close_button = gtk_button_new_with_label ("Close");
  g_signal_connect (close_button,
		    "clicked",
		    G_CALLBACK (close_button_clicked),
		    dialog);
  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
			       close_button);


  {
    GtkWidget *w;

    if (G_TYPE_IS_ENUM (type))
      {
	w = g_inspector_invoke_procedure_by_name ("create-panel-enum-value-list",
						  GTYPE_TO_POINTER (type),
						  NULL);
      }
    else /* G_TYPE_IS_FLAGS (type) */
      {
	w = g_inspector_invoke_procedure_by_name ("create-panel-flags-value-list",
						  GTYPE_TO_POINTER (type),
						  NULL);
      }

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			w, TRUE, TRUE, 0);
  }


  gtk_widget_show_all (top);


  return top;
}

static void
close_button_clicked (GtkButton *button,
		      gpointer   user_data)
{
  gtk_widget_destroy (GTK_WIDGET (user_data));
}
