/*
*  $Id: auditcontrollerdelegate.h $
*  Proyecto Ginkgo
*
*  Copyright 2008 MetaEmotion S.L. All rights reserved.
*
*/
#pragma once
#include <string>
#include <api/autoptr.h>

namespace GNC {	
	namespace GCS {
		class SmartRetrieveService;

		class SmartRetrieveController
		{
		public:
			static SmartRetrieveController *Instance();
			static void FreeInstance();
			
			//stop and reload settings...
			void resetStatus();

			bool isEnabled();
			void enable(bool enable);
			int getPeriod();
			void setPeriod(int period);
			int getMaxDownloadPerIteration();
			void setMaxDownloadPerIteration(int maxDownloads);

		protected:
			SmartRetrieveController();
			~SmartRetrieveController();

			void stopThread();
			void startThread();
			
			int tidService;
			SmartRetrieveService* pThread;
			//singleton
			static SmartRetrieveController* m_pInstance;
		};
	}
}


