/*
 *  
 *  $Id: gvistasimple.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include "visualizatorviews.h"
#include <api/controllers/ieventscontroller.h>
#include <api/iwidgets.h>
#include <api/ianotador.h>
#include <api/icontexto.h>
#include <api/observers/ieventsobserver.h>
#include "../estudios/overlay.h"

#include <vtkCommand.h>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

namespace GNKVisualizator {
	class Vista2D;
}

class GVtkObserver;
class IconoImagenCtrl;
class vtkAlgorithmOutput;
class vtkImageData;

class GVistaSimple: public VistaSimpleBase, public GNC::GCS::IAnotador, public GNC::GCS::IImpresorOverlay, public GNC::GCS::IEventsObserver {
public:
   /* Constructor */
	GVistaSimple( GNKVisualizator::Vista2D* pIVista, wxWindow* pParent);
   /* Destructor */
	~GVistaSimple();

	virtual void OnSize( wxSizeEvent& event );
	virtual void OnPaint( wxPaintEvent& event );

	virtual void setEstudioReferido(const GNC::GCS::Ptr<GNC::GCS::IStudyContext>& parent);

	virtual void UnRefIVista();

	void RefrescarOverlays(const GNKVisualizator::TEstadoOverlay& estadoOverlays);
	void SetOverlays(GNC::GCS::Ptr<GNKVisualizator::TListaOverlays>& pListaOverlays,const GNKVisualizator::TEstadoOverlay& estadoOverlays);

	GNC::GCS::Ptr<GNC::GCS::IReferredStudyContext>& GetEstudio();

	vtkImageData* GetImage(){
		return ViewImage2D->GetInput();
	};

   //region "Eventos"
	void OnMenuVerClick(wxCommandEvent& event);
	void OnMenuCineClick(wxCommandEvent& event);

	void OnFocus(wxChildFocusEvent &event);

	void ResetTimeInstant();

	void SetPeriodo(int milisegundos);

	void OnKeyDown( wxKeyEvent& event );

	void OnMouseWheel( wxMouseEvent& event );

	void OnPlayClick(wxCommandEvent &event);

	void OnStopClick(wxCommandEvent &event);

	void OnBucleClick(wxCommandEvent &event);

	void OnTimer();

	void OnSincronizarClick(wxCommandEvent &event);

	void OnDessincronizarClick(wxCommandEvent &event);

	void OnTimeInstantChanged(wxScrollEvent& event);

	void GoToTSlice(int posicion, bool relativa =  true);

	void GoToSlice(int posicion, bool relativa =  true, bool propagar = true);

	void ActualizarTSlider();

	typedef std::list<GNKVisualizator::Vista2D*> TipoListaVista2D;
	void Sincronizar(TipoListaVista2D lista);
	void DesSincronizar();
	bool IsSincronized();

   //endregion


	//region "Realizacion de la interfaz IAnnotator"
	virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetPatientPosition(GNC::GCS::Contexto3D* c);
	virtual std::string GetAnotacionPosicion(const GNC::GCS::Vector3D& wP, GNC::GCS::Contexto3D* c);
	//endregion

	//region "Interfaz de impresion de overlays de widgets"
	virtual void ImprimirOverlay(GNC::GCS::Widgets::IWidget* w, GNC::GCS::Contexto3D* c, GNC::GCS::Vector& boundingBox);
	virtual void ImprimirOverlay(GNC::GCS::Widgets::IWidgetBuilder* wb, GNC::GCS::Contexto3D* c, GNC::GCS::Vector& boundingBox);
	//endregion

	//region "Helpers"
	float ObtenerValoracion(const GNC::GCS::Vector& v);
	void ObtenerEstadisticos(GNC::GCS::Widgets::IWidget* w, GNC::GCS::Widgets::IWidget::Muestreador ptr, GNC::GCS::Vector boundingBox[2], double* area, float* media, float* varianza);
	//endregion

	virtual void ProcesarEvento(GNC::GCS::Events::IEvent *evt) ;

protected:
	GNKVisualizator::Vista2D*                  IVista;
	GNC::GCS::Ptr<GNC::GCS::IReferredStudyContext> EstudioReferido;
	GVtkObserver*                              m_pObserverVTK;
	int													 m_tDimensions;

	GNC::GCS::Ptr<GNKVisualizator::TListaOverlays> m_pListaOverlays;
	friend class GVistaCompleja;
};
