/*
 *  
 *  $Id: streamingloader.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#if defined _WINDOWS
#pragma warning(disable : 4702)
#endif

#include <api/api.h>
#include <api/controllers/icontroladorcarga.h>
#include <api/ilock.h>
#include <itkProcessObject.h>
#include <itkGDCMImageIO.h>
#include <vtkSmartPointer.h>

//region "Forward Declarations"

class vtkImageData;
class vtkImageDataStreamer;
class vtkImageChangeInformation;

namespace GNC {
	namespace GCS {
		class IComando;
	}
}
//endregion

namespace GNC {

	class EXTAPI StreamingLoader : public GNC::GCS::IStreamingLoader {
	public:
		typedef itk::GDCMImageIO         ImageIO;
		typedef ImageIO::IOComponentType ImageComponentType;
		typedef ImageIO::IOPixelType     ImagePixelType;

		//region Constructor
		StreamingLoader();
		virtual ~StreamingLoader();

		virtual bool IsSignalFile() { return m_SignalFile; }
		virtual void SetInput(const std::string& fichero);
		virtual void Update();                                       // Actualiza la imagen completa del puerto de salida
		virtual void UpdateInformation();                            // Actualiza la informacion del puerto de salida
		virtual void SetCustomOrientation(GNC::GCS::Vector3D& camera_focal_point, GNC::GCS::Vector3D& camera_position, GNC::GCS::Vector3D& camera_view_up, double& rotation);
		virtual const GNC::GCS::Ptr<GNC::GCS::IGinkgoMatrix4x4> GetDirection();                // Obtiene los cosenos directores
		virtual void GetDimensions(int dimensions[3]);      // Obtiene las dimensiones de la imagen de entrada
		virtual void GetOrigin(double origin[3]);                    // Obtiene el origen de la imagen de entrada
		virtual void GetSpacing(double spacing[3]);                  // Obtiene el spacing de la imagen de entrada
		virtual void SetOutputSpacing(double spacing[3]);            // establece el spacing de salida
		virtual void SetOutputOrigin(double origin[3]);				 // establece el origen de salida
		virtual void GetOutputOrigin(double origin[3]);              // Obtiene el origen de la imagen de entrada
		virtual void GetOutputSpacing(double spacing[3]);            // Obtiene el spacing de la imagen de entrada
		virtual int GetCurrentSliceIndex()  const;
		virtual std::string GetPatientPosition();
		virtual vtkSmartPointer<vtkAlgorithmOutput> GetOutputPort(); // Devuelve el puerto de salida
		virtual void GetOutputCopy(vtkSmartPointer<vtkImageData>& output);    // Devuelve por parametro una copia de la imagen
		virtual void GetOutputDimensions(int currentDimensions[3]);  //devuelve las dimensiones de salida
		virtual bool GetDefaultWindowLevel(double &window, double &level);
		
	protected:
		void CargarITK(GNC::GCS::IComando* cmd, int* orientacion, double* spacing = NULL);

		itk::ProcessObject::Pointer                m_pReader;
		itk::ProcessObject::Pointer                m_pPipelineJoiner;
		vtkSmartPointer<vtkImageChangeInformation> m_pOutput;
		GNC::GCS::Ptr<GNC::GCS::IGinkgoMatrix4x4>  DirectionCosines;
		double                                     m_Origin[3];
		double                                     m_Spacing[3];


	private:
		ImageIO::Pointer    m_IO;
		unsigned int        m_CurrentNumberOfComponents;
		ImageComponentType  m_CurrentComponentType;
		ImagePixelType      m_CurrentPixelType;
		unsigned int        m_CurrentDimensions[3];
		std::string         m_CurrentFile;
		bool                m_SignalFile;

		void RecomponerPipeline();
	};
}
