/*
 *  
 *  $Id: iwidgetsmanager.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include "iwidgetsmanager.h"
#include "observers/iwidgetsobserver.h"

GNC::GCS::IWidgetsManager::IWidgetsManager(GNC::GCS::IVista* pView) :
m_pRendererActivo(NULL),
m_Modified(false),
m_pView(pView),
m_Enabled(true),
m_cursor(GNC::GCS::Widgets::CUR_FLECHA)
{ }

GNC::GCS::IWidgetsManager::~IWidgetsManager() {
	m_pView = NULL;
}

void GNC::GCS::IWidgetsManager::Enable(bool enabled)
{
	m_Enabled = enabled;
}

bool GNC::GCS::IWidgetsManager::IsEnabled()
{
	return m_Enabled;
}

//----------------------------------------------------------------------------------------------------
//region "Interfaz de registro del IWidgetsRenderer"

void GNC::GCS::IWidgetsManager::InsertarObservador(GNC::GCS::Widgets::IObservadorWidget* observador)
{
	m_Observadores.push_back(observador);
}

void GNC::GCS::IWidgetsManager::EliminarObservador(GNC::GCS::Widgets::IObservadorWidget* observador)
{
	IteradorListaObservadores it;
	
	for (it = m_Observadores.begin(); it != m_Observadores.end() && (*it) != observador; ++it);
	
	if (it != m_Observadores.end()) {
		m_Observadores.erase(it);
	}
}

//endregion

