/*
 *  
 *  $Id: gwaveformview.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <api/observers/ieventsobserver.h>
#include <export/contracts/iwidgetscontract.h>
#include <api/ianotador.h>

#include "visualizatorviews.h"

class vtkGinkgoImageViewer;

namespace GNKVisualizator{
	namespace Widgets {
		class WECG;
	}
	class WaveFormView;
	namespace GUI {
		class GWaveformViewButtonBar;
		class GWaveformViewDelegate;
			
		class GWaveformView : public GWaveformViewBase, public GNC::GCS::IWidgetsContract, public GNC::GCS::IEventsObserver, public GNC::GCS::IAnotador
		{
			friend class GWaveformViewDelegate;
		public:
			/* Constructor */
			GWaveformView(GNKVisualizator::WaveFormView* pView);

			/* Destructor */
			~GWaveformView();

			void InitPipeline();

			void StopPipeline();

			void OnFinishLoad();

			virtual vtkGinkgoImageViewer* GetViewerActivo();
			
			virtual GNC::GCS::IWidgetsManager* GetManager();

			void OnPaint(wxPaintEvent& event);
			virtual void OnComboGroup(wxCommandEvent &event);
			virtual void OnShowHideMetadata(wxCommandEvent &event);
			virtual void ShowMetaData(bool show);
			virtual void OnShowHideCornerAnnotations(wxCommandEvent &event);

			//Ianotador
			std::string GetDICOMTag(std::string tagId);
			virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetAnotacionPosicion(GNC::GCS::Vector* pPosicionRaton);
			//

		protected:
			void OnFocus(wxChildFocusEvent &event);
			
			void PreProcesarEvento(GNC::GCS::Events::IEvent* evt, std::list<GNC::GCS::Events::IEvent*>& lista);
			void ProcesarEvento(GNC::GCS::Events::IEvent *evt) ;

			GNKVisualizator::WaveFormView* View;
			GNKVisualizator::Widgets::WECG* WECG;
			GWaveformViewButtonBar* m_pButtonBar;
			
			GNC::GCS::IWidgetsManager* m_pManager;
			GNC::GCS::Ptr<GWaveformViewDelegate> Delegate;
		};
	}
}

