/*
 *  
 *  $Id: wprogreso.h 5047 2012-07-25 13:14:57Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwidgets.h>
#include <api/ievento.h>
#include <api/observers/ieventsobserver.h>
#include <vector>
#include <list>
#include <set>
#include "openglhelper.h"


namespace GNC {
	namespace GCS {

		namespace Widgets {
			typedef enum ModoProgreso {
				MP_Definido,
				MP_Indefinido
			} ModoProgreso;

			// Este widget se asocia a un renderer concreto.
			class WProgreso : public GNC::GCS::Widgets::IWidget, public GNC::GCS::IEventsObserver {

			//----------------------------------------------------------------------------------------------------
			//region "Constructor y destructor"
			public:

				WProgreso(GNC::GCS::IWidgetsRenderer* pRenderer, IWidgetsManager* pManager, long vid, const char* nombre, long gid);

				~WProgreso();

				virtual void TickAnimation(double freq);
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region "Interfaz especifica"
			public:
				void SetModo(ModoProgreso modo);

			protected:
				ModoProgreso m_ModoActivo;
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region "Interfaz generica"
				virtual void Modificar(bool modificar);

				virtual void OnMouseEvents(GNC::GCS::Events::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Events::EventoTeclado&);

				virtual bool HitTest(float x, float y, float umbralCuadrado);

				virtual bool HitTest(GNC::GCS::Vector* vertices, int numVertices);

				virtual void Render(GNC::GCS::Contexto3D* c);


			//endregion

			//----------------------------------------------------------------------------------------------------
			//region "Estado interno"
			private:
				GNC::GCS::Vector  m_PosicionCursor;
				GNC::GCS::Vector  m_Posicion;
				double            m_Progreso;

			public:
				virtual void RecalcularEstaticas(void* renderer);
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region Interfaz de eventos ginkgo
			public:
				virtual void ProcesarEvento(GNC::GCS::Events::IEvent* /*evento*/) {}
			//endregion

			};
		}
	}
}
