/*
 *  
 *  $Id: showhistorytool.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "imageexporttool.h"
#include <api/ivista.h>
#include <export/contracts/iimageexportcontract.h>
#include <main/gui/toolsystem/wxmenuitemtool.h>
#include <main/gui/export/wxwizardexportacionginkgo.h>


//----------------------------------------------------------------------
namespace GNC {
	namespace GUI {
		class wxImageExportEventHandler: public wxDefaultEvtHandlerTool
		{
		public:
			wxImageExportEventHandler(wxEvtHandler* pParent, GNC::ImageExportTool* pTool): wxDefaultEvtHandlerTool(pParent, pTool)
			{
				m_pImageExport = pTool;
			}

			~wxImageExportEventHandler()
			{
			}

			virtual void OnUpdateUI(wxUpdateUIEvent &event)
			{
				wxDefaultEvtHandlerTool::OnUpdateUI(event);
				if (event.GetEnabled()) {
					event.Enable(m_pImageExport->IsEnabled());
				}
			}
			GNC::ImageExportTool* m_pImageExport;
		};

	}
}

GNC::GCS::ITool* GNC::ImageExportTool::NewTool()
{
	return new GNC::ImageExportTool();
}

GNC::ImageExportTool::ImageExportTool()
{
}
GNC::ImageExportTool::~ImageExportTool()
{
}
		
bool GNC::ImageExportTool::ExecuteAction()
{	
	GNC::GCS::Ptr<GNC::GCS::IImageExportDelegate> pDelegate(ExportContract->GetNewExportDelegate());
	GNC::GUI::wxWidzardExportacionGinkgo dlg(ExportContract->GetView()->GetWindow(), pDelegate);
	if (ExportContract->GetView()->GetWindow() != NULL) {
		//set position relative to view window...
		wxPoint position = ExportContract->GetView()->GetWindow()->GetPosition();
		wxPoint screeenPosition = ExportContract->GetView()->GetWindow()->ClientToScreen(position);
		screeenPosition.x += 20;
		screeenPosition.y += 20;
		dlg.SetPosition(screeenPosition);
	}
	dlg.ShowModal();
	return true;
}

void GNC::ImageExportTool::AppendToolIn(wxEvtHandler* pParent, wxMenu* pMenu)
{
	if (AppendsInMenu()) {
		GNC::GUI::wxImageExportEventHandler* evtHandler = new GNC::GUI::wxImageExportEventHandler(pParent, this);
		pMenu->Append(new GNC::GUI::wxMenuItemTool(pMenu, ID, wxString::FromUTF8(Name.c_str()),Icon, evtHandler));
	}
}

bool GNC::ImageExportTool::IsEnabled()
{
	return ExportContract->CanBeExported();
}
