/*
*
*  $Id: ipipelineproperties.h $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#ifndef IPIPELINEPROPERTIES_H
#define IPIPELINEPROPERTIES_H
#include <api/autoptr.h>

//----------------------------------------------------------------------------------------------------
//region Forward Declarations

//endregion
namespace GNC {
	namespace GCS {
		class IGinkgoMatrix4x4;
		class Vector3D;

		//----------------------------------------------------------------------------------------------------
		/** Pipeline Properties Proxy  class **/
		class IPipelineProperties {
		public:
			virtual ~IPipelineProperties() {}

			/** Updates **/
			virtual void Update() = 0;

			/** Updates output information **/
			virtual void UpdateInformation() = 0;

			/** Sets camera custom orientation **/
			virtual void SetCustomOrientation(GNC::GCS::Vector3D& camera_focal_point, GNC::GCS::Vector3D& camera_position, GNC::GCS::Vector3D& camera_view_up, double& rotation) = 0;

			/* Gets direction cosines */
			virtual const GNC::GCS::Ptr<GNC::GCS::IGinkgoMatrix4x4> GetDirection() = 0;
		
			/** Gets the output origin **/
			virtual void GetOutputOrigin(double origin[3]) = 0;
		
			/** Gets the output spacing **/
			virtual void GetOutputSpacing(double spacing[3]) = 0;
		
			/**Gets the output dimensions **/
			virtual void GetOutputDimensions(int currentDimensions[3]) = 0;  

			/** Gets the output current slice number **/
			virtual int GetCurrentSliceIndex() = 0;
		};
		//endregion
	}
}


#endif
