/*
*  
*  $Id: volumecommand.h 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once

#define IDC_VOLUME_RECONSTRUCTION 4003

#include <api/icomando.h>
#include <yasper/yasper.h>
#include "../pipelines/volumepipeline.h"


namespace MedicalViewer {
	namespace Reconstruction {
		namespace Volume {

			typedef MedicalViewer::Reconstruction::Pipelines::VolumePipeline TPipeline;
			typedef TPipeline::VolumeBlendType                               TBlendType;

			namespace Commands {

				class VolumeCommandParams : public GNC::GCS::IComandoParams {
				public:

					/** Volume Command (setup) Parameters.
						pipeline: VolumeReconstruction pipeline
						datasetNum: Loaded Volume index (VOI)
						reductionFactor: Volume reduction factor (0~1)
						window: Radiolucency Window.
						level: Radiolucency Level.
						blendType: Transfer Function
					**/
					VolumeCommandParams(
						const GnkPtr<TPipeline>& pipeline,
						unsigned int datasetNum,
						double reductionFactor,
						double window,
						double level,
						TBlendType blendType
					);

					virtual ~VolumeCommandParams() ;

				public:

					GnkPtr<TPipeline>   Pipeline;
					unsigned int        DataSetNum;
					double              ReductionFactor;
					double              Window;
					double              Level;
					TBlendType          BlendType;
				};


				class VolumeCommand : public GNC::GCS::IComando, public MedicalViewer::Reconstruction::Pipelines::IReconstructionNotifier
				{
				public:
					VolumeCommand(VolumeCommandParams* pParams);
					~VolumeCommand(void);

				protected:
				
					virtual void Execute();
					virtual void Update();

					virtual void OnAbort();

					void LiberarRecursos();

					virtual bool NotifyReconstructionProgress(const std::string& texto,  float progress);

					VolumeCommandParams* m_pVolumeParams;
				};
			}
		}
	}
}
