/*
 *  
 *  $Id: toolwindowlevellight.h 3905 2011-06-30 08:47:47Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <lightvisualizator/export/itoolwindowlevellight.h>
#include <api/icontroladoreventos.h>

#include <map>

namespace LightVisualizator {

	class ToolWindowLevelLight : public IToolWindowLevelLight, public GNC::GCS::IObservador {

	public:
		typedef std::map<TContratoWindowLevel*, GNC::GCS::IContratoWindowLevel::WindowLevel> ListaWindowLevelsIniciales;

		ToolWindowLevelLight();
		virtual ~ToolWindowLevelLight();

		//region "Realización de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );
		//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);


		//region "metodos propios de la herramienta window/level"
		virtual void ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel);

		virtual void SetWindowLevel(const GNC::GCS::IContratoWindowLevel::WindowLevel& wl);
		void Resetear();
		//endregion

	protected:
		ListaWindowLevelsIniciales m_WindowLevelInicial;

	};
}
