/*
*  
*  $Id: generaldata.cpp 3681 2011-04-12 10:53:31Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#include <api/ientorno.h>
#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/valtext.h>
#include <wx/busyinfo.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/confbase.h>
#include <api/dicom/imodelodicom.h>
#include <api/ientorno.h>
#include <string>
#include <sstream>
#include <cmath>

#include "generaldata.h"

#include <export/tagsprivadoscomunes.h>
#include <fooextension/license.h>

#include <fooextension/commands/dicomizecommand.h>

namespace FooExtension {
	namespace GUI {

		GeneralData::GeneralData(wxWindow* pParent,IWizard* pWizard,const std::string &dirTemporal ,GnkPtr<ImportationPersistentData> datosPersistentes ,GNC::GCS::IEntorno * pEntorno):GeneralDataBase(pParent),IPasoWizard(pWizard)
		{
			Hide();
			m_pEntorno=pEntorno;
			m_pPersistentData=datosPersistentes;

			wxDateTime date = wxDateTime::Now();
			m_pStudyTime->SetDateTimeValue(date);
			m_pSeriesTime->SetDateTimeValue(date);
		}

		GeneralData::~GeneralData()
		{
		}


		//region "IPasoWizard"

		void GeneralData::Attach(wxSizer *sizer){
			m_pPatientId->SetFocus();

			Show(true);

			sizer->Add(this,10, wxEXPAND);
			this->GetParent()->Layout();
		}

		void GeneralData::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string GeneralData::GetTitle(){
			return _Std("Title of this step");
		}

		std::string GeneralData::GetSubTitle(){
			return _Std("Subtitle of this step");
		}

		//allows next
		bool GeneralData::Siguiente(){
			return true;
		}

		//allows back
		bool GeneralData::Anterior(){
			return true;
		}

		//allows cancel
		bool GeneralData::Cancelar(){
			return true;
		}

		//validate data
		bool GeneralData::Validar(){
			bool ok =  ValidateData();
			if (ok) {
				//fill in dicom tags, here you can add your own tags
				FillInCommonTags(m_pPersistentData->baseImages);
				//throws dicomization command...
				//first create params...
				FooExtension::GADAPI::DicomizeCommandParameters* pParams = new FooExtension::GADAPI::DicomizeCommandParameters(m_pPersistentData, m_pEntorno);
				//secondly create command
				FooExtension::GADAPI::DicomizeCommand* pCmd = new FooExtension::GADAPI::DicomizeCommand(pParams);
				//Lastly call command controller to execute command asynchronous
				m_pEntorno->GetControladorComandos()->ProcessAsync(_Std("Dicomization"), pCmd, NULL);
			}
			return ok;
		}

		bool GeneralData::ValidateData() {
			wxString mensaje = wxEmptyString;

			if (m_pPatientId->GetValue().IsEmpty()) {
				mensaje += _("\n* The patient ID is required.");
			}

			if(m_pPatientSurname1->GetValue().size() + m_pPatientSurname2->GetValue().size() + m_pPatientName->GetValue().size() > 61) {
				mensaje += _("\n* Concatenation of patient name and surnames can't be higher than 61.");
			}

			if ( m_pPatientBirthDate->GetValue().IsLaterThan(m_pStudyDate->GetValue()) ) {
				mensaje += _("\n* The patient's birth date is after the date of study");
			}

			if(mensaje != wxEmptyString){
				wxMessageBox(_("The following errors have occurred when validating fields") + mensaje, _("Error validating fields"), wxICON_ERROR);

				return false;
			} else {
				m_pPersistentData->PatientFirstSurname = GetPatientFirstSurname();
				m_pPersistentData->PatientSecondSurname=GetPatientSecondSurname();
				m_pPersistentData->PatientAge=GetPatientAge();
				m_pPersistentData->PatientBirthDate=GetPatientBirthDate();
				m_pPersistentData->PatientId=GetPatientId();
				m_pPersistentData->PatientName=GetPatientName();
				m_pPersistentData->PatientSex=GetPatientSex();
				m_pPersistentData->StudyDescription=GetStudyDescription();
				m_pPersistentData->StudyDate=GetStudyDate();
				m_pPersistentData->StudyTime=GetStudyTime();
				m_pPersistentData->SeriesDescription=GetSeriesDescription();
				m_pPersistentData->SeriesDate=GetSeriesDate();
				m_pPersistentData->SeriesTime=GetSeriesTime();
				return true;
			}
		}

		void GeneralData::FillInCommonTags(GIL::DICOM::TipoJerarquia& base)
		{
			//list of selected files
			for(ListaFicheros::const_iterator it=m_pListaFicheros->begin(); it!= m_pListaFicheros->end(); it++) {
				std::string path = (*it);
				FooExtension::GUI::ImportationPersistentData::TDicomizedFile file;
				file.imagePath = path;

				m_pPersistentData->m_dicomizedFiles.push_back(file);
			}

			std::string tag;

			//institucion
			wxString wxTmp;
			if(m_pPersistentData->InstitutionName == "" ){
				wxConfigBase::Get()->Read(wxT("/GinkgoCore/Estacion/CentroNombre"),&wxTmp,wxEmptyString);
				if(wxTmp != wxEmptyString){
					base.tags[std::string("0008|0080")] = std::string(wxTmp.ToUTF8());
				}
			} else {
				base.tags[std::string("0008|0080")] = m_pPersistentData->InstitutionName;
			}

			//nombre del medico responsable de la institucion
			if(m_pPersistentData->PhysicianName == ""){
				wxConfigBase::Get()->Read(wxT("/GinkgoCore/Estacion/NombreMedico"),&wxTmp,wxEmptyString);
				if(wxTmp != wxEmptyString){
					base.tags[std::string("0008|0090")] = std::string(wxTmp.ToUTF8());
				}
			} else {
				base.tags[std::string("0008|0090")] = m_pPersistentData->PhysicianName;
			}

			base.tags[std::string("0008|0070")] = std::string("Metaemotion S.L.");

			//description of the extension
			base.tags[std::string("0008|1090")] = FOO_EXTENSION_DESCRIPTION;

			//uid of the extension, used to open imported files with this extension
			base.tags[std::string("0018|1030")] = FOO_EXTENSION_UID;

			base.tags[std::string("0008|0020")] = m_pPersistentData->StudyDate;

			base.tags[std::string("0008|0030")] =  m_pPersistentData->StudyTime;

			base.tags[std::string("0008|1030")] = m_pPersistentData->StudyDescription;

			base.tags[std::string("0008|0021")] = m_pPersistentData->SeriesDate;

			base.tags[std::string("0008|0031")] = m_pPersistentData->SeriesTime;

			base.tags[std::string("0008|103e")] = m_pPersistentData->SeriesDescription;

			base.tags[std::string("0008|0022")] = m_pPersistentData->SeriesDate;
			base.tags[std::string("0008|0032")] = m_pPersistentData->SeriesTime;
			base.tags[std::string("0020|4000")] = m_pPersistentData->SeriesDescription;


			base.tags[std::string("0010|0010")] = m_pPersistentData->PatientName + "^" + m_pPersistentData->PatientFirstSurname + "^" + m_pPersistentData->PatientSecondSurname;

			base.tags[std::string("0010|0020")] = m_pPersistentData->PatientId;

			base.tags[std::string("0010|1010")] = m_pPersistentData->PatientAge;

			base.tags[std::string("0010|0030")] = m_pPersistentData->PatientBirthDate;

			base.tags[std::string("0010|0040")] = m_pPersistentData->PatientSex;
		}

		//endregion

		std::string GeneralData::GetPatientName(){
			return std::string(m_pPatientName->GetValue().ToUTF8());
		}

		std::string GeneralData::GetPatientFirstSurname(){
			return std::string(m_pPatientSurname1->GetValue().ToUTF8());
		}

		std::string GeneralData::GetPatientSecondSurname(){
			return std::string(m_pPatientSurname2->GetValue().ToUTF8());
		}

		std::string GeneralData::GetPatientId(){
			return std::string(m_pPatientId->GetValue().ToUTF8());
		}

		std::string GeneralData::GetPatientBirthDate(){
			return std::string(m_pPatientBirthDate->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
		}

		std::string GeneralData::GetPatientAge()
		{
			int age = CalculateAge();
			std::ostringstream os;
			os.fill('0');
			os.width(3);
			os << age << "Y";
			return os.str();
		}

		std::string GeneralData::GetPatientSex(){
			std::string str;
			switch(m_pPatientSex->GetSelection()){
				case 0:
					str = std::string("M");
					break;
				case 1:
					str = std::string("F");
					break;
				case 2:
					str = std::string("O");
					break;
			}
			return str;
		}

		void GeneralData::OnKillFocusEstudioTimeControl(wxFocusEvent &event)
		{
			if(!m_pStudyTime->GetDateTimeValue().IsValid()){
				wxDateTime ahora = wxDateTime::Now();
				m_pStudyTime->SetDateTimeValue(ahora);
			}
		}


		std::string GeneralData::GetStudyDate()
		{
			if(m_pStudyDate->GetValue().IsValid()){
				return std::string(m_pStudyDate->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string GeneralData::GetStudyTime()
		{
			if(m_pStudyTime->GetDateTimeValue().IsValid()){
				return std::string(m_pStudyTime->GetDateTimeValue().Format(wxT("%H%M%S")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string GeneralData::GetStudyDescription()
		{
			return std::string(m_pStudyDescription->GetValue().ToUTF8());
		}

		void GeneralData::OnKillFocusSerieTimeControl(wxFocusEvent &event)
		{
			if(!m_pSeriesTime->GetDateTimeValue().IsValid())
			{
				wxDateTime ahora = wxDateTime::Now();
				m_pSeriesTime->SetDateTimeValue(ahora);
			}
		}


		std::string GeneralData::GetSeriesDate()
		{
			if(m_pSeriesDate->GetValue().IsValid()){
				return std::string(m_pSeriesDate->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string GeneralData::GetSeriesTime()
		{
			if(m_pSeriesTime->GetDateTimeValue().IsValid()){
				return std::string(m_pSeriesTime->GetDateTimeValue().Format(wxT("%H%M%S")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string GeneralData::GetSeriesDescription()
		{
			return std::string(m_pSeriesDescription->GetValue().ToUTF8());
		}


		int GeneralData::CalculateAge()
		{
			wxDateTime fechaEstudio = m_pStudyDate->GetValue();
			wxDateTime fechaNacimiento = m_pPatientBirthDate->GetValue();
			int edad = 0;
			if( (fechaEstudio.GetMonth() > fechaNacimiento.GetMonth()) ||
				(fechaEstudio.GetMonth() == fechaNacimiento.GetMonth() && fechaEstudio.GetDay() >= fechaNacimiento.GetDay()) ){
					edad = fechaEstudio.GetYear() - fechaNacimiento.GetYear();
			} else {
				edad = fechaEstudio.GetYear() - fechaNacimiento.GetYear() - 1;
			}
			return edad;
		}
	}
}
