/*
 *  
 *  $Id: dicomizecommand.h 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/icomando.h>
#include <api/imgproxy.h>
#include <api/ientorno.h>
#include <api/icontroladoreventos.h>
#include <api/imodelointegracion.h>
#include <fooextension/gui/importation/importationpersistentdata.h>

#include <wx/xml/xml.h>
#include <wx/thread.h>


namespace FooExtension {
	namespace GADAPI {

		//data that command uses is defined in the parameters class, this class will be deleted when command is destroyed
		class DicomizeCommandParameters : public GNC::GCS::IComandoParams {
		public:
			DicomizeCommandParameters(GnkPtr< ::FooExtension::GUI::ImportationPersistentData > pDatosPersistentes, GNC::GCS::IEntorno* pEntorno) ;

			//if you reserve memory in the parameters you have to define virtual destructor
			virtual ~DicomizeCommandParameters() ;

		public:
			GnkPtr< ::FooExtension::GUI::ImportationPersistentData > m_pPersistentData;
			GNC::GCS::IEntorno* m_pEntorno;

			std::string m_TmpDir;
			std::string m_errorMessage;
		};


		//command of dicomization, all commands has one part executed in background and another synchronized with interface
		class DicomizeCommand : public GNC::GCS:: IComando {
		public:
			//receives parameters used in processing
			DicomizeCommand(DicomizeCommandParameters* pParams);

		 protected:
			//this part is executed in background, it can't call interface methods neither asks for user interaction
			virtual void Execute();

			//this method is called after execute is performed, is synchronized with user interface
			virtual void Update();
			
			//called when command is aborted
			virtual void OnAbort();

		protected:
			bool ImportFiles();

			bool CopyDICOMToGinkgoCADx();

			bool RemoveTempDir(const wxString& dirPath);

			DicomizeCommandParameters* m_pDicomizationParameters;
		};
	}
}
