/*
 *  
 *  $Id: wprogreso.cpp 3748 2011-04-20 10:38:38Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#ifdef __WXOSX__
#define FUENTE_CAIRO "Arial"
#else
#define FUENTE_CAIRO "Arial"
#endif
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include <api/iwidgetsrenderer.h>
#include "wprogreso.h"
#include <api/ievento.h>
#include <api/icontexto.h>
#include <eventos/eventosginkgo.h>

#include <cmath>
#include <cstring>
#include <cairo/cairo.h>

#include <vtkgl.h>
#include <sstream>
#define RADIO 20.0f

//----------------------------------------------------------------------------------------------------
//region "Constructor y destructor"

GNC::GCS::Widgets::WProgreso::WProgreso(GNC::GCS::IWidgetsRenderer* pRenderer, IWidgetsManager* pManager, long vid, const char* nombre, long gid) : GNC::GCS::Widgets::IWidget(pManager, vid, nombre, gid)
{
	m_Oculto = false;
	m_TopLevel = true;
	m_ModoActivo = GNC::GCS::Widgets::MP_Indefinido;
	m_Progreso = 0.0f;
	m_ReservaRecursos = true;
	m_pRenderer = pRenderer;

	GTRACE("Progreso creado");

	GNC::GCS::Eventos::EventoModificacionImagen evt2(m_pManager->GetVista());
	m_pManager->GetControladorEventos()->Registrar(this, evt2);

}

GNC::GCS::Widgets::WProgreso::~WProgreso()
{
	Modificar(true);
	GTRACE("Progreso destruido");
}

//endregion

void GNC::GCS::Widgets::WProgreso::TickAnimation(double freq)
{
	double nprogreso = m_Progreso + (1.0f / freq);
	if (nprogreso > 1.0f) {
		if (m_ModoActivo == MP_Indefinido) {
			nprogreso = 0.0f;
		}
		else {
			nprogreso = 1.0f;
		}
	}
	if (m_Progreso != nprogreso) {
		m_Progreso = nprogreso;
		Modificar(true);
	}
}

//----------------------------------------------------------------------------------------------------
//region "Interfaz especifica"
void GNC::GCS::Widgets::WProgreso::SetModo(GNC::GCS::Widgets::ModoProgreso modo)
{
	if (m_ModoActivo != modo) {
		m_ModoActivo = modo;
		Modificar(true);
	}
}

//endregion

//----------------------------------------------------------------------------------------------------
//region "Interfaz generica"

void GNC::GCS::Widgets::WProgreso::Modificar(bool modificar)
{
	m_Modificado = modificar;
	if (m_Modificado && m_pRenderer != NULL) {
		m_pRenderer->Modificar(true);
	}

}

void GNC::GCS::Widgets::WProgreso::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& /*evento*/)
{
}

void GNC::GCS::Widgets::WProgreso::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&)
{
}

bool GNC::GCS::Widgets::WProgreso::HitTest(float , float , float /*umbralCuadrado*/)
{
	return false;
}

bool GNC::GCS::Widgets::WProgreso::HitTest(GNC::GCS::Vector* , int )
{
	return false;
}

void GNC::GCS::Widgets::WProgreso::Render(GNC::GCS::Contexto3D* c)
{
	if(m_Oculto || c == NULL || c->GetRenderer() != m_pRenderer ) {
		return;
	}

	glPushAttrib(GL_ALL_ATTRIB_BITS);

	float viewport[4] = {0.0f, 0.0f, 0.0f, 0.0f}; // { x, y, ancho, alto }. Convenio de coordenadas: {x, y} == {bottom, left}, {ancho, alto} == {top, right}
	glGetFloatv(GL_VIEWPORT, viewport);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho( 0, viewport[2] , viewport[3] , 0, -1, 1 );

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	GNC::GCS::Vector viewPortPantalla(viewport[2], viewport[3]); // Tamano del viewport.

	GNC::GCS::Vector TamCaja = GNC::GCS::Vector( 0.20f * viewPortPantalla.x, 0.01f * viewPortPantalla.y).Redondeado();
	GNC::GCS::Vector PadCaja = GNC::GCS::Vector(0.0f, 0.02f * viewPortPantalla.y).Redondeado();
	GNC::GCS::Vector PosCaja = GNC::GCS::Vector( (viewPortPantalla.x - TamCaja.x) / 2.0f - PadCaja.x, viewPortPantalla.y - TamCaja.y - PadCaja.y).Redondeado();

	glLineWidth(1.0f);
	glColor4f(1.0f, 0.84f, 0.0f, 1.0f);
	glBegin(GL_LINE_LOOP);
	glVertex2d(PosCaja.x - 2.0f, PosCaja.y - 2.0f);
	glVertex2d(PosCaja.x + TamCaja.x + 2.0f, PosCaja.y - 2.0f);
	glVertex2d(PosCaja.x + TamCaja.x + 2.0f, PosCaja.y + TamCaja.y + 2.0f);
	glVertex2d(PosCaja.x - 2.0f, PosCaja.y + TamCaja.y + 2.0f);
	glEnd();

	TamCaja.x *= m_Progreso;


	glBegin(GL_QUADS);
	glColor4f(1.0f, 0.91f, 0.5f, 1.0f);
	glVertex2d(PosCaja.x, PosCaja.y);
	glVertex2d(PosCaja.x + TamCaja.x, PosCaja.y);
	glColor4f(0.5f, 0.4f, 0.0f, 1.0f);
	glVertex2d(PosCaja.x + TamCaja.x, PosCaja.y + TamCaja.y);
	glVertex2d(PosCaja.x, PosCaja.y + TamCaja.y);
	glEnd();

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	glPopAttrib();

}

//endregion

//----------------------------------------------------------------------------------------------------
//region "Estado interno"

void GNC::GCS::Widgets::WProgreso::RecalcularEstaticas(void* /*renderer*/)
{
}
//endregion

//----------------------------------------------------------------------------------------------------
//region Interfaz de eventos ginkgo

//endregion

