/*
 *  
 *  $Id: dicomimg2dcm.h 3834 2011-05-10 07:42:57Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/globals.h>
#include <api/dicom/idicomizador.h>
#ifdef verify
#define MACRO_QUE_ESTORBA verify
#undef verify
#endif

#include <dcmtk/config/osconfig.h>
#include "libi2d/i2d.h"
#include "libi2d/i2djpgs.h"
#include "libi2d/i2dplsc.h"
#include "libi2d/i2dplvlp.h"
#include "libi2d/i2dplnsc.h"
#include "dcmtk/dcmdata/dcdict.h"
#include "dcmtk/dcmdata/dchashdi.h"

class DcmElement;

namespace GIL {
	namespace DICOM {
		
		class DICOMImg2DCM : public IDICOMImg2DCM {
		public:
			/* Constructor */
			DICOMImg2DCM() {
				i2d = NULL;
				outputPlug = NULL;
				inputPlug = NULL;
				resultObject = NULL;
				writeXfer = EXS_Unknown;
			};
			
			/* Destructor */
			~DICOMImg2DCM() {
				LiberarMemoria();
			}
			
			void LiberarMemoria() {
				if (resultObject != NULL) {
					delete resultObject;
					resultObject = NULL;
				}
				if (inputPlug != NULL) {
					delete inputPlug;
					inputPlug = NULL;
				}
				if (outputPlug != NULL) {
					delete outputPlug;
					outputPlug = NULL;
				}
				if (i2d != NULL) {
					delete i2d;
					i2d = NULL;
				}
			};
			
			/* Inicializa una conversión. IInspectCallback sirve para especificar un callback mediante el cual se pueden inspeccionar los atributos buscados.
			 *
			 * Formatos de entrada soportados:
			 *	  JPEG
			 * Formatos de salida soportados (DICOM SOP a generar):
			 *   VLP (Visible Light Photography)
			 *   SC (Secondary Capture)
			 *   NSC (New Secondary Capture)
			 */
			virtual void Inicializar(std::string& inputFile, IInspectCallBack* pICallback = NULL, bool debug = false, TDICOMOutputFormat outputFormat = TDOF_VLP);

			virtual void Inicializar(TImageFile& fileDefinition, IInspectCallBack* pICallback = NULL, bool debug = false, TDICOMOutputFormat outputFormat = TDOF_VLP);

			void Inicializar(I2DImgSource* plugEntrada, IInspectCallBack* pICallback, bool debug, TDICOMOutputFormat outputFormat);
			
			virtual int InsertarJerarquia(TipoJerarquia& base); 

			virtual int InsertarTagsPrivados(TipoPrivateTags& base);

			virtual int InsertarTagsPrivados(TipoPrivateTags& base, DcmDataset* dcmDataSet);

			int InsertarJerarquia(TipoJerarquia& base,DcmDataset* dcmDataSet, DcmItem* itemPadre, DcmSequenceOfItems* seqPadre);
			
			/* Actualiza los campos DICOM a sobreescribir */
			virtual void ActualizarCampos(IInspectCallBack* pICallback);
			
			/* Realiza una conversión ya inicializada */
			virtual bool Convertir(std::string& outputFile);

			unsigned int GetElementIdentifier(GIL::DICOM::TipoPrivateTags& tags, DcmDataset* dataset);

			bool CrearSRDoc(std::string& outputFile, TipoJerarquia& base, std::list<GnkPtr<TipoPrivateTags> >& tagsPrivados);

			virtual void Reset() {
				LiberarMemoria();
			}
			
		protected:
			
			/* Crea un elemento de DCMTK parseando la cadena pasada como parámetro que debe tener el formato:
			 <hex_2_bytes>|<hex_2_bytes>
			 o bien:
			 <hex_2_bytes>|<hex_2_bytes>=<cadena>
			 Nota: <cadena> puede ser vacía
			 */
			DcmElement* CrearElementoConValor(const char* s);
			
			// Main class for controlling conversion
			Image2Dcm*       i2d;
			// Output plugin to use (ie. SOP class to write)
			I2DOutputPlug*   outputPlug;
			// Input plugin to use (ie. file format to read)
			I2DImgSource*    inputPlug;
			// Result object
			DcmDataset*      resultObject;
			// The transfersytanx proposed to be written by output plugin
			E_TransferSyntax writeXfer;
		};
	};
};
