/*
 *  
 *  $Id: controladoreventos.h 3521 2011-03-16 14:54:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladoreventos.h>
#include <wx/thread.h>
#include <map>
#include <list>

//----------------------------------------------------------------------------------------------------
//region Forward Declarations

//endregion
		
namespace GNC {

	namespace GCS {
		
		//====================================================================================================
		//= Controlador de eventos
		//====================================================================================================
		class EXTAPI ControladorEventos: public IControladorEventos
		{

		public:
			//lista de punteros a eventos
			typedef std::list<GNC::GCS::Eventos::IEvento*> TipoListaPunterosEventos;

		protected:
			typedef std::list<IObservador * > TipoListaObservadores;
			//codigo de evento,observador
			typedef std::map<long , TipoListaObservadores > TipoMapaCodigos;
			//codigo de ambito, lista de observadores
			typedef std::map<long , TipoMapaCodigos> TipoMapaAmbito;
			//vista, ambitos
			typedef std::map<GNC::GCS::IVista* , TipoMapaAmbito > TipoMapaVistas;
			//lista de eventos
			typedef std::list<GNC::GCS::Eventos::IEvento> TipoListaEventos;
			//observadores,Evtentos para desregistrarse
			typedef std::map<IObservador*, TipoListaEventos> TipoMapaEventos;

		public:

			//se apunta a escuchar un evento
			void Registrar ( IObservador* pObservador, const GNC::GCS::Eventos::IEvento& evento);
			//se desapunta de escuchar un evento
			void DesRegistrar (IObservador* pObservador, const GNC::GCS::Eventos::IEvento& evento);
			//se desapunta de todos los eventos a los que escucha
			void DesRegistrar (IObservador* pObservador);
			//avisa a los observadores registrados a este evento
			void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

			static ControladorEventos *Instance();
			static void FreeInstance();

			static ControladorEventos* m_psInstancia;

		protected:

			ControladorEventos();
			~ControladorEventos();

			void NotificarEvento(GNC::GCS::Eventos::IEvento *evt, TipoListaObservadores & listaObservadores);

			//semaforo para controlar las secciones criticas
			wxCriticalSection m_eventosCriticalSection;

			//atributos donde se lleva la cuenta de observadores/eventos
			TipoMapaVistas m_mapaVistas;
			TipoMapaEventos m_mapaEventos;
		};
	}
}
