/*
*
*  $Id: comandomergediagnosticwithimage.cpp 4374 2011-11-04 13:24:30Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#include <sstream>

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/xml/xml.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/mstream.h>
#include <wx/sstream.h>

#include <api/globals.h>
#include <api/ientorno.h>
#include <api/icontextoestudio.h>
#include <api/dicom/idicommanager.h>

#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorextensiones.h>

#include <eventos/eventosginkgo.h>

#include <commands/comandomergediagnosticwithimage.h>
#include <commands/comandopacs.h>

#define IDC_MERGE_DIAGNOSTIC           114

namespace GADAPI {

	ComandoMergeDiagnosticWithImageParams::ComandoMergeDiagnosticWithImageParams(const std::string& serverSeleccionado, const std::string& diagnosticStudyInstanceUID, GIL::DICOM::TipoTransferSyntaxEnvio transferSyntax)
	{
		m_ServerSeleccionado = serverSeleccionado;

/*
			std::list<std::string> pathsOriginal;
			GNC::GCS::ControladorHistorial::Instance()->GetReferencedFiles(uidDiagnosticSeries, pathsOriginal);
			for (std::list<std::string>::iterator it = pathsOriginal.begin(); it != pathsOriginal.end(); ++it)
			{
				T_File file;
				file.m_path = (*it);
				m_oldImages.push_back(file);
			}*/
		
		m_uidDiagnosticStudy = diagnosticStudyInstanceUID;
		
		m_diagnosticMode = GNC::GCS::IContextoEstudio::TMF_UNDiagnostico;
		
		m_transferSyntax = transferSyntax;

		//search module and tags replace...
		std::string uidImportater = GNC::GCS::ControladorHistorial::Instance()->GetUIDImporterFromDiagnosticStudy(m_uidDiagnosticStudy);
		GNC::ControladorExtensiones::ListaModulos listaModulos = GNC::ControladorExtensiones::Instance()->Modulos();
		bool salir = false;
		for(GNC::ControladorExtensiones::IteradorListaModulos itModulos = listaModulos.begin(); itModulos!= listaModulos.end() && !salir; ++itModulos){
			for (GNC::GCS::IControladorModulo::IteradorListaModos itModos = (*itModulos).second->GetListaModos().begin(); itModos != (*itModulos).second->GetListaModos().end(); ++itModos) {
				if ((*itModos)->SupportsImportationUID(uidImportater)) {
					//get all files of series included in this diagnostic
					std::list<std::string> pathsOriginal;
					GNC::GCS::ControladorHistorial::Instance()->GetReferencedFiles(m_uidDiagnosticStudy, pathsOriginal);
					for (std::list<std::string>::iterator it = pathsOriginal.begin(); it != pathsOriginal.end(); ++it)
					{
						T_File file;
						file.m_path = (*it);
						m_oldImages.push_back(file);
					}
					
					(*itModulos).second->GetTagsPrivadosReplace(m_mapTagsPrivadosReplace);
					m_diagnosticMode = (*itModulos).second->GetDiagnosticMode();
					salir = true;
					break;
				}
			}
		}
		do {
			m_tempPath = FROMPATH(GNC::Entorno::Instance()->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
		} while(wxDir::Exists(m_tempPath));

		#ifdef _WIN32
				wxFileName::Mkdir(m_tempPath);
		#else
				wxFileName::Mkdir(m_tempPath.c_str(), 0777);
		#endif

		m_commandType = TC_UPLOAD;

		m_includeGinkgoTags = true;
	}

	ComandoMergeDiagnosticWithImageParams::ComandoMergeDiagnosticWithImageParams(const std::string& targetPath, GnkPtr<GNC::GCS::IContextoEstudio>& pStudyContext, const GIL::DICOM::TipoJerarquia& anonymizedTags, bool incluirTagsGinkgo, bool actual)
	{
		m_tempPath = FROMPATH(targetPath);

		if (actual) {
			T_File file;
			file.m_path = pStudyContext->GetRutaDeImagenActiva();
			m_oldImages.push_back(file);
		} else {
			std::vector<std::string> pathList = pStudyContext->GetRutasImagenes();
			for (std::vector<std::string>::iterator it = pathList.begin(); it != pathList.end(); ++it)
			{
				T_File file;
				file.m_path = (*it);
				m_oldImages.push_back(file);
			}
		}
		m_uidDiagnosticStudy = pStudyContext->GetUIDEstudioDiagnostico();
		m_diagnosticMode = pStudyContext->GetModoFuncionamiento();
		m_pModeloIntegracion = pStudyContext->GetModeloIntegracion();

		pStudyContext->Vista->GetModulo()->GetTagsPrivadosReplace(m_mapTagsPrivadosReplace);

		m_includeGinkgoTags = incluirTagsGinkgo;
		m_anonymizedTags = anonymizedTags;

		m_commandType = TC_EXPORT;
	}

	/////////
	ComandoMergeDiagnosticWithImage::ComandoMergeDiagnosticWithImage(ComandoMergeDiagnosticWithImageParams* pParams):GNC::GCS::IComando(pParams, _Std("Merge diagnostic"))
	{
		m_pMergeParams = pParams;

		SetId(IDC_MERGE_DIAGNOSTIC);
		EsperaA(IDC_MERGE_DIAGNOSTIC);

		GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoProgresoComando());
	}


	void ComandoMergeDiagnosticWithImage::Execute()
	{
		if (!NotificarProgreso(0.0, _Std("Merging files...")) )
			return;

		//first of all create new sop instance uids and fill in dictionaries
		{
			GIL::DICOM::IDICOMManager* pDicomManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			GNC::GCS::IControladorHistorial::ModeloDCM fileModel;
			for (ComandoMergeDiagnosticWithImageParams::TFileList::iterator it = m_pMergeParams->m_oldImages.begin(); it !=  m_pMergeParams->m_oldImages.end(); ++it)
			{
				ComandoMergeDiagnosticWithImageParams::T_File newFile;
				fileModel = GNC::GCS::ControladorHistorial::Instance()->GetModeloDCM((*it).m_path);
				(*it).m_sopInstance = fileModel.m_uidImagen;
				(*it).m_seriesInstance = fileModel.m_uidSerie;
				//sop instance map
				newFile.m_sopInstance = pDicomManager->GetNewUID();

				wxString wxOldUIDImagen = wxString::FromUTF8(fileModel.m_uidImagen.c_str());
				wxString wxOldUIDSeries = wxString::FromUTF8(fileModel.m_uidSerie.c_str());
				m_pMergeParams->m_mapSopUIDs[wxOldUIDImagen] = wxString::FromUTF8(newFile.m_sopInstance.c_str());
				//series map
				if (m_pMergeParams->m_mapSeriesUIDs.find(wxOldUIDSeries) != m_pMergeParams->m_mapSeriesUIDs.end()) {
					newFile.m_seriesInstance = m_pMergeParams->m_mapSeriesUIDs[wxOldUIDSeries].ToUTF8();
				} else {
					newFile.m_seriesInstance = pDicomManager->GetNewUID();
					m_pMergeParams->m_mapSeriesUIDs[wxOldUIDSeries] = wxString::FromUTF8(newFile.m_seriesInstance.c_str());
				}
				m_pMergeParams->m_newImages.push_back(newFile);
			}
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
		}

		if (!NotificarProgreso(0.1, _Std("Merging files...")) )
			return;


		bool error = false;
		if (m_pMergeParams->m_diagnosticMode == GNC::GCS::IContextoEstudio::TMF_UNDiagnostico) {
			error = !OneDiagnostic();
		} else {
			error = !MultipleDiagnostic();
		}


		if (!NotificarProgreso(0.85, _Std("Waiting upload...")) )
			return;

		if (!error && m_pMergeParams->m_commandType == ComandoMergeDiagnosticWithImageParams::TC_UPLOAD)
		{
			//llamamos al comando pacs... y lo esperamos
			std::vector<std::string> rutas;
			for (ComandoMergeDiagnosticWithImageParams::TFileList::iterator it = m_pMergeParams->m_newImages.begin(); it != m_pMergeParams->m_newImages.end(); ++it)
			{
				rutas.push_back((*it).m_path);
			}

			GADAPI::ComandoPACSParams * pParams = new GADAPI::ComandoPACSParams(m_pMergeParams->m_ServerSeleccionado, rutas, m_pMergeParams->m_pModeloIntegracion, m_pMergeParams->m_transferSyntax);

			m_pMergeParams->m_pComandoEspera = new GADAPI::ComandoPACS(pParams);
			GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Uploading to the PACS ..."),m_pMergeParams->m_pComandoEspera, NULL);
			m_pMergeParams->m_SemaforoEsperarComando.Wait();
		}
	}

	bool ComandoMergeDiagnosticWithImage::OneDiagnostic()
	{
		std::string uidEstudio;
		{
			GIL::DICOM::IDICOMManager* pDicomManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			uidEstudio = pDicomManager->GetNewUID();
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
		}

		std::string pathDiagnostic("");
		GIL::DICOM::TipoJerarquia baseDiagnostic;
		TMapaTagsPrivados privateTagsDiagnosticList;
		int i = 1;
		ComandoMergeDiagnosticWithImageParams::TFileList::iterator itNew = m_pMergeParams->m_newImages.begin();
		for (ComandoMergeDiagnosticWithImageParams::TFileList::iterator itOld = m_pMergeParams->m_oldImages.begin(); itOld !=  m_pMergeParams->m_oldImages.end(); ++itOld, ++itNew, i++)
		{
			GIL::DICOM::IDICOMManager* pDicomManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			if (!NotificarProgreso(0.8f * ((float)i/m_pMergeParams->m_oldImages.size()), std::string(wxString::Format(_("Merging file %d of %d"),i, m_pMergeParams->m_oldImages.size()).ToUTF8())) )
			{
				GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
				return false;
			}

			if (m_pMergeParams->m_includeGinkgoTags) {
				if (pathDiagnostic == "") {
					//read diagnostic file
					GNC::GCS::IControladorHistorial::ModeloDCM diagnosticModel;
					diagnosticModel = GNC::GCS::ControladorHistorial::Instance()->GetDiagnosticoSerie((*itOld).m_seriesInstance,m_pMergeParams->m_uidDiagnosticStudy);
					pathDiagnostic = GNC::Entorno::Instance()->GetPathAbsolutoFichero(diagnosticModel.m_pathRelativo);
					pDicomManager->CargarFichero(pathDiagnostic, baseDiagnostic);
					for (GNC::GCS::IControladorModulo::TMapaTagsPrivados::iterator itModulos = m_pMergeParams->m_mapTagsPrivadosReplace.begin(); itModulos != m_pMergeParams->m_mapTagsPrivadosReplace.end(); ++itModulos)
					{
						GnkPtr<GIL::DICOM::TipoPrivateTags> pTags(new GIL::DICOM::TipoPrivateTags((*itModulos).first));
						pDicomManager->CargarTagsPrivados(*pTags);
						privateTagsDiagnosticList[(*itModulos).first] = pTags;
					}
					AdaptSRDataset(baseDiagnostic, privateTagsDiagnosticList, (*itNew), uidEstudio);
				} else {
					baseDiagnostic.tags["0020|000d"] = uidEstudio;
					//series instance uid
					baseDiagnostic.tags["0020|000e"] = (*itNew).m_seriesInstance;
					//sop instance uid
					baseDiagnostic.tags["0008|0018"] = (*itNew).m_sopInstance;
				}
			}

			pDicomManager->CargarFichero((*itOld).m_path);

			pDicomManager->ActualizarJerarquia(baseDiagnostic);

			pDicomManager->ActualizarJerarquia(m_pMergeParams->m_anonymizedTags);

			if (m_pMergeParams->m_includeGinkgoTags) {
				for (TMapaTagsPrivados::iterator itTagsPrivados = privateTagsDiagnosticList.begin(); itTagsPrivados != privateTagsDiagnosticList.end(); ++itTagsPrivados)
				{
					pDicomManager->ActualizarTagsPrivados((*(*itTagsPrivados).second));
				}
			} else {
				pDicomManager->AnonimizarTagsPrivados();
			}

			wxString pathNewImage = GetFichero(m_pMergeParams->m_tempPath, wxT("dcm"));
			pDicomManager->AlmacenarFichero(std::string(TOPATH(pathNewImage)));
			(*itNew).m_path = TOPATH(pathNewImage);
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
		}

		return true;
	}

	bool ComandoMergeDiagnosticWithImage::MultipleDiagnostic()
	{
		std::string uidEstudio;
		{
			GIL::DICOM::IDICOMManager* pDicomManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			uidEstudio = pDicomManager->GetNewUID();
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
		}

		int i = 0;
		ComandoMergeDiagnosticWithImageParams::TFileList::iterator itNew = m_pMergeParams->m_newImages.begin();
		for (ComandoMergeDiagnosticWithImageParams::TFileList::iterator itOld = m_pMergeParams->m_oldImages.begin(); itOld !=  m_pMergeParams->m_oldImages.end(); ++itOld, ++itNew, ++i)
		{
			GIL::DICOM::IDICOMManager* pDicomManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			if (!NotificarProgreso(0.8f * ((float)i/m_pMergeParams->m_oldImages.size()), std::string(wxString::Format(_("Merging file %d of %d"),i, m_pMergeParams->m_oldImages.size()).ToUTF8())) )
			{
				GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
				return false;
			}

			GIL::DICOM::TipoJerarquia baseDiagnostic;
			std::map<std::string, GnkPtr<GIL::DICOM::TipoPrivateTags> > privateTagsDiagnosticList;

			if (m_pMergeParams->m_includeGinkgoTags) {
				//read diagnostic file
				GNC::GCS::IControladorHistorial::ModeloDCM diagnosticModel;
				diagnosticModel = GNC::GCS::ControladorHistorial::Instance()->GetDiagnostico((*itOld).m_path,m_pMergeParams->m_uidDiagnosticStudy);
				std::string pathDiagnostic = GNC::Entorno::Instance()->GetPathAbsolutoFichero(diagnosticModel.m_pathRelativo);
				pDicomManager->CargarFichero(pathDiagnostic, baseDiagnostic);

				for (GNC::GCS::IControladorModulo::TMapaTagsPrivados::iterator itModulos = m_pMergeParams->m_mapTagsPrivadosReplace.begin(); itModulos != m_pMergeParams->m_mapTagsPrivadosReplace.end(); ++itModulos)
				{
					GnkPtr<GIL::DICOM::TipoPrivateTags> pTags(new GIL::DICOM::TipoPrivateTags((*itModulos).first));
					pDicomManager->CargarTagsPrivados(*pTags);
					privateTagsDiagnosticList[(*itModulos).first] = pTags;
				}
			}


			pDicomManager->CargarFichero((*itOld).m_path);

			AdaptSRDataset(baseDiagnostic, privateTagsDiagnosticList, (*itNew), uidEstudio);

			pDicomManager->ActualizarJerarquia(baseDiagnostic);

			pDicomManager->ActualizarJerarquia(m_pMergeParams->m_anonymizedTags);

			if (m_pMergeParams->m_includeGinkgoTags) {
				for (TMapaTagsPrivados::iterator itTagsPrivados = privateTagsDiagnosticList.begin(); itTagsPrivados != privateTagsDiagnosticList.end(); ++itTagsPrivados)
				{
					pDicomManager->ActualizarTagsPrivados((*(*itTagsPrivados).second));
				}
			} else {
				pDicomManager->AnonimizarTagsPrivados();
			}

			wxString pathNewImage = GetFichero(m_pMergeParams->m_tempPath, wxT("dcm"));
			pDicomManager->AlmacenarFichero(std::string(TOPATH(pathNewImage)));
			(*itNew).m_path = TOPATH(pathNewImage);
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pDicomManager);
		}

		return true;
	}

	void ComandoMergeDiagnosticWithImage::AdaptSRDataset(GIL::DICOM::TipoJerarquia& data, TMapaTagsPrivados&  privateTagsDiagnosticList, const ComandoMergeDiagnosticWithImageParams::T_File& newFile, const std::string& uidEstudio)
	{
		data.tags["0020|000d"] = uidEstudio;
		//series instance uid
		data.tags["0020|000e"] = newFile.m_seriesInstance;
		//sop instance uid
		data.tags["0008|0018"] = newFile.m_sopInstance;

		//tags erased
		{
			std::string tagsRemove[13] = {"0008|0005","0008|0060","0008|0016", "0008|0032","0008|0033","0040|a040","0020|0010","0020|0011","0020|0012","0020|0013","0040|a050","0040|a491","0040|a493"};
			GIL::DICOM::ListaTags::iterator it;
			for (int i = 0; i< 13; ++i) {
				it = data.tags.find(tagsRemove[i]);
				if (it != data.tags.end()) {
					data.tags.erase(it);
				}
			}
		}
		{
			//secuencias
			for (GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it = data.secuencias.begin(); it != data.secuencias.end(); ++it)
			{
				if ((*it).tagName == "0040|a372") {
					data.secuencias.erase(it);
					break;
				}
			}
			for (GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it = data.secuencias.begin(); it != data.secuencias.end(); ++it)
			{
				if ((*it).tagName == "0008|1140") {
					data.secuencias.erase(it);
					break;
				}
			}
		}
		//tags where we have to search/replace...
		{
			for(GNC::GCS::IControladorModulo::TMapaTagsPrivados::iterator itModulos = m_pMergeParams->m_mapTagsPrivadosReplace.begin(); itModulos != m_pMergeParams->m_mapTagsPrivadosReplace.end(); ++itModulos)
			{
				GnkPtr<GIL::DICOM::TipoPrivateTags>& pJerarquia = privateTagsDiagnosticList[(*itModulos).first];
				for (GNC::GCS::IControladorModulo::TListaIdsTagsPrivados::iterator itTagsPrivados = (*itModulos).second.begin(); itTagsPrivados != (*itModulos).second.end(); ++itTagsPrivados)
				{
					wxString wxTmp;
					if ((*itTagsPrivados).type == GNC::GCS::IControladorModulo::TPrivateTagReemplazable::XML) {
						wxXmlDocument documento;
						GIL::DICOM::TagPrivadoUndefined* pTagWidgets = pJerarquia->GetTagUndefined((*itTagsPrivados).id);
						if(pTagWidgets != NULL){
							{
								wxMemoryInputStream input(pTagWidgets->GetValor(),pTagWidgets->GetSize());
								documento.Load(input,wxT("UTF 8"));
							}
							if(documento.IsOk()){
								{
									wxStringOutputStream ostream;
									documento.Save(ostream);
									wxTmp = ostream.GetString();
								}

								//replaces...
								for (std::map<wxString, wxString>::iterator itMapa = m_pMergeParams->m_mapSeriesUIDs.begin(); itMapa != m_pMergeParams->m_mapSeriesUIDs.end(); ++itMapa)
								{
									wxTmp.Replace(wxT("\"") + (*itMapa).first + wxT("\""), wxT("\"") + (*itMapa).second + wxT("\""));
								}
								for (std::map<wxString, wxString>::iterator itMapa = m_pMergeParams->m_mapSopUIDs.begin(); itMapa != m_pMergeParams->m_mapSopUIDs.end(); ++itMapa)
								{
									wxTmp.Replace(wxT("\"") + (*itMapa).first + wxT("\""), wxT("\"") + (*itMapa).second + wxT("\""));
								}
								//writes
								{
									bool addCaracter =false;
									wxFileOffset longitud = wxTmp.size();
									if(longitud%2!=0){
										longitud++;
										addCaracter = true;
									}
									if(addCaracter){
										wxTmp += wxT(" ");
									}
									std::string str(wxTmp.ToUTF8());
									pJerarquia->SetTag((*itTagsPrivados).id, (unsigned char*) str.c_str(),longitud);
								}
							}
						}
					} else {
						//std mode
						std::string tmpStr;
						if (pJerarquia->GetTag((*itTagsPrivados).id, tmpStr)) {
							wxString wxTmp = wxString::FromUTF8(tmpStr.c_str());

							//replaces...
							for (std::map<wxString, wxString>::iterator itMapa = m_pMergeParams->m_mapSeriesUIDs.begin(); itMapa != m_pMergeParams->m_mapSeriesUIDs.end(); ++itMapa)
							{
								wxTmp.Replace((*itMapa).first, (*itMapa).second);
							}
							for (std::map<wxString, wxString>::iterator itMapa = m_pMergeParams->m_mapSopUIDs.begin(); itMapa != m_pMergeParams->m_mapSopUIDs.end(); ++itMapa)
							{
								wxTmp.Replace((*itMapa).first, (*itMapa).second);
							}

							pJerarquia->SetTag((*itTagsPrivados).id, std::string(wxTmp.ToUTF8()));
						}
					}
				}
			}
		}
	}

	void ComandoMergeDiagnosticWithImage::Update()
	{
		if (m_pMergeParams->m_commandType == ComandoMergeDiagnosticWithImageParams::TC_UPLOAD)
		{
			BorrarArchivosTemporales(m_pMergeParams->m_tempPath);
		}
	}


	bool  ComandoMergeDiagnosticWithImage::BorrarArchivosTemporales(wxString& dirPath)
	{
		//borra en cascada
		if(!wxRmdir(dirPath)){
			//vaciar
			wxDir dir;
			if (dir.Open(dirPath)) {
				wxString fileName;
				bool cont = dir.GetFirst(&fileName);
				while (cont) {
					fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;
					if(wxDir::Exists(fileName)){
						if (BorrarArchivosTemporales(fileName)) {
							cont = dir.GetFirst(&fileName);
						} else {
							cont = dir.GetNext(&fileName);
						}
					}else{
						if (wxRemoveFile(fileName)) {
							cont = dir.GetFirst(&fileName);
						} else {
							cont = dir.GetNext(&fileName);
						}
					}
				}
			}
		}
		if(wxDir::Exists(dirPath)){
			return wxRmdir(dirPath);
		}
		return true;
	}

	wxString ComandoMergeDiagnosticWithImage::GetFichero(const wxString& dir, const wxString& extension){
		wxString destino(wxEmptyString);
		std::string nombre (wxDateTime::Now().Format(_("image_%m-%d-%Y_")).ToUTF8());
		std::string stdDir(TOPATH(dir));
		std::string stdExtension(TOPATH(extension));
		int indice=0;
		//yy-mm-dd_imagen_indice
		do {
			std::ostringstream ostr;
			ostr << stdDir << (char)wxFileName::GetPathSeparator() << nombre << indice++ << "." << stdExtension;
			destino = FROMPATH(ostr.str());
		} while(wxFile::Exists(destino));
		return destino;
	}

	void ComandoMergeDiagnosticWithImage::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
	{
		GNC::GCS::Eventos::EventoProgresoComando* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoProgresoComando*> (evt);
		GNC::GCS::IComando* pCmd = pEvt->GetComando();
		if (pEvt == NULL  || pEvt->GetComando() == NULL || pCmd != m_pMergeParams->m_pComandoEspera) {
			//LOG_TRACE("ComandoDicomizacionIntegracion", "Evento ignorado. No corresponde al comando de interes");
			return;
		} else {
			if (pEvt->GetTipo() == GNC::GCS::Eventos::EventoProgresoComando::TEP_Finalizado)
			{
				m_pMergeParams->m_SemaforoEsperarComando.Post();
			}
		}
	}

};
