/*
*  
*  $Id: volumedataset.h 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#include <list>
#include <yasper/yasper.h>
#include <api/math/geometria3d.h>
#include <vtkSmartPointer.h>

class vtkImageData;

namespace GNC {
	namespace GCS {
		class IContextoEstudioReferido;
	}
}

namespace MedicalViewer {
	namespace Reconstruction {
		namespace DataSet {

			class Slice {
			public:
				GNC::GCS::GVector3D<int, int>       dims;
				GNC::GCS::GVector3D<double, double> origin;
				GNC::GCS::GVector3D<double, double> spacing;
				double cosines[9];
				int id;

				Slice(int id);
			};

			typedef std::list< GnkPtr<Slice> > SliceList;

			class DataSet : public SliceList {
			public:

				typedef Slice TSlice;

				GnkPtr<GNC::GCS::IContextoEstudioReferido> RefStudy;
				vtkSmartPointer<vtkImageData> Img;

				GNC::GCS::GVector3D<int, int>       dims;
				GNC::GCS::GVector3D<double, double> origin;
				GNC::GCS::GVector3D<double, double> spacing;
				GNC::GCS::GVector3D<double, double> vdir;
				double cosines[9];

				short MinValue;
				short MaxValue;

				DataSet(const GnkPtr<GNC::GCS::IContextoEstudioReferido>& ref, const GnkPtr<Slice>& slice);

				~DataSet();

				void Compute();

				/** Checks if the slice with corresponding cosines can belongs to this dataset **/
				bool Add(const GnkPtr<Slice>& slice);

			protected:
				void DoAdd(const GnkPtr<Slice>& slice);
			};

			typedef std::list< GnkPtr<DataSet> > DataSetList;
		}
	}
}
