/*
 *  
 *  $Id: selectimagesimportationvisualizator.h 4303 2011-10-18 10:31:44Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include <string>
#include <vector>
#include "datospersistentesimportacion.h"
#include <api/dicom/idicomizador.h>
#include <wx/ginkgostyle/ginkgostyle.h>
#include <main/gui/import/selectimagesimportation.h>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

namespace GNKVisualizator {
	namespace GUI {

		class SelectImagesImportationVisualizator: public GNC::GUI::SelectImagesImportation
		{
			public:
				SelectImagesImportationVisualizator(wxWindow* pParent,IWizard* pWizard,const GnkPtr<TipoWizardImportacion>& datosPersistentes,const std::string &dirTemporal);
				~SelectImagesImportationVisualizator();

				virtual bool Validar();

				virtual bool Dicomizar();

				void RellenarTagsComunes(GIL::DICOM::TipoJerarquia& base);

				GnkPtr<TipoWizardImportacion> m_pDatosPersistentes;
				std::string m_dirTemporal;
				bool m_dicomizado;
		};
	}
}
