/*
 *
 *  $Id: panelhistorial2.cpp 4367 2011-11-04 10:58:44Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/textfile.h>
#include <wx/imaglist.h>
#include <wx/menu.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/busyinfo.h>
#include <wx/bmpcbox.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include "panelhistorial2.h"
#include "panelserie.h"
#include "panelpaciente.h"
#include "panelestudio.h"
#include "dialogoconfirmacioneliminar.h"
#include <main/gui/import/wxwizardimportacionginkgo.h>
#include <main/gui/acquisition/dialogoadquisicion.h>
#include <main/gui/open/abrir.h>

#include <api/dicom/imodelodicom.h>
#include <eventos/eventosginkgo.h>

#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorpermisos.h>
#include <main/controllers/controladorhistorial.h>
#include <commands/comandoincluirhistorial.h>
#include <api/icontroladorcomandos.h>

#include <api/icontextoestudio.h>
#include <resources/ginkgoresourcemanager.h>

#include <sstream>

#include <api/dicom/imodelodicom.h>


#define ID_MENUS 1401
#define ID_EJECUTAR 1
#define ID_TITULO 0


namespace GNC {
	namespace GUI {

		class TimerRecargarHistorial:public wxTimer
		{
		public:
			TimerRecargarHistorial(PanelHistorial2* pHistorial){
				m_pHistorial = pHistorial;
			}

			~TimerRecargarHistorial()
			{
				m_pHistorial=NULL;
			}

			virtual void Notify()
			{
				m_pHistorial->RecargarBusqueda();
			}

			PanelHistorial2* m_pHistorial;
		};

		class wxDataPaciente: public wxClientData {
		public:
			wxDataPaciente(const GNC::GCS::ControladorHistorial::ModeloPaciente& modeloPaciente):wxClientData()
			{
				m_modeloPaciente = modeloPaciente;
			}
			~wxDataPaciente() {
			}
			GNC::GCS::ControladorHistorial::ModeloPaciente m_modeloPaciente;
		};


		PanelHistorial2::PanelHistorial2(wxWindow* parent) : PanelHistorial2Base(parent),
			INodoHistorial(NULL,"")
		{
			m_pTimerRecargar = new TimerRecargarHistorial(this);
			m_pacienteActual = _Std("All patients");
			m_modalidadActual = _Std("All modalities");
			m_fromActual = wxDateTime::Now();
			m_toActual = wxInvalidDateTime;
			//titulo
			m_pHistoryTitle->GetButtonBar()->AddTool(ID_EJECUTAR,_("Hide"),GinkgoResourcesManager::PanelHistorial::GetIcoPlegar(),_("Hide"), wxITEM_NORMAL);
			m_pHistoryTitle->GetButtonBar()->Connect(ID_EJECUTAR,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( PanelHistorial2::OnPlegarClick),NULL,this);
			m_pHistoryTitle->Realize();

			//titulo filtros
			m_pFiltersTitle->GetButtonBar()->AddTool(ID_EJECUTAR,_("Hide"),GinkgoResourcesManager::PanelHistorial::GetIcoPlegar(),_("Hide"), wxITEM_NORMAL);
			m_pFiltersTitle->GetButtonBar()->Connect(ID_EJECUTAR,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( PanelHistorial2::OnPlegarFilters),NULL,this);
			m_pFiltersTitle->Realize();

			{
				m_pComboBoxPaciente->Connect( wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler( PanelHistorial2::OnComboBox ), NULL, this );
			}

			m_pComboDate->Select(0);

			//se conecta el evento Ginkgo
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoModificacionFichero());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoAddFicheroHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoSeleccionarHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoLayoutHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoAbribleEliminado());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoRecargarHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoAddModeloHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoColorPaciente());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GUI::Eventos::EventoLimpiarHistorial());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EvtHandleDicom());			
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventView());
			GNC::Entorno::Instance()->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventDeleteFileHistory());

			m_pSeleccionado = NULL;

			SetSize(230, -1);
			SetMinSize(wxSize(230, -1));
			SetMaxSize(wxSize(230, -1));
			Layout();
		}

		PanelHistorial2::~PanelHistorial2() {
			//stores filter state
			{
				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/History", "PatientComboValue", std::string(m_pComboBoxPaciente->GetValue().ToUTF8()));
				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/History", "ModalityValue", std::string(m_pComboModalidad->GetValue().ToUTF8()));
				GNC::GCS::ConfigurationController::Instance()->writeIntUser("/GinkgoCore/History", "DateChoice", m_pComboDate->GetSelection());
				if (m_fromActual.IsValid()) {
					GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/History", "DateFrom", std::string(m_fromActual.Format(wxT("%Y/%m/%d")).ToUTF8()));
				} else {
					GNC::GCS::ConfigurationController::Instance()->deleteEntryUser("/GinkgoCore/History", "DateFrom");
				}

				if (m_toActual.IsValid()) {
					GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/History", "DateTo", std::string(m_toActual.Format(wxT("%Y/%m/%d")).ToUTF8()));
				} else {
					GNC::GCS::ConfigurationController::Instance()->deleteEntryUser("/GinkgoCore/History", "DateTo");
				}
			}

			//si es preciso limpiar historial...
			GNC::GCS::Permisos::EstadoPermiso estado = GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions", "anonymous_history");
			if (estado) {
				GNC::GCS::ControladorHistorial::Instance()->VaciarHistorial(true);
			}
			delete m_pTimerRecargar;

			this->Disconnect( wxEVT_SIZE, wxSizeEventHandler( PanelHistorial2::OnSize ) );
			this->Disconnect( wxEVT_RIGHT_UP, wxMouseEventHandler( PanelHistorial2::OnMenuMouse ), NULL, this );
		}

		void PanelHistorial2::RecargarCombos(bool comprobarPurga)
		{
			if (comprobarPurga) {
				//si es preciso limpiar historial...
				GNC::GCS::Permisos::EstadoPermiso estado = GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions", "anonymous_history");
				if (estado) {
					GNC::GCS::ControladorHistorial::Instance()->VaciarHistorial(true);
				}
			}

			//combo box pacientes
			GNC::GCS::ControladorHistorial::ListaModelosPaciente listaPacientes;
			GNC::GCS::ControladorHistorial::Instance()->GetAllPatients(listaPacientes);

			m_pComboBoxPaciente->Clear();

			m_pComboBoxPaciente->Append(_("All patients"), GinkgoResourcesManager::PanelHistorial::GetIcoAllPatients());

			if (m_pacienteActual == _Std("All patients")) {
				m_pComboBoxPaciente->Select(0);
			}
			m_pComboBoxPaciente->AppendString(wxT("-----------------------------"));

			for (GNC::GCS::ControladorHistorial::ListaModelosPaciente::iterator it = listaPacientes.begin(); it != listaPacientes.end(); ++it) {
				std::ostringstream ostr;
				ostr << (*it).m_nombrePaciente << " (" << (*it).m_idPaciente << ")";

				wxDataPaciente* pData = new wxDataPaciente((*it));
				int indice = -1;
				if ((*it).m_sexo == 'M'){
					indice = m_pComboBoxPaciente->Append(wxString::FromUTF8(ostr.str().c_str()), GinkgoResourcesManager::PanelHistorial::GetIcoHombre(), pData);
				}else if((*it).m_sexo =='F'){
					indice = m_pComboBoxPaciente->Append(wxString::FromUTF8(ostr.str().c_str()), GinkgoResourcesManager::PanelHistorial::GetIcoMujer(), pData);
				}else{
					indice = m_pComboBoxPaciente->Append(wxString::FromUTF8(ostr.str().c_str()), GinkgoResourcesManager::PanelHistorial::GetIcoOtro(), pData);
				}

				if ((*it).m_idPaciente == m_pacienteActual) {
					m_pComboBoxPaciente->Select(indice);
				}
			}
			if (m_pComboBoxPaciente->GetSelection() <0) {
				m_pComboBoxPaciente->Select(0);
			}

			//combo box modalidades
			m_pComboModalidad->Clear();
			m_pComboModalidad->AppendString(_("All modalities"));
			if (m_modalidadActual == _Std("All modalities")) {
				m_pComboModalidad->Select(0);
			}
			m_pComboModalidad->AppendString(wxT("-----------------------------"));

			std::list<std::string> listaModalidades;
			GNC::GCS::ControladorHistorial::Instance()->GetAllModalities(listaModalidades);
			for (std::list<std::string>::iterator it = listaModalidades.begin(); it !=  listaModalidades.end(); ++it) {
				int item = m_pComboModalidad->Append((wxString::FromUTF8((*it).c_str())));
				if (m_modalidadActual == (*it)) {
					m_pComboModalidad->Select(item);
				}
			}

			if (comprobarPurga) {
				//load filter state
				std::string strTmp;
				if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/History", "PatientComboValue", strTmp)) {
					int pos = m_pComboBoxPaciente->FindString(wxString::FromUTF8(strTmp.c_str()));
					if (pos >= 0) {
						m_pComboBoxPaciente->Select(pos);
					}
				}
				if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/History", "ModalityValue", strTmp)) {
					int pos = m_pComboModalidad->FindString(wxString::FromUTF8(strTmp.c_str()));
					if (pos >= 0) {
						m_pComboModalidad->Select(pos);
					}
				}
				int intTmp;
				if (GNC::GCS::ConfigurationController::Instance()->readIntUser("/GinkgoCore/History", "DateChoice", intTmp)) {
					m_pComboDate->Select(intTmp);
				}
				if (m_pComboDate->GetValue() == _("Between:")) {
					if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/History", "DateFrom", strTmp)) {
						wxDateTime from;
						from.ParseFormat(wxString::FromUTF8(strTmp.c_str()), wxT("%Y/%m/%d"),wxDateTime::Now());
						m_pDatePickerFrom->SetValue(from);
					}
					if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/History", "DateTo", strTmp)) {
						wxDateTime to;
						to.ParseFormat(wxString::FromUTF8(strTmp.c_str()), wxT("%Y/%m/%d"),wxDateTime::Now());
						m_pDatePickerTo->SetValue(to);
					}
				}
			}
		}

		void PanelHistorial2::CargarSeries( const GNC::GCS::IControladorHistorial::ListaModelosSeries& modelos, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
			Freeze();
			m_pPanelHistorial->Freeze();
			std::string uidScroll = "";
			{
				m_pPanelNoCabeMas->Show(false);

				bool refrescar = false;
				for(GNC::GCS::ControladorHistorial::ListaModelosSeries::const_iterator it = modelos.begin(); it!= modelos.end(); it++) {
					GNC::GCS::ControladorHistorial::ModeloSerie modeloControlador = (*it);

					if(m_mapaUIDsAbribles.find(modeloControlador.m_uidSerie) != m_mapaUIDsAbribles.end()){
						uidScroll = modeloControlador.m_uidSerie;
					} else {
						if(modeloControlador.m_modalidad != "SR") {
							//se rellena el modelo
							PanelPaciente* pPaciente = GetPaciente(modeloControlador);
							refrescar = true;
							if (pPaciente != NULL) {
								uidScroll = modeloControlador.m_uidSerie;
								m_mapaUIDsAbribles[modeloControlador.m_uidSerie] = pPaciente;
								pPaciente->AddModeloSerie(modeloControlador);
								refrescar = true;
							} else {
								//no caben más pacientes...
								m_pPanelNoCabeMas->Show(true);
								m_pPanelHistorial->Layout();
								refrescar = true;
								break;
							}
						}
					}
				}
				if (refrescar) {
					m_pResultTitle->SetTitle(_("Results") + wxString::Format(_(" (%d series)"), m_mapaUIDsAbribles.size()));
					GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
				}

				if(uidScroll != "") {
					PanelSerie* pPanel = m_mapaUIDsAbribles[uidScroll]->GetSeries(uidScroll, true);
					wxWindow* pWin = dynamic_cast<wxWindow*>(pPanel);
					if(pWin!=NULL) {
						int pixelsx,pixelsy;
						m_pPanelHistorial->GetScrollPixelsPerUnit(&pixelsx,&pixelsy);
						wxPoint punto(0,0);
						wxWindow* pParent = pWin;
						do {
							punto.y += pParent->GetPosition().y;
							pParent = pParent->GetParent();
						}while (pParent != this);
						int x,y;
						m_pPanelHistorial->CalcUnscrolledPosition(punto.x,punto.y,&x,&y);
						m_pPanelHistorial->Scroll(0,y/pixelsy);
					}else {
						m_pPanelHistorial->Scroll(0,0);
					}
				} else {
					m_pPanelHistorial->Scroll(0,0);
				}
				GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
				Thaw();
				m_pPanelHistorial->Thaw();
			}
		}

		void PanelHistorial2::CargarDCMs( const GNC::GCS::IControladorHistorial::ListaModelosDCM& modelos, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion, bool desplegarNodo)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
			Freeze();
			m_pPanelHistorial->Freeze();
			std::string uidScroll = "";
			{
				m_pPanelNoCabeMas->Show(false);

				bool refrescar = false;
				//los ficheros que pertenecen a series que ya existen provocan el refresco
				std::set<std::string> listaRefrescarSlices;
				for(GNC::GCS::ControladorHistorial::ListaModelosDCM::const_iterator it = modelos.begin(); it!= modelos.end(); it++) {
					GNC::GCS::ControladorHistorial::ModeloDCM modeloDCM = (*it);

					if(m_mapaUIDsAbribles.find(modeloDCM.m_uidSerie) != m_mapaUIDsAbribles.end()){
						uidScroll = modeloDCM.m_uidSerie;
						listaRefrescarSlices.insert(modeloDCM.m_uidSerie);
					}
				}

				//ahora se meten las nuevas series
				for(GNC::GCS::ControladorHistorial::ListaModelosDCM::const_iterator it = modelos.begin(); it!= modelos.end(); it++) {
					GNC::GCS::ControladorHistorial::ModeloDCM modeloDCM = (*it);

					if(m_mapaUIDsAbribles.find(modeloDCM.m_uidSerie) != m_mapaUIDsAbribles.end()){
						uidScroll = modeloDCM.m_uidSerie;

						PanelSerie* pPanel = m_mapaUIDsAbribles[modeloDCM.m_uidSerie]->GetSeries(modeloDCM.m_uidSerie);
						if (pPanel != NULL) {
							pPanel->IncrementarNumeroSlices();
						}
					} else {
						if(modeloDCM.m_modalidad != "SR") {
							GNC::GCS::ControladorHistorial::ModeloSerie modeloSerie(modeloDCM);
							//se rellena el modelo
							PanelPaciente* pPaciente = GetPaciente(modeloSerie, desplegarNodo);
							if (pPaciente != NULL) {
								m_mapaUIDsAbribles[modeloSerie.m_uidSerie] = pPaciente;
								uidScroll = modeloDCM.m_uidSerie;
								pPaciente->AddModeloSerie(modeloSerie);
								refrescar = true;
							} else {
								//no caben más pacientes
								m_pPanelNoCabeMas->Show(true);
								m_pPanelHistorial->Layout();
								refrescar = true;
								break;
							}
						}
					}
				}
				//por último se refresca el numero d slices de las series que exisitian
				for (std::set<std::string>::iterator it = listaRefrescarSlices.begin(); it != listaRefrescarSlices.end(); ++it) {
					PanelSerie* pPanel = m_mapaUIDsAbribles[(*it)]->GetSeries((*it));
					if (pPanel != NULL) {
						pPanel->RefrescarNumeroSlices();
					}
				}


				if (refrescar) {
					m_pResultTitle->SetTitle(_("Results") + wxString::Format(_(" (%d series)"), m_mapaUIDsAbribles.size()));
					GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
				}

				if(uidScroll != "") {
					PanelSerie* pPanel = m_mapaUIDsAbribles[uidScroll]->GetSeries(uidScroll, true);
					wxWindow* pWin = dynamic_cast<wxWindow*>(pPanel);
					if(pWin!=NULL) {
						int pixelsx,pixelsy;
						m_pPanelHistorial->GetScrollPixelsPerUnit(&pixelsx,&pixelsy);
						wxPoint punto(0,0);
						wxWindow* pParent = pWin;
						do {
							punto.y += pParent->GetPosition().y;
							pParent = pParent->GetParent();
						}while (pParent != this);
						int x,y;
						m_pPanelHistorial->CalcUnscrolledPosition(punto.x,punto.y,&x,&y);
						m_pPanelHistorial->Scroll(0,y/pixelsy);
					}else {
						m_pPanelHistorial->Scroll(0,0);
					}
				} else {
					m_pPanelHistorial->Scroll(0,0);
				}
			}
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
			Thaw();
			m_pPanelHistorial->Thaw();
		}

		//cargo pasando el path si es directorio cargo uno a uno... eso creo q no es asi xo bueno...
	/*	void PanelHistorial2::CargarDICOM( const std::vector<std::string>& paths, bool abrirDespuesDeCargar,GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
		{
			//controlador historial....
			GNC::GCS::ControladorHistorial::ListaModelosDCM listaModelos;
			GNC::GCS::ControladorHistorial::ListaModelosDCM listaModelosSR;
			GNC::GCS::ControladorHistorial::ListaPaths rutasAdd;
			GNC::GCS::ControladorHistorial::ListaPaths rutasModificar;
			for(std::vector<std::string>::const_iterator it = paths.begin(); it != paths.end(); ++it){
				wxString wxPath = FROMPATH((*it));
				if(wxFileExists(wxPath)){
					std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero((*it));
					if(!GNC::GCS::ControladorHistorial::Instance()->ExisteFichero(pathRelativo)) {
						rutasAdd.push_back((*it));
					} else {
						if(m_mapaPathsAbribles.find((*it)) != m_mapaPathsAbribles.end()){
							GNC::GCS::ControladorHistorial::ModeloDCM modelo;
							modelo.m_pathRelativo = pathRelativo;
							listaModelos.push_back(modelo);
						} else {
							//es un "SR" que posiblemente se ha modificado, lo refrescamos
							rutasModificar.push_back((*it));
						}
					}
				} else if(wxDirExists(wxPath)) {
					//se listan los dcms del directorio y se cargan
					wxDir dir;
					std::vector<std::string> dcmEnElDirectorio;
					if (dir.Open(wxPath)) {
						wxString dcmName;
						bool cont = dir.GetFirst(&dcmName,wxT("*.dcm"));
						while (cont) {
							dcmName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +dcmName;
							dcmEnElDirectorio.push_back(std::string(TOPATH(dcmName)));
							cont = dir.GetNext(&dcmName);
						}
					}
					for(std::vector<std::string>::iterator it2=dcmEnElDirectorio.begin();it2!=dcmEnElDirectorio.end();++it2){
						std::string pathRelativo = GNC::Entorno::Instance()->GetPathRelativoFichero((*it2));
						if(!GNC::GCS::ControladorHistorial::Instance()->ExisteFichero(pathRelativo)) {
							rutasAdd.push_back((*it2));
						} else {
							if(m_mapaPathsAbribles.find((*it2)) != m_mapaPathsAbribles.end()){
								GNC::GCS::ControladorHistorial::ModeloDCM modelo;
								modelo.m_pathRelativo = pathRelativo;
								listaModelos.push_back(modelo);
							} else {
								//es un "SR" que posiblemente se ha modificado, lo refrescamos
								rutasModificar.push_back((*it2));
							}
						}
					}
				}
			}
			if(rutasAdd.size()>0 || rutasModificar.size() >0){
				wxBusyInfo* info = new wxBusyInfo(_("Updating History..."),this);
				GNC::Entorno::Instance()->YieldApp();
				GNC::GCS::ControladorHistorial::ListaPaths fooLista;
				if(GNC::GCS::ControladorHistorial::Instance()->AddFiles(rutasAdd, listaModelos, fooLista, true) && GNC::GCS::ControladorHistorial::Instance()->UpdateFiles(rutasModificar,listaModelosSR)){
					delete info;
					CargarDICOM(listaModelos,abrirDespuesDeCargar,pModeloIntegracion);
				} else {
					delete info;
				}
			} else {
				CargarDICOM(listaModelos, abrirDespuesDeCargar, pModeloIntegracion);
			}
		}*/


		//ya esta cargado... me avisan
		void PanelHistorial2::DICOMActivado(GNC::GCS::IVista* pVista)
		{
			for(std::list<std::string>::const_iterator it = pVista->GetEstudio()->ListaUIDsSerie.begin(); it != pVista->GetEstudio()->ListaUIDsSerie.end(); ++it){
				TMapaAbribles::iterator it2 = m_mapaUIDsAbribles.find( (*it) );
				if(it2 != m_mapaUIDsAbribles.end()){
					//ya esta metido
					PanelSerie* pPanel = (*it2).second->GetSeries((*it), true);
					if (pPanel != NULL) {
						pPanel->AddVista(pVista);
					}
				}
				else{
					std::cerr << _Std("error, have tried to select a file that is not added to history")<<std::endl;
				}
			}
		}

		//Se desactiva...
		void PanelHistorial2::DICOMDesactivado(GNC::GCS::IVista* pVista)
		{
			for(std::list<std::string>::const_iterator it = pVista->GetEstudio()->ListaUIDsSerie.begin(); it != pVista->GetEstudio()->ListaUIDsSerie.end(); ++it){
				TMapaAbribles::iterator it2 = m_mapaUIDsAbribles.find( (*it) );
				if(it2 != m_mapaUIDsAbribles.end()){
					//ya esta metido
					//ya esta metido
					PanelSerie* pPanel = (*it2).second->GetSeries((*it), true);
					if (pPanel != NULL) {
						pPanel->RemoveVista(pVista);
					}
				}
				else{
					std::cerr << _Std("error, have tried to select a file that is not added to history")<<std::endl;
				}
			}

			PurgarHistorial(true);
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
		}


//region "Eventos"

		//interfaz modelo dicom
		PanelPaciente* PanelHistorial2::GetPaciente(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie, bool desplegarNodo)
		{
			TMapaHijos::iterator it=m_mapaHijos.find(modeloSerie.m_idPaciente);
			if(it!=m_mapaHijos.end()){
				return (PanelPaciente*)(*it).second;
			}else{
				//si el virtual size pasa de 16 bits (32000 pasan cosas malas) hay que dejar un margen para desplegar
				if (m_pPanelHistorial->GetVirtualSize().y < 30000) {
					if(m_pPanelMensajeVacio->IsShown()) {
						m_pPanelMensajeVacio->Hide();
					}
					if (desplegarNodo) {
						//si el virtual size pasa de 16 bits (32000 pasan cosas malas)
						desplegarNodo = m_pPanelHistorial->GetVirtualSize().y < 25000;
					}
					PanelPaciente* pPanelPaciente = new PanelPaciente(this,m_pPanelHistorial,modeloSerie, desplegarNodo);
					m_pPanelHistorial->GetSizer()->Add(pPanelPaciente,0,wxBOTTOM|wxEXPAND,0);
					m_pPanelHistorial->Layout();
					m_mapaHijos[modeloSerie.m_idPaciente]=pPanelPaciente;
					return pPanelPaciente;
				} else {
					//implica que no caben todos...
					return NULL;
				}
			}
		}

		wxColour PanelHistorial2::GetColorPaciente(const std::string& idPaciente)
		{
			TMapaHijos::iterator it=m_mapaHijos.find(idPaciente);
			if(it!=m_mapaHijos.end()){
				return ((PanelPaciente*)(*it).second)->GetBackgroundColour();
			}
			return wxColour(49,106,197);
		}
		//

		void PanelHistorial2::ForzarCargarTodos()
		{
			m_pComboBoxPaciente->SetSelection(m_pComboBoxPaciente->FindString(_("All patients")) );
			m_pacienteActual = _Std("All patients");
			//se eliminan todos los estudios que no están abiertos
			Freeze();
			//se eliminan los nodos que ya no van a valer
			PurgarHistorial(false);

			//pillamos los estudios del paciente seleccionado
			GNC::GCS::ControladorHistorial::ListaModelosSeries listaSeries;
			GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerie(listaSeries);
			CargarSeries(listaSeries, NULL);
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			Thaw();
		}

		std::list<std::string> PanelHistorial2::GetOpenedSeriesUIDs()
		{
			std::list<std::string> result;
			for (TMapaAbribles::iterator it = m_mapaUIDsAbribles.begin(); it !=  m_mapaUIDsAbribles.end(); ++it)
			{
				GNC::GUI::PanelSerie* pPanel = (*it).second->GetSeries((*it).first);
				if (pPanel != NULL && pPanel->EstaAbierto()) {
					result.push_back((*it).first);
				}
			}
			return result;
		}

		std::list<std::string> PanelHistorial2::GetOpenedStudiesUIDs()
		{
			std::set<std::string> studies;
			for (TMapaAbribles::iterator it = m_mapaUIDsAbribles.begin(); it !=  m_mapaUIDsAbribles.end(); ++it)
			{
				GNC::GUI::PanelSerie* pPanel = (*it).second->GetSeries((*it).first);
				if (pPanel != NULL && pPanel->EstaAbierto()) {
					studies.insert(pPanel->GetParentNode()->GetClave());
				}
			}
			std::list<std::string> result;
			for(std::set<std::string>::iterator it = studies.begin(); it != studies.end(); ++it)
			{
				result.push_back((*it));
			}
			return result;
		}

		GNC::GCS::IVista* PanelHistorial2::GetVistaFromSeriesUID(const std::string& uid)
		{
			TMapaAbribles::iterator it = m_mapaUIDsAbribles.find(uid);
			if (it != m_mapaUIDsAbribles.end()) {
				GNC::GUI::PanelSerie* pPanel = (*it).second->GetSeries((*it).first);
				if (pPanel != NULL && pPanel->EstaAbierto()) {
					return pPanel->m_pVistas.front();
				}
			}
			return NULL;
		}

		GNC::GCS::IVista* PanelHistorial2::GetVistaFromStudyUID(const std::string& uid)
		{
			for (TMapaAbribles::iterator it = m_mapaUIDsAbribles.begin(); it !=  m_mapaUIDsAbribles.end(); ++it)
			{
				GNC::GUI::PanelSerie* pPanel = (*it).second->GetSeries((*it).first);
				if (pPanel != NULL && pPanel->EstaAbierto()) {
					if (pPanel->GetParentNode()->GetClave() == uid)
					{
						return pPanel->m_pVistas.front();
					}
				}
			}
			
			return NULL;
		}

		void PanelHistorial2::OnCheckFromClick(wxCommandEvent &)
		{
			m_pTimerRecargar->Stop();
			m_pTimerRecargar->Start(500,true);
		}

		void PanelHistorial2::OnCheckToClick(wxCommandEvent &)
		{
			m_pTimerRecargar->Stop();
			m_pTimerRecargar->Start(500,true);
		}

		void PanelHistorial2::OnPlegarFilters(wxCommandEvent&)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
			m_pFiltersPanel->Show(!m_pFiltersPanel->IsShown());
			if (m_pFiltersPanel->IsShown()) {
				m_pFiltersTitle->GetButtonBar()->SetToolBitmap(ID_EJECUTAR, GinkgoResourcesManager::PanelHistorial::GetIcoPlegar());
			} else {
				m_pFiltersTitle->GetButtonBar()->SetToolBitmap(ID_EJECUTAR, GinkgoResourcesManager::PanelHistorial::GetIcoDesplegar());
			}
			Layout();
			Refresh(true);
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
		}

		void PanelHistorial2::OnPlegarClick(wxCommandEvent& )
		{
			Plegar(true);
		}

		void PanelHistorial2::OnDesplegar(wxMouseEvent& )
		{
			Plegar(false);
		}

		void PanelHistorial2::Plegar(bool plegar)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
			if (!plegar) {
				SetSize(230, -1);
				SetMinSize(wxSize(230, -1));
				SetMaxSize(wxSize(300, -1));
			} else {
				SetSize(20, -1);
				SetMinSize(wxSize(26, -1));
			}
			GetParent()->Layout();
			m_pPanelHistorial->Show(!plegar);
			m_pFiltersPanel->Show(!plegar);
			m_pFiltersTitle->Show(!plegar);
			m_pResultTitle->Show(!plegar);
			m_pHistoryTitle->Show(!plegar);
			m_pPanelVertical->Show(plegar);
			if (m_pFiltersPanel->IsShown()) {
				m_pFiltersTitle->GetButtonBar()->SetToolBitmap(ID_EJECUTAR, GinkgoResourcesManager::PanelHistorial::GetIcoPlegar());
			} else {
				m_pFiltersTitle->GetButtonBar()->SetToolBitmap(ID_EJECUTAR, GinkgoResourcesManager::PanelHistorial::GetIcoDesplegar());
			}
			Layout();
			GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
		}

		void PanelHistorial2::OnDateFromChanged( wxDateEvent&  )
		{
			m_pComboDate->Select(m_pComboDate->FindString(_("Between:")));
			m_pTimerRecargar->Stop();
			m_pTimerRecargar->Start(500,true);
		}

		void PanelHistorial2::OnDateToChanged( wxDateEvent&  )
		{
			m_pComboDate->Select(m_pComboDate->FindString(_("Between:")));
			m_pTimerRecargar->Stop();
			m_pTimerRecargar->Start(500,true);
		}

		void PanelHistorial2::OnComboBox( wxCommandEvent& )
		{
			m_pTimerRecargar->Stop();
			m_pTimerRecargar->Start(500,true);
		}

		void PanelHistorial2::RecargarBusqueda(bool force)
		{
			bool cambio = false;
			if (m_pComboBoxPaciente->GetSelection() >= 0) {
				if (m_pComboBoxPaciente->GetSelection() > 1) {
					wxDataPaciente* pPaciente = (wxDataPaciente*)(m_pComboBoxPaciente->GetClientObject(m_pComboBoxPaciente->GetSelection()));
					std::string idPacienteSeleccionado = pPaciente->m_modeloPaciente.m_idPaciente;
					if (idPacienteSeleccionado != m_pacienteActual) {
						m_pacienteActual = idPacienteSeleccionado;
						cambio  = true;
					}
				} else if (m_pComboBoxPaciente->GetSelection() == 0) {
					wxString stringSeleccionado = m_pComboBoxPaciente->GetString(m_pComboBoxPaciente->GetSelection());
					if (stringSeleccionado == _("All patients") && m_pacienteActual != _Std("All patients")) {
						m_pacienteActual = std::string(stringSeleccionado.ToUTF8());
						cambio = true;
					}
				}
			}

			//distinto del separador
			if (m_pComboModalidad->GetSelection() >= 0) {
				if (m_pComboModalidad->GetSelection() != 1) {
					std::string modalidadSeleccionada (m_pComboModalidad->GetString(m_pComboModalidad->GetSelection()).ToUTF8());
					if (modalidadSeleccionada != m_modalidadActual) {
						m_modalidadActual = modalidadSeleccionada;
						cambio = true;
					}
				}
			}
			
			wxDateTime newFechaDesde = wxInvalidDateTime, newFechaHasta = wxInvalidDateTime;
			std::string timeFrom(""), timeTo("");
			if (m_pComboDate->GetValue() == _("Between:")) {
				newFechaDesde = m_pDatePickerFrom->GetValue();
				newFechaHasta = m_pDatePickerTo->GetValue();
			} else if (m_pComboDate->GetValue() == _("Today") || m_pComboDate->GetValue() == _("Today AM") || m_pComboDate->GetValue() == _("Today PM")) {
				newFechaDesde = newFechaHasta = wxDateTime::Now();
				if (m_pComboDate->GetValue() == _("Today AM")) {
					timeFrom = "00:00:00";
					timeTo = "11:59:59";
				} else if (m_pComboDate->GetValue() == _("Today PM")) {
					timeFrom = "12:00:00";
					timeTo = "23:59:59";
				}
			} else if (m_pComboDate->GetValue() == _("Yesterday")) {
				newFechaDesde = newFechaHasta = wxDateTime::Now().Add(wxDateSpan(0,0,0,-1));
				m_pDatePickerTo->SetValue(wxDateTime::Now());
			} else if (m_pComboDate->GetValue() == _("Last week")) {
				newFechaDesde = wxDateTime::Now().Add(wxDateSpan(0,0,-1,0));
				m_pDatePickerTo->SetValue(wxDateTime::Now());
			} else if (m_pComboDate->GetValue() == _("Last month")) {
				newFechaDesde = wxDateTime::Now().Add(wxDateSpan(0,-1,0,0));
				m_pDatePickerTo->SetValue(wxDateTime::Now());
			} else if (m_pComboDate->GetValue() == _("Last 3 months")) {
				newFechaDesde = wxDateTime::Now().Add(wxDateSpan(0,-3,0,0));
				m_pDatePickerTo->SetValue(wxDateTime::Now());
			} //else any date (invalid datetimes)

			if ((newFechaDesde.IsValid() && !m_fromActual.IsValid()) || (!newFechaDesde.IsValid() && m_fromActual.IsValid()) ||
				(newFechaDesde.IsValid() && m_fromActual.IsValid() && newFechaDesde != m_fromActual))
			{
				cambio = true;
				m_fromActual = newFechaDesde;
			}
			if ((newFechaHasta.IsValid() && !m_toActual.IsValid()) || (!newFechaHasta.IsValid() && m_toActual.IsValid()) ||
				(newFechaHasta.IsValid() && m_toActual.IsValid() && newFechaHasta != m_toActual))
			{
				cambio = true;
				m_toActual = newFechaHasta;
			}
			if (m_fromActual.IsValid()) {
				m_pDatePickerFrom->SetValue(m_fromActual);
			}
			if (m_toActual.IsValid()) {
				m_pDatePickerTo->SetValue(m_toActual);
			}

			if (cambio || force) {
				//se eliminan todos los estudios que no están abiertos
				Freeze();
				//se eliminan los nodos que ya no van a valer
				PurgarHistorial(false);

				//pillamos los estudios del paciente seleccionado
				GNC::GCS::ControladorHistorial::ListaModelosSeries listaSeries;
				GNC::GCS::ControladorHistorial::Instance()->GetModelosSeriePacienteModalidad(m_pacienteActual, m_modalidadActual, m_fromActual, m_toActual, timeFrom, timeTo, listaSeries);
				CargarSeries(listaSeries, NULL);
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
				m_pResultTitle->SetTitle(_("Results") + wxString::Format(_(" (%d series)"), m_mapaUIDsAbribles.size()));
				Thaw();
			}
		}

		void PanelHistorial2::PurgarHistorial(bool ignoreActual)
		{
			Freeze();

			if (ignoreActual) {

				//#1 eliminamos los estudios de pacientes que sobran
				{
					std::list<GNC::GUI::INodoHistorial*> listaEliminar;
					bool todosLosPacientes = m_pacienteActual == _Std("All patients");
					if (!todosLosPacientes) {
						for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
							if (ignoreActual) {
								if (((PanelPaciente*)(*it).second)->GetIdPaciente() == m_pacienteActual )
									continue;
							}
							if ((*it).second->HayNodosAbiertos()) {
								(*it).second->EliminarNodosNoAbiertos();
							} else {
								listaEliminar.push_back((*it).second);
							}
						}
					}
					for (std::list<GNC::GUI::INodoHistorial*>::iterator it = listaEliminar.begin(); it != listaEliminar.end(); ++it) {
						(*it)->Eliminar();
					}
				}
				//#2 eliminamos las series que sobran por modalidad
				{
					std::list<GNC::GUI::INodoHistorial*> listaEliminar;
					bool todosLasModalidades = m_modalidadActual == _Std("All modalities");
					if (!todosLasModalidades) {
						for (TMapaAbribles::iterator it = m_mapaUIDsAbribles.begin(); it != m_mapaUIDsAbribles.end(); ++it) {
							PanelSerie* pPanel = (*it).second->GetSeries((*it).first);
							if (pPanel != NULL) {
								if (!pPanel->EstaAbierto() && pPanel->GetModalidad() != m_modalidadActual) {
									listaEliminar.push_back( pPanel);
								}
							}
						}
					}
					for (std::list<GNC::GUI::INodoHistorial*>::iterator it = listaEliminar.begin(); it != listaEliminar.end(); ++it) {
						(*it)->Eliminar();
					}
				}
			} else {
				std::list<GNC::GUI::INodoHistorial*> listaEliminar;
				for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
					if ((*it).second->HayNodosAbiertos()) {
						(*it).second->EliminarNodosNoAbiertos();
					} else {
						listaEliminar.push_back((*it).second);
					}
				}
				for (std::list<GNC::GUI::INodoHistorial*>::iterator it = listaEliminar.begin(); it != listaEliminar.end(); ++it) {
					(*it)->Eliminar();
				}
			}

			m_pResultTitle->SetTitle(_("Results") + wxString::Format(_(" (%d series)"), m_mapaUIDsAbribles.size()));

			Thaw();
		}

		void PanelHistorial2::OnSize(wxSizeEvent &event)
		{
			m_pCabeceraVacio->SetLabel(_("\nThere aren't any stored study that matches with the search filter.\n"));
			m_pCabeceraVacio->Wrap(event.GetSize().x-20);

			m_pMensajeVacio->SetLabel(_("\nTo begin working must change filter criteria, acquire an existing study or import images in DICOM format.\n"));
			m_pMensajeVacio->Wrap(event.GetSize().x-20);

			m_pCabeceraNoCabeMas->SetLabel(_("\nThere is no size in the medical history to show every patients\n"));
			m_pCabeceraNoCabeMas->Wrap(event.GetSize().x-40);

			m_pMensajeNoCabeMas->SetLabel(_("\nTry using filters or collapsing nodes and refresh search\n"));
			m_pMensajeNoCabeMas->Wrap(event.GetSize().x-40);

			m_pPanelHistorial->Layout();
			Layout();
			this->GetParent()->Layout();
			event.Skip();
		}

		void PanelHistorial2::OnMenuMouse(wxMouseEvent &event)
		{
			wxMenu menu(wxEmptyString);

			wxMenuItem* pMenuAdquirir = new wxMenuItem(&menu, 3, wxString( _("&DICOM &Acquisition") ), _("Acquiring a new DICOM study"), wxITEM_NORMAL );
			menu.Connect(3,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnAdquirir),NULL,this);

			wxMenuItem* pMenuOpenFile = new wxMenuItem(&menu, 4, wxString( _("&Open File") ), _("Open a DICOM file"), wxITEM_NORMAL );
			menu.Connect(4,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnOpenFile),NULL,this);

			wxMenuItem* pMenuOpenFolder = new wxMenuItem(&menu, 5, wxString( _("&Open Folder") ), _("Acquire from a local folder"), wxITEM_NORMAL );
			menu.Connect(5,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnOpenFolder),NULL,this);

			wxMenuItem* pMenuImportar = new wxMenuItem( &menu, 6, wxString( _("&Import ...") ), _("Import images"), wxITEM_NORMAL );
			menu.Connect(6,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnImportar),NULL,this);
			
			wxMenuItem* pMenuSend = new wxMenuItem(&menu, 7, wxString( _("Send to PACS server") ), _("Send to PACS server"), wxITEM_NORMAL );
			menu.Connect(7,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelPaciente::OnUploadPACS),NULL,this);

			#ifdef __WXMSW__
			pMenuAdquirir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
			pMenuImportar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
			pMenuOpenFile->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
			pMenuOpenFolder->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
			pMenuSend->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
			#else
			pMenuAdquirir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
			pMenuImportar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
			pMenuOpenFile->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
			pMenuOpenFolder->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
			pMenuSend->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
			#endif

			menu.Append(pMenuOpenFile);
			menu.Append(pMenuOpenFolder);
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_acquisition")) {
				menu.AppendSeparator();
				menu.Append( pMenuAdquirir );
			} else {
				delete pMenuAdquirir;
			}
			menu.AppendSeparator();
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_upload")) {
				menu.Append(pMenuSend);
			} else {
				delete pMenuSend;
			}
			menu.AppendSeparator();
			menu.Append(pMenuImportar);

			menu.AppendSeparator();
			wxMenuItem* pMenuEliminar = new wxMenuItem(&menu, 1, wxString( _("&Clear History") ), _("Delete"), wxITEM_NORMAL );
			menu.Connect(1,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelHistorial2::OnLimpiarHistorial),NULL,this);
			#ifdef __WXMSW__
			pMenuEliminar->SetBitmaps(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
			#else
			pMenuEliminar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
			#endif
			menu.Append(pMenuEliminar);
			if(m_mapaHijos.size() == 0) {
				pMenuEliminar->Enable(false);
			}
			PopupMenu(&menu);
			event.Skip(false);
		}

		void PanelHistorial2::OnMouseWheel(wxMouseEvent &event)
		{
			if(event.GetWheelRotation() > 0)
			{
				m_pPanelHistorial->ScrollLines(-1);
			}
			else if(event.GetWheelRotation() < 0)
			{
				m_pPanelHistorial->ScrollLines(1);
			}
		}

		void PanelHistorial2::OnMedicalHistoryClick(wxMouseEvent &)
		{
			m_pPanelHistorial->SetFocus();
		}

		void PanelHistorial2::OnLimpiarHistorial(wxCommandEvent& event)
		{
			LimpiarHistorial();
			event.Skip(false);
		}

		void PanelHistorial2::LimpiarHistorial()
		{
			for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
				if ((*it).second->HayNodosAbiertos())
				{
					wxMessageBox(_("Failed to empty the history, you have to close opened studies"), _("Info"),
						wxOK | wxICON_WARNING);
					return;
				}
			}

			bool eliminar = false;

			DialogoConfirmacionEliminar dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), _("all files"));
			dlg.ShowModal();
			switch (dlg.GetResultado()) {
				case DialogoConfirmacionEliminar::TR_Eliminar :
					eliminar = GNC::GCS::ControladorHistorial::Instance()->VaciarHistorial(true);
					break;
				case DialogoConfirmacionEliminar::TR_Cancelar :
					break;
			}
			if(eliminar) {
				Freeze();
				for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
					wxWindow* pWin = dynamic_cast<wxWindow*> ((*it).second);
					if(pWin!= NULL) {
						GetSizer()->Detach(pWin);
						pWin->Destroy();
					}
				}
				m_mapaHijos.clear();
				m_mapaUIDsAbribles.clear();
				if(!m_pPanelMensajeVacio->IsShown()) {
					m_pPanelMensajeVacio->Show();
				}
				m_pResultTitle->SetTitle(_("Results") + wxString::Format(_(" (%d series)"), 0));
				RecargarCombos(false);
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
				Thaw();
			}
		}

		void PanelHistorial2::OnImportar(wxCommandEvent& )
		{
			try{
				GNC::GUI::wxWizardImportacionGinkgo ib(this,NULL);
				ib.ShowModal();
			}
			catch(GIL::DICOM::I2DException i){
			}
		}

		void PanelHistorial2::OnAdquirir(wxCommandEvent& )
		{
			GNC::GUI::DialogoAdquisicion::Instance()->Show();
		}

		void PanelHistorial2::Eliminar()
		{
			if(!m_pPanelMensajeVacio->IsShown()) {
				m_pPanelMensajeVacio->Show();
				Layout();
			}
			m_mapaHijos.clear();
			m_mapaUIDsAbribles.clear();
		}

		void PanelHistorial2::Detach(wxWindow* pHijo)
		{
			m_pPanelHistorial->GetSizer()->Detach(pHijo);
			pHijo->Hide();
		}

		void PanelHistorial2::PreProcesarEvento(GNC::GCS::Eventos::IEvento * evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista)
		{
			if (evt == NULL) {
				std::cerr << "Error: null event" << std::endl;
				return;
			}
			switch (evt->GetCodigoEvento()) {
				case ginkgoEVT_Core_HistorialSeleccionar:
				case ginkgoEVT_Core_HistorialLayout:
					{
						lista.push_back(new GNC::GUI::Eventos::EventoSetFocusHistorial());
					}
					break;
				default:
					break;

			}
		}

		void PanelHistorial2::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
		{
			switch(evt->GetCodigoEvento()) {
				case ginkgoEVT_Core_ModificacionFichero:
					{
						GNC::GCS::Eventos::EventoModificacionFichero* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionFichero*>(evt);
						if(pEvt != NULL && pEvt->GetVistaModificada()!=NULL){
							std::list<std::string> listaUIDsSerie = pEvt->GetContextoEstudio()->ListaUIDsSerie;
							for(std::list<std::string>::const_iterator it = listaUIDsSerie.begin(); it != listaUIDsSerie.end(); ++it){
								TMapaAbribles::iterator it2 = m_mapaUIDsAbribles.find( (*it) );
								if(it2 != m_mapaUIDsAbribles.end()){//si esta en el arbol
									if(pEvt->GetTipoEvento() == GNC::GCS::Eventos::EventoModificacionFichero::FicheroModificado){
										PanelSerie* pPanel = (*it2).second->GetSeries((*it), true);
										if (pPanel != NULL) {
											pPanel->VistaModificada(pEvt->GetVistaModificada());
										}
									} else if(pEvt->GetTipoEvento() == GNC::GCS::Eventos::EventoModificacionFichero::FicheroGuardado){
										PanelSerie* pPanel = (*it2).second->GetSeries((*it), true);
										if (pPanel != NULL) {
											pPanel->VistaGuardada(pEvt->GetVistaModificada());
										}
									}
								}
							}

							if(pEvt->GetTipoEvento() == GNC::GCS::Eventos::EventoModificacionFichero::FicheroGuardado){
								//se lanza el comando de incluir en el historial con los diagnosticos
								std::list<std::string> nuevasRutas;
								std::vector<std::string> listaPaths = pEvt->GetContextoEstudio()->GetRutasDiagnosticos();
								for (std::vector<std::string>::const_iterator it = listaPaths.begin(); it != listaPaths.end(); ++it) {
									nuevasRutas.push_back((*it));
								}
								GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(nuevasRutas,false,true);
								pParams->m_informar = false;
								GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
								GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);
							}
						}
					}
					break;
				case  ginkgoEVT_Core_AddFicheroHistorial:
					{
						GNC::GCS::Eventos::EventoAddFicheroHistorial* pEvtMod = dynamic_cast<GNC::GCS::Eventos::EventoAddFicheroHistorial*>(evt);
						if(pEvtMod != NULL){
							//se lanza el comando de incluir en el historial
							GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(pEvtMod->GetListaRutas(), pEvtMod->GetAbrirDespuesDeCargar(), true);
							pParams->m_informar = false;
							GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
							GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);
						}
					}
					break;
				case  ginkgoEVT_Core_HistorialSeleccionar:
					{
						GNC::GUI::Eventos::EventoSeleccionarHistorial* pEvtSelecc = dynamic_cast<GNC::GUI::Eventos::EventoSeleccionarHistorial*>(evt);
						if(pEvtSelecc != NULL) {
							GNC::GUI::ISeleccionableHistorial* pSeleccionable = pEvtSelecc->GetSeleccionable();
							if(pSeleccionable != m_pSeleccionado){
								if(m_pSeleccionado!= NULL) {
									m_pSeleccionado->Seleccionar(false);
								}
								if(pSeleccionable != NULL){
									pSeleccionable->Seleccionar(true);
								}
								m_pSeleccionado = pSeleccionable;
							}
						}
					}
					break;
				case ginkgoEVT_Core_SetFocus:
					{
					    #if defined(_WIN32) || defined(__WXOSX__)
						m_pPanelHistorial->SetFocus();
						#endif
					}
					break;
				case ginkgoEVT_Core_HistorialLayout:
					{
						// SuperHack
						GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();
						Freeze();
						m_pPanelHistorial->Freeze();
						#if defined(_WIN32) || defined(__WXOSX__)
						int yPos = m_pPanelHistorial->GetScrollPos(wxVERTICAL);
						m_pPanelHistorial->SetScrollbars(20, 20, 20, 30, 0, yPos, false);
						m_pPanelHistorial->AdjustScrollbars();
						#endif

						m_pPanelHistorial->Layout();
						Layout();
						this->GetParent()->Layout();
						#if defined(_WIN32) || defined(__WXOSX__)
						m_pPanelHistorial->Scroll(0, yPos);
						Refresh(true);
						#endif
						m_pPanelHistorial->Thaw();
						Thaw();
						GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
					}
					break;
				case ginkgoEVT_Core_HistorialAbribleEliminado:
					{
						Freeze();
						GNC::GUI::Eventos::EventoAbribleEliminado* pEvtElim = dynamic_cast<GNC::GUI::Eventos::EventoAbribleEliminado*>(evt);
						if(pEvtElim != NULL) {
							for(std::list<std::string>::const_iterator itUIDs = pEvtElim->GetUIDs().begin(); itUIDs!= pEvtElim->GetUIDs().end(); itUIDs++){
								TMapaAbribles::iterator it = m_mapaUIDsAbribles.find((*itUIDs));
								if(it!= m_mapaUIDsAbribles.end()) {
									m_mapaUIDsAbribles.erase(it);
								}
							}
						}
						Thaw();
					}
					break;
				case ginkgoEVT_Core_HistorialRecargarHistorial:
					{
						Freeze();
						GNC::GUI::Eventos::EventoRecargarHistorial* pEvtRecargar = dynamic_cast<GNC::GUI::Eventos::EventoRecargarHistorial*>(evt);
						if(pEvtRecargar != NULL) {
							for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
								wxWindow* pWin = dynamic_cast<wxWindow*> ((*it).second);
								if(pWin!= NULL) {
									GetSizer()->Detach(pWin);
									pWin->Destroy();
								}
							}
							m_mapaHijos.clear();
							m_mapaUIDsAbribles.clear();
							if(!m_pPanelMensajeVacio->IsShown()) {
								m_pPanelMensajeVacio->Show();
							}
							Layout();

							//se vacia el historial
							GNC::GCS::ControladorHistorial::Instance()->RecargarHistorial();
							RecargarCombos(false);
							RecargarBusqueda(true);
						}
						Thaw();
					}
					break;
				case ginkgoEVT_Core_AddModeloHistorial:
					{
						//no freeze porque muestra diálogos
						GNC::GUI::Eventos::EventoAddModeloHistorial* pEvtAdd = dynamic_cast<GNC::GUI::Eventos::EventoAddModeloHistorial*>(evt);
						if(pEvtAdd != NULL) {

							bool todos = m_pacienteActual == _Std("All patients");
							GNC::GCS::ControladorHistorial::ListaModelosDCM listaPacienteActual;
							for(GNC::GCS::ControladorHistorial::ListaModelosDCM::iterator it = pEvtAdd->GetListaModelos()->begin(); it!= pEvtAdd->GetListaModelos()->end(); it++) {
								if (todos || (*it).m_idPaciente == m_pacienteActual || pEvtAdd->GetAbrirDespuesDeCargar()) {
									listaPacienteActual.push_back((*it));
								}
							}
							if (listaPacienteActual.size() > 0) {
								CargarDCMs( listaPacienteActual, pEvtAdd->GetModeloIntegracion(), true);
								if (pEvtAdd->GetAbrirDespuesDeCargar()) {
									//se pilla la primear serie y se abre
									const std::string& uidSerie =listaPacienteActual.front().m_uidSerie;
									if ( m_mapaUIDsAbribles.find(uidSerie) != m_mapaUIDsAbribles.end() ){
										PanelSerie* pPanel = m_mapaUIDsAbribles[uidSerie]->GetSeries(uidSerie, true);
										if (pPanel != NULL) {
											pPanel->Abrir();
										}
									}
								}
							}
							RecargarCombos(false);
						}

					}
					break;
				case ginkgoEVT_Core_Estilo:
					{
						Freeze();
						GNC::GCS::Eventos::EventoColorPaciente* pEvtColor = dynamic_cast<GNC::GCS::Eventos::EventoColorPaciente*>(evt);
						if(pEvtColor != NULL) {
							wxColour colorPaciente = GetColorPaciente(pEvtColor->GetIdPaciente());
							GNC::GCS::Eventos::EventoColorPaciente::TColor color;
							color.r = colorPaciente.Red();
							color.g = colorPaciente.Green();
							color.b = colorPaciente.Blue();
							pEvtColor->SetColorPaciente(color);
						}
						Thaw();
					}
					break;
				case ginkgoEVT_Core_LimpiarHistorial:
					{
						//no freeze porque muestra diálogos
						LimpiarHistorial();
					}
					break;
				case ginkgoEVT_Core_HandleDICOM :
					{
						GNC::GCS::Eventos::EvtHandleDicom* pEvt = dynamic_cast<GNC::GCS::Eventos::EvtHandleDicom*>(evt);
						if (pEvt->GetAction() == GNC::GCS::Eventos::EvtHandleDicom::OpenSeries) {
							const GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs& listaUIDs = pEvt->GetListaUIDs();
							GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs listaUIDsNoHistorial;
							for (GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs::const_iterator it = listaUIDs.begin(); it != listaUIDs.end(); ++it)
							{
								if (m_mapaUIDsAbribles.find((*it)) == m_mapaUIDsAbribles.end()) {
									listaUIDsNoHistorial.push_back((*it));
								} else {
									PanelSerie* pPanel = m_mapaUIDsAbribles[(*it)]->GetSeries((*it), true);
									if (pPanel) {
										pPanel->Abrir();
									}
								}
							}
							//se añaden al historial
							GNC::GCS::IControladorHistorial::ListaModelosSeries listaModelosSerie;
							GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerieSeries(listaUIDsNoHistorial, listaModelosSerie);
							CargarSeries(listaModelosSerie, NULL);

							for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = listaModelosSerie.begin(); it != listaModelosSerie.end(); ++it) {
								//se pilla la serie y se abre
								const std::string& uidSerie =(*it).m_uidSerie;
								if ( m_mapaUIDsAbribles.find(uidSerie) != m_mapaUIDsAbribles.end() ){
									PanelSerie* pPanel = m_mapaUIDsAbribles[uidSerie]->GetSeries(uidSerie, true);
									if (pPanel != NULL) {
										pPanel->Abrir();
									}
								}
							}
						} else {
							//delete
							const GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs& listaUIDs = pEvt->GetListaUIDs();
							GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs listaUIDsNoHistorial;
							for (GNC::GCS::Eventos::EvtHandleDicom::ListaUIDs::const_iterator it = listaUIDs.begin(); it != listaUIDs.end(); ++it)
							{
								if (m_mapaUIDsAbribles.find((*it)) == m_mapaUIDsAbribles.end()) {
									listaUIDsNoHistorial.push_back((*it));
								} else {
									PanelSerie* pPanel = m_mapaUIDsAbribles[(*it)]->GetSeries((*it), true);
									if (pPanel) {
										if (!pPanel->DoDelete(false)) {
											return;
										}
									}
								}
							}
							//
							GNC::GCS::ControladorHistorial::Instance()->DeleteSeriesList(listaUIDsNoHistorial, true);
							RecargarCombos(false);
							RecargarBusqueda();
						}
					}
					break;
				case ginkgoEVT_Core_Views:
					{
						GNC::GCS::Eventos::EventView* pEvt = dynamic_cast<GNC::GCS::Eventos::EventView*>(evt);
						if (pEvt != NULL)
						{
							if (pEvt->GetType() == GNC::GCS::Eventos::EventView::Creation) {
								DICOMActivado(pEvt->GetView());
							} else {
								DICOMDesactivado(pEvt->GetView());
							}
						}						
					}
					break;
				case ginkgoEVT_Core_DeleteFile:
					{
						GNC::GCS::Eventos::EventDeleteFileHistory* pEvt = dynamic_cast<GNC::GCS::Eventos::EventDeleteFileHistory*>(evt);
						if (pEvt != NULL)
						{
							//delete files from history
							if (GNC::GCS::ControladorHistorial::Instance()->DeleteFilesList(pEvt->GetPatientId(), pEvt->GetStudyId(), pEvt->GetSeriesId(), (GNC::GCS::IControladorHistorial::ListaStrings)pEvt->GetIdList()))
							{
								if (m_mapaUIDsAbribles.find(pEvt->GetSeriesId()) != m_mapaUIDsAbribles.end()) {
									PanelSerie* pPanel = m_mapaUIDsAbribles[pEvt->GetSeriesId()]->GetSeries(pEvt->GetSeriesId(), true);
									if (pPanel) {
										if (pPanel->RefrescarNumeroSlices() == 0) {
											pPanel->DoDelete(false);
										}
									}
								}								
							}
						}
					}
					break;
			}
		}
//endregion

	};
};
