/*
 *  
 *  $Id: parserxmlenglish.cpp 4034 2011-07-21 09:44:05Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <string>
#include <map>
#include <ctime>
#include <sstream>

#include <wx/xml/xml.h>
#include <wx/file.h>
#include <wx/sstream.h>
#include <wx/msgdlg.h>
#ifndef _WIN32
#include <signal.h>
#endif
#include <wx/tokenzr.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/filename.h>


#include "parserxmlenglish.h"
#include <api/globals.h>
#include <api/imodelohl7.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorhl7.h>
#include <api/iguiasmensajeriasacyl.h>
#include <api/aetwildcards.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorlog.h>
#include <main/entorno.h>
#include "dcmtk/dicomservers.h"

//creacion de la base de datos de mensajes
GIL::HL7::ParserXMLEnglish::ParserXMLEnglish()
{
}

GIL::HL7::ParserXMLEnglish::~ParserXMLEnglish()
{
}

//region "Interfaz generica"

std::list<std::string> GIL::HL7::ParserXMLEnglish::GetKeys()
{
	std::list<std::string> list;
	list.push_back("gnkworkflows");
	list.push_back("gnkworkflow");
	return list;
}

/* Parsea la cadena XML y construye el modelo de integracion. Los parametros no encontrados se asignan por defecto segun lo especificado en la configuracion global */
void GIL::HL7::ParserXMLEnglish::ParseIntegrationXML(GNC::GCS::IEntorno::ListaModelosIntegracion& models, wxXmlNode* pRoot) 
{
	MapaServers servers;
	std::string xpp; // XML Pretty Printed for extended information info.
	// PreCargamos la lista de PACS de la configuracion
	for (DicomServerHolder* sl = DicomServerList::Instance()->GetList(); sl != NULL; sl = sl->next) {
		IModeloPACSServer pacs;
		pacs.sid = sl->server.ID;
		pacs.AET = sl->server.AET;
		pacs.hostname = sl->server.HostName;
		pacs.puerto = sl->server.Port;

		servers[pacs.sid] = pacs;
	}
	//	

	if (pRoot->GetName().CmpNoCase(wxT("gnkworkflows")) == 0) {

		wxString propVal;

		// Parseamos los PACS especificados por fichero
		for (wxXmlNode* nodo = pRoot->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
			if (nodo->GetName().CmpNoCase(wxT("pacs")) == 0) { // Configuracion de PACS
				GIL::IModeloPACSServer pacsServer;

				propVal = nodo->GetPropVal(wxT("sid"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.sid = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted Identificator"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("aet"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.AET = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted AET"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("hostname"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.hostname = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Hostname missing"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("port"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.puerto = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted port"), xpp, "CONF/pacs");
				}
				
				propVal = nodo->GetPropVal(wxT("tls"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("yes")) == 0 || propVal.CmpNoCase(wxT("true")) == 0 || propVal.CmpNoCase(wxT("si")) == 0 || propVal.CmpNoCase(wxT("1")) == 0 ) {
					pacsServer.tls = true;
				}
				else {
					pacsServer.tls = false;
				}

				propVal = nodo->GetPropVal(wxT("pacs-user"), wxEmptyString);
				if( !propVal.empty()) {
					pacsServer.user = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("pacs-password"), wxEmptyString);
				if( !propVal.empty()) {
					pacsServer.password = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("verify-credentials"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("yes")) == 0 || propVal.CmpNoCase(wxT("true")) == 0 || propVal.CmpNoCase(wxT("si")) == 0 || propVal.CmpNoCase(wxT("1")) == 0 ) {
					pacsServer.verify = true;
				}
				else {
					pacsServer.verify = false;
				}

				propVal = nodo->GetPropVal(wxT("retrieve-method"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("get")) == 0 ) {
					pacsServer.metodo = GIL::IModeloPACSServer::IMPS_GET;
				}
				else {
					pacsServer.metodo = GIL::IModeloPACSServer::IMPS_MOVE;
				}
				
				propVal = nodo->GetPropVal(wxT("pdu"), wxEmptyString);
				if( propVal.empty()) {
					pacsServer.pdu = "16384";
				}
				else {
					pacsServer.pdu = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("retrieve-level"), wxEmptyString);
				if( propVal.empty()) {
					pacsServer.retrieveLevel = "SERIES";
				}
				else {
					pacsServer.retrieveLevel = propVal.ToUTF8();
				}

				for (wxXmlNode* subnodo = nodo->GetChildren(); subnodo != NULL; subnodo = subnodo->GetNext()) {
					if (subnodo->GetName().CmpNoCase(wxT("client-cert")) == 0) {
						pacsServer.cert = subnodo->GetNodeContent().ToUTF8();
					}
					else if (subnodo->GetName().CmpNoCase(wxT("client-key")) == 0) {
						pacsServer.key = subnodo->GetNodeContent().ToUTF8();
					}
				}

				servers[pacsServer.sid] = pacsServer;
				try{
					DicomServer* server = DicomServerList::Instance()->GetServer(pacsServer.sid);
					server->AET = pacsServer.AET;
					server->HostName = pacsServer.hostname;
					long puerto;
					long pdu;
					if(!wxString::FromUTF8(pacsServer.pdu.c_str()).ToLong(&pdu)) {
						throw HL7XMLException(_Std("The pdu size is not a valid number"), xpp, "CONF/pacs");
					}
					server->PDU = pdu;
					if(wxString::FromUTF8(pacsServer.puerto.c_str()).ToLong(&puerto)) {
						server->Port = puerto;
					} else {
						throw HL7XMLException(_Std("Port is not a valid number"), xpp, "CONF/pacs");
					}
					if (pacsServer.metodo == GIL::IModeloPACSServer::IMPS_GET) {
						server->retrieveWithMove = false;
					}
					else {
						server->retrieveWithMove = true;
					}
					server->retrieveSeries = wxString::FromUTF8(pacsServer.retrieveLevel.c_str()).CmpNoCase(wxT("SERIES")) == 0;
					server->useTLS = pacsServer.tls;
					server->verifyCredentials = pacsServer.verify;
					server->certificate = pacsServer.cert;
					server->privateKey  = pacsServer.key;
					server->pacsUser = pacsServer.user;
					server->pacsPass = pacsServer.password;

					DicomServerList::Instance()->SetDefaultServer(server->ID);

				} catch (GinkgoNoServerFoundException& ){
					long puerto;
					long pdu;
					if(!wxString::FromUTF8(pacsServer.pdu.c_str()).ToLong(&pdu)) {
						throw HL7XMLException(_Std("The pdu size is not a valid number"), xpp, "CONF/pacs");
					}
					if(wxString::FromUTF8(pacsServer.puerto.c_str()).ToLong(&puerto)) {
						DicomServerList::Instance()->AddServer( DicomServer(pacsServer.sid, pacsServer.AET, pacsServer.hostname, (int)puerto, 0, true, pdu, pacsServer.tls, pacsServer.user, pacsServer.password, pacsServer.metodo == GIL::IModeloPACSServer::IMPS_MOVE, wxString::FromUTF8(pacsServer.retrieveLevel.c_str()).Upper() == wxT("SERIES"), pacsServer.verify, pacsServer.cert, pacsServer.key), true );
					} else {
						throw HL7XMLException(_Std("The port is not a valid number"), xpp, "CONF/pacs");
					}
				}
			}
		}

		// Parseamos las gnkworkflows
		for (wxXmlNode* nodo = pRoot->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
			if (nodo->GetName().CmpNoCase(wxT("gnkworkflow") ) == 0)  { // gnkworkflow
				GIL::IModeloIntegracion* modelo = ParseGnkWorkflow(nodo, servers);				
				models.push_back(modelo);
			} //fin gnkworkflow
		} //fin de parseo de gnkworkflows
	} else if (pRoot->GetName().CmpNoCase(wxT("gnkworkflow")) == 0) {
		GIL::IModeloIntegracion* modelo = ParseGnkWorkflow(pRoot, servers);
		models.push_back(modelo);
	} else {
		throw HL7XMLException(_Std("Setting not found"), xpp, "CONF");
	}
}

GIL::IModeloIntegracion* GIL::HL7::ParserXMLEnglish::ParseGnkWorkflow(wxXmlNode* nodo, GIL::HL7::ParserXMLEnglish::MapaServers& servers)
{	
	std::string codigoAplicacion;
	//se extrae de la configuracion el codigo de aplicacion
	GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/HCE","CodigoAplicacion", codigoAplicacion);

	std::string xpp; // XML Pretty Printed for extended information info.
	wxString propVal;
	GIL::IModeloIntegracion* modelo = new IModeloIntegracion();
	//se copia el raw data
	{
		wxXmlNode* pNodo = new wxXmlNode(*nodo);
		wxXmlDocument docTmp;
		docTmp.SetRoot(pNodo);
		wxStringOutputStream out;
		docTmp.Save(out,wxXML_NO_INDENTATION);
		modelo->rawXmlData = out.GetString().ToUTF8();
	}
	//

	propVal = nodo->GetPropVal(wxT("tid"), wxEmptyString);
	if( !propVal.empty() ) {
		modelo->idPlantilla = propVal.ToUTF8();
	} else {
		modelo->idPlantilla = "";
	}

	propVal = nodo->GetPropVal(wxT("action"), wxEmptyString).Lower();
	if ( !propVal.empty() ) {

		if (propVal.CmpNoCase(wxT("retrieve")) == 0){
			modelo->accion = GIL::IModeloIntegracion::TA_Obtener;
		}
		else if (propVal.CmpNoCase(wxT("dicomize")) == 0 ) {
			modelo->accion = GIL::IModeloIntegracion::TA_Dicomizar;
		}
		else if (propVal.CmpNoCase(wxT("print")) == 0) {
			modelo->accion = GIL::IModeloIntegracion::TA_Imprimir;
		}
		else {
			throw HL7XMLException(_Std("\"action\" attribute invalid at \"gnkworkflow\" scope" ), xpp, "CONF/template");
		}
	}
	else {
		throw HL7XMLException(_Std("\"action\" attribute expected at \"gnkworkflow\" scope"), xpp, "CONF/template");
	}

	propVal = nodo->GetPropVal(wxT("petition-id"), wxEmptyString);
	if( !propVal.empty() ) {
		modelo->idPeticion = propVal.ToUTF8();
	}
	else {
		modelo->idPeticion = "";
	}

	propVal = nodo->GetPropVal(wxT("scope"), wxEmptyString);
	if( !propVal.empty() ) {
		modelo->idAmbitoPeticion = propVal.ToUTF8();
	}
	else {
		modelo->idAmbitoPeticion = "";
	}

	if( nodo->HasProp(wxT("pacs-retrieve-sid")) ) {
		propVal = nodo->GetPropVal(wxT("pacs-retrieve-sid"), wxEmptyString);
		if (!propVal.IsEmpty()) {
			modelo->PACSObtencion = propVal.ToUTF8();
		}
		else {
			throw HL7XMLException(_Std("\"pacs-retrieve-sid\" attribute empty at \"gnkworkflow\" scope"), xpp, "CONF/template");
		}					
	}

	if( nodo->HasProp(wxT("pacs-store-sid")) ) {
		propVal = nodo->GetPropVal(wxT("pacs-store-sid"), wxEmptyString);
		if (!propVal.IsEmpty()) {
			modelo->PACSAlmacenamiento = propVal.ToUTF8();
		}
		else {
			throw HL7XMLException(_Std("\"pacs-store-sid\" attribute empty at \"gnkworkflow\" scope"), xpp, "CONF/template");
		}					
	}

	//recorremos los hijos de las gnkworkflows
	for (wxXmlNode* hijo = nodo->GetChildren(); hijo != NULL; hijo = hijo->GetNext()) {
		//parseamos los campos dimse
		if(hijo->GetName().CmpNoCase(wxT("query-retrieve-level")) == 0){
			propVal = hijo->GetPropVal(wxT("value"), wxEmptyString);
			if ( !propVal.empty() ) {
				modelo->ambitoDIMSE = propVal.Upper().ToUTF8();
			}
			else {
				throw HL7XMLException(_Std("\"value\" attribute expected at \"query-retrieve-level\" scope"), xpp, "CONF/template");
			}
		}

		//parseamos los campos d paciente
		if(hijo->GetName().CmpNoCase(wxT("patient")) == 0) {
			for (wxXmlNode* hijosPaciente = hijo->GetChildren(); hijosPaciente != NULL; hijosPaciente = hijosPaciente->GetNext()) {
				if(hijosPaciente->GetName().CmpNoCase(wxT("name")) == 0) {
					if(hijosPaciente->GetChildren() != NULL){
						modelo->Paciente.nombre = hijosPaciente->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosPaciente->GetName().CmpNoCase(wxT("first-surname")) == 0) {
					if(hijosPaciente->GetChildren() != NULL){
						modelo->Paciente.apellido1 = hijosPaciente->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosPaciente->GetName().CmpNoCase(wxT("second-surname")) == 0) {
					if(hijosPaciente->GetChildren() != NULL){
						modelo->Paciente.apellido2 = hijosPaciente->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosPaciente->GetName().CmpNoCase(wxT("episode-number")) == 0) {
					if(hijosPaciente->GetChildren() != NULL){
						modelo->Paciente.numEpisodio = hijosPaciente->GetChildren()->GetContent().ToUTF8();
					}
				}else if(hijosPaciente->GetName().CmpNoCase(wxT("id")) == 0) {
					std::string codigo(propVal.ToUTF8());
					std::string valor(propVal.ToUTF8());
					propVal = hijosPaciente->GetPropVal(wxT("code"), wxEmptyString);
					if ( !propVal.empty() ) {
						codigo =  propVal.ToUTF8();
					}
					else {
						throw HL7Exception(_Std("\"code\" attribute expected at \"patient\" scope"), xpp, "CONF/template");
					}
					propVal = hijosPaciente->GetPropVal(wxT("value"), wxEmptyString);
					if ( !propVal.empty() ) {
						valor =  propVal.ToUTF8();
						modelo->Paciente.listaIdentificadores.push_back(IModeloIdentificador(codigo,valor));
					}								
				}
			}
		}//fin paciente

		//parseamos los campos d medico
		if(hijo->GetName().CmpNoCase(wxT("physician")) == 0) {
			for (wxXmlNode* hijosMedico = hijo->GetChildren(); hijosMedico != NULL; hijosMedico = hijosMedico->GetNext()) {
				if(hijosMedico->GetName().CmpNoCase(wxT("name")) == 0) {
					if(hijosMedico->GetChildren() != NULL){
						modelo->Medico.nombre = hijosMedico->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosMedico->GetName().CmpNoCase(wxT("first-surname")) == 0) {
					if(hijosMedico->GetChildren() != NULL){
						modelo->Medico.apellido1 = hijosMedico->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosMedico->GetName().CmpNoCase(wxT("second-surname")) == 0) {
					if(hijosMedico->GetChildren() != NULL){
						modelo->Medico.apellido2 = hijosMedico->GetChildren()->GetContent().ToUTF8();
					}
				} else if(hijosMedico->GetName().CmpNoCase(wxT("id")) == 0) {
					std::string codigo(propVal.ToUTF8());
					std::string valor(propVal.ToUTF8());
					propVal = hijosMedico->GetPropVal(wxT("code"), wxEmptyString);
					if ( !propVal.empty() ) {
						codigo =  propVal.ToUTF8();
					}
					else {
						throw HL7XMLException(_Std("\"code\" attribute expected at \"physician\" scope"), xpp, "CONF/template");
					}
					propVal = hijosMedico->GetPropVal(wxT("value"), wxEmptyString);
					if ( !propVal.empty() ) {
						valor =  propVal.ToUTF8();
					}
					else {
						throw HL7XMLException(_Std("\"value\" attribute expected at \"physician\" scope"), xpp, "CONF/template");
					}
					modelo->Medico.listaIdentificadores.push_back(IModeloIdentificador(codigo,valor));
				} else if(hijosMedico->GetName() == wxT("institution")) {
					propVal = hijosMedico->GetPropVal(wxT("iid"), wxEmptyString);
					if ( !propVal.empty() ) {
						modelo->Medico.idCentro =  propVal.ToUTF8();
					}
					else {
						throw HL7XMLException(_Std("\"iid\" atribute expected at \"institution\" scope"), xpp, "CONF/template");
					}

					if(hijosMedico->GetChildren() != NULL){
						modelo->Medico.nombreCentro = hijosMedico->GetChildren()->GetContent().ToUTF8();
					}
				}
			}
		}//fin medico

		if(hijo->GetName().CmpNoCase(wxT("hce")) == 0) {
			propVal = hijo->GetPropVal(wxT("aid"), wxEmptyString);
			if ( !propVal.empty() ) {
				modelo->HCE.Sid =  propVal.ToUTF8();
			}
			else {
				throw HL7XMLException(_Std("\"aid\" attribute expected at \"hce\" scope"), xpp, "CONF/template");
			}
		}

		if (hijo->GetName().CmpNoCase(wxT("metadata")) == 0) {
			std::string codigo;
			std::string clave;
			std::string valor;
			std::string descripcion;

			propVal = hijo->GetPropVal(wxT("code"), wxEmptyString);
			if ( !propVal.empty() ) {
				codigo = propVal.Upper().ToUTF8();
			}else {
				throw HL7XMLException(_Std("\"code\" attribute expected at \"metadata\" scope"), xpp, "CONF/template");
			}

			propVal = hijo->GetPropVal(wxT("key"), wxEmptyString);
			if ( !propVal.empty() ) {
				clave = propVal.Lower().ToUTF8();
			}else {
				throw HL7XMLException(_Std("\"key\" attribute expected at \"metadata\" scope"), xpp, "CONF/template");
			}

			propVal = hijo->GetPropVal(wxT("value"), wxEmptyString);
			if ( !propVal.empty() ) {
				valor = propVal.ToUTF8();
			}

			propVal = hijo->GetPropVal(wxT("description"), wxEmptyString);
			if ( !propVal.empty() ) {
				descripcion = propVal.ToUTF8();
			}

			IModeloTupla tupla(codigo,clave, valor,descripcion);
			modelo->Metadatos.push_back(tupla);
		}

		if (hijo->GetName().CmpNoCase(wxT("observations")) == 0) {
			if(hijo->GetChildren() != NULL) {
				modelo->observaciones = hijo->GetChildren()->GetContent().ToUTF8();
			}
		}
	}//fin hijos gnkworkflow
	if (modelo->accion == GIL::IModeloIntegracion::TA_Obtener && modelo->Paciente.listaIdentificadores.size() != 0)
	{
		modelo->Metadatos.push_back(IModeloTupla("DICOM","0010|0020", modelo->Paciente.GetIdentificadorPreferido().valor,""));
	}
	if (modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar) {
		if (modelo->idAmbitoPeticion == "") {
			throw HL7XMLException(_Std("\"scope\" attribute expected at \"gnkworkflow\" scope"), xpp, "CONF/template");
		}
		if (modelo->idPeticion == "") {
			throw HL7XMLException(_Std("\"petition-id\" attribute expected at \"gnkworkflow\" scope"), xpp, "CONF/template");
		}
		if(modelo->Medico.listaIdentificadores.size() == 0) {
			throw HL7XMLException(_Std("It has been read a \"medico\" tag without identifiers"), xpp, "CONF/template");
		}
	} else if (modelo->accion == GIL::IModeloIntegracion::TA_Obtener) {
		if (modelo->Metadatos.size() == 0) {
			throw HL7XMLException(_Std("You must specify attributes you want to use in the query"), xpp, "CONF/template");
		}
	}
	if(modelo->HCE.Sid == "") {
		throw HL7XMLException(_Std("id_application expected"), xpp, "CONF/template");
	}
	if(modelo->Paciente.listaIdentificadores.size() == 0 && modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar) {
		throw HL7XMLException(_Std("It has been read a \"patient\" tag without identifiers"), xpp, "CONF/template");
	}
	//se pone el codigo de aplicacion y el primer PACS de la configuracion si no nos ha venido  ninguno
	modelo->CodigoAplicacion = codigoAplicacion;
	if(servers.size() > 0) {
		DicomServer* pServer = DicomServerList::Instance()->GetDefaultServer();
		if (modelo->PACSObtencion.size() == 0 && pServer != NULL) {
			modelo->PACSObtencion = pServer->ID;
		}
		if (modelo->PACSAlmacenamiento.size() == 0 && pServer != NULL) {
			modelo->PACSAlmacenamiento = pServer->ID;
		}
	}
	if ( (modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar && modelo->PACSAlmacenamiento.size() == 0) || 
		(modelo->accion == GIL::IModeloIntegracion::TA_Obtener && modelo->PACSObtencion.size() == 0) ) 
	{
		throw HL7XMLException(_Std("You must define a default PACS in the integration XML or in the settings menu"), xpp, "CONF/template");
	}
	return modelo;
}
