/*
*
*  $Id: icontratoscore.h 4401 2011-11-11 13:25:38Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <api/icontrato.h>
#include <api/math/geometria.h>
#include <api/controllers/ipacscontroller.h>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkSmartPointer.h>
#include <vtkImageData.h>
#include <itkImage.h>
#include <itkRGBPixel.h>

#include <api/ientorno.h>
#include <api/icontroladorcomandos.h>

class vtkGinkgoImageViewer;
class wxCriticalSection;
class INotificadorChroma;
class INotificadorElevacion;
class vtkImageActor;

namespace GNC {
	namespace GCS {
		class IVista;
		class IWidgetsManager;
		class IElementoCache;
	}
}

namespace GNC {
	namespace GCS {

		class EXTAPI IContratoWidgets: public IContrato {
		public:

			inline IContratoWidgets() {
				m_pManager=NULL;
			}

			inline ~IContratoWidgets() {
				m_pManager=NULL;
			}

			void Setup(GNC::GCS::IWidgetsManager* pManager) {
				m_pManager = pManager;
			}

			inline GNC::GCS::IWidgetsManager* GetManager() { return m_pManager; }

			virtual vtkGinkgoImageViewer* GetViewer()     = 0;

			bool Inicializado()
			{
				return ( (m_pManager != NULL) && (GetViewer() != NULL) );
			}
		protected:
			GNC::GCS::IWidgetsManager*    m_pManager;
		};
		
		class EXTAPI IContratoSlider: public IContrato {
		public:

			inline IContratoSlider() {
			}

			inline ~IContratoSlider() {
			}
			
			virtual void SetSlice(int slicenum) = 0;
			virtual int GetSlice() const = 0;
			virtual int GetNumberOfSlices() const = 0;
		};

		class EXTAPI IContratoWindowLevel: public IContrato {
		public:
			class WindowLevel{
			public:
				WindowLevel(){
					m_label = std::string("");
					m_window = 0;
					m_level = 0;
				}

				WindowLevel(const std::string& label, const double& window,const double& level, bool userDefined = false){
					m_label = label;
					m_window = window;
					m_level = level;
					m_userDefined = userDefined;
				}

				WindowLevel(const double& window,const double& level, bool userDefined = false){
					m_label = std::string("");
					m_window = window;
					m_level = level;
					m_userDefined = userDefined;
				}

				WindowLevel(const WindowLevel& otro) {
					m_window = otro.m_window;
					m_level = otro.m_level;
					m_label = otro.m_label;
					m_userDefined = otro.m_userDefined;
				}

				WindowLevel& operator=(const WindowLevel& otro) {
					m_label = otro.m_label;
					m_window = otro.m_window;
					m_level = otro.m_level;
					m_userDefined = otro.m_userDefined;
					return *this;
				}

				bool			m_userDefined;
				std::string m_label;
				double m_window;
				double m_level;
			};

			typedef std::vector<WindowLevel> ListaWindowLevels;
			ListaWindowLevels m_listaWindowLevels;

			std::string m_labelCurrent;

			public: bool m_isCT;

			IContratoWindowLevel():IContrato() {
				m_labelCurrent = "";
			}

			~IContratoWindowLevel(){
				m_listaWindowLevels.clear();
			}

			virtual bool HasCurrentWindowLevel()
			{
				return m_listaWindowLevels.size() >0;
			}

			virtual WindowLevel GetCurrentWindowLevel()
			{
				for (ListaWindowLevels::iterator it = m_listaWindowLevels.begin(); it != m_listaWindowLevels.end(); ++it)
				{
					if ((*it).m_label == m_labelCurrent) {
						return (*it);
					}
				}
				if (m_listaWindowLevels.size() > 0) {
					m_labelCurrent = m_listaWindowLevels[0].m_label;
					return m_listaWindowLevels[0];
				} else {
					WindowLevel wl("",0,0,false);
					return wl;
				}
			}

			virtual bool HasDefaultWindowLevel()
			{
				bool resultado = false;
				for (ListaWindowLevels::iterator it = m_listaWindowLevels.begin(); it != m_listaWindowLevels.end(); ++it)
				{
					resultado = resultado || !(*it).m_userDefined;
				}
				return resultado;
			}

			virtual WindowLevel GetAndSetDefaultWindowLevel()
			{
				for (ListaWindowLevels::iterator it = m_listaWindowLevels.begin(); it != m_listaWindowLevels.end(); ++it)
				{
					if (!(*it).m_userDefined) {
						m_labelCurrent = (*it).m_label;
						return (*it);
					}
				}
				WindowLevel wl("",0,0,false);
				return wl;
			}

			virtual void Setup(GIL::DICOM::TipoJerarquia& base) {
				//se guardan los user defined
				ListaWindowLevels listaTemp;
				for (ListaWindowLevels::iterator it = m_listaWindowLevels.begin(); it !=  m_listaWindowLevels.end(); ++it)
				{
					if ((*it).m_userDefined) {
						listaTemp.push_back((*it));
					}
				}
				m_listaWindowLevels.clear();
				//se pillan los window levels
				double level = 0.0f;
				double window = 0.0f;
				std::string label("");

				std::string levelStr;
				std::string windowStr;
				std::string labelStr;
				std::string modality;

				base.getTag(std::string("0028|1050"),levelStr);
				base.getTag(std::string("0028|1051"),windowStr);
				base.getTag(std::string("0028|1055"),labelStr);
				base.getTag(std::string("0008|0060"),modality);

				bool wlValido = true;
				m_isCT = false;

				if ( levelStr.empty() || windowStr.empty() ){
					wlValido = false;
				}
				else {
					while(levelStr.size()>0){
						std::istringstream issl(levelStr);
						issl >> level;

						std::istringstream issw(windowStr);
						issw >> window;

						if (window == 0.0f) {
							wlValido = false;
						}

						if(labelStr.find_first_of('\\')!=std::string::npos){
							label = labelStr.substr(0,labelStr.find_first_of('\\'));
						} else if(labelStr.size()>0) {
							label = labelStr;
						} else {
							label = std::string("WindowLevel");
						}

						if(wlValido){
							if (m_labelCurrent == "") {
								m_labelCurrent = label;
							}
							WindowLevel wl(label,window,level);
							m_listaWindowLevels.push_back(wl);
						}


						if(levelStr.find_first_of('\\')!=std::string::npos){
							levelStr = levelStr.substr(levelStr.find_first_of('\\')+1,levelStr.size()-1);
							windowStr = windowStr.substr(windowStr.find_first_of('\\')+1,windowStr.size()-1);
							if(labelStr.find_first_of('\\')!=std::string::npos){
								labelStr = labelStr.substr(labelStr.find_first_of('\\')+1,labelStr.size()-1);
							}
						} else {
							break;
						}
					}
				}

				if (modality == "CT") {
					if (m_labelCurrent == "") {
						m_labelCurrent = _Std("Abdomen");
					}
					m_listaWindowLevels.push_back(WindowLevel(_Std("Abdomen"), 400, 40));
					m_listaWindowLevels.push_back(WindowLevel(_Std("Lung"), 1200, -600));
					m_listaWindowLevels.push_back(WindowLevel(_Std("Vertebra"), 2000, 350));
					m_listaWindowLevels.push_back(WindowLevel(_Std("Cranium"), 100, 35));
					m_listaWindowLevels.push_back(WindowLevel(_Std("Mediastinum"), 350, 40));
					m_listaWindowLevels.push_back(WindowLevel(_Std("Spine"), 300, 35));
				}
				//se meten i es necesario los user defined
				for (ListaWindowLevels::iterator it = listaTemp.begin(); it !=  listaTemp.end(); ++it)
				{
					m_listaWindowLevels.push_back((*it));
				}
			}
		};

		class EXTAPI IContratoElevacion: public IContrato {
		public:
			vtkSmartPointer<vtkImageData> m_pMapaValoracion;
			float m_maximo;
			float m_minimo;
			INotificadorElevacion* m_pNotificador;

			unsigned char m_mascaraSet;
			unsigned char m_mascaraUnSet;
			bool m_modoMascara;

			IContratoElevacion() {
				m_pNotificador = NULL;
			};
			~IContratoElevacion() {};

			virtual void Setup(  vtkSmartPointer<vtkImageData> pMapaValoracion,
				float maximo, float minimo, INotificadorElevacion* pNotificador)
			{
				m_pMapaValoracion=pMapaValoracion;
				m_maximo=maximo;
				m_minimo=minimo;
				m_pNotificador = pNotificador;
				m_modoMascara = false;
			}

			virtual void Setup(  vtkSmartPointer<vtkImageData> pMapaValoracion,
				unsigned char mascaraSet, unsigned char mascaraUnSet, INotificadorElevacion* pNotificador)
			{
				m_pMapaValoracion=pMapaValoracion;
				m_mascaraUnSet = mascaraUnSet;
				m_mascaraSet = mascaraSet;
				m_pNotificador = pNotificador;
				m_modoMascara = true;
			}

			bool Inicializado()
			{
				return ( (m_pMapaValoracion != NULL) );
			}
		};

		class EXTAPI IContratoExportacionImages: public IContrato {
		public:
			typedef itk::RGBPixel<unsigned char> PixelType;
			typedef itk::Image< PixelType,  2 > ImageType;
			typedef std::map<std::string,bool> MapaMapasValoracion;

			virtual void GetImageActual(ImageType::Pointer& img, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size) = 0;
			virtual void GetImage(ImageType::Pointer& img, int index, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size) = 0;
			virtual MapaMapasValoracion GetMapasValoracion() = 0;

			IContratoExportacionImages() {};
			~IContratoExportacionImages() {};
		};

		class EXTAPI IContratoLayoutVentana: public IContrato {
		public:
			IContratoLayoutVentana()
			{
				m_MinSlice = 0;
				m_MaxSlice = 0;
			}
			~IContratoLayoutVentana(){}
			virtual void SetLayoutVentana(int filas, int columnas) = 0;
			virtual int GetColumnas() = 0;
			virtual int GetFilas() = 0;

			virtual void Setup(int minSlice, int maxSlice) {
				m_MinSlice = minSlice;
				m_MaxSlice = maxSlice;
			}

			int m_MinSlice;
			int m_MaxSlice;
		};
	}
}

