/*
 *  
 *  $Id: vista2d.cpp 4122 2011-09-02 12:08:58Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/wx.h>
#include <wx/checkbox.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/busyinfo.h>
#include <wx/msgdlg.h>
#include <wx/xml/xml.h>
#include <wx/utils.h>

#include <api/globals.h>
#include <api/icontroladorherramientas.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorcarga.h>
#include <api/dicom/imodelodicom.h>
#include <api/dicom/idicomizador.h>
#include <api/icontroladorpermisos.h>
#include <eventos/eventosginkgo.h>

#include <export/iherramientapuntero.h>
#include <export/iherramientaregla.h>
#include <export/iherramientaangulo.h>
#include <export/iherramientanota.h>
#include <export/iherramientawindowlevel.h>
#include <export/iherramientalupa.h>
#include <export/iherramientamarcado.h>
#include <export/iherramientarejillametrica.h>
#include <export/iherramientaanotacionesesquina.h>
#include <export/iherramientainterpolate.h>
#include <api/imodelointegracion.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorpermisos.h>
#include <export/iherramientareset.h>
#include <export/iherramientalayoutventana.h>
#include "../exportacion/iherramientaoverlays.h"
#include "../exportacion/iherramientamapacolor.h"
#include "../eventos/visualizatorevents.h"
#include "../estudios/visualizatorstudy.h"

#include "vista2d.h"
#include "../wxvtk/gvistacompleja.h"
#include "../wxvtk/gvistasimple.h"
#include "../dialogos/contenedorherramientas.h"



#define TAG_WIDGETS					    0xb;

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkDataSetAttributes.h>
#include <vtkAlgorithm.h>
#include <vtkAlgorithmOutput.h>
#include <vtkImageData.h>
#include <hackimageactor.h>
#include <vtkAlgorithmOutput.h>
#include <vtkInformation.h>

/* Constructor */

GNKVisualizator::Vista2D::Vista2D(const GnkPtr<GNKVisualizator::VisualizatorStudy>& estudio) : GNC::GCS::IVista((GnkPtr<GNC::GCS::IContextoEstudio>)estudio), VisualizatorStudy(estudio)
{
	m_Cargada = false;
	m_IgnorarModificaciones = false;

	
	VisualizatorStudy->Ventana = GVista = new GVistaCompleja(this);

	GNC::GCS::IControladorHerramientas* cH = VisualizatorStudy->Entorno->GetControladorHerramientas();

	GNC::GCS::IHerramientaPuntero*             hPuntero = NULL;
	GNC::GCS::IHerramientaRegla*               hRegla = NULL;
	GNC::GCS::IHerramientaAngulo*              hAngulo = NULL;
	GNC::GCS::IHerramientaNota*                hNota = NULL;
	GNC::GCS::IHerramientaAnotacionesEsquina*  hAnotacionesEsquina = NULL;
	GNC::GCS::IHerramientaLupa*                hLupa = NULL;
	GNC::GCS::IHerramientaMarcado*             hMarcado       = NULL;
	GNC::GCS::IHerramientaRejillaMetrica*      hRejilla = NULL;
	GNC::GCS::IHerramientaReset*               hReset = NULL;
	GNC::GCS::IHerramientaLayoutVentana*       hHerramientaLayoutVentana = NULL;
	GNC::GCS::IHerramientaInterpolate*			 hInterpolate = NULL;
	GNKVisualizator::IHerramientaOverlays*     hOverlays = NULL;
	GNKVisualizator::IHerramientaMapaColor*    hMapa = NULL;

	try {
		// Subscribimos la vista al contrato de puntero
		hPuntero = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
		if (hPuntero != NULL) {
			GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>* contratablevtk=hPuntero;
			contratablevtk->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de regla
		hRegla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
		if (hRegla != NULL) {
			hRegla->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de angulo
		hAngulo = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAngulo>(GNC::GCS::IHerramientaAngulo::ID);
		if (hAngulo != NULL) {
			hAngulo->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de marcado
		hMarcado = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaMarcado>(GNC::GCS::IHerramientaMarcado::ID);
		if (hMarcado != NULL) {
			hMarcado->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de hNota
		hNota = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaNota>(GNC::GCS::IHerramientaNota::ID);
		if (hNota != NULL) {
			hNota->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de Anotaciones ventana
		hAnotacionesEsquina = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			hAnotacionesEsquina->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de Lupa
		hLupa = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLupa>(GNC::GCS::IHerramientaLupa::ID);
		if (hLupa != NULL) {
			((GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>*) hLupa)->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de rejilla
		hRejilla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRejillaMetrica>(GNC::GCS::IHerramientaRejillaMetrica::ID);
		if (hRejilla != NULL) {
			hRejilla->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de mapas de color
		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			hReset->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de mapas de color
		hInterpolate = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaInterpolate>(GNC::GCS::IHerramientaInterpolate::ID);
		if (hInterpolate != NULL) {
			hInterpolate->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de tags
		hHerramientaLayoutVentana = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLayoutVentana>(GNC::GCS::IHerramientaLayoutVentana::ID);
		if (hHerramientaLayoutVentana != NULL) {
			hHerramientaLayoutVentana->Subscribir(this, GVista);
		}

		// Subscribimos la vista al contrato de mapas de color
		hOverlays = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaOverlays>(GNKVisualizator::IHerramientaOverlays::ID);
		if (hOverlays != NULL) {
			hOverlays->Subscribir(this, GVista);
		}

		// Subscribimos la vista al contrato de mapas de color
		hMapa = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaMapaColor>(GNKVisualizator::IHerramientaMapaColor::ID);
		if (hMapa != NULL) {
			hMapa->Subscribir(this, GVista);
		}		
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
	}
}


GNKVisualizator::Vista2D::~Vista2D()
{
//	VisualizatorStudy->Entorno->GetControladorCarga()->FreeLoader(&m_pLoader);
	m_IgnorarModificaciones = true;
	GTRACE(">> Vista2D::~Vista2D() " << this)

	GNC::GCS::IControladorHerramientas* cH = VisualizatorStudy->Entorno->GetControladorHerramientas();
	GNC::GCS::IHerramientaPuntero*            hPuntero = NULL;
	GNC::GCS::IHerramientaRegla*              hRegla = NULL;
	GNC::GCS::IHerramientaAngulo*             hAngulo = NULL;
	GNC::GCS::IHerramientaNota*               hNota = NULL;
	GNC::GCS::IHerramientaWindowLevel*        hWindowLevel = NULL;
	GNC::GCS::IHerramientaAnotacionesEsquina* hAnotacionesEsquina = NULL;
	GNC::GCS::IHerramientaLupa*               hLupa = NULL;
	GNC::GCS::IHerramientaMarcado*            hMarcado       = NULL;
	GNC::GCS::IHerramientaRejillaMetrica*     hRejilla = NULL;
	GNC::GCS::IHerramientaReset*              hReset = NULL;
	GNC::GCS::IHerramientaInterpolate*			 hInterpolate = NULL;
	GNC::GCS::IHerramientaLayoutVentana*      hHerramientaLayoutVentana = NULL;
	GNKVisualizator::IHerramientaOverlays*          hOverlays = NULL;
	GNKVisualizator::IHerramientaMapaColor*         hMapa = NULL;

	try {
		// Desubscribimos la vista al contrato de puntero
		hPuntero = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
		if (hPuntero != NULL) {
			GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>* contratablevtk = hPuntero;
			contratablevtk->DesSubscribirsLosDeLaVista(this);
		}

		// Desubscribimos la vista al contrato de puntero
		hRegla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
		if (hRegla != NULL) {
			hRegla->DesSubscribirsLosDeLaVista(this);
		}

		// Desubscribimos la vista al contrato de puntero
		hAngulo = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAngulo>(GNC::GCS::IHerramientaAngulo::ID);
		if (hAngulo != NULL) {
			hAngulo->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de hNota
		hNota = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaNota>(GNC::GCS::IHerramientaNota::ID);
		if (hNota != NULL) {
			hNota->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de hWindowLevel
		hWindowLevel = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaWindowLevel>(GNC::GCS::IHerramientaWindowLevel::ID);
		if (hWindowLevel != NULL) {
			((GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>*)hWindowLevel)->DesSubscribirsLosDeLaVista(this);
			((GNC::GCS::IContratable<GNC::GCS::IContratoWindowLevel>*)hWindowLevel)->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de hLupa
		hLupa = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLupa>(GNC::GCS::IHerramientaLupa::ID);
		if (hLupa != NULL) {
			hLupa->DesSubscribirsLosDeLaVista(this);
		}

		// desubscribimos la vista al contrato de anotaciones ventana
		hAnotacionesEsquina= cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			hAnotacionesEsquina->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de marcado
		hMarcado = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaMarcado>(GNC::GCS::IHerramientaMarcado::ID);
		if (hMarcado != NULL) {
			hMarcado->DesSubscribirsLosDeLaVista(this);
		}

		// Subscribimos la vista al contrato de la rejilla metrica
		hRejilla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRejillaMetrica>(GNC::GCS::IHerramientaRejillaMetrica::ID);
		if (hRejilla != NULL) {
			hRejilla->DesSubscribirsLosDeLaVista(this);
		}

		// Subscribimos la vista al contrato de mapas de color
		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			hReset->DesSubscribirsLosDeLaVista(this);
		}

		// Subscribimos la vista al contrato de mapas de color
		hInterpolate = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaInterpolate>(GNC::GCS::IHerramientaInterpolate::ID);
		if (hInterpolate != NULL) {
			hInterpolate->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos paneltags
		hHerramientaLayoutVentana = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLayoutVentana>(GNC::GCS::IHerramientaLayoutVentana::ID);
		if (hHerramientaLayoutVentana != NULL) {
			hHerramientaLayoutVentana->DesSubscribirsLosDeLaVista(this);
		}

		// Subscribimos la vista al contrato de mapas de color
		hOverlays = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaOverlays>(GNKVisualizator::IHerramientaOverlays::ID);
		if (hOverlays != NULL) {
			hOverlays->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de mapas de color
		hMapa = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaMapaColor>(GNKVisualizator::IHerramientaMapaColor::ID);
		if (hMapa != NULL) {
			hMapa->DesSubscribirsLosDeLaVista(this);
		}		
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero. No se pudo des-subscribir la herramienta: " << ex.getCause() << std::endl;
	}

	/*
	for(TipoFicherosGNKVisualizator::iterator it = m_ficherosGNKVisualizator.begin(); it!= m_ficherosGNKVisualizator.end(); it++){
		delete (*it);
	}
	m_ficherosGNKVisualizator.clear();
	*/

	GTRACE("<< VistaSimple::~VistaSimple() " << this)
}

//----------------------------------------------------------------------------------------------------
//region Interfaz de Carga


// Comienzo de carga. Metodo sincrono con la interfaz.
void GNKVisualizator::Vista2D::OnCargaIniciada()
{
}

// Paso 1: Cargar los ficheros en memoria. Metodo NO sincrono con la interfaz.
void GNKVisualizator::Vista2D::CargarEstudio(GNC::GCS::IComando* pCmdInvocador)
{
	
}

// Finalizacion de la carga. Metodo sincrono con la interfaz.
void GNKVisualizator::Vista2D::OnCargaFinalizada()
{
	GVista->OnCargaFinalizada();
}

// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
void GNKVisualizator::Vista2D::IniciarPipeline()
{
	try {
		GVista->IniciarPipeline();
	}
	catch (const std::bad_alloc&) {
		DetenerPipeline();
		m_Cargada = false;
		throw GNC::GCS::VistaException(_Std("Error: System out of memory. Close some studies to free memory."));
	}
	catch (GNC::GCS::VistaException& ex) {
		DetenerPipeline();
		m_Cargada = false;
		throw ex;
	}

	m_Cargada = true;

	//se conecta el evento Ginkgo
	GNC::GCS::Eventos::EventoModificacionFichero evtModificado;
	evtModificado.SetVista(this);
	
	VisualizatorStudy->Entorno->GetControladorEventos()->Registrar(this,evtModificado);

	//tengo que cargar todos los widgets porque si no se podrian perder el evento de recalibrado
	m_IgnorarModificaciones=true;
	VisualizatorStudy->CargarWidgets();	
	m_IgnorarModificaciones=false;

	GVista->GoToSlice(0,false,false);

	//lanzo el evento de imagen cargada
	VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(this,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada));
	VisualizatorStudy->Entorno->GetControladorHerramientas()->RefrescarHerramientas();

	GenerarTitulo();
}

// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
void GNKVisualizator::Vista2D::DetenerPipeline()
{
	GVista->DetenerPipeline();
}

//endregion


//region Interfaz IVista
bool GNKVisualizator::Vista2D::SoportaHerramienta(GNC::GCS::IHerramienta* h)
{
	return GVista->GetManipulacionEnabled();
}
//endregion



bool GNKVisualizator::Vista2D::SoportaGuardar()
{
	std::string namespacePermisos("atencionprimaria.vista2d");
	if(VisualizatorStudy->Entorno->GetControladorPermisos()->Get(namespacePermisos,"guardar cambios")) {
		return true;
	} else {
		return false;
	}
}

bool GNKVisualizator::Vista2D::SoportaExportar()
{
	return true;
}

std::string GNKVisualizator::Vista2D::GetDICOMTagOriginal(std::string tagId)
{
	std::string str("");
	VisualizatorStudy->GetTagImagenActiva(tagId, str);
	return str;
}

std::string GNKVisualizator::Vista2D::GetDICOMTagDiagnostico(std::string tagId)
{
	std::string str("");
	VisualizatorStudy->GetTagDiagnosticoActivo(tagId, str);
	return str;
}

void GNKVisualizator::Vista2D::OnFocus()
{
	if (!m_Activada) {
		VisualizatorStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
	}
}

void GNKVisualizator::Vista2D::Activar()
{
	GNC::GCS::IVista::Activar();
	VisualizatorStudy->Modulo->OcultarPaneles();
//#if defined(_WINDOWS)
	GVista->SetFocus();
//#endif
}

void GNKVisualizator::Vista2D::Desactivar(){
	GNC::GCS::IVista::Desactivar();
	VisualizatorStudy->Modulo->OcultarPaneles();
}

wxWindow* GNKVisualizator::Vista2D::GetWindow()
{
	return GVista;
}


bool GNKVisualizator::Vista2D::Guardar() {
	bool correcto = true;
	
	GTRACE("VistaSimple::Guardar()")
	
	std::string namespacePermisos("atencionprimaria.vista2d");
	if(VisualizatorStudy->Entorno->GetControladorPermisos()->Get(namespacePermisos,"guardar cambios")) {
		correcto = VisualizatorStudy->Guardar();

		//se publica el evento de guardado
		if(correcto){
			GenerarTitulo();

			GNC::GCS::Eventos::EventoModificacionFichero* evt = new GNC::GCS::Eventos::EventoModificacionFichero(this, VisualizatorStudy, GNC::GCS::Eventos::EventoModificacionFichero::FicheroGuardado);
			VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(evt);
			VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(this,GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas));
		}
		else {
			wxMessageBox(_("Errors have occurred while trying to save the files in the series\nverify that the disk is not full and that has write permissions"),
				_("Error"));
		}
	}
	
	return correcto;
}

void GNKVisualizator::Vista2D::PreProcesarEvento(GNC::GCS::Eventos::IEvento* /*evt*/, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& /*lista*/)
{
	GTRACE("VistaSimple::PreprocesarEvento()" << this);
}

void GNKVisualizator::Vista2D::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	std::string namespacePermisos("atencionprimaria.vista2d");
	if(!m_IgnorarModificaciones && VisualizatorStudy->Entorno->GetControladorPermisos()->Get(namespacePermisos,"guardar cambios")){
		GNC::GCS::Eventos::EventoModificacionFichero* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionFichero*>(evt);
		if(pEvt != NULL){
			VisualizatorStudy->SetModificadoFicheroActivo();
			GNC::GCS::Eventos::EventoModificacionFichero* evt2 = new GNC::GCS::Eventos::EventoModificacionFichero(this, VisualizatorStudy);
			VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(evt2);
		}
	}	
}

void GNKVisualizator::Vista2D::AsignarConexionesDeFiltrado(vtkImageData** pImagen, int* slice, vtkImageData** pChroma)
{
	GVista->AsignarConexionesDeFiltrado(pImagen, slice, pChroma);
}

void GNKVisualizator::Vista2D::ActualizarImagen()
{
	GVista->ActualizarImagen();
}

/* Notificacion de cambio en la configuracion */
void GNKVisualizator::Vista2D::OnConfiguracionCambiada() {
	VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(this,GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas));
}

void GNKVisualizator::Vista2D::ActivarRuta(const std::string& pathCorte)
{
	int indice = VisualizatorStudy->GetIndicePath(pathCorte);
	if (indice >= 0) {
		GVista->GoToSlice(indice, false, true, true);
	}
}

void GNKVisualizator::Vista2D::ComienzaDestruccion()
{
	m_IgnorarModificaciones=true;
}

void ActivarRuta(const std::string & path)
{
}

void GNKVisualizator::Vista2D::GetImageActual(ImageType::Pointer& img, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size)
{
	GetImage(img, GVista->m_posicion, mapasValoracion, conWidgets, size);
}

void GNKVisualizator::Vista2D::GetImage(ImageType::Pointer& img, int index, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size)
{
	//como no tiene mapas no se redirige
	GVista->GetImage(img, index, conWidgets, size);
}

GNKVisualizator::Vista2D::MapaMapasValoracion GNKVisualizator::Vista2D::GetMapasValoracion()
{
	MapaMapasValoracion mapas;
	return mapas;
}

void GNKVisualizator::Vista2D::GenerarTitulo()
{
	std::ostringstream ostr;
	std::string valor;

	VisualizatorStudy->GetTagImagenActiva("0010|0010",valor);
	for (std::string::iterator it = valor.begin(); it != valor.end(); it++) {
		if ( *it == '^') {
			*it = ' ';
		}
	}
	ostr << valor.c_str() << ", ";
	VisualizatorStudy->GetTagImagenActiva("0008|1030",valor);
	ostr << valor.c_str();
	if (!valor.empty()) {
		ostr << "/";
	}
	VisualizatorStudy->GetTagImagenActiva("0008|103e",valor);
	ostr << valor.c_str();
	m_Titulo = ostr.str();
}

