/*
 *  
 *  $Id: visualizator.cpp 4109 2011-09-01 07:56:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "visualizator.h"
#include <visualizator/license.h>
#include "visualizator/controllers/visualizatorcontroller.h"
#include <api/ientorno.h>
#include <iostream>
#include <wx/msgdlg.h>

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif

IMPLEMENT_PrivateExtension(GNKVisualizatorExtension)


GNKVisualizatorExtension::GNKVisualizatorExtension():PrivateExtension(VISUALIZATOR_SID, VISUALIZATOR_PROVIDER, VISUALIZATOR_DESCRIPTION, VISUALIZATOR_VERSION, VISUALIZATOR_SUB_VERSION, VISUALIZATOR_SUB_RELEASE)
{
}
GNKVisualizatorExtension::~GNKVisualizatorExtension()
{
}
GNC::GCS::IControladorModulo* GNKVisualizatorExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	return new GNKVisualizator::ControladorAtencionPrimaria(pEntorno);
}
bool GNKVisualizatorExtension::IsActivated()
{
	return true;
}
void GNKVisualizatorExtension::ShowActivationDialog(wxWindow* pParent)
{
	wxMessageBox(_("Ginkgo CADx visualizator is Open Source"), _("Info"));
}

