/*
 *  $Id: lightvisualizatorextension.cpp 4103 2011-08-31 06:33:25Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include "lightvisualizatorextension.h"
#include "lightvisualizator/controllers/lightvisualizatorcontroller.h"
#include <api/ientorno.h>

#include <iostream>
#include <wx/config.h>
#include <wx/msgdlg.h>
#include "lightvisualizator/license.h"

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif

//it's required to call this macro
IMPLEMENT_PrivateExtension(LightVisualizatorExtension)

//parameters are related with provider, version... sid is the extension id, it's used to know if a file has been imported by this extension
//this information will be used in viewer open preference
LightVisualizatorExtension::LightVisualizatorExtension(): PrivateExtension(LIGHT_VISUALIZATOR_SID_EXTENSION, LIGHT_VISUALIZATOR_PROVIDER, LIGHT_VISUALIZATOR_DESCRIPTION, LIGHT_VISUALIZATOR_VERSION, LIGHT_VISUALIZATOR_SUB_VERSION, LIGHT_VISUALIZATOR_SUB_RELEASE)
{
}

LightVisualizatorExtension::~LightVisualizatorExtension()
{
}

//returns extension controller module
GNC::GCS::IControladorModulo* LightVisualizatorExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	return new LightVisualizator::LightVisualizatorController(pEntorno);
}

//here you can implement your own security policy
bool LightVisualizatorExtension::IsActivated()
{
	return true;
}

//this extension is free to use
void LightVisualizatorExtension::ShowActivationDialog(wxWindow* pParent)
{	
	wxMessageBox(_("Lite Visualizator is Open Source"), _("Info"));
}

