/*
 *  
 *  $Id: prvext.h 4072 2011-08-10 13:45:52Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>

#if defined(_WINDOWS)
#include <windows.h>
#endif

#include <main/licencia.h>

#include <iostream>
#include <string>

class wxWindow;

namespace GNC {
	namespace GCS {
		class IEntorno;
		class IControladorModulo;
	}
}
#if defined(_DEBUG)
	#define PRIVATE_EXTENSION_NAME CreatePrivateExtensionDebug
#else
	#define PRIVATE_EXTENSION_NAME CreatePrivateExtension
#endif


#if defined(WIN32)
	#if defined(_DEBUG)
		#define IMPLEMENT_PrivateExtension(name) extern "C" __declspec(dllexport) PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};
	#else
		#define IMPLEMENT_PrivateExtension(name) extern "C" __declspec(dllexport) PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};
	#endif
#else
	#if defined(_DEBUG)
		#define IMPLEMENT_PrivateExtension(name) extern "C" EXTAPI PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};
	#else
		#define IMPLEMENT_PrivateExtension(name) extern "C" EXTAPI PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};
	#endif

	
#endif

class PrivateExtension
{
public:
	PrivateExtension(const std::string& sid, const std::string& provider, const std::string& description, int version, int subversion, int subrelease, const unsigned char* pixelDataIcon = NULL, unsigned int iconSize = 0)
	{
		this->sid = sid;
		this->provider = provider;
		this->description = description;
		this->version = version;
		this->subversion = subversion;
		this->subrelease = subrelease;
		this->iconSize = iconSize;
		this->pixelDataIcon = pixelDataIcon;

		this->coreVersion = GINKGO_VERSION;
		this->coreSubversion = GINKGO_SUB_VERSION;

		AsignarFechaCompilacion(__DATE__);
	}

	PrivateExtension(const PrivateExtension& o)
	{
		*this = o;
	}

	virtual ~PrivateExtension()
	{
	}

	virtual GNC::GCS::IControladorModulo* InitializeLibrary(GNC::GCS::IEntorno* pEntorno) = 0;
	virtual bool IsActivated() = 0;
	virtual void ShowActivationDialog(wxWindow* pParent) = 0;

	int GetVersion() const
	{
		return this->version;
	}

	int GetSubVersion() const
	{
		return this->subversion;
	}

	int GetSubRelease() const
	{
		return this->subrelease;
	}

	const std::string& GetSID() const
	{
		return this->sid;
	}

	const std::string& GetProvider() const
	{
		return this->provider;
	}

	const std::string& GetDescription() const
	{
		return this->description;
	}

	void AsignarFechaCompilacion(const std::string& fecha)
	{
		this->fecha_compilacion = fecha;
	}

	void AsignPath(const std::string& path) 
	{
		this->path = path;
	}

	const std::string& GetPath() const
	{
		return this->path;
	}

	const std::string& GetFechaCompilacion() const
	{
		return this->fecha_compilacion;
	}

	int GetCoreVersion() const 
	{
		return coreVersion;
	}

	int GetCoreSubVersion() const 
	{
		return coreSubversion;
	}

	const unsigned char* GetPixelDataIcon()
	{
		return pixelDataIcon;
	}

	int GetIconSize() {
		return iconSize;
	}

	PrivateExtension& operator=(const PrivateExtension& o)
	{
		this->version = o.version;
		this->subversion = o.subversion;
		this->subrelease = o.subrelease;
		this->sid = o.sid;
		this->provider = o.provider;
		this->description = o.description;
		this->fecha_compilacion = o.fecha_compilacion;

		this->coreVersion = o.coreVersion;
		this->coreSubversion = o.coreSubversion;
		this->pixelDataIcon = o.pixelDataIcon;
		this->iconSize = o.iconSize;
		return *this;
	}

	friend std::ostream& operator<<(std::ostream &os, const PrivateExtension& ext)
	{
		return os << ext.GetSID() << " V" << ext.GetVersion() << "." << ext.GetSubVersion()<< "." << ext.GetSubRelease() << ". (c) " << ext.GetProvider().c_str() << " " << ext.GetFechaCompilacion().c_str();
	}

	friend std::ostream& operator<<(std::ostream& os, PrivateExtension* ext)
	{
		if (ext != NULL) {
			return os << (*ext);
		}
		else {
			return os << "NULL";
		}
	}

protected:
	int version;
	int subversion;
	int subrelease;
	int coreVersion;
	int coreSubversion;
	std::string sid;
	std::string provider;
	std::string description;
	std::string fecha_compilacion;
	std::string path;
	const unsigned char* pixelDataIcon;
	unsigned int	iconSize;
};

//define a function pointer type for convenience
#ifndef __PLUGIN_FUNCTION
#define __PLUGIN_FUNCTION
typedef PrivateExtension* ( *CreatePrivateExtension_function)();
#endif //__PLUGIN_FUNCTION

