/*
 *
 *  $Id: panelestudio.cpp 4044 2011-07-22 12:21:07Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/app.h>
#include "panelestudio.h"
#include <wx/menu.h>
#include <wx/msgdlg.h>
#include <wx/dcclient.h>
#include "dialogoconfirmacioneliminar.h"
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorpermisos.h>
#include <main/gui/pacsupload/wxwizarduploadpacs.h>
#include <main/entorno.h>
#include <resources/ginkgoresourcemanager.h>
#define WIDTH_OF_SERIE 127

#define FONDO_INACTIVO wxColour(72,72,72)
#define FONDO_ACTIVO   wxColour(183,143,12)

namespace GNC {
	namespace GUI {
		PanelEstudio::PanelEstudio(INodoHistorial* pPadre, wxWindow* pParentWindow, const std::string& descripcion, const std::string& uidEstudio):
			PanelEstudioBase(pParentWindow),INodoHistorial(pPadre,uidEstudio) {

			if(descripcion != "") {
				m_pLabelEstudio->SetToolTip(wxString::FromUTF8(descripcion.c_str()));

				wxString tmp = wxString::FromUTF8(descripcion.c_str());
				wxClientDC dc(this);
				dc.SetFont(m_pLabelEstudio->GetFont());
				int x,y;
				dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);

				while(x > 190)
				{
					dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);
					tmp = tmp.substr(0,tmp.size()-2);
				}
				if(descripcion.size() != tmp.size()) {
					std::stringstream ostr;
					ostr << tmp.ToUTF8() << "...";
					m_pLabelEstudio->SetLabel(wxString::FromUTF8(ostr.str().c_str()));
				} else {
					m_pLabelEstudio->SetLabel(wxString::FromUTF8(descripcion.c_str()));
				}
				this->SetToolTip(wxString::FromUTF8(descripcion.c_str()));
			} else {
				m_pLabelEstudio->SetLabel(_("No description"));
			}
			m_pLabelEstudio->Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( PanelEstudio::OnMouseWheel ), NULL, this );
			SetAutoLayout(true);

			Layout();
		}
		PanelEstudio::~PanelEstudio()
		{
			if(EstaSeleccionado()){
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(NULL));
			}
		}

		void PanelEstudio::Seleccionar(bool seleccionar,bool force)
		{
			if(m_seleccionado!=seleccionar || force){
				m_seleccionado = seleccionar;
				Refresh();
			}
		}

		PanelSerie* PanelEstudio::GetSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie){
			TMapaHijos::iterator it = m_mapaHijos.find(modeloSerie.m_uidSerie);
			if(it != m_mapaHijos.end()){
				return (PanelSerie*)(*it).second;
			}else{
				PanelSerie* pSerie = new PanelSerie(this,this,modeloSerie.m_descripcionSerie,modeloSerie.m_fechaSerie,modeloSerie.m_horaSerie,modeloSerie.m_uidImportador,modeloSerie.m_modalidad,modeloSerie.m_uidSerie, modeloSerie.m_numeroSlices, modeloSerie.m_uidEstudio, modeloSerie.m_uidTransferSyntax);
				m_pSizerSeries->Add(pSerie,0,wxTOP|wxALIGN_CENTER,1);
				Layout();
				m_mapaHijos[modeloSerie.m_uidSerie]=pSerie;
				return pSerie;
			}
		}

		void PanelEstudio::OnPaint(wxPaintEvent &event)
		{
			PanelEstudioBase::OnPaint(event);
			{
				wxPaintDC dc(this);
				if (m_seleccionado) {
					dc.SetBrush(wxBrush(FONDO_ACTIVO,wxTRANSPARENT));
					dc.SetPen(wxPen(FONDO_ACTIVO, 1, wxSOLID));
				} else {
					dc.SetBrush(wxBrush(FONDO_INACTIVO,wxTRANSPARENT));
					dc.SetPen(wxPen(FONDO_INACTIVO, 1, wxSOLID));
				}
				dc.DrawRectangle(wxRect(wxPoint(0,0), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
			}
		}

		void PanelEstudio::OnSize(wxSizeEvent &event)
		{
			Layout();
			event.Skip();
		}

		void PanelEstudio::OnMouseSeleccionar(wxMouseEvent &event)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(this));
			event.Skip(false);
		}

		void PanelEstudio::OnMenuMouse(wxMouseEvent &event)
		{
			//se selecciona
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(this));
			wxMenu menu;
		/*	menu.Append(5, _("Open Study"));
			menu.Connect(5,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelEstudio::OnAbrir),NULL,this);
			menu.Append(5, wxT("Abrir Serie con.."));
			menu.Connect(5,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelHistorial::OnAbrirCon),NULL,this);*/
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_upload")) {
				wxMenuItem* pMenuSend = new wxMenuItem(&menu, 7, wxString( _("Send to PACS server") ), _("Send to PACS server"), wxITEM_NORMAL );
				menu.Connect(7,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelEstudio::OnUploadPACS),NULL,this);
				#ifdef __WXMSW__
				pMenuSend->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
				#else
				pMenuSend->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
				#endif
				menu.Append(pMenuSend);
				menu.AppendSeparator();
			}

			wxMenuItem* pMenuEliminar = new wxMenuItem(&menu, 3, wxString( _("&Delete from history") ), _("Delete"), wxITEM_NORMAL );
			menu.Connect(3,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelEstudio::OnEliminar),NULL,this);
			#ifdef __WXMSW__
			pMenuEliminar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
			#else
			pMenuEliminar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
			#endif
			menu.Append(pMenuEliminar);
			menu.AppendSeparator();

			wxMenuItem* pMenuLimpiar = new wxMenuItem(&menu, 4, wxString( _("&Clear History") ), _("Delete"), wxITEM_NORMAL );
			menu.Connect(4,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelEstudio::OnLimpiarHistorial),NULL,this);
			#ifdef __WXMSW__
			pMenuLimpiar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
			pMenuLimpiar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
			#endif
			menu.Append(pMenuLimpiar);

			GNC::Entorno::Instance()->GetVentanaRaiz()->PopupMenu(&menu);
			event.Skip(false);
		}

		void PanelEstudio::OnMouseWheel(wxMouseEvent& event)
		{
			event.ResumePropagation(2);
			event.Skip(true);
		}

		void PanelEstudio::OnEliminar(wxCommandEvent& event)
		{
			for(TMapaHijos::iterator it=m_mapaHijos.begin(); it!= m_mapaHijos.end(); it++) {
				if ((*it).second->HayNodosAbiertos())
				{
					wxMessageBox(_("You can't remove opened studies"), _("Info"),
						wxOK | wxICON_WARNING);
					event.Skip(false);
					return;
				}
			}

			bool eliminar = false;
			{
				DialogoConfirmacionEliminar dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), _("this Study"));
				dlg.ShowModal();
				switch (dlg.GetResultado()) {
					case DialogoConfirmacionEliminar::TR_Eliminar :
						GNC::GCS::ControladorHistorial::Instance()->EliminarEstudio(m_clave,true);
						eliminar = true;
						break;
					case DialogoConfirmacionEliminar::TR_Cancelar :
						break;
				}
			}
			if(eliminar){
				Eliminar();
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			}
			event.Skip(false);
		}

		void PanelEstudio::OnLimpiarHistorial(wxCommandEvent &event)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLimpiarHistorial());
			event.Skip(false);
		}

		void PanelEstudio::OnUploadPACS(wxCommandEvent &)
		{
			wxWizardUploadPACSGinkgo::TListUIDs uidsList;

			GNC::GCS::ControladorHistorial::ListaModelosSeries seriesList;
			GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerieStudy(m_clave, seriesList);

			for (GNC::GCS::ControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
			{
				uidsList.push_back((*it).m_uidSerie);
			}

			wxWizardUploadPACSGinkgo wiz(GNC::Entorno::Instance()->GetVentanaRaiz(), uidsList);
			wiz.ShowModal();
		}

		void PanelEstudio::Detach(wxWindow* pHijo)
		{
			m_pSizerSeries->Detach(pHijo);
			pHijo->Hide();
			Layout();
		}

		void PanelEstudio::Eliminar()
		{
			m_pPadre->Detach(this);
			if(m_pPadre->Eliminar(this)) {
				this->Destroy();
			}
		}

		void PanelEstudio::OnAbrir(wxCommandEvent& )
		{
			if (m_mapaHijos.size() > 0) {
				((PanelSerie*)(*m_mapaHijos.begin()).second)->Abrir(true);
			}
		}
	}
}
