/*
 *  
 *  $Id: controladorextensiones.h 3832 2011-05-09 12:23:07Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladorextensiones.h>
#include <api/icontroladormodulo.h>
#include <map>
#include <string>

namespace GNC {

	class EXTAPI ControladorExtensiones : public GNC::GCS::IControladorExtensiones {
	public:

		static ControladorExtensiones* Instance();
		static void FreeInstance();

		void RegistrarModulo(GNC::GCS::IControladorModulo* pCtrlModulo);
		void DesRegistrarModulo(GNC::GCS::IControladorModulo* pCtrlModulo);
		void DesRegistrarModulos();

		GNC::GCS::IControladorModulo* ObtenerModulo(const std::string& idModulo);

		typedef std::map<std::string, GNC::GCS::IControladorModulo*> ListaModulos;
		typedef ListaModulos::iterator IteradorListaModulos;
		typedef ListaModulos::const_iterator IteradorConstanteListaModulos;

		std::list<GNC::GCS::IControladorModulo*> ModulosOrdenados();
		const ControladorExtensiones::ListaModulos& Modulos() const;

		// Realizacin de la interfaz IControladorExtensiones
		virtual GADVAPI::PrivateExtensionManager& GetPrivateExtensionsManager();

	protected:
		ControladorExtensiones();
		~ControladorExtensiones();

		void NotificarRegistro(GNC::GCS::IControladorModulo* pModulo);
		void NotificarDesRegistro(GNC::GCS::IControladorModulo* pModulo);

	protected:
		static ControladorExtensiones* m_pInstance;
		ListaModulos m_Modulos;

		GADVAPI::PrivateExtensionManager m_Manager;

	};
}
