/*
*
*  $Id: ipipeline.cpp 3830 2011-05-06 13:30:18Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#if defined(__DEPRECATED)
#undef __DEPRECATED
#endif

#include "../volumedataset/volumedataset.h"
#include "ipipeline.h"
#include <main/controllers/controladorlog.h>


#include <wx/window.h>

#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkCamera.h>
#include <vtkWindowToImageFilter.h>
#include <vtkJPEGWriter.h>


MedicalViewer::Reconstruction::Pipelines::IPipeline::IPipeline(const std::string& name, wxWindow* win3d) : PipelineName(name), Renderer(vtkSmartPointer<vtkRenderer>::New()), Initiallized(false), Win3D(win3d)
{
}

MedicalViewer::Reconstruction::Pipelines::IPipeline::~IPipeline()
{
}

GnkPtr<MedicalViewer::Reconstruction::Pipelines::IPipeline::TDataSet> MedicalViewer::Reconstruction::Pipelines::IPipeline::FindDataSet(unsigned int vol)
{
	unsigned int i = 0;

	for (TDataSetList::iterator it = DataSets.begin(); it != DataSets.end(); it++, i++) {
		if (i == vol) {
			return *it;
		}
	}
	return GnkPtr<TDataSet>();
}

void MedicalViewer::Reconstruction::Pipelines::IPipeline::ResetCamera()
{
	Renderer->ResetCamera();
	Renderer->ResetCameraClippingRange();
}

void MedicalViewer::Reconstruction::Pipelines::IPipeline::Print(const std::string& dest)
{
	LOG_DEBUG(PipelineName, _Std("Saving frame..."));

	try {
		vtkSmartPointer<vtkWindowToImageFilter> screen = vtkSmartPointer<vtkWindowToImageFilter>::New();
		vtkSmartPointer<vtkJPEGWriter> imgWriter = vtkSmartPointer<vtkJPEGWriter>::New();

		screen->SetInput(this->Renderer->GetRenderWindow());
		imgWriter->SetInput(screen->GetOutput());
		imgWriter->SetQuality(100);
		imgWriter->SetFileName(dest.c_str());
		imgWriter->ProgressiveOff();
		imgWriter->Write();

		LOG_DEBUG(PipelineName, _Std("Saving done"));

	}
	catch (...)
	{
		LOG_ERROR(PipelineName, _Std("Saving failed"));
	}
}

void MedicalViewer::Reconstruction::Pipelines::IPipeline::Render()
{
	if (!Initiallized) {
		Initiallized = true;
		ResetCamera();
	}
	if (Win3D) {
		Win3D->Refresh(false);
	}
}

void MedicalViewer::Reconstruction::Pipelines::IPipeline::RotateDemo(double angle)
{

	if (Renderer) {
		vtkCamera* cam = Renderer->GetActiveCamera();
		if (cam) {
			//cam->Roll(angle);
			cam->Azimuth(angle);
			Renderer->ResetCameraClippingRange();
		}
	}

}
