/*
 *  
 *  $Id: waveformview.cpp 3834 2011-05-10 07:42:57Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/wx.h>
#include <wx/checkbox.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/busyinfo.h>
#include <wx/msgdlg.h>
#include <wx/xml/xml.h>
#include <wx/utils.h>

#include <api/globals.h>
#include <api/icontroladorherramientas.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorcarga.h>
#include <api/dicom/imodelodicom.h>
#include <api/dicom/idicomizador.h>
#include <api/icontroladorpermisos.h>
#include <eventos/eventosginkgo.h>

#include <export/iherramientapuntero.h>
#include <export/iherramientaregla.h>
#include <export/iherramientaangulo.h>
#include <export/iherramientanota.h>
#include <export/iherramientamarcado.h>
#include <export/iherramientarejillametrica.h>
#include <export/iherramientaanotacionesesquina.h>
#include <api/imodelointegracion.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorpermisos.h>
#include <export/iherramientareset.h>
#include "../eventos/visualizatorevents.h"
#include "../estudios/visualizatorstudy.h"

#include <visualizator/widgets/wecg.h>

#include "waveformview.h"
#include "../wxvtk/gwaveformview.h"
#include "../dialogos/contenedorherramientas.h"


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkDataSetAttributes.h>
#include <vtkAlgorithm.h>
#include <vtkAlgorithmOutput.h>
#include <vtkImageData.h>
#include <hackimageactor.h>
#include <vtkAlgorithmOutput.h>
#include <vtkInformation.h>

/* Constructor */

GNKVisualizator::WaveFormView::WaveFormView(const GnkPtr<GNKVisualizator::ECGStudy>& estudio) : GNC::GCS::IVista((GnkPtr<GNC::GCS::IContextoEstudio>)estudio), VisualizatorStudy(estudio)
{
	m_Cargada = false;
	
	VisualizatorStudy->Ventana = GVista = new GNKVisualizator::GUI::GWaveformView(this);

	GNC::GCS::IControladorHerramientas* cH = VisualizatorStudy->Entorno->GetControladorHerramientas();

	GNC::GCS::IHerramientaPuntero*             hPuntero = NULL;
	GNC::GCS::IHerramientaRegla*               hRegla = NULL;
	GNC::GCS::IHerramientaAngulo*              hAngulo = NULL;
	GNC::GCS::IHerramientaNota*                hNota = NULL;
	GNC::GCS::IHerramientaAnotacionesEsquina*  hAnotacionesEsquina = NULL;
	GNC::GCS::IHerramientaMarcado*             hMarcado       = NULL;
	GNC::GCS::IHerramientaReset*               hReset = NULL;

	try {
		// Subscribimos la vista al contrato de puntero
		hPuntero = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
		if (hPuntero != NULL) {
			GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>* contratablevtk=hPuntero;
			contratablevtk->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de regla
		hRegla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
		if (hRegla != NULL) {
			hRegla->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de angulo
		hAngulo = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAngulo>(GNC::GCS::IHerramientaAngulo::ID);
		if (hAngulo != NULL) {
			hAngulo->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de marcado
		hMarcado = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaMarcado>(GNC::GCS::IHerramientaMarcado::ID);
		if (hMarcado != NULL) {
			hMarcado->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de hNota
		hNota = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaNota>(GNC::GCS::IHerramientaNota::ID);
		if (hNota != NULL) {
			hNota->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de Anotaciones ventana
		hAnotacionesEsquina = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			hAnotacionesEsquina->Subscribir(this,GVista);
		}

		// Subscribimos la vista al contrato de mapas de color
		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			hReset->Subscribir(this,GVista);
		}	
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
	}
}


GNKVisualizator::WaveFormView::~WaveFormView()
{
	GTRACE(">> WaveFormView::~WaveFormView() " << this)

	GNC::GCS::IControladorHerramientas* cH = VisualizatorStudy->Entorno->GetControladorHerramientas();
	GNC::GCS::IHerramientaPuntero*            hPuntero = NULL;
	GNC::GCS::IHerramientaRegla*              hRegla = NULL;
	GNC::GCS::IHerramientaAngulo*             hAngulo = NULL;
	GNC::GCS::IHerramientaNota*               hNota = NULL;
	GNC::GCS::IHerramientaAnotacionesEsquina* hAnotacionesEsquina = NULL;
	GNC::GCS::IHerramientaMarcado*            hMarcado       = NULL;
	GNC::GCS::IHerramientaReset*              hReset = NULL;

	try {
		// Desubscribimos la vista al contrato de puntero
		hPuntero = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
		if (hPuntero != NULL) {
			GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>* contratablevtk = hPuntero;
			contratablevtk->DesSubscribirsLosDeLaVista(this);
		}

		// Desubscribimos la vista al contrato de puntero
		hRegla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
		if (hRegla != NULL) {
			hRegla->DesSubscribirsLosDeLaVista(this);
		}

		// Desubscribimos la vista al contrato de puntero
		hAngulo = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAngulo>(GNC::GCS::IHerramientaAngulo::ID);
		if (hAngulo != NULL) {
			hAngulo->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de hNota
		hNota = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaNota>(GNC::GCS::IHerramientaNota::ID);
		if (hNota != NULL) {
			hNota->DesSubscribirsLosDeLaVista(this);
		}

		// desubscribimos la vista al contrato de anotaciones ventana
		hAnotacionesEsquina= cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			hAnotacionesEsquina->DesSubscribirsLosDeLaVista(this);
		}

		// dessuscribimos la vista al contrato de marcado
		hMarcado = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaMarcado>(GNC::GCS::IHerramientaMarcado::ID);
		if (hMarcado != NULL) {
			hMarcado->DesSubscribirsLosDeLaVista(this);
		}

		// Subscribimos la vista al contrato de mapas de color
		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			hReset->DesSubscribirsLosDeLaVista(this);
		}

	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero. No se pudo des-subscribir la herramienta: " << ex.getCause() << std::endl;
	}

	GTRACE("<< VistaSimple::~VistaSimple() " << this)
}

//----------------------------------------------------------------------------------------------------
//region Interfaz de Carga


// Comienzo de carga. Metodo sincrono con la interfaz.
void GNKVisualizator::WaveFormView::OnCargaIniciada()
{
}

// Paso 1: Cargar los ficheros en memoria. Metodo NO sincrono con la interfaz.
void GNKVisualizator::WaveFormView::CargarEstudio(GNC::GCS::IComando* pCmdInvocador)
{
	
}

// Finalizacion de la carga. Metodo sincrono con la interfaz.
void GNKVisualizator::WaveFormView::OnCargaFinalizada()
{
	GVista->OnFinishLoad();
}

// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
void GNKVisualizator::WaveFormView::IniciarPipeline()
{
	try {
		GVista->InitPipeline();
	}
	catch (const std::bad_alloc&) {
		DetenerPipeline();
		m_Cargada = false;
		throw GNC::GCS::VistaException(_Std("Error: System out of memory. Close some studies to free memory."));
	}
	catch (GNC::GCS::VistaException& ex) {
		DetenerPipeline();
		m_Cargada = false;
		throw ex;
	}

	m_Cargada = true;

	//se conecta el evento Ginkgo
	GNC::GCS::Eventos::EventoModificacionFichero evtModificado;
	evtModificado.SetVista(this);
	VisualizatorStudy->CargarWidgets();	

	VisualizatorStudy->IndiceFicheroActivo = 0;


	//lanzo el evento de imagen cargada
	VisualizatorStudy->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(this,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada));
	VisualizatorStudy->Entorno->GetControladorHerramientas()->RefrescarHerramientas();

	GenerarTitulo();
}

// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
void GNKVisualizator::WaveFormView::DetenerPipeline()
{
	GVista->StopPipeline();
}

//endregion


bool GNKVisualizator::WaveFormView::SoportaGuardar()
{
	return false;
}

bool GNKVisualizator::WaveFormView::SoportaExportar()
{
	return false;
}

void GNKVisualizator::WaveFormView::OnFocus()
{
	if (!m_Activada) {
		VisualizatorStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
	}
}

void GNKVisualizator::WaveFormView::Activar()
{
	GNC::GCS::IVista::Activar();
	VisualizatorStudy->Modulo->OcultarPaneles();
	GVista->SetFocus();
}


wxWindow* GNKVisualizator::WaveFormView::GetWindow()
{
	return GVista;
}

void GNKVisualizator::WaveFormView::GenerarTitulo()
{
	std::ostringstream ostr;
	std::string valor;

	VisualizatorStudy->GetTagImagenActiva("0010|0010",valor);
	for (std::string::iterator it = valor.begin(); it != valor.end(); it++) {
		if ( *it == '^') {
			*it = ' ';
		}
	}
	ostr << valor.c_str() << ", ";
	VisualizatorStudy->GetTagImagenActiva("0008|1030",valor);
	ostr << valor.c_str();
	if (!valor.empty()) {
		ostr << "/";
	}
	VisualizatorStudy->GetTagImagenActiva("0008|103e",valor);
	ostr << valor.c_str();
	m_Titulo = ostr.str();
}

