/*
 *  
 *  $Id: pasoperfilimportacion.h 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include "pasosimportacionbase.h"

#include <api/iwizard.h>
#include <api/controllers/ipacscontroller.h>
#include <api/ientorno.h>

#include <string>
#include <vector>

namespace GNC {

	namespace GCS {
		class IEntorno;
		class IControladorModulo;
	}

	namespace GUI {

		class PasoPefilImportacion: public PasoPerfilImportacionBase, public IPasoWizard
		{
			public:
				PasoPefilImportacion(wxWindow* pParent,IWizard* pWizard, GNC::GCS::IEntorno* pEntorno);
				~PasoPefilImportacion();

				GNC::GCS::IControladorModulo* GetControladorSeleccionado(){
					return m_pControladorModulo;
				};

			protected:
				GNC::GCS::IEntorno* m_pEntorno;
				GNC::GCS::IControladorModulo* m_pControladorModulo;

			//region "Metodos heredados de IPasoWizard"
				virtual void Attach(wxSizer *sizer);

				virtual void Detach(wxSizer *sizer);

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion
		};
	}
}
