/*
 *  
 *  $Id: controladorenviohl7.cpp 3893 2011-06-21 13:01:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <endpoint/endpoint.h>
#include "controladorenviohl7.h"
#include "controladorbbddhl7.h"
#include "controladorextensiones.h"
#include <api/globals.h>
#include <api/threads/thread.h>
#include <api/icomando.h>
#include <api/imodelohl7.h>
#include <api/iguiasmensajeriasacyl.h>

#define LOGGER "ControladorEnvioHl7"
#include "controladorlog.h"
#include "dcmtk/dicomservers.h"
#include "../entorno.h"

#include <map>

#include <ctime>

#include <wx/xml/xml.h>
#include <wx/file.h>
#include <wx/sstream.h>
#ifndef _WIN32
#include <signal.h>
#endif
#include <wx/tokenzr.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/filename.h>
#include <wx/thread.h>


void GIL::HL7::ControladorEnvioHl7::FreeInstance()
{
	wxCriticalSectionLocker locker(m_criticalSection);	
	if(m_pInstance != NULL){
		LOG_DEBUG("Core/HL7", "Parando el controlador de envío Hl7");
		//if(!m_pInstance->EstaAbortado()) {
			m_pInstance->Abortar();
			m_pInstance->Wait();
			delete m_pInstance;
			m_pInstance = NULL;
		//}
	}
}

void GIL::HL7::ControladorEnvioHl7::Arrancar()
{
	wxCriticalSectionLocker locker(m_criticalSection);
	if (m_pInstance == NULL) {
		m_pInstance = new GIL::HL7::ControladorEnvioHl7();
		m_pInstance->Create();
		GNC::GCS::Threading::SetThreadName( m_pInstance->GetId(), "EnvioHL7");
		wxThreadError error = m_pInstance->Run();
		if(error != wxTHREAD_NO_ERROR) {
			LOG_ERROR("Core/HL7", "Error al arrancar el controlador de envío HL7 error: " << error )
		} else {
			LOG_INFO("Core/HL7", "Arrancando controlador de envío Hl7")
		}
	} else {
		if(!m_pInstance->IsRunning()) {
			m_pInstance->Abortar();
			m_pInstance->Wait();
			delete m_pInstance;
			m_pInstance = new GIL::HL7::ControladorEnvioHl7();
			m_pInstance->Create();
			wxThreadError error = m_pInstance->Run();
			if(error != wxTHREAD_NO_ERROR) {
				LOG_ERROR("Core/HL7", "Error al arrancar el controlador de envío HL7 error: " << error )
			} else {
				LOG_INFO("Core/HL7", "Arrancando controlador de envío Hl7")
			}
		}
	}
}

bool GIL::HL7::ControladorEnvioHl7::EstaArrancado()
{
	wxCriticalSectionLocker locker(m_criticalSection);
	if(m_pInstance == NULL) {
		return false;
	} else {
		return m_pInstance->IsRunning();
	}
}

GIL::HL7::ControladorEnvioHl7* GIL::HL7::ControladorEnvioHl7::m_pInstance = NULL;
wxCriticalSection GIL::HL7::ControladorEnvioHl7::m_criticalSection;

//proceso que envia mensajes
GIL::HL7::ControladorEnvioHl7::ControladorEnvioHl7() : wxThread(wxTHREAD_JOINABLE)
{
	m_Abortado = false;
}

GIL::HL7::ControladorEnvioHl7::~ControladorEnvioHl7() 
{
	LOG_DEBUG("Core/HL7", "Controlador de envío hl7 destruido")
}

void GIL::HL7::ControladorEnvioHl7::Abortar() {
	m_Abortado = true;
}

bool GIL::HL7::ControladorEnvioHl7::EstaAbortado()
{
	return m_Abortado;
}

void* GIL::HL7::ControladorEnvioHl7::Entry()
{
	bool error =false;
	m_Abortado = false;
	//esperamos a que arranque todo correctamente
	#ifdef _WIN32
	Sleep(5000);
	#else
	usleep(5000000);
	#endif

	while(!TestDestroy() && !m_Abortado && !error) {
		#ifdef _WIN32
		Sleep(1000);
		#else
		usleep(1000000);
		#endif
		if(TestDestroy() || m_Abortado){
            break;
		}
		try {
			error = !ProcesarMensajes();
		}
		catch (HL7Exception ex)
		{
			std::ostringstream ostr;
			LOG_ERROR("Core/HL7", "Excepción al procesar mensaje:" << ex)
			return NULL;
		}
	}
	if(error) {
		//la instancia ha finalizado, no hace falta borrarla
		LOG_WARN("Core/HL7", "El Controlador de envío Hl7 ha finalizado debido a un error")
	} else {
		LOG_DEBUG("Core/HL7", "El Controlador de envío Hl7 ha finalizado correctamente")
	}
	return NULL;
}

bool GIL::HL7::ControladorEnvioHl7::ProcesarMensajes() {
	TListaMensajes listaMensajes;

	GIL::HL7::ControladorBBDDHl7::Instance()->GetMensajesHL7(listaMensajes,true);
	for(TListaMensajes::iterator it = listaMensajes.begin(); it!=listaMensajes.end(); it++) {
		{
			std::ostringstream ostr;
			LOG_DEBUG("Core/HL7", "Comienza el procesamiento del mensaje "<<(*it).m_id)
		}

		try {
			switch((*it).m_protocolo) {
				case GIL::HL7::IControladorHL7::TP_MLLP:
					EnviarMensajeMLLP((*it).m_mensaje,(*it).m_destino,(*it).m_procesarACK,(*it).m_msgControlId);
					GIL::HL7::ControladorBBDDHl7::Instance()->ActualizarEstadoMensaje((*it).m_id,GIL::HL7::MensajeHL7::TE_Enviado,"");
					LOG_DEBUG("Core/HL7", "Mensaje enviado correctamente")
					break;
				default:
					throw HL7Exception(_Std("Unknown protocol"));
			}
		} catch(HL7Exception& ex) {
			LOG_ERROR("Core/HL7", "Error al enviar el mensaje:" << ex)
			//ha ocurrido un error

			//al primer error se para
			if (ex.IsFatal()) {
				GIL::HL7::ControladorBBDDHl7::Instance()->ActualizarEstadoMensaje((*it).m_id,GIL::HL7::MensajeHL7::TE_Error,ex.GetCause().c_str());
				return false;
			}
			else {
				GIL::HL7::ControladorBBDDHl7::Instance()->ActualizarEstadoMensaje((*it).m_id,GIL::HL7::MensajeHL7::TE_Warning,ex.GetCause().c_str());
				return true;
			}
		}
		catch(...) {
			LOG_DEBUG("Core/HL7", "Error al enviar el mensaje: Error interno");
			GIL::HL7::ControladorBBDDHl7::Instance()->ActualizarEstadoMensaje((*it).m_id, GIL::HL7::MensajeHL7::TE_Error, "Error interno");
			return false;
		}

	}
	return true;
}


/* Envia el mensaje por MLLP */
void GIL::HL7::ControladorEnvioHl7::EnviarMensajeMLLP(const std::string& msg, const std::string& url, bool procesarACK, const std::string& msgControlId) const
{
	const std::string START_BLOCK = "\x0b";
	const std::string END_BLOCK   = "\x1C";
	const std::string END_MSG     = "\x0D";

	#ifndef _WIN32
	signal(SIGPIPE, SIG_IGN);
	#endif
	EndpointAddrlist::g_default_family = AF_INET;

	Endpoint::Initialize();

	Endpoint ep(TCP | CLIENT, url);

	if (!ep) {
		throw HL7Exception(_Std("Failed to start connection") + ep.m_error_str, "COMM");
	}

	std::stringstream outputStream;
	outputStream << START_BLOCK << msg << END_BLOCK << END_MSG;

	long nbytes = ep.Write(outputStream.str());
	if (nbytes != (long)outputStream.str().size()) {
		std::stringstream errmsg;
		if (nbytes == -1) {
			errmsg << _Std("Error sending message:") << ep.m_error_str;
		}
		else {
			errmsg << _Std("Error sending message. It was sent ") << nbytes << _Std(" bytes from a total of ") << outputStream;
		}
		throw HL7Exception(errmsg.str(), "COMM");
	}

	if (!procesarACK) {
		return;
	}

	ep.Shutdown(Endpoint::OUTPUT);

	//std::cout << "Message Control ID is = " << msgControlId << std::endl;

	outputStream.str("");

	//std::cout << "Connected to: " << std::string(ep.m_remote) << std::endl;

	unsigned int msgNum = 0;

	std::list<std::string> mStrings;
	std::stringstream      inputStream;

	std::string buff;

	int bytesReaded = 0;

	bool started = false;
	bool pending = true;

	while( pending && (bytesReaded = ep.Read(-1024, buff))>0 ) {
		if (!started) {

			std::string::size_type sb_loc = buff.find(START_BLOCK, 0);

			if (sb_loc != std::string::npos) {

				started = true;

				mStrings.push_back(std::string());

				msgNum++;

				std::string::size_type eb_loc = buff.find(END_BLOCK, sb_loc+1);

				if (eb_loc != std::string::npos) {
					inputStream << buff.substr(sb_loc + 1, eb_loc - 1 - sb_loc);

					mStrings.back() = inputStream.str();
					inputStream.str("");

					started = false;

					std::string::size_type em_loc = buff.find(END_MSG, eb_loc+1);
					if (em_loc != std::string::npos) {
						pending = false;
					}
					else {
						inputStream << buff.substr(eb_loc+1);
					}

				}
				else {
					inputStream << buff.substr(sb_loc + 1);
				}
			}

		}
		else {
			std::string::size_type eb_loc = buff.find(END_BLOCK, 0);

			if (eb_loc != std::string::npos) {
				inputStream << buff.substr(0, eb_loc - 1);
				started = false;

				mStrings.back() = inputStream.str();
				inputStream.str("");

				std::string::size_type em_loc = buff.find(END_MSG, eb_loc+1);
				if (em_loc != std::string::npos) {
					pending = false;
				}
				else {
					inputStream << buff.substr(eb_loc+1);
				}
			}
			else {
				inputStream << buff;
			}
		}
	}
	bool confirmado = false;
	std::list<std::string>::iterator it;
	unsigned int i;
	for ( i = 1, it = mStrings.begin(); it != mStrings.end(); i++, it++) {
		std::string& s = *it;

		if (i != msgNum || !pending) {
			//std::cout << "Mensaje :\n" << s << std::endl;
			try {
				GIL::Sacyl::Messages::ACKInterpreter ai(GIL::HL7::Message::FromER7(s));
				if (msgControlId != ai.GetReferralMessageControlId()) {
					throw HL7Exception(_Std("Error in the logic of confirmation. The control of the message ID does not match recognized"));
				}
				if (!ai.IsSuccess()) {
					std::stringstream errmsg;
					errmsg << _Std("NACK received:") << ai.ERR.GetErrorCodeDescription();
					throw HL7Exception(errmsg.str());
				}
				confirmado = true;
			}
			catch (HL7Exception& e)
			{
				throw HL7Exception(_Std("Failed delivery confirmation:") + e.GetCause(), "COMM");
			}
			break;
		}
	}
	if (!confirmado) {
		throw HL7Exception(_Std("Error in the confirmation of delivery: Delivery is not recognized by the remote end"), "COMM");
	}
	//std::cout << "Total: " << ep.GetTotalBytesReaded() << std::endl;*/
}
