/*
*
*  $Id: surfacepipeline.cpp 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "surfacepipeline.h"
#include "../volumedataset/volumedataset.h"

#include <exception>
#include <wx/window.h>
#include <api/internacionalizacion.h>
#include <main/controllers/controladorlog.h>
#include <vtkCommand.h>
#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkImageGaussianSmooth.h>
#include <vtkImageMarchingCubes.h>
#include <vtkContourFilter.h>
#include <vtkDecimatePro.h>
#include <vtkImageResample.h>
#include <vtkImageReslice.h>
#include <vtkSmoothPolyDataFilter.h>
#include <vtkPolyDataNormals.h>
#include <vtkPolyDataMapper.h>
#include <vtkLODActor.h>
#include <vtkActor.h>
#include <vtkCamera.h>
#include <vtkProperty.h>
#include <vtkRenderWindow.h>
#include <vtkDepthSortPolyData.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkInteractorStyleTrackballCamera.h>

namespace MedicalViewer {
	namespace Reconstruction {
		namespace Pipelines {

			class SurfaceCommandObserver : public vtkCommand
			{
			public:

				static SurfaceCommandObserver* New() {
					return new SurfaceCommandObserver();
				}

				void SetInformation(const std::string& text)
				{
					Text = text;
				}

				void SetInformation(const std::string& text, unsigned int step)
				{
					std::ostringstream os;
					os << text << " " << step;
					Text = os.str();
				}

				void SetNotifier(IReconstructionNotifier* notifier)
				{
					Notifier = notifier;
				}

				virtual void Execute(vtkObject* caller, unsigned long, void *callData) {
					double dProgress = *( (double*)(callData) );
					vtkAlgorithm* alg = (vtkAlgorithm* ) caller;
					if (Notifier) {
						if (! Notifier->NotifyReconstructionProgress( Text, (float)dProgress) ){
							alg->AbortExecuteOn();
							alg->AbortExecuteOn();
						}
					}
				}

				std::string Text;
				unsigned int Step;
				unsigned int NSteps;

				IReconstructionNotifier* Notifier;
			};

		}
	}
}


MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SurfacePipeline(wxWindow* win3d) : IPipeline("Reconstruction/Surface", win3d)
{
	ApplyPreSmooth  = true;
	ApplyPostSmooth = true;

	vtkSmartPointer<SurfaceCommandObserver> Progress;

	Renderer->SetBackground(0.0, 0.0, 0.0);

	PreSmooth = vtkSmartPointer<vtkImageGaussianSmooth>::New();
	PreSmooth->SetRadiusFactors(3, 3, 3);
	PreSmooth->SetDimensionality(3);

	Resample = vtkSmartPointer<vtkImageResample>::New();

	PostSmooth = vtkSmartPointer<vtkImageGaussianSmooth>::New();
	PostSmooth->SetRadiusFactors(3, 3, 3);
	PostSmooth->SetDimensionality(3);
	PostSmooth->SetInputConnection(Resample->GetOutputPort());

	//Progresses
	Progress = vtkSmartPointer<SurfaceCommandObserver>::New();
	Progress->SetInformation("Processing VOI");
	Resample->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);

	Progress = vtkSmartPointer<SurfaceCommandObserver>::New();
	Progress->SetInformation("PreProcessing VOI");
	PreSmooth->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);

	Progress = vtkSmartPointer<SurfaceCommandObserver>::New();
	Progress->SetInformation("PostProcessing VOI");
	PostSmooth->AddObserver(vtkCommand::ProgressEvent, Progress);
	Progresses.push_back(Progress);

	for (unsigned int i = 0; i < NSURF; i++) {


		Surf[i] = vtkSmartPointer<TReconstructionFilter>::New();
		Surf[i]->ComputeNormalsOn();
		//Surf[i]->ComputeGradientsOn();

		Decimate[i] = vtkSmartPointer<vtkDecimatePro>::New();
		Decimate[i]->SetInputConnection(Surf[i]->GetOutputPort());
		Decimate[i]->PreserveTopologyOn();


		DepthSort[i] = vtkSmartPointer<vtkDepthSortPolyData>::New();
		DepthSort[i]->SetInputConnection(Decimate[i]->GetOutputPort());
		DepthSort[i]->SetDirectionToBackToFront();
		DepthSort[i]->SetVector(1.0, 1.0, 1.0);
		DepthSort[i]->SetCamera(Renderer->GetActiveCamera());
		DepthSort[i]->SortScalarsOn();

		Mapper[i] = vtkSmartPointer<vtkPolyDataMapper>::New();
		Mapper[i]->SetInputConnection(DepthSort[i]->GetOutputPort());
		Mapper[i]->ScalarVisibilityOff();

		Actor[i] = vtkSmartPointer<vtkLODActor>::New();
		Actor[i]->SetMapper(Mapper[i]);
		Actor[i]->SetNumberOfCloudPoints(1000000);
		Actor[i]->VisibilityOff();
		Actor[i]->GetProperty()->FrontfaceCullingOn();
		Actor[i]->GetProperty()->BackfaceCullingOn();

		DepthSort[i]->SetProp3D(Actor[i]);

		Renderer->AddActor(Actor[i]);

		//Progresses

		Progress = vtkSmartPointer<SurfaceCommandObserver>::New();
		Progress->SetInformation("Reconstructing Surface", i + 1);
		Surf[i]->AddObserver(vtkCommand::ProgressEvent, Progress);
		Progresses.push_back(Progress);

		Progress = vtkSmartPointer<SurfaceCommandObserver>::New();
		Progress->SetInformation("Decimating Surface", i + 1);
		Decimate[i]->AddObserver(vtkCommand::ProgressEvent, Progress);
		Progresses.push_back(Progress);

	}

}

MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::~SurfacePipeline()
{
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetupInteractor()
{
	Renderer->GetRenderWindow()->GetInteractor()->SetInteractorStyle(vtkSmartPointer<vtkInteractorStyleTrackballCamera>::New());

}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetDataSet(unsigned int volNum, unsigned int quality)
{

	GnkPtr<TDataSet> vol = FindDataSet(volNum);

	if (!vol) {
		LOG_ERROR(PipelineName, "Unable to set DataSet " << volNum << ": DataSet not found");
		return;
	}

	LOG_DEBUG(PipelineName, "Setting DataSet " << volNum << ". Range = [ " << vol->MinValue << ", " << vol->MaxValue << " ]");

	CurrentImage = vol->Img;


	if (ApplyPreSmooth) {
		if (PreSmooth->GetInput() != (vtkImageData*) CurrentImage) {
			PreSmooth->SetInput(CurrentImage);
		}
		if (Resample->GetNumberOfInputConnections(0) == 0 || Resample->GetInputConnection(0, 0) != PreSmooth->GetOutputPort()) {
			Resample->RemoveAllInputs();
			Resample->SetInputConnection(PreSmooth->GetOutputPort());
		}
	}
	else {
		if (Resample->GetNumberOfInputConnections(0) == 0 || Resample->GetInputConnection(0, 0) == PreSmooth->GetOutputPort() ) {
			Resample->RemoveAllInputs();
			Resample->SetInput(CurrentImage);
		}
	}

	for (unsigned int i = 0; i < NSURF; i++) {
		if (ApplyPostSmooth) {
			if (Surf[i]->GetNumberOfInputConnections(0) == 0 || Surf[i]->GetInputConnection(0, 0) != PostSmooth->GetOutputPort()) {
				Surf[i]->RemoveAllInputs();
				Surf[i]->SetInputConnection(PostSmooth->GetOutputPort());
			}
		}
		else {
			if (Surf[i]->GetNumberOfInputConnections(0) == 0 || Surf[i]->GetInputConnection(0, 0) != Resample->GetOutputPort()) {
				Surf[i]->RemoveAllInputs();
				Surf[i]->SetInputConnection(Resample->GetOutputPort());
			}
		}

		if (Actor[i]->GetProperty()->GetOpacity() <= 0.999) {
			if (DepthSort[i]->GetNumberOfInputConnections(0) == 0 || DepthSort[i]->GetInputConnection(0, 0) != Decimate[i]->GetOutputPort()) {
				DepthSort[i]->RemoveAllInputs();
				DepthSort[i]->SetInputConnection(Decimate[i]->GetOutputPort());
				DepthSort[i]->SetCamera(Renderer->GetActiveCamera());
			}
			if (Mapper[i]->GetNumberOfInputConnections(0) == 0 || Mapper[i]->GetInputConnection(0, 0) != DepthSort[i]->GetOutputPort()) {
				Mapper[i]->RemoveAllInputs();
				Mapper[i]->SetInputConnection(DepthSort[i]->GetOutputPort());
			}
		}
		else {
			if (DepthSort[i]->GetNumberOfInputConnections(0) == 0 || DepthSort[i]->GetInputConnection(0, 0) != Decimate[i]->GetOutputPort()) {
				DepthSort[i]->RemoveAllInputs();
				DepthSort[i]->SetCamera(NULL);
			}
			if (Mapper[i]->GetNumberOfInputConnections(0) == 0 || Mapper[i]->GetInputConnection(0, 0) != Decimate[i]->GetOutputPort()) {
				Mapper[i]->RemoveAllInputs();
				Mapper[i]->SetInputConnection(Decimate[i]->GetOutputPort());
			}
		}
	}

	SetResolutionQuality(quality);
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::EnableSurface(int surf, bool enable)
{
	if (surf < NSURF) {
		if (enable) {
			Actor[surf]->VisibilityOn();
		}
		else {
			Actor[surf]->VisibilityOff();
		}
	}
	if (enable && !Initiallized) {
		Initiallized = true;
		ResetCamera();
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetSurfValue(int surf, double val)
{
	if (surf < NSURF) {
		Surf[surf]->SetValue(0, val);
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetSurfColor(int surf, double r, double g, double b)
{
	if (surf < NSURF) {
		Actor[surf]->GetProperty()->SetColor(r, g, b);
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetSurfTransparency(int surf, double opacity)
{
	if (surf < NSURF) {
		Actor[surf]->GetProperty()->SetOpacity(opacity);
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::EnableSmooth(bool enablePreSmooth, bool enablePostSmooth)
{
	ApplyPreSmooth = enablePreSmooth;
	ApplyPostSmooth = enablePostSmooth;
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::Enable(int surf, bool enabled)
{
	if (surf < NSURF) {
		if (enabled) {
			Actor[surf]->VisibilityOn();
		}
		else {
			Actor[surf]->VisibilityOff();
		}
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetProgressNotifier(IReconstructionNotifier* notifier)
{
	for (TProgressList::iterator it = Progresses.begin(); it != Progresses.end(); it++) {
		(*it)->SetNotifier(notifier);
	}
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::Update()
{
	LOG_DEBUG(PipelineName, _Std("Updating..."));
	for (unsigned int i = 0; i < NSURF; i++) {
		PreSmooth->AbortExecuteOff();
		Resample->AbortExecuteOff();
		PostSmooth->AbortExecuteOff();
		Surf[i]->AbortExecuteOff();
		Decimate[i]->AbortExecuteOff();
		Mapper[i]->AbortExecuteOff();

		if (Enabled[i]) {
			try {
				Mapper[i]->Update();
			}
			catch (...)
			{
				LOG_ERROR(PipelineName, _Std("Reconstruction internal error"));
			}
		}
	}

	LOG_DEBUG(PipelineName, _Std("Update done"));
}

void MedicalViewer::Reconstruction::Pipelines::SurfacePipeline::SetResolutionQuality(unsigned int quality)
{
	float res[3] = {0.0f, 0.0f, 0.0f};

	switch (quality) {
		case 3: // 256x256x256
			res[0] = 256.0f;
			res[1] = 256.0f;
			res[2] = 256.0f;
			quality = 3;
			break;
		case 2: // 128x128x128
			res[0] = 128.0f;
			res[1] = 128.0f;
			res[2] = 128.0f;
			quality = 2;
			break;
		case 1: // 64x64x64
			res[0] = 64.0f;
			res[1] = 64.0f;
			res[2] = 64.0f;
			quality = 1;
			break;
		case 0: // 32x32x32
		default:
			res[0] = 32.0f;
			res[1] = 32.0f;
			res[2] = 32.0f;
			quality = 0;
			break;
	}

	int    dims[3] = {0, 0, 0};
	double spc[3] = {1.0, 1.0, 1.0};

	double factor[3] = {1.0, 1.0, 1.0};

	CurrentImage->UpdateInformation();

	CurrentImage->GetDimensions(dims);
	CurrentImage->GetSpacing(spc);

	factor[0] = (float) res[0] / dims[0];
	factor[1] = (float) res[1] / dims[1];
	factor[2] = (float) res[2] / dims[2];

	for (unsigned int i = 0; i < NSURF; i++) {
		Resample->SetOutputDimensionality(3);
		Resample->SetInterpolationModeToLinear();
		Resample->SetAxisMagnificationFactor(0, factor[0]);
		Resample->SetAxisMagnificationFactor(1, factor[1]);
		Resample->SetAxisMagnificationFactor(2, factor[2]);
	}
}
