/*
 *  
 *  $Id: voiextractioncommand.cpp 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "voiextractioncommand.h"
#include "surfacecommand.h"
#include "volumecommand.h"
#include "../volumedataset/volumedataset.h"

#include <api/icontextoestudio.h>
#include <api/internacionalizacion.h>
#include <api/icontroladorcarga.h>
#include <main/controllers/controladorlog.h>


MedicalViewer::Reconstruction::Commands::VOIExtractionCommandParams::VOIExtractionCommandParams(const GnkPtr<TRefStudy>& ref, const GnkPtr<TPipeline>& pipeline, IRangeListener* rangeListener) : RefStudy(ref), Pipeline(pipeline), RangeListener(rangeListener)
{

}

MedicalViewer::Reconstruction::Commands::VOIExtractionCommandParams::~VOIExtractionCommandParams()
{

}

//====================================================================

MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::VOIExtractionCommand(VOIExtractionCommandParams* pParams) : GNC::GCS::IComando(pParams, "VOI Extraction" )
{
	m_pExtractionParams = pParams;
	SetId(IDC_VOI_EXTRACTION);
	EsperaA(IDC_VOI_EXTRACTION);
	CancelaA(IDC_SURFACE_RECONSTRUCTION);
	CancelaA(IDC_VOLUME_RECONSTRUCTION);
}

MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::~VOIExtractionCommand(void)
{
}

void MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::Execute()
{
	typedef MedicalViewer::Reconstruction::Pipelines::IPipeline::TDataSet      TDataSet;
	typedef MedicalViewer::Reconstruction::Pipelines::IPipeline::TDataSetList  TDataSetList;

	int num = m_pExtractionParams->RefStudy->GetNumeroCortes();
	float progress = 0.0f;
	float step = 0.0f;
	
	step = (1.0f / (float)num);
	progress = 0.0f;

	for (int i = 0; i < num; i++) {
		NotificarProgreso(progress, _Std("Generating VOIs...."));
		progress += step;

		m_pExtractionParams->RefStudy->SetIndiceActivo(i);

		GnkPtr<TDataSet::TSlice> s = new TDataSet::TSlice(i);

		m_pExtractionParams->RefStudy->GetDimensionsImagenActiva(s->dims.v);
		m_pExtractionParams->RefStudy->GetOriginActiva(s->origin.v);
		m_pExtractionParams->RefStudy->GetSpacingActiva(s->spacing.v);
		m_pExtractionParams->RefStudy->Loader->GetDirection(s->cosines);

		bool added = false;


		for (TDataSetList::iterator it = m_pExtractionParams->Pipeline->GetDataSetList().begin(); !added && it != m_pExtractionParams->Pipeline->GetDataSetList().end(); it++) {
			added = (*it)->Add(s);
		}
		
		if (!added) {
			GnkPtr<TDataSet> vol = new TDataSet(m_pExtractionParams->RefStudy, s);
			m_pExtractionParams->Pipeline->GetDataSetList().push_back(vol);
		}

	}

	step = (1.0f / (float)m_pExtractionParams->Pipeline->GetDataSetList().size());
	progress = 0.0f;

	LOG_DEBUG("VOIExtraction", m_pExtractionParams->Pipeline->GetDataSetList().size() << _Std(" VOIs detected."));

	for (TDataSetList::iterator it = m_pExtractionParams->Pipeline->GetDataSetList().begin(); it != m_pExtractionParams->Pipeline->GetDataSetList().end(); it++) {
		NotificarProgreso(progress, _Std("Computing VOIs...."));
		progress += step;
		(*it)->Compute();
	}
	LOG_DEBUG("VOIExtraction", _Std("Done"));

}

void MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::Update()
{
	if (m_pExtractionParams->RangeListener != NULL) {
		m_pExtractionParams->RangeListener->OnRangeCalculated();
	}
}

void MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::OnAbort()
{
	LOG_DEBUG("VOIExtraction", _Std("Aborted"));
}

void MedicalViewer::Reconstruction::Commands::VOIExtractionCommand::LiberarRecursos()
{
}
