/*
 *
 *  $Id: surfacecommand.cpp 3359 2011-02-21 08:23:37Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <exception>
#include "surfacecommand.h"
#include "voiextractioncommand.h"
#include "../pipelines/surfacepipeline.h"

MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommandParams::SurfaceCommandParams(
	const GnkPtr<TPipeline>& pipeline,
	unsigned int datasetNum,
	bool         preSmooth,
	bool         postSmooth,
	unsigned int quality,
	const SurfaceProps& propsS1,
	const SurfaceProps& propsS2
	) : Pipeline(pipeline), DataSetNum(datasetNum), PreSmooth(preSmooth), PostSmooth(postSmooth), Quality(quality), Surface1Props(propsS1), Surface2Props(propsS2)
{
}

MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommandParams::~SurfaceCommandParams()
{
}

//====================================================================

MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::SurfaceCommand(SurfaceCommandParams* pParams) : GNC::GCS::IComando(pParams, "SurfaceReconstruction" )
{
	m_pSurfaceParams = pParams;
	SetId(IDC_SURFACE_RECONSTRUCTION);
	CancelaA(IDC_SURFACE_RECONSTRUCTION);
	EsperaA(IDC_VOI_EXTRACTION);
}

MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::~SurfaceCommand(void)
{
}

void MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::Execute()
{

	m_pSurfaceParams->Pipeline->EnableSmooth(m_pSurfaceParams->PreSmooth, m_pSurfaceParams->PostSmooth);

	m_pSurfaceParams->Pipeline->Enabled[0] = m_pSurfaceParams->Surface1Props.Enabled;
	m_pSurfaceParams->Pipeline->SetSurfValue(0, m_pSurfaceParams->Surface1Props.ISOValue);
	m_pSurfaceParams->Pipeline->SetSurfColor(0, m_pSurfaceParams->Surface1Props.Red, m_pSurfaceParams->Surface1Props.Green, m_pSurfaceParams->Surface1Props.Blue);
	m_pSurfaceParams->Pipeline->SetSurfTransparency(0, m_pSurfaceParams->Surface1Props.Alpha);

	m_pSurfaceParams->Pipeline->Enabled[1] = m_pSurfaceParams->Surface2Props.Enabled;
	m_pSurfaceParams->Pipeline->SetSurfValue(1, m_pSurfaceParams->Surface2Props.ISOValue);
	m_pSurfaceParams->Pipeline->SetSurfColor(1, m_pSurfaceParams->Surface2Props.Red, m_pSurfaceParams->Surface2Props.Green, m_pSurfaceParams->Surface2Props.Blue);
	m_pSurfaceParams->Pipeline->SetSurfTransparency(1, m_pSurfaceParams->Surface2Props.Alpha);

	m_pSurfaceParams->Pipeline->SetDataSet(m_pSurfaceParams->DataSetNum, m_pSurfaceParams->Quality);

	try {
		m_pSurfaceParams->Pipeline->SetProgressNotifier(this);
		m_pSurfaceParams->Pipeline->Update();
		m_pSurfaceParams->Pipeline->SetProgressNotifier(NULL);
	}
	catch (...) {

	}
}

void MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::Update()
{
	m_pSurfaceParams->Pipeline->Enable(0, m_pSurfaceParams->Surface1Props.Enabled);
	m_pSurfaceParams->Pipeline->Enable(1, m_pSurfaceParams->Surface2Props.Enabled);
	m_pSurfaceParams->Pipeline->Render();
}

void MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::OnAbort()
{
}

void MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::LiberarRecursos()
{
}

bool MedicalViewer::Reconstruction::Surface::Commands::SurfaceCommand::NotifyReconstructionProgress(const std::string& text, float progress)
{
	return NotificarProgreso(progress, text);
}
