/*
 *  
 *  $Id: imprimevistasimple.cpp 3713 2011-04-15 12:55:23Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/internacionalizacion.h>

#include <wx/config.h>

#include <vtkSmartPointer.h>
#include <vtkImageMapToRGBA.h>
#include <vtkObject.h>

#include "imprimevistasimple.h"



namespace GNKVisualizator {

	ImprimeVistaSimple::ImprimeVistaSimple(GNC::GCS::IWidgetsManager* pWidgetsManager, GnkPtr<GNC::GCS::IContextoEstudio> estudioAprimaria, int index ) : GNC::GCS::IImpresion (pWidgetsManager, estudioAprimaria, index)
	{
	}

	ImprimeVistaSimple::~ImprimeVistaSimple()
	{
	}
	

	void ImprimeVistaSimple::PrintImageRGB(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, bool conWidgets, const GNC::GCS::Vector& size)
	{
		Imprimir(GetImage(), conWidgets, size, img);
	}

	void ImprimeVistaSimple::PrintImage(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, bool conWidgets, vtkScalarsToColors* pLookUpTable, const GNC::GCS::Vector& size)
	{
		vtkImageMapToRGBA * pImageMap = vtkImageMapToRGBA::New();
		pImageMap->SetInput(GetImage());
		pImageMap->SetLookupTable(pLookUpTable);
		pImageMap->SetOutputFormatToRGB();
		pImageMap->Update();
		Imprimir(pImageMap->GetOutput(), conWidgets, size, img);
	}

//endregion
}

