/*
 *  
 *  $Id: waveformview.h 3698 2011-04-14 12:38:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/ivista.h>
#include <visualizator/estudios/ecgstudy.h>
#include <export/icontratoscore.h>
#include <api/icontroladoreventos.h>
#include <api/icontroladorimportacionpacs.h>
#include <api/icontroladorcarga.h> // TODO: Promover a IVista

class wxWindow;
class wxVtkPageView;
namespace GNKVisualizator{
	class VisualizatorStudy;
	namespace GUI{
		class GWaveformView;
	}

	class WaveFormView : public GNC::GCS::IVista {
	public:
		/* Constructor */
		WaveFormView(const GnkPtr<GNKVisualizator::ECGStudy>& estudio);

		//----------------------------------------------------------------------------------------------------
		//region Interfaz de Carga

		// Comienzo de carga. Metodo sincrono con la interfaz.
		virtual void OnCargaIniciada();

		// Paso 1: Cargar los ficheros en memoria. Metodo NO sincrono con la interfaz.
		virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador);

		// Finalizacion de la carga. Metodo sincrono con la interfaz.
		virtual void OnCargaFinalizada();

		// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
		virtual void IniciarPipeline();

		// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
		virtual void DetenerPipeline();

		//endregion

		/* Destructor */
		~WaveFormView();

		virtual bool SoportaGuardar();

		virtual bool SoportaExportar();

		virtual void OnFocus();

		virtual void Activar();

		virtual wxWindow* GetWindow();

		GnkPtr<GNKVisualizator::ECGStudy>& GetECGStudy() {return VisualizatorStudy;}
	
	protected:
		GNKVisualizator::GUI::GWaveformView*             GVista;
		GnkPtr<GNKVisualizator::ECGStudy>  VisualizatorStudy;

		void GenerarTitulo();
	};
}

