/*
 *  
 *  $Id: herramientaoverlays.cpp 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>

#include <api/globals.h>
#include <api/icontroladoreventos.h>
#include "../eventos/visualizatorevents.h"
#include <api/ientorno.h>
#include "herramientaoverlays.h"
#include <eventos/eventosginkgo.h>
#include <api/internacionalizacion.h>

#define MENU_OVERLAYS  4051

namespace GNKVisualizator {
	namespace GUI {
	class MenuHerramientaOverlays : public wxMenu {
			public:
			MenuHerramientaOverlays(wxWindow* pParent, GNKVisualizator::HerramientaOverlays* pHerramienta):wxMenu() {
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(m_pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaOverlays::OnUpdateSeleccionarOverlaysUI),NULL,this);
			}

			~MenuHerramientaOverlays() {
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaOverlays::OnUpdateSeleccionarOverlaysUI),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaOverlays::OnMostrarOverlay ),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnUpdateSeleccionarOverlaysUI(wxUpdateUIEvent& event) {
				//se agregan los overlays...
				while(this->GetMenuItemCount() >0) {
					this->Destroy(FindItemByPosition(0));
				}

				GNKVisualizator::TListaOverlays* pLista = m_pHerramienta->GetListaOverlays();
				GNKVisualizator::TEstadoOverlay* estadoOverlays = m_pHerramienta->GetEstadoOverlays();
				if(pLista!= NULL && estadoOverlays!=NULL && pLista->size() > 0) {
					int idOverlay = MENU_OVERLAYS;
					for(GNKVisualizator::TListaOverlays::iterator itOverlays = pLista->begin(); itOverlays!=pLista->end(); itOverlays++,idOverlay++) {
						wxMenuItem* capa = new wxMenuItem( this, idOverlay,wxString::FromUTF8((*itOverlays).nombre.c_str()),wxEmptyString,wxITEM_CHECK);
						Append(capa);
						bool oculto = false;
						if(estadoOverlays->find((*itOverlays).indice) != estadoOverlays->end()) {
							oculto = (*estadoOverlays->find(itOverlays->indice)).second;
						}
						if(oculto){
							Check(capa->GetId(),false);
						} else {
							Check(capa->GetId(),true);
						}
						m_pParent->Connect(capa->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaOverlays::OnMostrarOverlay ),NULL,this);
					}			
					event.Show(true);
					event.Enable(true);
				} else {
					event.Show(false);
					event.Enable(false);
				}
			}

			void OnMostrarOverlay(wxCommandEvent& event)
			{
				int idOverlay = event.GetId() - MENU_OVERLAYS;
				m_pHerramienta->ToggleOverlay(idOverlay);
				event.Skip(false);
			} 

			GNKVisualizator::HerramientaOverlays* m_pHerramienta;
			wxWindow* m_pParent;
		};
	}
}

//----------------------------------------------------------------------

GNKVisualizator::HerramientaOverlays::HerramientaOverlays()
{
	m_Descripcion = _Std("Layers Overlays");
	m_IsMenu = true;
	////////////////////////////////////////////m_Icono = GinkgoResourcesManager::IconosMenus::GetIcoReset();
}

GNKVisualizator::HerramientaOverlays::~HerramientaOverlays()
{
}

bool GNKVisualizator::HerramientaOverlays::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	wxMenu* pMenu = new GNKVisualizator::GUI::MenuHerramientaOverlays(pParent,this);	
	pMenuParent->Append(ID, wxString::FromUTF8(m_Descripcion.c_str()), pMenu);
	return true;
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNKVisualizator::HerramientaOverlays::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

GNKVisualizator::TListaOverlays* GNKVisualizator::HerramientaOverlays::GetListaOverlays()
{
	GNKVisualizator::TListaOverlays* resultado = NULL;
	if(Habilitada())
	{
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			resultado = pCW->m_pListaOverlays;
		}
	}
	return resultado;
}

GNKVisualizator::TEstadoOverlay* GNKVisualizator::HerramientaOverlays::GetEstadoOverlays()
{
	GNKVisualizator::TEstadoOverlay* resultado = NULL;
	if(Habilitada())
	{
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			resultado = &pCW->m_EstadoOverlays;
		}
	}
	return resultado;
}

void GNKVisualizator::HerramientaOverlays::ToggleOverlay(int idOverlay)
{
	if(Habilitada())
	{
		if(TContratableWidgets::m_pListaActiva->size() > 0) {
			TContratoWidgets* pC = (*TContratableWidgets::m_pListaActiva->begin());

			GNKVisualizator::TListaOverlays::iterator itOverlays = pC->m_pListaOverlays->begin();
			for(; idOverlay > 0 && itOverlays!=pC->m_pListaOverlays->end(); itOverlays++, idOverlay--);
			if(itOverlays!= pC->m_pListaOverlays->end()) {
				if(pC->m_EstadoOverlays.find((*itOverlays).indice) != pC->m_EstadoOverlays.end()) {
					pC->m_EstadoOverlays[itOverlays->indice] = !pC->m_EstadoOverlays[itOverlays->indice];
				} else {
					pC->m_EstadoOverlays[itOverlays->indice] = false;
				}
				pC->m_pEntorno->GetControladorEventos()->ProcesarEvento(new GNKVisualizator::Eventos::EventoMostrarOverlay(TContratableWidgets::m_pVistaActiva,(*itOverlays)));
			}
		}
	}
}

void GNKVisualizator::HerramientaOverlays::SolicitarActivacion()
{
}

void GNKVisualizator::HerramientaOverlays::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNKVisualizator::HerramientaOverlays::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNKVisualizator::HerramientaOverlays::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activación. Accion ignorada" << std::endl;
		return;
	}

}

//endregion



