/*
 *  
 *  $Id: herramientamapacolor.cpp 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>

#include <api/globals.h>
#include <api/ientorno.h>
#include "herramientamapacolor.h"
#include <eventos/eventosginkgo.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkVISUManagement/vtkLookupTableManager.h>
#include <vtkginkgoimageviewer.h>

#include "../../recursos/aprimresourcemanager.h"
#include <api/internacionalizacion.h>

#define INVERTIR_COLORES  4100
#define MENU_MAPAS_COLOR  4101

namespace GNKVisualizator {
	namespace GUI {
	class MenuHerramientaMapaColor : public wxMenu {
			public:
				MenuHerramientaMapaColor(wxWindow* pParent, GNKVisualizator::HerramientaMapaColor* pHerramienta):wxMenu() {
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;

				std::vector<std::string> choices = vtkLookupTableManager::GetAvailableLookupTables();
				int idMapa = MENU_MAPAS_COLOR;
				for(std::vector<std::string>::iterator it = choices.begin(); it!= choices.end(); it++,idMapa++){
					wxMenuItem* mapa = new wxMenuItem( this, idMapa,wxString::FromUTF8((*it).c_str()),wxString::FromUTF8((*it).c_str()),wxITEM_CHECK);
					m_pParent->Connect(mapa->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaMapaColor::OnSeleccionarMapa ),NULL,this);
					m_pParent->Connect(mapa->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaMapaColor::OnUpdateMenuMapaColorUI),NULL,this);
					Append(mapa);
				}

				m_pParent->Connect(m_pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaMapaColor::OnUpdateMenuMapaColorUI),NULL,this);
			}

			~MenuHerramientaMapaColor() {
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaMapaColor::OnSeleccionarMapa),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaMapaColor::OnUpdateMenuMapaColorUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnSeleccionarMapa( wxCommandEvent& event )
			{
				int idMapa = event.GetId() - MENU_MAPAS_COLOR;
				m_pHerramienta->SeleccionarMapa(idMapa);
				event.Skip(false);
			}

			void OnUpdateMenuMapaColorUI(wxUpdateUIEvent& event) {
				event.Enable(m_pHerramienta->SoportaMapas());

				std::vector<std::string> choices = vtkLookupTableManager::GetAvailableLookupTables();
				int idMapaSeleccionado = m_pHerramienta->GetIdLookupTable();
				int idMapa = MENU_MAPAS_COLOR;
				for(std::vector<std::string>::iterator it = choices.begin(); it!= choices.end(); it++,idMapa++) {
					Check(idMapa, idMapa-MENU_MAPAS_COLOR == idMapaSeleccionado);
				}
			}

			GNKVisualizator::HerramientaMapaColor* m_pHerramienta;
			wxWindow* m_pParent;
		};

		//invertir mapa de colores
		class EventHandlerInvert: public wxEvtHandler {
		public:
			EventHandlerInvert(wxWindow* pParent, GNKVisualizator::HerramientaMapaColor* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(INVERTIR_COLORES, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerInvert::OnInvertColorMapClick),NULL,this);
				m_pParent->Connect(INVERTIR_COLORES, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerInvert::OnUpdateColorMapUI),NULL,this);
			}

			~EventHandlerInvert()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerInvert::OnInvertColorMapClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerInvert::OnUpdateColorMapUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnInvertColorMapClick( wxCommandEvent& event )
			{
				m_pHerramienta->InvertColorMap();
				event.Skip(false);
			}

			void OnUpdateColorMapUI(wxUpdateUIEvent& event) {
				event.Enable(m_pHerramienta->SoportaMapas());
			}

			GNKVisualizator::HerramientaMapaColor* m_pHerramienta;
			wxWindow* m_pParent;
		};


		class MenuInvertColorMap : public wxMenuItem {
		public:
			MenuInvertColorMap(wxWindow* pParent, const wxString& nombre, wxMenu* pMenuPadre, GNKVisualizator::HerramientaMapaColor* pHerramienta):wxMenuItem(pMenuPadre,INVERTIR_COLORES,nombre,nombre,wxITEM_NORMAL) {
				pEventHandler = new EventHandlerInvert(pParent,pHerramienta);
#ifdef __WXMSW__
				SetBitmaps(APrimResourcesManager::Herramientas::GetIcoInvert());
#else
				SetBitmap(APrimResourcesManager::Herramientas::GetIcoInvert());
#endif
			}

			~MenuInvertColorMap() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerInvert* pEventHandler;
		};
	}
}

//----------------------------------------------------------------------

GNKVisualizator::HerramientaMapaColor::HerramientaMapaColor()
{
	m_Descripcion = _Std("Color Map");
	m_IsMenu = true;
	////////////////////////////////////////////m_Icono = GinkgoResourcesManager::IconosMenus::GetIcoReset();
}

GNKVisualizator::HerramientaMapaColor::~HerramientaMapaColor()
{
}

bool GNKVisualizator::HerramientaMapaColor::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNKVisualizator::GUI::MenuInvertColorMap(pParent,_("Invert color map"),pMenuParent,this));

	wxMenu* pMenu = new GNKVisualizator::GUI::MenuHerramientaMapaColor(pParent,this);
	pMenuParent->Append(ID,wxString::FromUTF8(m_Descripcion.c_str()),pMenu);

	return true;
}

//region "Realizacin de la interfaz IHerramienta"

void GNKVisualizator::HerramientaMapaColor::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

bool GNKVisualizator::HerramientaMapaColor::SoportaMapas()
{
	if(Habilitada())
	{
		bool soporta =true;
		for (TContratableMapa::IteradorListaContratos it1 = TContratableMapa::m_pListaActiva->begin(); it1 != TContratableMapa::m_pListaActiva->end(); it1++) {
			TContratoMapa* pCW = (*it1);
			if(pCW->Estudio->Viewer != NULL) {

				int nc = pCW->Estudio->Viewer->GetNumberOfComponents();

				soporta = ( soporta && (nc == 1) );
			}
			else {
				soporta = false;
			}
		}
		return soporta;
	} else {
		return false;
	}
}

void GNKVisualizator::HerramientaMapaColor::SeleccionarMapa(int idMapa)
{
	if(Habilitada())
	{
		if(idMapa>=0 && idMapa<(int)vtkLookupTableManager::GetAvailableLookupTables().size()) {
			vtkLookupTable* vtkTabla = vtkLookupTableManager::GetLookupTable(idMapa);
			if(vtkTabla != NULL)
			{
				for (TContratableMapa::IteradorListaContratos it1 = TContratableMapa::m_pListaActiva->begin(); it1 != TContratableMapa::m_pListaActiva->end(); it1++) {
					TContratoMapa* pCW = (*it1);
					pCW->SetMapaColor(vtkTabla, idMapa);
				}
				vtkTabla->Delete();
			}
		}
	}
}

void GNKVisualizator::HerramientaMapaColor::SolicitarActivacion()
{
}
///////////////////////


int GNKVisualizator::HerramientaMapaColor::GetIdLookupTable()
{
	if (!SoportaMapas())
		return -1;
	int idMapa = -1;
	for (TContratableMapa::IteradorListaContratos it1 = TContratableMapa::m_pListaActiva->begin(); it1 != TContratableMapa::m_pListaActiva->end(); it1++) {
		TContratoMapa* pCW = (*it1);
		idMapa = pCW->Estudio->Viewer->GetIdLookupTable();
	}
	return idMapa;
}

void GNKVisualizator::HerramientaMapaColor::InvertColorMap()
{
	int idMapa = GetIdLookupTable();

	if (idMapa == vtkLookupTableManager::LUT_LINEAR) {
		idMapa = vtkLookupTableManager::LUT_LINEAR_INV;
	} else if (idMapa == vtkLookupTableManager::LUT_LINEAR_INV) {
		idMapa = vtkLookupTableManager::LUT_LINEAR;
	} else {
		idMapa = vtkLookupTableManager::LUT_LINEAR;
	}
	SeleccionarMapa(idMapa);
}

void GNKVisualizator::HerramientaMapaColor::ConectarContratoFalso(bool ) {
	if (TContratableMapa::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNKVisualizator::HerramientaMapaColor::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableMapa::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNKVisualizator::HerramientaMapaColor::ConectarContratos(bool )
{
	if (TContratableMapa::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la lgica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

//endregion



